/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.LookAndFeel;
import javax.swing.ScrollPaneConstants;
import javax.swing.ScrollPaneLayout;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.ActionMapUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.ScrollPaneUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicScrollBarUI;

public class BasicScrollPaneUI
extends ScrollPaneUI
implements ScrollPaneConstants {
    static int SCROLL_NON_SCROLLABLES = 10;
    static int ROWS_PER_WHEEL_CLICK = 3;
    protected JScrollPane scrollpane;
    protected ChangeListener hsbChangeListener;
    protected ChangeListener vsbChangeListener;
    protected ChangeListener viewportChangeListener;
    protected PropertyChangeListener spPropertyChangeListener;
    MouseWheelListener mouseWheelListener;
    ContainerListener containerListener;

    public static ComponentUI createUI(JComponent jComponent) {
        return new BasicScrollPaneUI();
    }

    protected void installDefaults(JScrollPane jScrollPane) {
        this.scrollpane = jScrollPane;
        LookAndFeel.installColorsAndFont(jScrollPane, "ScrollPane.background", "ScrollPane.foreground", "ScrollPane.font");
        LookAndFeel.installBorder(jScrollPane, "ScrollPane.border");
        Border border = jScrollPane.getViewportBorder();
        if (border == null || border instanceof UIResource) {
            border = UIManager.getBorder("ScrollPane.viewportBorder");
            jScrollPane.setViewportBorder(border);
        }
        jScrollPane.setOpaque(true);
    }

    protected void uninstallDefaults(JScrollPane jScrollPane) {
        LookAndFeel.uninstallBorder(jScrollPane);
        Border border = jScrollPane.getViewportBorder();
        if (border != null && border instanceof UIResource) {
            jScrollPane.setViewportBorder(null);
        }
    }

    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        this.installDefaults((JScrollPane)jComponent);
        this.installListeners((JScrollPane)jComponent);
        this.installKeyboardActions((JScrollPane)jComponent);
    }

    protected void installListeners(JScrollPane jScrollPane) {
        if (this.spPropertyChangeListener == null) {
            this.spPropertyChangeListener = this.createPropertyChangeListener();
        }
        jScrollPane.addPropertyChangeListener(this.spPropertyChangeListener);
        if (this.hsbChangeListener == null) {
            this.hsbChangeListener = this.createHSBChangeListener();
        }
        jScrollPane.getHorizontalScrollBar().getModel().addChangeListener(this.hsbChangeListener);
        if (this.vsbChangeListener == null) {
            this.vsbChangeListener = this.createVSBChangeListener();
        }
        jScrollPane.getVerticalScrollBar().getModel().addChangeListener(this.vsbChangeListener);
        if (this.viewportChangeListener == null) {
            this.viewportChangeListener = this.createViewportChangeListener();
        }
        if (this.mouseWheelListener == null) {
            this.mouseWheelListener = this.createMouseWheelListener();
        }
        if (this.containerListener == null) {
            this.containerListener = new ViewportContainerListener();
        }
        JViewport jViewport = jScrollPane.getViewport();
        jViewport.addChangeListener(this.viewportChangeListener);
        jViewport.addContainerListener(this.containerListener);
        for (int i = 0; i < jViewport.getComponentCount(); ++i) {
            jViewport.getComponent(i).addMouseWheelListener(this.mouseWheelListener);
        }
    }

    InputMap getInputMap(int n) {
        if (n == 1) {
            return (InputMap)UIManager.get("ScrollPane.ancestorInputMap");
        }
        return null;
    }

    ActionMap getActionMap() {
        ActionMap actionMap = (ActionMap)UIManager.get("ScrollPane.actionMap");
        if (actionMap == null && (actionMap = this.createActionMap()) != null) {
            UIManager.put("ScrollPane.actionMap", actionMap);
        }
        return actionMap;
    }

    ActionMap createActionMap() {
        ActionMapUIResource actionMapUIResource = new ActionMapUIResource();
        actionMapUIResource.put("scrollLeft", new AbstractAction("scrollLeft"){

            public void actionPerformed(ActionEvent actionEvent) {
                JScrollPane jScrollPane = (JScrollPane)actionEvent.getSource();
                JScrollBar jScrollBar = jScrollPane.getHorizontalScrollBar();
                if (jScrollBar.isVisible()) {
                    int n = jScrollBar.getBlockIncrement(-1);
                    jScrollBar.setValue(jScrollBar.getValue() + n);
                }
            }
        });
        actionMapUIResource.put("scrollEnd", new AbstractAction("scrollEnd"){

            public void actionPerformed(ActionEvent actionEvent) {
                JScrollBar jScrollBar;
                JScrollPane jScrollPane = (JScrollPane)actionEvent.getSource();
                JScrollBar jScrollBar2 = jScrollPane.getHorizontalScrollBar();
                if (jScrollBar2.isVisible()) {
                    jScrollBar2.setValue(jScrollBar2.getMaximum());
                }
                if ((jScrollBar = jScrollPane.getVerticalScrollBar()).isVisible()) {
                    jScrollBar.setValue(jScrollBar.getMaximum());
                }
            }
        });
        actionMapUIResource.put("unitScrollUp", new AbstractAction("unitScrollUp"){

            public void actionPerformed(ActionEvent actionEvent) {
                JScrollPane jScrollPane = (JScrollPane)actionEvent.getSource();
                JScrollBar jScrollBar = jScrollPane.getVerticalScrollBar();
                if (jScrollBar.isVisible()) {
                    int n = jScrollBar.getUnitIncrement(-1);
                    jScrollBar.setValue(jScrollBar.getValue() + n);
                }
            }
        });
        actionMapUIResource.put("unitScrollLeft", new AbstractAction("unitScrollLeft"){

            public void actionPerformed(ActionEvent actionEvent) {
                JScrollPane jScrollPane = (JScrollPane)actionEvent.getSource();
                JScrollBar jScrollBar = jScrollPane.getHorizontalScrollBar();
                if (jScrollBar.isVisible()) {
                    int n = jScrollBar.getUnitIncrement(-1);
                    jScrollBar.setValue(jScrollBar.getValue() + n);
                }
            }
        });
        actionMapUIResource.put("scrollUp", new AbstractAction("scrollUp"){

            public void actionPerformed(ActionEvent actionEvent) {
                JScrollPane jScrollPane = (JScrollPane)actionEvent.getSource();
                JScrollBar jScrollBar = jScrollPane.getVerticalScrollBar();
                if (jScrollBar.isVisible()) {
                    int n = jScrollBar.getBlockIncrement(-1);
                    jScrollBar.setValue(jScrollBar.getValue() + n);
                }
            }
        });
        actionMapUIResource.put("scrollRight", new AbstractAction("scrollRight"){

            public void actionPerformed(ActionEvent actionEvent) {
                JScrollPane jScrollPane = (JScrollPane)actionEvent.getSource();
                JScrollBar jScrollBar = jScrollPane.getHorizontalScrollBar();
                if (jScrollBar.isVisible()) {
                    int n = jScrollBar.getBlockIncrement(1);
                    jScrollBar.setValue(jScrollBar.getValue() + n);
                }
            }
        });
        actionMapUIResource.put("scrollHome", new AbstractAction("scrollHome"){

            public void actionPerformed(ActionEvent actionEvent) {
                JScrollBar jScrollBar;
                JScrollPane jScrollPane = (JScrollPane)actionEvent.getSource();
                JScrollBar jScrollBar2 = jScrollPane.getHorizontalScrollBar();
                if (jScrollBar2.isVisible()) {
                    jScrollBar2.setValue(jScrollBar2.getMinimum());
                }
                if ((jScrollBar = jScrollPane.getVerticalScrollBar()).isVisible()) {
                    jScrollBar.setValue(jScrollBar.getMinimum());
                }
            }
        });
        actionMapUIResource.put("scrollDown", new AbstractAction("scrollDown"){

            public void actionPerformed(ActionEvent actionEvent) {
                JScrollPane jScrollPane = (JScrollPane)actionEvent.getSource();
                JScrollBar jScrollBar = jScrollPane.getVerticalScrollBar();
                if (jScrollBar.isVisible()) {
                    int n = jScrollBar.getBlockIncrement(1);
                    jScrollBar.setValue(jScrollBar.getValue() + n);
                }
            }
        });
        actionMapUIResource.put("unitScrollDown", new AbstractAction("unitScrollDown"){

            public void actionPerformed(ActionEvent actionEvent) {
                JScrollPane jScrollPane = (JScrollPane)actionEvent.getSource();
                JScrollBar jScrollBar = jScrollPane.getVerticalScrollBar();
                if (jScrollBar.isVisible()) {
                    int n = jScrollBar.getUnitIncrement(1);
                    jScrollBar.setValue(jScrollBar.getValue() + n);
                }
            }
        });
        actionMapUIResource.put("unitScrollRight", new AbstractAction("unitScrollRight"){

            public void actionPerformed(ActionEvent actionEvent) {
                JScrollPane jScrollPane = (JScrollPane)actionEvent.getSource();
                JScrollBar jScrollBar = jScrollPane.getHorizontalScrollBar();
                if (jScrollBar.isVisible()) {
                    int n = jScrollBar.getUnitIncrement(1);
                    jScrollBar.setValue(jScrollBar.getValue() + n);
                }
            }
        });
        return actionMapUIResource;
    }

    protected void installKeyboardActions(JScrollPane jScrollPane) {
        InputMap inputMap = this.getInputMap(1);
        SwingUtilities.replaceUIInputMap(jScrollPane, 1, inputMap);
        ActionMap actionMap = this.getActionMap();
        SwingUtilities.replaceUIActionMap(jScrollPane, actionMap);
    }

    protected void uninstallKeyboardActions(JScrollPane jScrollPane) {
        SwingUtilities.replaceUIActionMap(jScrollPane, null);
        SwingUtilities.replaceUIInputMap(jScrollPane, 1, null);
    }

    protected ChangeListener createHSBChangeListener() {
        return new HSBChangeListener();
    }

    protected ChangeListener createVSBChangeListener() {
        return new VSBChangeListener();
    }

    protected ChangeListener createViewportChangeListener() {
        return new ViewportChangeHandler();
    }

    protected PropertyChangeListener createPropertyChangeListener() {
        return new PropertyChangeHandler();
    }

    protected MouseWheelListener createMouseWheelListener() {
        return new MouseWheelHandler();
    }

    public void uninstallUI(JComponent jComponent) {
        this.uninstallDefaults((JScrollPane)jComponent);
        this.uninstallListeners(jComponent);
        this.installKeyboardActions((JScrollPane)jComponent);
    }

    protected void uninstallListeners(JComponent jComponent) {
        JScrollPane jScrollPane = (JScrollPane)jComponent;
        jScrollPane.removePropertyChangeListener(this.spPropertyChangeListener);
        jScrollPane.getHorizontalScrollBar().getModel().removeChangeListener(this.hsbChangeListener);
        jScrollPane.getVerticalScrollBar().getModel().removeChangeListener(this.vsbChangeListener);
        JViewport jViewport = jScrollPane.getViewport();
        jViewport.removeChangeListener(this.viewportChangeListener);
        jViewport.removeContainerListener(this.containerListener);
        for (int i = 0; i < jViewport.getComponentCount(); ++i) {
            jViewport.getComponent(i).removeMouseWheelListener(this.mouseWheelListener);
        }
    }

    public Dimension getMinimumSize(JComponent jComponent) {
        JScrollPane jScrollPane = (JScrollPane)jComponent;
        ScrollPaneLayout scrollPaneLayout = (ScrollPaneLayout)jScrollPane.getLayout();
        return scrollPaneLayout.minimumLayoutSize(jComponent);
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        Border border = this.scrollpane.getViewportBorder();
        if (border != null) {
            Rectangle rectangle = this.scrollpane.getViewportBorderBounds();
            border.paintBorder(this.scrollpane, graphics, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
    }

    protected void syncScrollPaneWithViewport() {
        JViewport jViewport = this.scrollpane.getViewport();
        if (jViewport != null) {
            JViewport jViewport2;
            JViewport jViewport3;
            JScrollBar jScrollBar;
            int n;
            int n2;
            Dimension dimension = jViewport.getExtentSize();
            Point point = jViewport.getViewPosition();
            Dimension dimension2 = jViewport.getViewSize();
            JScrollBar jScrollBar2 = this.scrollpane.getVerticalScrollBar();
            if (jScrollBar2 != null) {
                int n3 = dimension.height;
                n2 = dimension2.height;
                n = Math.max(0, Math.min(point.y, n2 - n3));
                jScrollBar2.setValues(n, n3, 0, n2);
            }
            if ((jScrollBar = this.scrollpane.getHorizontalScrollBar()) != null) {
                n2 = dimension.width;
                n = dimension2.width;
                int n4 = Math.max(0, Math.min(point.x, n - n2));
                jScrollBar.setValues(n4, n2, 0, n);
            }
            if ((jViewport3 = this.scrollpane.getRowHeader()) != null) {
                Point point2 = new Point(0, point.y);
                jViewport3.setViewPosition(point2);
            }
            if ((jViewport2 = this.scrollpane.getColumnHeader()) != null) {
                Point point3 = new Point(point.x, 0);
                jViewport2.setViewPosition(point3);
            }
        }
    }

    protected void updateColumnHeader(PropertyChangeEvent propertyChangeEvent) {
    }

    protected void updateRowHeader(PropertyChangeEvent propertyChangeEvent) {
    }

    protected void updateScrollBarDisplayPolicy(PropertyChangeEvent propertyChangeEvent) {
        this.scrollpane.revalidate();
        this.scrollpane.repaint();
    }

    protected void updateViewport(PropertyChangeEvent propertyChangeEvent) {
        JViewport jViewport = (JViewport)propertyChangeEvent.getOldValue();
        jViewport.removeChangeListener(this.viewportChangeListener);
        JViewport jViewport2 = (JViewport)propertyChangeEvent.getNewValue();
        jViewport2.addChangeListener(this.viewportChangeListener);
        this.syncScrollPaneWithViewport();
    }

    class ViewportContainerListener
    implements ContainerListener {
        ViewportContainerListener() {
        }

        public void componentAdded(ContainerEvent containerEvent) {
            containerEvent.getChild().addMouseWheelListener(BasicScrollPaneUI.this.mouseWheelListener);
        }

        public void componentRemoved(ContainerEvent containerEvent) {
            containerEvent.getChild().removeMouseWheelListener(BasicScrollPaneUI.this.mouseWheelListener);
        }
    }

    protected class MouseWheelHandler
    implements MouseWheelListener {
        final Rectangle rect = new Rectangle();

        protected MouseWheelHandler() {
        }

        public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
            if (BasicScrollPaneUI.this.scrollpane.isWheelScrollingEnabled() && mouseWheelEvent.getScrollAmount() != 0) {
                JScrollBar jScrollBar = BasicScrollPaneUI.this.scrollpane.getVerticalScrollBar();
                if (jScrollBar == null || !jScrollBar.isVisible()) {
                    jScrollBar = BasicScrollPaneUI.this.scrollpane.getHorizontalScrollBar();
                }
                if (jScrollBar != null && jScrollBar.isVisible()) {
                    int n = mouseWheelEvent.getWheelRotation() < 0 ? -1 : 1;
                    int n2 = mouseWheelEvent.getScrollType();
                    if (n2 == 0) {
                        BasicScrollBarUI.scrollByUnits(jScrollBar, n, mouseWheelEvent.getScrollAmount());
                    } else if (n2 == 1) {
                        BasicScrollBarUI.scrollByBlock(jScrollBar, n);
                    }
                }
            }
        }
    }

    public class PropertyChangeHandler
    implements PropertyChangeListener {
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if (string.equals("viewport")) {
                BasicScrollPaneUI.this.updateViewport(propertyChangeEvent);
            } else if (string.equals("rowHeader")) {
                BasicScrollPaneUI.this.updateRowHeader(propertyChangeEvent);
            } else if (string.equals("columnHeader")) {
                BasicScrollPaneUI.this.updateColumnHeader(propertyChangeEvent);
            } else if (string.equals("horizontalScrollBarPolicy") || propertyChangeEvent.getPropertyName().equals("verticalScrollBarPolicy")) {
                BasicScrollPaneUI.this.updateScrollBarDisplayPolicy(propertyChangeEvent);
            } else if (string.equals("verticalScrollBar")) {
                JScrollBar jScrollBar = (JScrollBar)propertyChangeEvent.getOldValue();
                jScrollBar.getModel().removeChangeListener(BasicScrollPaneUI.this.vsbChangeListener);
                JScrollBar jScrollBar2 = (JScrollBar)propertyChangeEvent.getNewValue();
                jScrollBar2.getModel().addChangeListener(BasicScrollPaneUI.this.vsbChangeListener);
            } else if (string.equals("horizontalScrollBar")) {
                JScrollBar jScrollBar = (JScrollBar)propertyChangeEvent.getOldValue();
                jScrollBar.getModel().removeChangeListener(BasicScrollPaneUI.this.hsbChangeListener);
                JScrollBar jScrollBar3 = (JScrollBar)propertyChangeEvent.getNewValue();
                jScrollBar3.getModel().addChangeListener(BasicScrollPaneUI.this.hsbChangeListener);
            }
        }
    }

    public class ViewportChangeHandler
    implements ChangeListener {
        public void stateChanged(ChangeEvent changeEvent) {
            BasicScrollPaneUI.this.syncScrollPaneWithViewport();
        }
    }

    public class VSBChangeListener
    implements ChangeListener {
        public void stateChanged(ChangeEvent changeEvent) {
            JScrollBar jScrollBar = BasicScrollPaneUI.this.scrollpane.getVerticalScrollBar();
            JViewport jViewport = BasicScrollPaneUI.this.scrollpane.getViewport();
            Point point = jViewport.getViewPosition();
            point.y = jScrollBar.getValue();
            jViewport.setViewPosition(point);
        }
    }

    public class HSBChangeListener
    implements ChangeListener {
        public void stateChanged(ChangeEvent changeEvent) {
            JScrollBar jScrollBar = BasicScrollPaneUI.this.scrollpane.getHorizontalScrollBar();
            JViewport jViewport = BasicScrollPaneUI.this.scrollpane.getViewport();
            Point point = jViewport.getViewPosition();
            point.x = jScrollBar.getValue();
            jViewport.setViewPosition(point);
        }
    }
}

