/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BoundedRangeModel;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.LookAndFeel;
import javax.swing.SwingConstants;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.ActionMapUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.ScrollBarUI;
import javax.swing.plaf.basic.BasicArrowButton;
import javax.swing.plaf.basic.BasicGraphicsUtils;

public class BasicScrollBarUI
extends ScrollBarUI
implements LayoutManager,
SwingConstants {
    protected ArrowButtonListener buttonListener;
    protected ModelListener modelListener;
    protected PropertyChangeListener propertyChangeListener;
    protected ScrollListener scrollListener;
    protected TrackListener trackListener;
    protected JButton decrButton;
    protected JButton incrButton;
    protected Dimension maximumThumbSize;
    protected Dimension minimumThumbSize;
    protected Color thumbColor;
    protected Color thumbDarkShadowColor;
    protected Color thumbHighlightColor;
    protected Color thumbLightShadowColor;
    protected Color trackHighlightColor;
    protected Color trackColor;
    protected Rectangle trackRect;
    protected Rectangle thumbRect;
    protected static final int DECREASE_HIGHLIGHT = 1;
    protected static final int INCREASE_HIGHLIGHT = 2;
    protected static final int NO_HIGHLIGHT = 0;
    private static final int POSITIVE_SCROLL = 1;
    private static final int NEGATIVE_SCROLL = -1;
    private transient Dimension preferredSize;
    protected int trackHighlight;
    protected boolean isDragging;
    protected Timer scrollTimer;
    protected JScrollBar scrollbar;
    boolean thumbRollover;

    public void addLayoutComponent(String string, Component component) {
    }

    protected void configureScrollBarColors() {
        this.trackColor = UIManager.getColor("ScrollBar.track");
        this.trackHighlightColor = UIManager.getColor("ScrollBar.trackHighlight");
        this.thumbColor = UIManager.getColor("ScrollBar.thumb");
        this.thumbHighlightColor = UIManager.getColor("ScrollBar.thumbHighlight");
        this.thumbDarkShadowColor = UIManager.getColor("ScrollBar.thumbDarkShadow");
        this.thumbLightShadowColor = UIManager.getColor("ScrollBar.thumbShadow");
    }

    protected ArrowButtonListener createArrowButtonListener() {
        return new ArrowButtonListener();
    }

    protected JButton createIncreaseButton(int n) {
        return new BasicArrowButton(n);
    }

    protected JButton createDecreaseButton(int n) {
        return new BasicArrowButton(n);
    }

    protected ModelListener createModelListener() {
        return new ModelListener();
    }

    protected PropertyChangeListener createPropertyChangeListener() {
        return new PropertyChangeHandler();
    }

    protected ScrollListener createScrollListener() {
        return new ScrollListener();
    }

    protected TrackListener createTrackListener() {
        return new TrackListener();
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new BasicScrollBarUI();
    }

    public Dimension getMaximumSize(JComponent jComponent) {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    protected Dimension getMaximumThumbSize() {
        return this.maximumThumbSize;
    }

    public Dimension getMinimumSize(JComponent jComponent) {
        return this.getPreferredSize(jComponent);
    }

    protected Dimension getMinimumThumbSize() {
        return this.minimumThumbSize;
    }

    void calculatePreferredSize() {
        int n = 0;
        int n2 = 0;
        if (this.scrollbar.getOrientation() == 0) {
            n = (int)((double)n + this.incrButton.getPreferredSize().getWidth());
            n = (int)((double)n + this.decrButton.getPreferredSize().getWidth());
            n += 16;
            n2 = UIManager.getInt("ScrollBar.width");
        } else {
            n2 = (int)((double)n2 + this.incrButton.getPreferredSize().getHeight());
            n2 = (int)((double)n2 + this.decrButton.getPreferredSize().getHeight());
            n2 += 16;
            n = UIManager.getInt("ScrollBar.width");
        }
        Insets insets = this.scrollbar.getInsets();
        this.preferredSize = new Dimension(n += insets.left + insets.right, n2 += insets.top + insets.bottom);
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        this.calculatePreferredSize();
        return this.preferredSize;
    }

    protected Rectangle getThumbBounds() {
        return this.thumbRect;
    }

    protected Rectangle getTrackBounds() {
        return this.trackRect;
    }

    protected void installComponents() {
        int n = this.scrollbar.getOrientation();
        switch (n) {
            case 0: {
                this.incrButton = this.createIncreaseButton(3);
                this.decrButton = this.createDecreaseButton(7);
                break;
            }
            default: {
                this.incrButton = this.createIncreaseButton(5);
                this.decrButton = this.createDecreaseButton(1);
            }
        }
        if (this.incrButton != null) {
            this.scrollbar.add(this.incrButton);
        }
        if (this.decrButton != null) {
            this.scrollbar.add(this.decrButton);
        }
    }

    protected void installDefaults() {
        LookAndFeel.installColors(this.scrollbar, "ScrollBar.background", "ScrollBar.foreground");
        LookAndFeel.installBorder(this.scrollbar, "ScrollBar.border");
        this.scrollbar.setOpaque(true);
        this.scrollbar.setLayout(this);
        this.configureScrollBarColors();
        this.maximumThumbSize = UIManager.getDimension("ScrollBar.maximumThumbSize");
        this.minimumThumbSize = UIManager.getDimension("ScrollBar.minimumThumbSize");
    }

    protected void installKeyboardActions() {
        InputMap inputMap = this.getInputMap(1);
        SwingUtilities.replaceUIInputMap(this.scrollbar, 1, inputMap);
        ActionMap actionMap = this.getActionMap();
        SwingUtilities.replaceUIActionMap(this.scrollbar, actionMap);
    }

    protected void uninstallKeyboardActions() {
        SwingUtilities.replaceUIActionMap(this.scrollbar, null);
        SwingUtilities.replaceUIInputMap(this.scrollbar, 1, null);
    }

    InputMap getInputMap(int n) {
        if (n == 1) {
            return (InputMap)UIManager.get("ScrollBar.focusInputMap");
        }
        return null;
    }

    ActionMap getActionMap() {
        ActionMap actionMap = (ActionMap)UIManager.get("ScrollBar.actionMap");
        if (actionMap == null && (actionMap = this.createActionMap()) != null) {
            UIManager.put("ScrollBar.actionMap", actionMap);
        }
        return actionMap;
    }

    ActionMap createActionMap() {
        ActionMapUIResource actionMapUIResource = new ActionMapUIResource();
        actionMapUIResource.put("positiveUnitIncrement", new AbstractAction("positiveUnitIncrement"){

            public void actionPerformed(ActionEvent actionEvent) {
                JScrollBar jScrollBar = (JScrollBar)actionEvent.getSource();
                if (jScrollBar.isVisible()) {
                    int n = jScrollBar.getUnitIncrement(1);
                    jScrollBar.setValue(jScrollBar.getValue() + n);
                }
            }
        });
        actionMapUIResource.put("positiveBlockIncrement", new AbstractAction("positiveBlockIncrement"){

            public void actionPerformed(ActionEvent actionEvent) {
                JScrollBar jScrollBar = (JScrollBar)actionEvent.getSource();
                if (jScrollBar.isVisible()) {
                    int n = jScrollBar.getBlockIncrement(1);
                    jScrollBar.setValue(jScrollBar.getValue() + n);
                }
            }
        });
        actionMapUIResource.put("negativeUnitIncrement", new AbstractAction("negativeUnitIncrement"){

            public void actionPerformed(ActionEvent actionEvent) {
                JScrollBar jScrollBar = (JScrollBar)actionEvent.getSource();
                if (jScrollBar.isVisible()) {
                    int n = jScrollBar.getUnitIncrement(-1);
                    jScrollBar.setValue(jScrollBar.getValue() + n);
                }
            }
        });
        actionMapUIResource.put("negativeBlockIncrement", new AbstractAction("negativeBlockIncrement"){

            public void actionPerformed(ActionEvent actionEvent) {
                JScrollBar jScrollBar = (JScrollBar)actionEvent.getSource();
                if (jScrollBar.isVisible()) {
                    int n = jScrollBar.getBlockIncrement(-1);
                    jScrollBar.setValue(jScrollBar.getValue() + n);
                }
            }
        });
        actionMapUIResource.put("minScroll", new AbstractAction("minScroll"){

            public void actionPerformed(ActionEvent actionEvent) {
                JScrollBar jScrollBar = (JScrollBar)actionEvent.getSource();
                if (jScrollBar.isVisible()) {
                    jScrollBar.setValue(jScrollBar.getMinimum());
                }
            }
        });
        actionMapUIResource.put("maxScroll", new AbstractAction("maxScroll"){

            public void actionPerformed(ActionEvent actionEvent) {
                JScrollBar jScrollBar = (JScrollBar)actionEvent.getSource();
                if (jScrollBar.isVisible()) {
                    jScrollBar.setValue(jScrollBar.getMaximum());
                }
            }
        });
        return actionMapUIResource;
    }

    protected void installListeners() {
        this.scrollListener = this.createScrollListener();
        this.trackListener = this.createTrackListener();
        this.buttonListener = this.createArrowButtonListener();
        this.modelListener = this.createModelListener();
        this.propertyChangeListener = this.createPropertyChangeListener();
        this.scrollbar.addMouseMotionListener(this.trackListener);
        this.scrollbar.addMouseListener(this.trackListener);
        this.incrButton.addMouseListener(this.buttonListener);
        this.decrButton.addMouseListener(this.buttonListener);
        this.scrollbar.addPropertyChangeListener(this.propertyChangeListener);
        this.scrollbar.getModel().addChangeListener(this.modelListener);
        this.scrollTimer.addActionListener(this.scrollListener);
    }

    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        if (jComponent instanceof JScrollBar) {
            this.scrollbar = (JScrollBar)jComponent;
            this.trackRect = new Rectangle();
            this.thumbRect = new Rectangle();
            this.scrollTimer = new Timer(300, null);
            this.installDefaults();
            this.installComponents();
            this.configureScrollBarColors();
            this.installListeners();
            this.installKeyboardActions();
            this.calculatePreferredSize();
        }
    }

    public void layoutContainer(Container container) {
        if (container instanceof JScrollBar) {
            if (this.scrollbar.getOrientation() == 0) {
                this.layoutHScrollbar((JScrollBar)container);
            } else {
                this.layoutVScrollbar((JScrollBar)container);
            }
        }
    }

    protected void layoutHScrollbar(JScrollBar jScrollBar) {
        Rectangle rectangle = new Rectangle();
        SwingUtilities.calculateInnerArea(this.scrollbar, rectangle);
        Dimension dimension = this.incrButton.getPreferredSize();
        Dimension dimension2 = this.decrButton.getPreferredSize();
        SwingUtilities.calculateInnerArea(this.scrollbar, this.trackRect);
        this.trackRect.width = (int)((double)this.trackRect.width - dimension.getWidth());
        this.trackRect.width = (int)((double)this.trackRect.width - dimension2.getWidth());
        this.trackRect.x = (int)((double)this.trackRect.x + dimension2.getWidth());
        this.updateThumbRect();
        this.decrButton.setBounds(rectangle.x, rectangle.y, dimension2.width, this.trackRect.height);
        this.incrButton.setBounds(this.trackRect.x + this.trackRect.width, rectangle.y, dimension.width, this.trackRect.height);
    }

    protected void layoutVScrollbar(JScrollBar jScrollBar) {
        Rectangle rectangle = new Rectangle();
        SwingUtilities.calculateInnerArea(this.scrollbar, rectangle);
        Dimension dimension = this.incrButton.getPreferredSize();
        Dimension dimension2 = this.decrButton.getPreferredSize();
        SwingUtilities.calculateInnerArea(this.scrollbar, this.trackRect);
        this.trackRect.height = (int)((double)this.trackRect.height - dimension.getHeight());
        this.trackRect.height = (int)((double)this.trackRect.height - dimension2.getHeight());
        this.trackRect.y = (int)((double)this.trackRect.y + dimension2.getHeight());
        this.updateThumbRect();
        this.decrButton.setBounds(rectangle.x, rectangle.y, this.trackRect.width, dimension2.height);
        this.incrButton.setBounds(rectangle.x, this.trackRect.y + this.trackRect.height, this.trackRect.width, dimension.height);
    }

    void updateThumbRect() {
        int n = this.scrollbar.getMaximum();
        int n2 = this.scrollbar.getMinimum();
        int n3 = this.scrollbar.getValue();
        int n4 = this.scrollbar.getVisibleAmount();
        if (n - n4 <= n2) {
            if (this.scrollbar.getOrientation() == 0) {
                this.thumbRect.x = this.trackRect.x;
                this.thumbRect.y = this.trackRect.y;
                this.thumbRect.width = this.getMinimumThumbSize().width;
                this.thumbRect.height = this.trackRect.height;
            } else {
                this.thumbRect.x = this.trackRect.x;
                this.thumbRect.y = this.trackRect.y;
                this.thumbRect.width = this.trackRect.width;
                this.thumbRect.height = this.getMinimumThumbSize().height;
            }
        } else if (this.scrollbar.getOrientation() == 0) {
            this.thumbRect.x = this.trackRect.x;
            this.thumbRect.width = Math.max(n4 * this.trackRect.width / (n - n2), this.getMinimumThumbSize().width);
            int n5 = this.trackRect.width - this.thumbRect.width;
            this.thumbRect.x += (n3 - n2) * n5 / (n - n2 - n4);
            this.thumbRect.y = this.trackRect.y;
            this.thumbRect.height = this.trackRect.height;
        } else {
            this.thumbRect.x = this.trackRect.x;
            this.thumbRect.height = Math.max(n4 * this.trackRect.height / (n - n2), this.getMinimumThumbSize().height);
            int n6 = this.trackRect.height - this.thumbRect.height;
            this.thumbRect.y = this.trackRect.y + (n3 - n2) * n6 / (n - n2 - n4);
            this.thumbRect.width = this.trackRect.width;
        }
    }

    public Dimension minimumLayoutSize(Container container) {
        return this.preferredLayoutSize(container);
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        this.paintTrack(graphics, jComponent, this.getTrackBounds());
        this.paintThumb(graphics, jComponent, this.getThumbBounds());
        if (this.trackHighlight == 2) {
            this.paintIncreaseHighlight(graphics);
        } else if (this.trackHighlight == 1) {
            this.paintDecreaseHighlight(graphics);
        }
    }

    protected void paintDecreaseHighlight(Graphics graphics) {
        Color color = graphics.getColor();
        graphics.setColor(this.trackHighlightColor);
        if (this.scrollbar.getOrientation() == 0) {
            graphics.fillRect(this.trackRect.x, this.trackRect.y, this.thumbRect.x - this.trackRect.x, this.trackRect.height);
        } else {
            graphics.fillRect(this.trackRect.x, this.trackRect.y, this.trackRect.width, this.thumbRect.y - this.trackRect.y);
        }
        graphics.setColor(color);
    }

    protected void paintIncreaseHighlight(Graphics graphics) {
        Color color = graphics.getColor();
        graphics.setColor(this.trackHighlightColor);
        if (this.scrollbar.getOrientation() == 0) {
            graphics.fillRect(this.thumbRect.x + this.thumbRect.width, this.trackRect.y, this.trackRect.x + this.trackRect.width - this.thumbRect.x - this.thumbRect.width, this.trackRect.height);
        } else {
            graphics.fillRect(this.trackRect.x, this.thumbRect.y + this.thumbRect.height, this.trackRect.width, this.trackRect.y + this.trackRect.height - this.thumbRect.y - this.thumbRect.height);
        }
        graphics.setColor(color);
    }

    protected void paintThumb(Graphics graphics, JComponent jComponent, Rectangle rectangle) {
        graphics.setColor(this.thumbColor);
        graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        BasicGraphicsUtils.drawBezel(graphics, rectangle.x, rectangle.y, rectangle.width, rectangle.height, false, false, this.thumbDarkShadowColor, this.thumbDarkShadowColor, this.thumbHighlightColor, this.thumbHighlightColor);
    }

    protected void paintTrack(Graphics graphics, JComponent jComponent, Rectangle rectangle) {
        Color color = graphics.getColor();
        graphics.setColor(this.trackColor);
        graphics.fill3DRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height, false);
        graphics.setColor(color);
    }

    public Dimension preferredLayoutSize(Container container) {
        if (container instanceof JComponent) {
            return this.getPreferredSize((JComponent)container);
        }
        return null;
    }

    public void removeLayoutComponent(Component component) {
    }

    protected void scrollByBlock(int n) {
        BasicScrollBarUI.scrollByBlock(this.scrollbar, n);
    }

    static final void scrollByBlock(JScrollBar jScrollBar, int n) {
        int n2 = n > 0 ? jScrollBar.getBlockIncrement(n) : -jScrollBar.getBlockIncrement(n);
        int n3 = jScrollBar.getValue();
        int n4 = n3 + n2;
        if (n2 > 0 && n4 < n3) {
            n4 = jScrollBar.getMaximum();
        } else if (n2 < 0 && n4 > n3) {
            n4 = jScrollBar.getMinimum();
        }
        jScrollBar.setValue(n4);
    }

    protected void scrollByUnit(int n) {
        BasicScrollBarUI.scrollByUnits(this.scrollbar, n, 1);
    }

    static final void scrollByUnits(JScrollBar jScrollBar, int n, int n2) {
        for (int i = 0; i < n2; ++i) {
            int n3 = n > 0 ? jScrollBar.getUnitIncrement(n) : -jScrollBar.getUnitIncrement(n);
            int n4 = jScrollBar.getValue();
            int n5 = n4 + n3;
            if (n3 > 0 && n5 < n4) {
                n5 = jScrollBar.getMaximum();
            } else if (n3 < 0 && n5 > n4) {
                n5 = jScrollBar.getMinimum();
            }
            jScrollBar.setValue(n5);
        }
    }

    protected void setThumbBounds(int n, int n2, int n3, int n4) {
        this.thumbRect.x = n;
        this.thumbRect.y = n2;
        this.thumbRect.width = n3;
        this.thumbRect.height = n4;
    }

    protected void uninstallComponents() {
        if (this.incrButton != null) {
            this.scrollbar.remove(this.incrButton);
        }
        if (this.decrButton != null) {
            this.scrollbar.remove(this.decrButton);
        }
    }

    protected void uninstallDefaults() {
        this.scrollbar.setForeground(null);
        this.scrollbar.setBackground(null);
        LookAndFeel.uninstallBorder(this.scrollbar);
        this.incrButton = null;
        this.decrButton = null;
    }

    protected void uninstallListeners() {
        if (this.scrollTimer != null) {
            this.scrollTimer.removeActionListener(this.scrollListener);
        }
        if (this.scrollbar != null) {
            this.scrollbar.getModel().removeChangeListener(this.modelListener);
            this.scrollbar.removePropertyChangeListener(this.propertyChangeListener);
            this.scrollbar.removeMouseListener(this.trackListener);
            this.scrollbar.removeMouseMotionListener(this.trackListener);
        }
        if (this.decrButton != null) {
            this.decrButton.removeMouseListener(this.buttonListener);
        }
        if (this.incrButton != null) {
            this.incrButton.removeMouseListener(this.buttonListener);
        }
        this.propertyChangeListener = null;
        this.modelListener = null;
        this.buttonListener = null;
        this.trackListener = null;
        this.scrollListener = null;
    }

    public void uninstallUI(JComponent jComponent) {
        this.uninstallKeyboardActions();
        this.uninstallListeners();
        this.uninstallDefaults();
        this.uninstallComponents();
        this.scrollTimer = null;
        this.thumbRect = null;
        this.trackRect = null;
        this.trackColor = null;
        this.trackHighlightColor = null;
        this.thumbColor = null;
        this.thumbHighlightColor = null;
        this.thumbDarkShadowColor = null;
        this.thumbLightShadowColor = null;
        this.scrollbar = null;
    }

    int valueForYPosition(int n) {
        int n2 = this.scrollbar.getMinimum();
        int n3 = this.scrollbar.getMaximum();
        int n4 = this.trackRect.height;
        if (n4 == 0) {
            return (n3 - n2) / 2;
        }
        int n5 = (n - this.trackRect.y) * (n3 - n2) / n4 + n2;
        if (n5 > n3) {
            n5 = n3;
        } else if (n5 < n2) {
            n5 = n2;
        }
        return n5;
    }

    int valueForXPosition(int n) {
        int n2 = this.scrollbar.getMinimum();
        int n3 = this.scrollbar.getMaximum();
        int n4 = this.trackRect.width;
        if (n4 == 0) {
            return (n3 - n2) / 2;
        }
        int n5 = (n - this.trackRect.x) * (n3 - n2) / n4 + n2;
        if (n5 > n3) {
            n5 = n3;
        } else if (n5 < n2) {
            n5 = n2;
        }
        return n5;
    }

    public boolean isThumbRollover() {
        return this.thumbRollover;
    }

    protected void setThumbRollover(boolean bl) {
        this.thumbRollover = bl;
    }

    public boolean getSupportsAbsolutePositioning() {
        return false;
    }

    protected class TrackListener
    extends MouseAdapter
    implements MouseMotionListener {
        protected int currentMouseX;
        protected int currentMouseY;
        protected int offset;

        protected TrackListener() {
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            this.currentMouseX = mouseEvent.getX();
            this.currentMouseY = mouseEvent.getY();
            if (BasicScrollBarUI.this.scrollbar.getValueIsAdjusting()) {
                int n = BasicScrollBarUI.this.scrollbar.getOrientation() == 0 ? BasicScrollBarUI.this.valueForXPosition(this.currentMouseX) - this.offset : BasicScrollBarUI.this.valueForYPosition(this.currentMouseY) - this.offset;
                BasicScrollBarUI.this.scrollbar.setValue(n);
            }
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            BasicScrollBarUI.this.thumbRollover = BasicScrollBarUI.this.thumbRect.contains(mouseEvent.getPoint());
        }

        public void mousePressed(MouseEvent mouseEvent) {
            this.currentMouseX = mouseEvent.getX();
            this.currentMouseY = mouseEvent.getY();
            int n = BasicScrollBarUI.this.scrollbar.getOrientation() == 0 ? BasicScrollBarUI.this.valueForXPosition(this.currentMouseX) : BasicScrollBarUI.this.valueForYPosition(this.currentMouseY);
            if (!BasicScrollBarUI.this.thumbRect.contains(mouseEvent.getPoint())) {
                BasicScrollBarUI.this.scrollTimer.stop();
                BasicScrollBarUI.this.scrollListener.setScrollByBlock(true);
                if (n > BasicScrollBarUI.this.scrollbar.getValue()) {
                    BasicScrollBarUI.this.trackHighlight = 2;
                    BasicScrollBarUI.this.scrollListener.setDirection(1);
                } else {
                    BasicScrollBarUI.this.trackHighlight = 1;
                    BasicScrollBarUI.this.scrollListener.setDirection(-1);
                }
                BasicScrollBarUI.this.scrollTimer.setDelay(100);
                BasicScrollBarUI.this.scrollTimer.start();
            } else {
                BasicScrollBarUI.this.scrollListener.setScrollByBlock(false);
                BasicScrollBarUI.this.scrollbar.setValueIsAdjusting(true);
                this.offset = n - BasicScrollBarUI.this.scrollbar.getValue();
            }
            BasicScrollBarUI.this.scrollbar.repaint();
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            BasicScrollBarUI.this.scrollTimer.stop();
            BasicScrollBarUI.this.scrollTimer.setDelay(300);
            this.currentMouseX = mouseEvent.getX();
            this.currentMouseY = mouseEvent.getY();
            if (this.shouldScroll(1)) {
                BasicScrollBarUI.this.scrollByBlock(1);
            } else if (this.shouldScroll(-1)) {
                BasicScrollBarUI.this.scrollByBlock(-1);
            }
            BasicScrollBarUI.this.trackHighlight = 0;
            BasicScrollBarUI.this.scrollListener.setScrollByBlock(false);
            BasicScrollBarUI.this.scrollbar.setValueIsAdjusting(true);
            BasicScrollBarUI.this.scrollbar.repaint();
        }

        boolean shouldScroll(int n) {
            int n2 = BasicScrollBarUI.this.scrollbar.getOrientation() == 0 ? BasicScrollBarUI.this.valueForXPosition(this.currentMouseX) : BasicScrollBarUI.this.valueForYPosition(this.currentMouseY);
            if (BasicScrollBarUI.this.thumbRect.contains(this.currentMouseX, this.currentMouseY)) {
                return false;
            }
            if (n == 1) {
                return n2 > BasicScrollBarUI.this.scrollbar.getValue();
            }
            return n2 < BasicScrollBarUI.this.scrollbar.getValue();
        }
    }

    protected class ScrollListener
    implements ActionListener {
        private transient int direction;
        private transient boolean block;

        public ScrollListener() {
            this.direction = 1;
            this.block = true;
        }

        public ScrollListener(int n, boolean bl) {
            this.direction = n;
            this.block = bl;
        }

        public void setDirection(int n) {
            this.direction = n;
        }

        public void setScrollByBlock(boolean bl) {
            this.block = bl;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (this.block) {
                if (!BasicScrollBarUI.this.trackListener.shouldScroll(this.direction)) {
                    BasicScrollBarUI.this.trackHighlight = 0;
                    BasicScrollBarUI.this.scrollbar.repaint();
                    return;
                }
                BasicScrollBarUI.this.scrollByBlock(this.direction);
            } else {
                BasicScrollBarUI.this.scrollByUnit(this.direction);
            }
        }
    }

    public class PropertyChangeHandler
    implements PropertyChangeListener {
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getPropertyName().equals("model")) {
                ((BoundedRangeModel)propertyChangeEvent.getOldValue()).removeChangeListener(BasicScrollBarUI.this.modelListener);
                BasicScrollBarUI.this.scrollbar.getModel().addChangeListener(BasicScrollBarUI.this.modelListener);
                BasicScrollBarUI.this.updateThumbRect();
            } else if (propertyChangeEvent.getPropertyName().equals("orientation")) {
                BasicScrollBarUI.this.uninstallListeners();
                BasicScrollBarUI.this.uninstallComponents();
                BasicScrollBarUI.this.uninstallDefaults();
                BasicScrollBarUI.this.installDefaults();
                BasicScrollBarUI.this.installComponents();
                BasicScrollBarUI.this.installListeners();
            } else if (propertyChangeEvent.getPropertyName().equals("enabled")) {
                Boolean bl = (Boolean)propertyChangeEvent.getNewValue();
                if (BasicScrollBarUI.this.incrButton != null) {
                    BasicScrollBarUI.this.incrButton.setEnabled(bl);
                }
                if (BasicScrollBarUI.this.decrButton != null) {
                    BasicScrollBarUI.this.decrButton.setEnabled(bl);
                }
            }
        }
    }

    protected class ModelListener
    implements ChangeListener {
        protected ModelListener() {
        }

        public void stateChanged(ChangeEvent changeEvent) {
            BasicScrollBarUI.this.calculatePreferredSize();
            BasicScrollBarUI.this.updateThumbRect();
            BasicScrollBarUI.this.scrollbar.repaint();
        }
    }

    protected class ArrowButtonListener
    extends MouseAdapter {
        protected ArrowButtonListener() {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            BasicScrollBarUI.this.scrollTimer.stop();
            BasicScrollBarUI.this.scrollListener.setScrollByBlock(false);
            if (mouseEvent.getSource() == BasicScrollBarUI.this.incrButton) {
                BasicScrollBarUI.this.scrollListener.setDirection(1);
            } else if (mouseEvent.getSource() == BasicScrollBarUI.this.decrButton) {
                BasicScrollBarUI.this.scrollListener.setDirection(-1);
            }
            BasicScrollBarUI.this.scrollTimer.setDelay(100);
            BasicScrollBarUI.this.scrollTimer.start();
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            BasicScrollBarUI.this.scrollTimer.stop();
            BasicScrollBarUI.this.scrollTimer.setDelay(300);
            if (mouseEvent.getSource() == BasicScrollBarUI.this.incrButton) {
                BasicScrollBarUI.this.scrollByUnit(1);
            } else if (mouseEvent.getSource() == BasicScrollBarUI.this.decrButton) {
                BasicScrollBarUI.this.scrollByUnit(-1);
            }
        }
    }
}

