/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicToggleButtonUI;
import javax.swing.text.View;

public class BasicRadioButtonUI
extends BasicToggleButtonUI {
    protected Icon icon;

    public static ComponentUI createUI(JComponent jComponent) {
        return new BasicRadioButtonUI();
    }

    protected void installDefaults(AbstractButton abstractButton) {
        super.installDefaults(abstractButton);
        this.icon = UIManager.getIcon(this.getPropertyPrefix() + "icon");
    }

    protected String getPropertyPrefix() {
        return "RadioButton.";
    }

    public Icon getDefaultIcon() {
        return this.icon;
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        AbstractButton abstractButton = (AbstractButton)jComponent;
        Dimension dimension = jComponent.getSize();
        Insets insets = abstractButton.getInsets();
        BasicRadioButtonUI.textR.x = 0;
        BasicRadioButtonUI.textR.y = 0;
        BasicRadioButtonUI.textR.width = 0;
        BasicRadioButtonUI.textR.height = 0;
        BasicRadioButtonUI.iconR.x = 0;
        BasicRadioButtonUI.iconR.y = 0;
        BasicRadioButtonUI.iconR.width = 0;
        BasicRadioButtonUI.iconR.height = 0;
        BasicRadioButtonUI.viewR.x = insets.left;
        BasicRadioButtonUI.viewR.y = insets.right;
        BasicRadioButtonUI.viewR.width = dimension.width - insets.left - insets.right;
        BasicRadioButtonUI.viewR.height = dimension.height - insets.top - insets.bottom;
        Font font = jComponent.getFont();
        graphics.setFont(font);
        Icon icon = abstractButton.getIcon();
        if (icon == null) {
            icon = this.getDefaultIcon();
        }
        Icon icon2 = this.getCurrentIcon(abstractButton);
        String string = SwingUtilities.layoutCompoundLabel(jComponent, graphics.getFontMetrics(font), abstractButton.getText(), icon2 == null ? this.getDefaultIcon() : icon2, abstractButton.getVerticalAlignment(), abstractButton.getHorizontalAlignment(), abstractButton.getVerticalTextPosition(), abstractButton.getHorizontalTextPosition(), viewR, iconR, textR, abstractButton.getIconTextGap());
        if (icon2 != null) {
            icon2.paintIcon(jComponent, graphics, BasicRadioButtonUI.iconR.x, BasicRadioButtonUI.iconR.y);
        }
        if (string != null) {
            View view = (View)jComponent.getClientProperty("html");
            if (view != null) {
                view.paint(graphics, textR);
            } else {
                this.paintText(graphics, abstractButton, textR, string);
            }
            if (abstractButton.hasFocus() && abstractButton.isFocusPainted() && BasicRadioButtonUI.textR.width > 0 && BasicRadioButtonUI.textR.height > 0) {
                this.paintFocus(graphics, textR, dimension);
            }
        }
    }

    private Icon getCurrentIcon(AbstractButton abstractButton) {
        ButtonModel buttonModel = abstractButton.getModel();
        Icon icon = abstractButton.getIcon();
        if (icon == null) {
            icon = this.getDefaultIcon();
        } else {
            if (!buttonModel.isEnabled()) {
                icon = buttonModel.isSelected() ? abstractButton.getDisabledSelectedIcon() : abstractButton.getDisabledIcon();
            } else if (buttonModel.isPressed() && buttonModel.isArmed()) {
                icon = abstractButton.getPressedIcon();
                if (icon == null) {
                    icon = abstractButton.getSelectedIcon();
                }
            } else if (buttonModel.isSelected()) {
                if (abstractButton.isRolloverEnabled() && buttonModel.isRollover()) {
                    icon = abstractButton.getRolloverSelectedIcon();
                    if (icon == null) {
                        icon = abstractButton.getSelectedIcon();
                    }
                } else {
                    icon = abstractButton.getSelectedIcon();
                }
            } else if (abstractButton.isRolloverEnabled() && buttonModel.isRollover()) {
                icon = abstractButton.getRolloverIcon();
            }
            if (icon == null) {
                icon = abstractButton.getIcon();
            }
        }
        return icon;
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        AbstractButton abstractButton = (AbstractButton)jComponent;
        Insets insets = abstractButton.getInsets();
        String string = abstractButton.getText();
        Icon icon = abstractButton.getIcon();
        if (icon == null) {
            icon = this.getDefaultIcon();
        }
        BasicRadioButtonUI.textR.x = 0;
        BasicRadioButtonUI.textR.y = 0;
        BasicRadioButtonUI.textR.width = 0;
        BasicRadioButtonUI.textR.height = 0;
        BasicRadioButtonUI.iconR.x = 0;
        BasicRadioButtonUI.iconR.y = 0;
        BasicRadioButtonUI.iconR.width = 0;
        BasicRadioButtonUI.iconR.height = 0;
        BasicRadioButtonUI.viewR.x = 0;
        BasicRadioButtonUI.viewR.y = 0;
        BasicRadioButtonUI.viewR.width = Short.MAX_VALUE;
        BasicRadioButtonUI.viewR.height = Short.MAX_VALUE;
        SwingUtilities.layoutCompoundLabel(abstractButton, abstractButton.getFontMetrics(abstractButton.getFont()), string, icon, abstractButton.getVerticalAlignment(), abstractButton.getHorizontalAlignment(), abstractButton.getVerticalTextPosition(), abstractButton.getHorizontalTextPosition(), viewR, iconR, textR, string == null ? 0 : abstractButton.getIconTextGap());
        Rectangle rectangle = SwingUtilities.computeUnion(BasicRadioButtonUI.textR.x, BasicRadioButtonUI.textR.y, BasicRadioButtonUI.textR.width, BasicRadioButtonUI.textR.height, iconR);
        return new Dimension(insets.left + rectangle.width + insets.right, insets.top + rectangle.height + insets.bottom);
    }

    protected void paintFocus(Graphics graphics, Rectangle rectangle, Dimension dimension) {
        Color color = UIManager.getColor(this.getPropertyPrefix() + ".focus");
        Color color2 = graphics.getColor();
        graphics.setColor(color);
        graphics.drawRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        graphics.setColor(color2);
    }
}

