/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.geom.AffineTransform;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.JProgressBar;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.ProgressBarUI;

public class BasicProgressBarUI
extends ProgressBarUI {
    protected Rectangle boxRect;
    private transient Timer animationTimer;
    private transient int animationIndex;
    private transient int numFrames;
    private transient Animator animation;
    private transient PropertyChangeHandler propertyListener;
    protected ChangeListener changeListener;
    protected JProgressBar progressBar;
    transient double boxDependent = -1.0;
    transient int boxIndependent = -1;
    transient double incr = -1.0;
    private transient int cellLength;
    private transient int cellSpacing;
    private transient Color selectionBackground;
    private transient Color selectionForeground;
    private AncestorListener ancestorListener;
    private ComponentListener componentListener;

    public static ComponentUI createUI(JComponent jComponent) {
        return new BasicProgressBarUI();
    }

    protected int getAmountFull(Insets insets, int n, int n2) {
        double d = this.progressBar.getPercentComplete();
        if (this.progressBar.getOrientation() == 0) {
            return (int)(d * (double)(n - insets.left - insets.right));
        }
        return (int)(d * (double)(n2 - insets.top - insets.bottom));
    }

    protected int getAnimationIndex() {
        return this.animationIndex;
    }

    protected Rectangle getBox(Rectangle rectangle) {
        int n;
        if (!this.progressBar.isIndeterminate()) {
            return null;
        }
        if (rectangle == null) {
            rectangle = new Rectangle();
        }
        Rectangle rectangle2 = new Rectangle();
        SwingUtilities.calculateInnerArea(this.progressBar, rectangle2);
        if (this.incr == -1.0 || this.boxDependent == -1.0 || this.boxIndependent == -1) {
            n = this.numFrames / 2;
            if (this.progressBar.getOrientation() == 0) {
                this.boxDependent = (double)rectangle2.width / 6.0;
                this.incr = ((double)rectangle2.width - this.boxDependent) / (double)n;
                this.boxIndependent = rectangle2.height;
            } else {
                this.boxDependent = (double)rectangle2.height / 6.0;
                this.incr = ((double)rectangle2.height - this.boxDependent) / (double)n;
                this.boxIndependent = rectangle2.width;
            }
        }
        n = this.getAnimationIndex();
        if (this.animationIndex > this.numFrames / 2) {
            n = this.numFrames - this.getAnimationIndex();
        }
        if (this.progressBar.getOrientation() == 0) {
            rectangle.x = rectangle2.x + (int)(this.incr * (double)n);
            rectangle.y = rectangle2.y;
            rectangle.width = (int)this.boxDependent;
            rectangle.height = this.boxIndependent;
        } else {
            rectangle.x = rectangle2.x;
            rectangle.y = rectangle2.height - (int)(this.incr * (double)n) + rectangle2.y - (int)this.boxDependent;
            rectangle.width = this.boxIndependent;
            rectangle.height = (int)this.boxDependent;
        }
        return rectangle;
    }

    protected int getCellLength() {
        return this.cellLength;
    }

    protected int getCellSpacing() {
        return this.cellSpacing;
    }

    public Dimension getMaximumSize(JComponent jComponent) {
        Dimension dimension;
        Insets insets = jComponent.getInsets();
        int n = this.progressBar.getOrientation();
        if (n == 1) {
            dimension = this.getPreferredInnerVertical();
            dimension.height = Short.MAX_VALUE;
            dimension.width += insets.left + insets.right;
        } else {
            dimension = this.getPreferredInnerHorizontal();
            dimension.width = Short.MAX_VALUE;
            dimension.height += insets.top + insets.bottom;
        }
        return dimension;
    }

    public Dimension getMinimumSize(JComponent jComponent) {
        Dimension dimension;
        Insets insets = jComponent.getInsets();
        int n = this.progressBar.getOrientation();
        if (n == 1) {
            dimension = this.getPreferredInnerVertical();
            dimension.height = 10;
            dimension.width += insets.left + insets.right;
        } else {
            dimension = this.getPreferredInnerHorizontal();
            dimension.width = 10;
            dimension.height += insets.top + insets.bottom;
        }
        return dimension;
    }

    protected Dimension getPreferredInnerHorizontal() {
        Font font = this.progressBar.getFont();
        FontMetrics fontMetrics = this.progressBar.getFontMetrics(font);
        int n = 0;
        String string = this.progressBar.getString();
        if (string != null) {
            n = fontMetrics.stringWidth(this.progressBar.getString());
        }
        Insets insets = this.progressBar.getInsets();
        int n2 = Math.max(200 - insets.left - insets.right, n);
        int n3 = 0;
        if (string != null) {
            n3 = fontMetrics.getHeight();
        }
        int n4 = Math.max(16 - insets.top - insets.bottom, n3);
        return new Dimension(n2, n4);
    }

    protected Dimension getPreferredInnerVertical() {
        Font font = this.progressBar.getFont();
        FontMetrics fontMetrics = this.progressBar.getFontMetrics(font);
        int n = 0;
        String string = this.progressBar.getString();
        if (string != null) {
            n = fontMetrics.stringWidth(this.progressBar.getString());
        }
        Insets insets = this.progressBar.getInsets();
        int n2 = Math.max(200 - insets.left - insets.right, n);
        int n3 = 0;
        if (string != null) {
            n3 = fontMetrics.getHeight();
        }
        int n4 = Math.max(16 - insets.top - insets.bottom, n3);
        return new Dimension(n4, n2);
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        Insets insets = jComponent.getInsets();
        int n = this.progressBar.getOrientation();
        Dimension dimension = n == 1 ? this.getPreferredInnerVertical() : this.getPreferredInnerHorizontal();
        dimension.width += insets.left + insets.right;
        dimension.height += insets.top + insets.bottom;
        return dimension;
    }

    protected Color getSelectionBackground() {
        return this.selectionBackground;
    }

    protected Color getSelectionForeground() {
        return this.selectionForeground;
    }

    protected Point getStringPlacement(Graphics graphics, String string, int n, int n2, int n3, int n4) {
        Rectangle rectangle = new Rectangle();
        Rectangle rectangle2 = new Rectangle();
        Rectangle rectangle3 = new Rectangle();
        if (this.progressBar.getOrientation() == 0) {
            rectangle2.setBounds(n, n2, n3, n4);
        } else {
            rectangle2.setBounds(n2, n, n4, n3);
        }
        Font font = graphics.getFont();
        FontMetrics fontMetrics = graphics.getFontMetrics(font);
        SwingUtilities.layoutCompoundLabel(this.progressBar, fontMetrics, string, null, 0, 0, 0, 0, rectangle2, rectangle3, rectangle, 0);
        if (this.progressBar.getOrientation() == 0) {
            return new Point(rectangle.x, rectangle.y);
        }
        return new Point(rectangle.y, rectangle.x);
    }

    protected void incrementAnimationIndex() {
        ++this.animationIndex;
        if (this.animationIndex >= this.numFrames) {
            this.animationIndex = 0;
        }
        this.progressBar.repaint();
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        if (!this.progressBar.isIndeterminate()) {
            this.paintDeterminate(graphics, jComponent);
        } else {
            this.paintIndeterminate(graphics, jComponent);
        }
    }

    protected void paintDeterminate(Graphics graphics, JComponent jComponent) {
        Color color = graphics.getColor();
        int n = this.getCellSpacing();
        int n2 = this.getCellLength();
        int n3 = this.progressBar.getMaximum();
        int n4 = this.progressBar.getMinimum();
        int n5 = this.progressBar.getValue();
        Rectangle rectangle = SwingUtilities.calculateInnerArea(jComponent, new Rectangle());
        Rectangle rectangle2 = this.progressBar.getBounds();
        Insets insets = jComponent.getInsets();
        int n6 = this.getAmountFull(insets, rectangle2.width, rectangle2.height);
        if (this.progressBar.getOrientation() == 0) {
            graphics.setColor(jComponent.getForeground());
            graphics.fillRect(rectangle.x, rectangle.y, n6, rectangle.height);
        } else {
            graphics.setColor(jComponent.getForeground());
            graphics.fillRect(rectangle.x, rectangle.y + rectangle.height - n6, rectangle.width, n6);
        }
        if (this.progressBar.isStringPainted() && !this.progressBar.getString().equals("")) {
            this.paintString(graphics, 0, 0, rectangle2.width, rectangle2.height, n6, insets);
        }
        graphics.setColor(color);
    }

    protected void paintIndeterminate(Graphics graphics, JComponent jComponent) {
        Color color = graphics.getColor();
        Insets insets = jComponent.getInsets();
        Rectangle rectangle = jComponent.getBounds();
        Rectangle rectangle2 = new Rectangle();
        SwingUtilities.calculateInnerArea(jComponent, rectangle2);
        graphics.setColor(jComponent.getBackground());
        graphics.fillRect(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
        this.boxRect = this.getBox(this.boxRect);
        graphics.setColor(jComponent.getForeground());
        graphics.fillRect(this.boxRect.x, this.boxRect.y, this.boxRect.width, this.boxRect.height);
        if (this.progressBar.isStringPainted() && !this.progressBar.getString().equals("")) {
            this.paintString(graphics, 0, 0, rectangle.width, rectangle.height, this.getAmountFull(insets, rectangle.width, rectangle.height), insets);
        }
        graphics.setColor(color);
    }

    protected void paintString(Graphics graphics, int n, int n2, int n3, int n4, int n5, Insets insets) {
        String string = this.progressBar.getString();
        int n6 = this.getAmountFull(insets, n3, n4);
        Point point = this.getStringPlacement(graphics, this.progressBar.getString(), n + insets.left, n2 + insets.top, n3 - insets.left - insets.right, n4 - insets.top - insets.bottom);
        Color color = graphics.getColor();
        Shape shape = graphics.getClip();
        FontMetrics fontMetrics = graphics.getFontMetrics(this.progressBar.getFont());
        if (this.progressBar.getOrientation() == 1) {
            AffineTransform affineTransform = AffineTransform.getRotateInstance(1.5707963267948966);
            graphics.setFont(this.progressBar.getFont().deriveFont(affineTransform));
            point.x = n3 - point.x - fontMetrics.getAscent();
        } else {
            point.y += fontMetrics.getAscent();
        }
        graphics.setColor(this.getSelectionForeground());
        graphics.setClip(0, 0, n6 + insets.left, n4);
        graphics.drawString(string, point.x, point.y);
        graphics.setColor(this.getSelectionBackground());
        graphics.setClip(n6 + insets.left, 0, n3 - n6, n4);
        graphics.drawString(string, point.x, point.y);
        graphics.setClip(shape);
        graphics.setColor(color);
    }

    protected void setAnimationIndex(int n) {
        this.animationIndex = n <= this.numFrames ? n : 0;
        this.progressBar.repaint();
    }

    protected void setCellLength(int n) {
        this.cellLength = n;
    }

    protected void setCellSpacing(int n) {
        this.cellSpacing = n;
    }

    protected void startAnimationTimer() {
        if (this.animationTimer != null) {
            this.animationTimer.start();
        }
    }

    protected void stopAnimationTimer() {
        if (this.animationTimer != null) {
            this.animationTimer.stop();
        }
        this.setAnimationIndex(0);
    }

    protected void installDefaults() {
        LookAndFeel.installColorsAndFont(this.progressBar, "ProgressBar.background", "ProgressBar.foreground", "ProgressBar.font");
        LookAndFeel.installBorder(this.progressBar, "ProgressBar.border");
        this.progressBar.setOpaque(true);
        this.selectionForeground = UIManager.getColor("ProgressBar.selectionForeground");
        this.selectionBackground = UIManager.getColor("ProgressBar.selectionBackground");
        this.cellLength = UIManager.getInt("ProgressBar.cellLength");
        this.cellSpacing = UIManager.getInt("ProgressBar.cellSpacing");
        int n = UIManager.getInt("ProgressBar.repaintInterval");
        int n2 = UIManager.getInt("ProgressBar.cycleTime");
        if (n2 % n != 0 && n2 / n % 2 != 0) {
            int n3 = n2 / n + 2;
            n3 /= 2;
            n2 = (n3 *= 2) * n;
        }
        this.setAnimationIndex(0);
        this.numFrames = n2 / n;
        this.animationTimer.setDelay(n);
    }

    protected void uninstallDefaults() {
        this.progressBar.setFont(null);
        this.progressBar.setForeground(null);
        this.progressBar.setBackground(null);
        this.selectionForeground = null;
        this.selectionBackground = null;
    }

    protected void installListeners() {
        this.changeListener = new ChangeHandler();
        this.propertyListener = new PropertyChangeHandler();
        this.animation = new Animator();
        this.progressBar.addChangeListener(this.changeListener);
        this.progressBar.addPropertyChangeListener(this.propertyListener);
        this.animationTimer.addActionListener(this.animation);
        this.ancestorListener = new AncestorHandler();
        this.progressBar.addAncestorListener(this.ancestorListener);
        this.componentListener = new ComponentHandler();
        this.progressBar.addComponentListener(this.componentListener);
    }

    protected void uninstallListeners() {
        this.progressBar.removeChangeListener(this.changeListener);
        this.progressBar.removePropertyChangeListener(this.propertyListener);
        this.animationTimer.removeActionListener(this.animation);
        this.changeListener = null;
        this.propertyListener = null;
        this.animation = null;
        if (this.ancestorListener != null) {
            this.progressBar.removeAncestorListener(this.ancestorListener);
        }
        this.ancestorListener = null;
        if (this.componentListener != null) {
            this.progressBar.removeComponentListener(this.componentListener);
        }
        this.componentListener = null;
    }

    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        if (jComponent instanceof JProgressBar) {
            this.progressBar = (JProgressBar)jComponent;
            this.animationTimer = new Timer(200, null);
            this.animationTimer.setRepeats(true);
            this.installDefaults();
            this.installListeners();
        }
        if (this.progressBar.isIndeterminate()) {
            this.startAnimationTimer();
        }
    }

    public void uninstallUI(JComponent jComponent) {
        super.uninstallUI(jComponent);
        this.uninstallListeners();
        this.uninstallDefaults();
        this.animationTimer = null;
        this.progressBar = null;
    }

    private class ComponentHandler
    extends ComponentAdapter {
        private ComponentHandler() {
        }

        public void componentResized(ComponentEvent componentEvent) {
            BasicProgressBarUI.this.boxDependent = -1.0;
            BasicProgressBarUI.this.boxIndependent = -1;
            BasicProgressBarUI.this.incr = -1.0;
        }
    }

    private class Animator
    implements ActionListener {
        private Animator() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            BasicProgressBarUI.this.incrementAnimationIndex();
        }
    }

    private class AncestorHandler
    implements AncestorListener {
        private AncestorHandler() {
        }

        public void ancestorAdded(AncestorEvent ancestorEvent) {
            if (BasicProgressBarUI.this.progressBar.isIndeterminate()) {
                BasicProgressBarUI.this.startAnimationTimer();
            }
        }

        public void ancestorRemoved(AncestorEvent ancestorEvent) {
            BasicProgressBarUI.this.stopAnimationTimer();
        }

        public void ancestorMoved(AncestorEvent ancestorEvent) {
        }
    }

    private class PropertyChangeHandler
    implements PropertyChangeListener {
        private PropertyChangeHandler() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getPropertyName().equals("indeterminate")) {
                if (((Boolean)propertyChangeEvent.getNewValue()).booleanValue() && BasicProgressBarUI.this.progressBar.isShowing()) {
                    BasicProgressBarUI.this.startAnimationTimer();
                } else {
                    BasicProgressBarUI.this.stopAnimationTimer();
                }
            }
        }
    }

    public class ChangeHandler
    implements ChangeListener {
        public void stateChanged(ChangeEvent changeEvent) {
            BasicProgressBarUI.this.progressBar.repaint();
        }
    }
}

