/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.KeyboardFocusManager;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.util.EventListener;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.ComponentInputMap;
import javax.swing.JApplet;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JRootPane;
import javax.swing.LookAndFeel;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.plaf.ActionMapUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.PopupMenuUI;
import javax.swing.plaf.basic.BasicMenuItemUI;
import javax.swing.plaf.basic.DefaultMenuLayout;
import javax.swing.plaf.basic.SharedUIDefaults;

public class BasicPopupMenuUI
extends PopupMenuUI {
    protected JPopupMenu popupMenu;
    private transient PopupMenuListener popupMenuListener = new PopupMenuHandler();
    TopWindowListener topWindowListener = new TopWindowListener();
    private static int numPopups;
    private static KeyboardHelper keyboardHelper;

    public static ComponentUI createUI(JComponent jComponent) {
        return new BasicPopupMenuUI();
    }

    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        if (numPopups == 0) {
            keyboardHelper = new KeyboardHelper();
            MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
            menuSelectionManager.addChangeListener(keyboardHelper);
        }
        ++numPopups;
        this.popupMenu = (JPopupMenu)jComponent;
        this.popupMenu.setLayout(new DefaultMenuLayout(this.popupMenu, 1));
        this.popupMenu.setBorderPainted(true);
        JPopupMenu.setDefaultLightWeightPopupEnabled(true);
        this.installDefaults();
        this.installListeners();
        this.installKeyboardActions();
    }

    public void installDefaults() {
        LookAndFeel.installColorsAndFont(this.popupMenu, "PopupMenu.background", "PopupMenu.foreground", "PopupMenu.font");
        LookAndFeel.installBorder(this.popupMenu, "PopupMenu.border");
        this.popupMenu.setOpaque(true);
    }

    protected void installListeners() {
        this.popupMenu.addPopupMenuListener(this.popupMenuListener);
    }

    protected void installKeyboardActions() {
    }

    void installKeyboardActionsImpl() {
        Object[] objectArray = this.popupMenu.getComponentOrientation().isLeftToRight() ? (Object[])SharedUIDefaults.get("PopupMenu.selectedWindowInputMapBindings") : (Object[])SharedUIDefaults.get("PopupMenu.selectedWindowInputMapBindings.RightToLeft");
        ComponentInputMap componentInputMap = LookAndFeel.makeComponentInputMap(this.popupMenu, objectArray);
        SwingUtilities.replaceUIInputMap(this.popupMenu, 2, componentInputMap);
        SwingUtilities.replaceUIActionMap(this.popupMenu, this.getActionMap());
    }

    private ActionMap getActionMap() {
        ActionMap actionMap = (ActionMap)UIManager.get("PopupMenu.actionMap");
        if (actionMap == null) {
            actionMap = this.createDefaultActions();
            UIManager.getLookAndFeelDefaults().put("PopupMenu.actionMap", actionMap);
        }
        return actionMap;
    }

    private ActionMap createDefaultActions() {
        ActionMapUIResource actionMapUIResource = new ActionMapUIResource();
        NavigateAction navigateAction = new NavigateAction("selectNext");
        actionMapUIResource.put(navigateAction.getValue("Name"), navigateAction);
        navigateAction = new NavigateAction("selectPrevious");
        actionMapUIResource.put(navigateAction.getValue("Name"), navigateAction);
        navigateAction = new NavigateAction("selectParent");
        actionMapUIResource.put(navigateAction.getValue("Name"), navigateAction);
        navigateAction = new NavigateAction("selectChild");
        actionMapUIResource.put(navigateAction.getValue("Name"), navigateAction);
        navigateAction = new NavigateAction("return");
        actionMapUIResource.put(navigateAction.getValue("Name"), navigateAction);
        navigateAction = new NavigateAction("cancel");
        actionMapUIResource.put(navigateAction.getValue("Name"), navigateAction);
        return actionMapUIResource;
    }

    public void uninstallUI(JComponent jComponent) {
        this.uninstallListeners();
        this.uninstallDefaults();
        this.uninstallKeyboardActions();
        this.popupMenu = null;
        if (--numPopups == 0) {
            MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
            menuSelectionManager.removeChangeListener(keyboardHelper);
        }
    }

    protected void uninstallDefaults() {
        this.popupMenu.setBackground(null);
        this.popupMenu.setBorder(null);
        this.popupMenu.setFont(null);
        this.popupMenu.setForeground(null);
    }

    protected void uninstallListeners() {
        this.popupMenu.removePopupMenuListener(this.popupMenuListener);
    }

    protected void uninstallKeyboardActions() {
    }

    void uninstallKeyboardActionsImpl() {
        SwingUtilities.replaceUIInputMap(this.popupMenu, 2, null);
        SwingUtilities.replaceUIActionMap(this.popupMenu, null);
    }

    public Dimension getMinimumSize(JComponent jComponent) {
        return null;
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        return null;
    }

    public Dimension getMaximumSize(JComponent jComponent) {
        return null;
    }

    public boolean isPopupTrigger(MouseEvent mouseEvent) {
        return false;
    }

    private class TopWindowListener
    implements ComponentListener {
        private TopWindowListener() {
        }

        public void componentResized(ComponentEvent componentEvent) {
            MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
            menuSelectionManager.clearSelectedPath();
        }

        public void componentMoved(ComponentEvent componentEvent) {
            MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
            menuSelectionManager.clearSelectedPath();
        }

        public void componentShown(ComponentEvent componentEvent) {
            MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
            menuSelectionManager.clearSelectedPath();
        }

        public void componentHidden(ComponentEvent componentEvent) {
            MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
            menuSelectionManager.clearSelectedPath();
        }
    }

    private class PopupMenuHandler
    implements PopupMenuListener {
        private PopupMenuHandler() {
        }

        public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
            MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
            menuSelectionManager.clearSelectedPath();
        }

        public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
            Component component = BasicPopupMenuUI.this.popupMenu.getInvoker();
            Component component2 = SwingUtilities.getRoot(component);
            if (component2 != null) {
                component2.removeComponentListener(BasicPopupMenuUI.this.topWindowListener);
            }
        }

        public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
            MenuSelectionManager menuSelectionManager;
            Component component = BasicPopupMenuUI.this.popupMenu.getInvoker();
            Component component2 = SwingUtilities.getRoot(component);
            if (component2 != null) {
                component2.addComponentListener(BasicPopupMenuUI.this.topWindowListener);
            }
            if ((menuSelectionManager = MenuSelectionManager.defaultManager()).getSelectedPath().length == 0) {
                MenuElement[] menuElementArray = new MenuElement[2];
                menuElementArray[0] = BasicPopupMenuUI.this.popupMenu;
                Component[] componentArray = BasicPopupMenuUI.this.popupMenu.getComponents();
                if (componentArray.length != 0 && componentArray[0] instanceof MenuElement) {
                    menuElementArray[1] = (MenuElement)((Object)componentArray[0]);
                    menuSelectionManager.setSelectedPath(menuElementArray);
                }
            }
        }
    }

    private class KeyboardHelper
    implements ChangeListener {
        private MenuElement[] lastSelectedPath = new MenuElement[0];
        private Component lastFocused;
        private JRootPane invokerRootPane;

        private KeyboardHelper() {
        }

        /*
         * WARNING - void declaration
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void stateChanged(ChangeEvent changeEvent) {
            MenuSelectionManager menuSelectionManager = (MenuSelectionManager)changeEvent.getSource();
            MenuElement[] menuElementArray = menuSelectionManager.getSelectedPath();
            JPopupMenu jPopupMenu = this.getActivePopup(menuElementArray);
            if (jPopupMenu == null || jPopupMenu.isFocusable()) {
                if (this.lastSelectedPath.length != 0 && menuElementArray.length != 0 && !this.invokerEquals(menuElementArray[0], this.lastSelectedPath[0])) {
                    BasicPopupMenuUI.this.uninstallKeyboardActionsImpl();
                    this.lastSelectedPath = new MenuElement[0];
                }
                if (this.lastSelectedPath.length == 0 && menuElementArray.length > 0) {
                    void var5_9;
                    if (jPopupMenu == null) {
                        if (menuElementArray.length != 2 || !(menuElementArray[0] instanceof JMenuBar) || !(menuElementArray[1] instanceof JMenu)) return;
                        JComponent jComponent = (JComponent)((Object)menuElementArray[1]);
                        jPopupMenu = ((JMenu)jComponent).getPopupMenu();
                    } else {
                        Component component = jPopupMenu.getInvoker();
                        if (component instanceof JFrame) {
                            JRootPane jRootPane = ((JFrame)component).getRootPane();
                        } else if (component instanceof JApplet) {
                            JRootPane jRootPane = ((JApplet)component).getRootPane();
                        } else {
                            while (!(component instanceof JComponent)) {
                                if (component == null) {
                                    return;
                                }
                                component = component.getParent();
                            }
                            JComponent jComponent = (JComponent)component;
                        }
                    }
                    this.lastFocused = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
                    this.invokerRootPane = SwingUtilities.getRootPane((Component)var5_9);
                    if (this.invokerRootPane != null) {
                        this.invokerRootPane.requestFocus(true);
                        BasicPopupMenuUI.this.installKeyboardActionsImpl();
                    }
                } else if (this.lastSelectedPath.length != 0 && menuElementArray.length == 0) {
                    BasicPopupMenuUI.this.uninstallKeyboardActionsImpl();
                }
            }
            this.lastSelectedPath = menuElementArray;
        }

        private JPopupMenu getActivePopup(MenuElement[] menuElementArray) {
            JPopupMenu jPopupMenu = null;
            for (int i = menuElementArray.length - 1; i >= 0 && jPopupMenu == null; --i) {
                MenuElement menuElement = menuElementArray[i];
                if (!(menuElement instanceof JPopupMenu)) continue;
                jPopupMenu = (JPopupMenu)menuElement;
            }
            return jPopupMenu;
        }

        private boolean invokerEquals(MenuElement menuElement, MenuElement menuElement2) {
            Component component = menuElement.getComponent();
            Component component2 = menuElement2.getComponent();
            if (component instanceof JPopupMenu) {
                component = ((JPopupMenu)component).getInvoker();
            }
            if (component2 instanceof JPopupMenu) {
                component2 = ((JPopupMenu)component2).getInvoker();
            }
            return component == component2;
        }
    }

    private static class NavigateAction
    extends AbstractAction {
        NavigateAction(String string) {
            super(string);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = (String)this.getValue("Name");
            if (string.equals("selectNext")) {
                this.navigateNextPrevious(true);
            } else if (string.equals("selectPrevious")) {
                this.navigateNextPrevious(false);
            } else if (string.equals("selectChild")) {
                this.navigateParentChild(true);
            } else if (string.equals("selectParent")) {
                this.navigateParentChild(false);
            } else if (string.equals("cancel")) {
                this.cancel();
            } else if (string.equals("return")) {
                this.doReturn();
            } else assert (false) : "Must not reach here";
        }

        private void navigateNextPrevious(boolean bl) {
            MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
            MenuElement[] menuElementArray = menuSelectionManager.getSelectedPath();
            int n = menuElementArray.length;
            if (n >= 2) {
                if (menuElementArray[0] instanceof JMenuBar && menuElementArray[1] instanceof JMenu && n == 2) {
                    MenuElement[] menuElementArray2;
                    JPopupMenu jPopupMenu = ((JMenu)menuElementArray[1]).getPopupMenu();
                    MenuElement menuElement = this.findEnabledChild(jPopupMenu.getSubElements(), -1, true);
                    if (menuElement != null) {
                        menuElementArray2 = new MenuElement[4];
                        menuElementArray2[3] = menuElement;
                    } else {
                        menuElementArray2 = new MenuElement[3];
                    }
                    System.arraycopy(menuElementArray, 0, menuElementArray2, 0, 2);
                    menuElementArray2[2] = jPopupMenu;
                    menuSelectionManager.setSelectedPath(menuElementArray2);
                } else if (menuElementArray[n - 1] instanceof JPopupMenu && menuElementArray[n - 2] instanceof JMenu) {
                    JMenu jMenu = (JMenu)menuElementArray[n - 2];
                    JPopupMenu jPopupMenu = jMenu.getPopupMenu();
                    MenuElement menuElement = this.findEnabledChild(jPopupMenu.getSubElements(), -1, bl);
                    if (menuElement != null) {
                        MenuElement[] menuElementArray3 = new MenuElement[n + 1];
                        System.arraycopy(menuElementArray, 0, menuElementArray3, 0, n);
                        menuElementArray3[n] = menuElement;
                        menuSelectionManager.setSelectedPath(menuElementArray3);
                    } else if (n > 2 && menuElementArray[n - 3] instanceof JPopupMenu && (menuElement = this.findEnabledChild((jPopupMenu = (JPopupMenu)menuElementArray[n - 3]).getSubElements(), jMenu, bl)) != null && menuElement != jMenu) {
                        MenuElement[] menuElementArray4 = new MenuElement[n - 1];
                        System.arraycopy(menuElementArray, 0, menuElementArray4, 0, n - 2);
                        menuElementArray4[n - 2] = menuElement;
                        menuSelectionManager.setSelectedPath(menuElementArray4);
                    }
                } else {
                    MenuElement[] menuElementArray5 = menuElementArray[n - 2].getSubElements();
                    MenuElement menuElement = this.findEnabledChild(menuElementArray5, menuElementArray[n - 1], bl);
                    if (menuElement == null) {
                        menuElement = this.findEnabledChild(menuElementArray5, -1, bl);
                    }
                    if (menuElement != null) {
                        menuElementArray[n - 1] = menuElement;
                        menuSelectionManager.setSelectedPath(menuElementArray);
                    }
                }
            }
        }

        private MenuElement findEnabledChild(MenuElement[] menuElementArray, MenuElement menuElement, boolean bl) {
            MenuElement menuElement2 = null;
            for (int i = 0; i < menuElementArray.length && menuElement2 == null; ++i) {
                if (menuElementArray[i] != menuElement) continue;
                menuElement2 = this.findEnabledChild(menuElementArray, i, bl);
            }
            return menuElement2;
        }

        private MenuElement findEnabledChild(MenuElement[] menuElementArray, int n, boolean bl) {
            MenuElement menuElement = null;
            if (bl) {
                menuElement = this.findNextEnabledChild(menuElementArray, n + 1, menuElementArray.length - 1);
                if (menuElement == null) {
                    menuElement = this.findNextEnabledChild(menuElementArray, 0, n - 1);
                }
            } else {
                menuElement = this.findPreviousEnabledChild(menuElementArray, n - 1, 0);
                if (menuElement == null) {
                    menuElement = this.findPreviousEnabledChild(menuElementArray, menuElementArray.length - 1, n + 1);
                }
            }
            return menuElement;
        }

        private MenuElement findNextEnabledChild(MenuElement[] menuElementArray, int n, int n2) {
            MenuElement menuElement = null;
            for (int i = n; i <= n2 && menuElement == null; ++i) {
                Component component;
                if (menuElementArray[i] == null || (component = menuElementArray[i].getComponent()) == null || !component.isEnabled() || !component.isVisible()) continue;
                menuElement = menuElementArray[i];
            }
            return menuElement;
        }

        private MenuElement findPreviousEnabledChild(MenuElement[] menuElementArray, int n, int n2) {
            MenuElement menuElement = null;
            for (int i = n; i >= n2 && menuElement == null; --i) {
                Component component;
                if (menuElementArray[i] == null || (component = menuElementArray[i].getComponent()) == null || !component.isEnabled() || !component.isVisible()) continue;
                menuElement = menuElementArray[i];
            }
            return menuElement;
        }

        private void navigateParentChild(boolean bl) {
            MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
            MenuElement[] menuElementArray = menuSelectionManager.getSelectedPath();
            int n = menuElementArray.length;
            if (bl) {
                if (n > 0 && menuElementArray[n - 1] instanceof JMenu && !((JMenu)menuElementArray[n - 1]).isTopLevelMenu()) {
                    MenuElement[] menuElementArray2;
                    JMenu jMenu = (JMenu)menuElementArray[n - 1];
                    JPopupMenu jPopupMenu = jMenu.getPopupMenu();
                    MenuElement[] menuElementArray3 = jPopupMenu.getSubElements();
                    MenuElement menuElement = this.findEnabledChild(menuElementArray3, -1, true);
                    if (menuElement == null) {
                        menuElementArray2 = new MenuElement[n + 1];
                    } else {
                        menuElementArray2 = new MenuElement[n + 2];
                        menuElementArray2[n + 1] = menuElement;
                    }
                    System.arraycopy(menuElementArray, 0, menuElementArray2, 0, n);
                    menuElementArray2[n] = jPopupMenu;
                    menuSelectionManager.setSelectedPath(menuElementArray2);
                    return;
                }
            } else {
                int n2 = n - 1;
                if (n > 2 && (menuElementArray[n2] instanceof JPopupMenu || menuElementArray[--n2] instanceof JPopupMenu) && !((JMenu)menuElementArray[n2 - 1]).isTopLevelMenu()) {
                    MenuElement[] menuElementArray4 = new MenuElement[n2];
                    System.arraycopy(menuElementArray, 0, menuElementArray4, 0, n2);
                    menuSelectionManager.setSelectedPath(menuElementArray4);
                    return;
                }
            }
            if (n > 1 && menuElementArray[0] instanceof JMenuBar) {
                MenuElement menuElement = menuElementArray[1];
                MenuElement menuElement2 = this.findEnabledChild(menuElementArray[0].getSubElements(), menuElement, bl);
                if (menuElement2 != null && menuElement2 != menuElement) {
                    MenuElement[] menuElementArray5 = n == 2 ? new MenuElement[]{menuElementArray[0], menuElement2} : new MenuElement[]{menuElementArray[0], menuElement2, ((JMenu)menuElement2).getPopupMenu()};
                    menuSelectionManager.setSelectedPath(menuElementArray5);
                }
            }
        }

        private void cancel() {
            MenuElement[] menuElementArray;
            JPopupMenu jPopupMenu = this.getLastPopup();
            EventListener[] eventListenerArray = jPopupMenu.getListeners(PopupMenuListener.class);
            for (int i = 0; i < eventListenerArray.length; ++i) {
                menuElementArray = new PopupMenuEvent(jPopupMenu);
                ((PopupMenuListener)eventListenerArray[i]).popupMenuCanceled((PopupMenuEvent)menuElementArray);
            }
            MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
            menuElementArray = menuSelectionManager.getSelectedPath();
            if (menuElementArray.length > 4) {
                MenuElement[] menuElementArray2 = new MenuElement[menuElementArray.length - 2];
                System.arraycopy(menuElementArray, 0, menuElementArray2, 0, menuElementArray.length - 2);
                MenuSelectionManager.defaultManager().setSelectedPath(menuElementArray2);
            } else {
                menuSelectionManager.clearSelectedPath();
            }
        }

        private JPopupMenu getLastPopup() {
            MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
            MenuElement[] menuElementArray = menuSelectionManager.getSelectedPath();
            JPopupMenu jPopupMenu = null;
            for (int i = menuElementArray.length - 1; jPopupMenu == null && i >= 0; --i) {
                if (!(menuElementArray[i] instanceof JPopupMenu)) continue;
                jPopupMenu = (JPopupMenu)menuElementArray[i];
            }
            return jPopupMenu;
        }

        private void doReturn() {
            MenuSelectionManager menuSelectionManager;
            MenuElement[] menuElementArray;
            KeyboardFocusManager keyboardFocusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
            Component component = keyboardFocusManager.getFocusOwner();
            if ((component == null || component instanceof JRootPane) && (menuElementArray = (menuSelectionManager = MenuSelectionManager.defaultManager()).getSelectedPath()).length > 0) {
                MenuElement menuElement = menuElementArray[menuElementArray.length - 1];
                if (menuElement instanceof JMenu) {
                    MenuElement[] menuElementArray2 = new MenuElement[menuElementArray.length + 1];
                    System.arraycopy(menuElementArray, 0, menuElementArray2, 0, menuElementArray.length);
                    menuElementArray2[menuElementArray.length] = ((JMenu)menuElement).getPopupMenu();
                    menuSelectionManager.setSelectedPath(menuElementArray2);
                } else if (menuElement instanceof JMenuItem) {
                    JMenuItem jMenuItem = (JMenuItem)menuElement;
                    if (jMenuItem.getUI() instanceof BasicMenuItemUI) {
                        ((BasicMenuItemUI)jMenuItem.getUI()).doClick(menuSelectionManager);
                    } else {
                        menuSelectionManager.clearSelectedPath();
                        jMenuItem.doClick(0);
                    }
                }
            }
        }
    }
}

