/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import gnu.classpath.NotImplementedException;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPopupMenu;
import javax.swing.LookAndFeel;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.MenuDragMouseEvent;
import javax.swing.event.MenuDragMouseListener;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuKeyEvent;
import javax.swing.event.MenuKeyListener;
import javax.swing.event.MenuListener;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicMenuItemUI;

public class BasicMenuUI
extends BasicMenuItemUI {
    protected ChangeListener changeListener;
    protected MenuListener menuListener;
    protected PropertyChangeListener propertyChangeListener;

    public BasicMenuUI() {
        this.mouseInputListener = this.createMouseInputListener((JMenu)this.menuItem);
        this.menuListener = this.createMenuListener((JMenu)this.menuItem);
        this.propertyChangeListener = this.createPropertyChangeListener((JMenu)this.menuItem);
    }

    protected ChangeListener createChangeListener(JComponent jComponent) {
        return new ChangeHandler((JMenu)jComponent, this);
    }

    protected MenuDragMouseListener createMenuDragMouseListener(JComponent jComponent) {
        return new MenuDragMouseHandler();
    }

    protected MenuKeyListener createMenuKeyListener(JComponent jComponent) {
        return new MenuKeyHandler();
    }

    protected MenuListener createMenuListener(JComponent jComponent) {
        return new MenuHandler();
    }

    protected MouseInputListener createMouseInputListener(JComponent jComponent) {
        return new MouseInputHandler();
    }

    protected PropertyChangeListener createPropertyChangeListener(JComponent jComponent) {
        return new BasicMenuItemUI.PropertyChangeHandler();
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new BasicMenuUI();
    }

    public Dimension getMaximumSize(JComponent jComponent) {
        return jComponent.getPreferredSize();
    }

    protected String getPropertyPrefix() {
        return "Menu";
    }

    protected void installDefaults() {
        LookAndFeel.installBorder(this.menuItem, "Menu.border");
        LookAndFeel.installColorsAndFont(this.menuItem, "Menu.background", "Menu.foreground", "Menu.font");
        this.menuItem.setMargin(UIManager.getInsets("Menu.margin"));
        this.acceleratorFont = UIManager.getFont("Menu.acceleratorFont");
        this.acceleratorForeground = UIManager.getColor("Menu.acceleratorForeground");
        this.acceleratorSelectionForeground = UIManager.getColor("Menu.acceleratorSelectionForeground");
        this.selectionBackground = UIManager.getColor("Menu.selectionBackground");
        this.selectionForeground = UIManager.getColor("Menu.selectionForeground");
        this.arrowIcon = UIManager.getIcon("Menu.arrowIcon");
        this.oldBorderPainted = UIManager.getBoolean("Menu.borderPainted");
        ((JMenu)this.menuItem).setDelay(200);
    }

    protected void installKeyboardActions() {
        super.installKeyboardActions();
    }

    protected void installListeners() {
        super.installListeners();
        ((JMenu)this.menuItem).addMenuListener(this.menuListener);
    }

    protected void setupPostTimer(JMenu jMenu) {
        Timer timer = new Timer(jMenu.getDelay(), new SelectMenuAction());
        timer.setRepeats(false);
        timer.start();
    }

    protected void uninstallDefaults() {
        this.menuItem.setBackground(null);
        this.menuItem.setBorder(null);
        this.menuItem.setFont(null);
        this.menuItem.setForeground(null);
        this.menuItem.setMargin(null);
        this.acceleratorFont = null;
        this.acceleratorForeground = null;
        this.acceleratorSelectionForeground = null;
        this.selectionBackground = null;
        this.selectionForeground = null;
        this.arrowIcon = null;
    }

    protected void uninstallKeyboardActions() {
        super.installKeyboardActions();
    }

    protected void uninstallListeners() {
        super.uninstallListeners();
        ((JMenu)this.menuItem).removeMenuListener(this.menuListener);
    }

    private class MenuKeyHandler
    implements MenuKeyListener {
        private MenuKeyHandler() {
        }

        public void menuKeyPressed(MenuKeyEvent menuKeyEvent) {
        }

        public void menuKeyReleased(MenuKeyEvent menuKeyEvent) {
        }

        public void menuKeyTyped(MenuKeyEvent menuKeyEvent) throws NotImplementedException {
        }
    }

    private class MenuDragMouseHandler
    implements MenuDragMouseListener {
        private MenuDragMouseHandler() {
        }

        public void menuDragMouseDragged(MenuDragMouseEvent menuDragMouseEvent) {
            if (BasicMenuUI.this.menuItem.isEnabled()) {
                Component component;
                MenuSelectionManager menuSelectionManager = menuDragMouseEvent.getMenuSelectionManager();
                MenuElement[] menuElementArray = menuDragMouseEvent.getPath();
                Point point = menuDragMouseEvent.getPoint();
                if (point.x >= 0 && point.x < BasicMenuUI.this.menuItem.getWidth() && point.y >= 0 && point.y < BasicMenuUI.this.menuItem.getHeight()) {
                    JMenu jMenu = (JMenu)BasicMenuUI.this.menuItem;
                    MenuElement[] menuElementArray2 = menuSelectionManager.getSelectedPath();
                    if (menuElementArray2.length <= 0 || menuElementArray2[menuElementArray2.length - 1] != jMenu.getPopupMenu()) {
                        if (jMenu.isTopLevelMenu() || jMenu.getDelay() == 0 || menuDragMouseEvent.getID() == 506) {
                            MenuElement[] menuElementArray3 = new MenuElement[menuElementArray.length + 1];
                            System.arraycopy(menuElementArray, 0, menuElementArray3, 0, menuElementArray.length);
                            menuElementArray3[menuElementArray.length] = jMenu.getPopupMenu();
                            menuSelectionManager.setSelectedPath(menuElementArray3);
                        } else {
                            menuSelectionManager.setSelectedPath(menuElementArray);
                            BasicMenuUI.this.setupPostTimer(jMenu);
                        }
                    }
                } else if (menuDragMouseEvent.getID() == 502 && (component = menuSelectionManager.componentForPoint(menuDragMouseEvent.getComponent(), menuDragMouseEvent.getPoint())) == null) {
                    menuSelectionManager.clearSelectedPath();
                }
            }
        }

        public void menuDragMouseEntered(MenuDragMouseEvent menuDragMouseEvent) {
        }

        public void menuDragMouseExited(MenuDragMouseEvent menuDragMouseEvent) {
        }

        public void menuDragMouseReleased(MenuDragMouseEvent menuDragMouseEvent) {
        }
    }

    public class ChangeHandler
    implements ChangeListener {
        public boolean isSelected;
        public JMenu menu;
        public BasicMenuUI ui;
        public Component wasFocused;

        public ChangeHandler(JMenu jMenu, BasicMenuUI basicMenuUI2) {
            this.menu = jMenu;
            this.ui = basicMenuUI2;
        }

        public void stateChanged(ChangeEvent changeEvent) {
        }
    }

    private class MenuHandler
    implements MenuListener {
        private MenuHandler() {
        }

        public void menuCanceled(MenuEvent menuEvent) {
            this.menuDeselected(menuEvent);
        }

        public void menuDeselected(MenuEvent menuEvent) {
            JMenu jMenu = (JMenu)BasicMenuUI.this.menuItem;
            if (jMenu.getParent() != null) {
                if (jMenu.isTopLevelMenu()) {
                    ((JMenuBar)jMenu.getParent()).getSelectionModel().clearSelection();
                } else {
                    ((JPopupMenu)jMenu.getParent()).getSelectionModel().clearSelection();
                }
            }
        }

        public void menuSelected(MenuEvent menuEvent) {
            JMenu jMenu = (JMenu)BasicMenuUI.this.menuItem;
            if (jMenu.isTopLevelMenu()) {
                ((JMenuBar)jMenu.getParent()).setSelected(jMenu);
            } else {
                ((JPopupMenu)jMenu.getParent()).setSelected(jMenu);
            }
        }
    }

    protected class MouseInputHandler
    implements MouseInputListener {
        protected MouseInputHandler() {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
            menuSelectionManager.processMouseEvent(mouseEvent);
        }

        private boolean popupVisible() {
            JMenuBar jMenuBar = (JMenuBar)((JMenu)BasicMenuUI.this.menuItem).getParent();
            if (!jMenuBar.isSelected()) {
                return false;
            }
            for (int i = 0; i < jMenuBar.getMenuCount(); ++i) {
                JMenu jMenu = jMenuBar.getMenu(i);
                if (jMenu == null || !jMenu.isPopupMenuVisible()) continue;
                return true;
            }
            return false;
        }

        public void mouseEntered(MouseEvent mouseEvent) {
            JMenu jMenu = (JMenu)BasicMenuUI.this.menuItem;
            if (jMenu.isEnabled()) {
                MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
                MenuElement[] menuElementArray = menuSelectionManager.getSelectedPath();
                if (!jMenu.isTopLevelMenu()) {
                    if (menuElementArray.length <= 0 || menuElementArray[menuElementArray.length - 1] != jMenu.getPopupMenu()) {
                        if (jMenu.getDelay() == 0) {
                            MenuElement[] menuElementArray2 = BasicMenuUI.this.getPath();
                            MenuElement[] menuElementArray3 = new MenuElement[menuElementArray2.length + 1];
                            System.arraycopy(menuElementArray2, 0, menuElementArray3, 0, menuElementArray2.length);
                            menuElementArray3[menuElementArray2.length] = jMenu.getPopupMenu();
                            menuSelectionManager.setSelectedPath(menuElementArray3);
                        } else {
                            menuSelectionManager.setSelectedPath(BasicMenuUI.this.getPath());
                            BasicMenuUI.this.setupPostTimer(jMenu);
                        }
                    }
                } else if (menuElementArray.length > 0 && menuElementArray[0] == jMenu.getParent()) {
                    MenuElement[] menuElementArray4 = new MenuElement[]{(MenuElement)((Object)jMenu.getParent()), jMenu, jMenu.getPopupMenu()};
                    menuSelectionManager.setSelectedPath(menuElementArray4);
                }
            }
        }

        public void mouseExited(MouseEvent mouseEvent) {
            MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
            menuSelectionManager.processMouseEvent(mouseEvent);
        }

        public void mouseMoved(MouseEvent mouseEvent) {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
            JMenu jMenu = (JMenu)BasicMenuUI.this.menuItem;
            if (jMenu.isEnabled()) {
                MenuElement[] menuElementArray;
                Object object;
                if (jMenu.isTopLevelMenu()) {
                    if (jMenu.isSelected()) {
                        menuSelectionManager.clearSelectedPath();
                    } else {
                        object = jMenu.getParent();
                        if (object != null && object instanceof JMenuBar) {
                            menuElementArray = new MenuElement[]{(MenuElement)object, jMenu};
                            menuSelectionManager.setSelectedPath(menuElementArray);
                        }
                    }
                }
                if (((MenuElement[])(object = menuSelectionManager.getSelectedPath())).length > 0 && object[((MenuElement[])object).length - 1] != jMenu.getPopupMenu()) {
                    if (jMenu.isTopLevelMenu() || jMenu.getDelay() == 0) {
                        menuElementArray = new MenuElement[((MenuElement[])object).length + 1];
                        System.arraycopy(object, 0, menuElementArray, 0, ((MenuElement[])object).length);
                        menuElementArray[((MenuElement[])object).length] = jMenu.getPopupMenu();
                        menuSelectionManager.setSelectedPath(menuElementArray);
                    } else {
                        BasicMenuUI.this.setupPostTimer(jMenu);
                    }
                }
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
            menuSelectionManager.processMouseEvent(mouseEvent);
        }
    }

    class SelectMenuAction
    extends AbstractAction {
        SelectMenuAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JMenu jMenu = (JMenu)BasicMenuUI.this.menuItem;
            MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
            MenuElement[] menuElementArray = menuSelectionManager.getSelectedPath();
            if (menuElementArray.length > 0 && menuElementArray[menuElementArray.length - 1] == jMenu) {
                MenuElement[] menuElementArray2 = new MenuElement[menuElementArray.length + 1];
                System.arraycopy(menuElementArray, 0, menuElementArray2, 0, menuElementArray.length);
                menuElementArray2[menuElementArray.length] = jMenu.getPopupMenu();
                menuSelectionManager.setSelectedPath(menuElementArray2);
            }
        }
    }
}

