/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.KeyStroke;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.LabelUI;
import javax.swing.plaf.basic.BasicGraphicsUtils;
import javax.swing.plaf.basic.BasicHTML;
import javax.swing.text.View;

public class BasicLabelUI
extends LabelUI
implements PropertyChangeListener {
    protected static BasicLabelUI labelUI;
    private Rectangle vr = new Rectangle();
    private Rectangle ir = new Rectangle();
    private Rectangle tr = new Rectangle();
    private Insets cachedInsets;

    public static ComponentUI createUI(JComponent jComponent) {
        if (labelUI == null) {
            labelUI = new BasicLabelUI();
        }
        return labelUI;
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        Dimension dimension;
        JLabel jLabel = (JLabel)jComponent;
        Insets insets = jLabel.getInsets();
        int n = insets.left + insets.right;
        int n2 = insets.top + insets.bottom;
        Icon icon = jLabel.getIcon();
        String string = jLabel.getText();
        if (icon == null && string == null) {
            dimension = new Dimension(n, n2);
        } else if (icon != null && string == null) {
            dimension = new Dimension(icon.getIconWidth() + n, icon.getIconHeight() + n2);
        } else {
            FontMetrics fontMetrics = this.getFontMetrics(jLabel);
            this.ir.x = 0;
            this.ir.y = 0;
            this.ir.width = 0;
            this.ir.height = 0;
            this.tr.x = 0;
            this.tr.y = 0;
            this.tr.width = 0;
            this.tr.height = 0;
            this.vr.x = 0;
            this.vr.y = 0;
            this.vr.width = Short.MAX_VALUE;
            this.vr.height = Short.MAX_VALUE;
            this.layoutCL(jLabel, fontMetrics, string, icon, this.vr, this.ir, this.tr);
            Rectangle rectangle = SwingUtilities.computeUnion(this.tr.x, this.tr.y, this.tr.width, this.tr.height, this.ir);
            dimension = new Dimension(rectangle.width + n, rectangle.height + n2);
        }
        return dimension;
    }

    public Dimension getMinimumSize(JComponent jComponent) {
        return this.getPreferredSize(jComponent);
    }

    public Dimension getMaximumSize(JComponent jComponent) {
        return this.getPreferredSize(jComponent);
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        JLabel jLabel = (JLabel)jComponent;
        Icon icon = jLabel.isEnabled() ? jLabel.getIcon() : jLabel.getDisabledIcon();
        String string = jLabel.getText();
        if (icon != null || string != null && !string.equals("")) {
            FontMetrics fontMetrics = this.getFontMetrics(jLabel);
            Insets insets = jComponent.getInsets(this.cachedInsets);
            this.vr.x = insets.left;
            this.vr.y = insets.right;
            this.vr.width = jComponent.getWidth() - insets.left - insets.right;
            this.vr.height = jComponent.getHeight() - insets.top - insets.bottom;
            this.ir.x = 0;
            this.ir.y = 0;
            this.ir.width = 0;
            this.ir.height = 0;
            this.tr.x = 0;
            this.tr.y = 0;
            this.tr.width = 0;
            this.tr.height = 0;
            string = this.layoutCL(jLabel, fontMetrics, string, icon, this.vr, this.ir, this.tr);
            if (icon != null) {
                icon.paintIcon(jLabel, graphics, this.ir.x, this.ir.y);
            }
            if (string != null && !string.equals("")) {
                Object object = jLabel.getClientProperty("html");
                if (object == null) {
                    if (jLabel.isEnabled()) {
                        this.paintEnabledText(jLabel, graphics, string, this.tr.x, this.tr.y + fontMetrics.getAscent());
                    } else {
                        this.paintDisabledText(jLabel, graphics, string, this.tr.x, this.tr.y + fontMetrics.getAscent());
                    }
                } else {
                    ((View)object).paint(graphics, this.tr);
                }
            }
        }
    }

    protected String layoutCL(JLabel jLabel, FontMetrics fontMetrics, String string, Icon icon, Rectangle rectangle, Rectangle rectangle2, Rectangle rectangle3) {
        return SwingUtilities.layoutCompoundLabel(jLabel, fontMetrics, string, icon, jLabel.getVerticalAlignment(), jLabel.getHorizontalAlignment(), jLabel.getVerticalTextPosition(), jLabel.getHorizontalTextPosition(), rectangle, rectangle2, rectangle3, jLabel.getIconTextGap());
    }

    protected void paintDisabledText(JLabel jLabel, Graphics graphics, String string, int n, int n2) {
        graphics.setColor(jLabel.getBackground().brighter());
        int n3 = jLabel.getDisplayedMnemonicIndex();
        if (n3 != -1) {
            BasicGraphicsUtils.drawStringUnderlineCharAt(graphics, string, n3, n, n2);
        } else {
            graphics.drawString(string, n, n2);
        }
        graphics.setColor(jLabel.getBackground().darker());
        if (n3 != -1) {
            BasicGraphicsUtils.drawStringUnderlineCharAt(graphics, string, n3, n + 1, n2 + 1);
        } else {
            graphics.drawString(string, n + 1, n2 + 1);
        }
    }

    protected void paintEnabledText(JLabel jLabel, Graphics graphics, String string, int n, int n2) {
        graphics.setColor(jLabel.getForeground());
        int n3 = jLabel.getDisplayedMnemonicIndex();
        if (n3 != -1) {
            BasicGraphicsUtils.drawStringUnderlineCharAt(graphics, string, n3, n, n2);
        } else {
            graphics.drawString(string, n, n2);
        }
    }

    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        if (jComponent instanceof JLabel) {
            JLabel jLabel = (JLabel)jComponent;
            this.installComponents(jLabel);
            this.installDefaults(jLabel);
            this.installListeners(jLabel);
            this.installKeyboardActions(jLabel);
        }
    }

    public void uninstallUI(JComponent jComponent) {
        super.uninstallUI(jComponent);
        if (jComponent instanceof JLabel) {
            JLabel jLabel = (JLabel)jComponent;
            this.uninstallKeyboardActions(jLabel);
            this.uninstallListeners(jLabel);
            this.uninstallDefaults(jLabel);
            this.uninstallComponents(jLabel);
        }
    }

    protected void installComponents(JLabel jLabel) {
        BasicHTML.updateRenderer(jLabel, jLabel.getText());
    }

    protected void uninstallComponents(JLabel jLabel) {
        jLabel.putClientProperty("html", null);
        jLabel.putClientProperty("html.base", null);
    }

    protected void installDefaults(JLabel jLabel) {
        LookAndFeel.installColorsAndFont(jLabel, "Label.background", "Label.foreground", "Label.font");
    }

    protected void uninstallDefaults(JLabel jLabel) {
        jLabel.setForeground(null);
        jLabel.setBackground(null);
        jLabel.setFont(null);
    }

    protected void installKeyboardActions(JLabel jLabel) {
        int n;
        Component component = jLabel.getLabelFor();
        if (component != null && (n = jLabel.getDisplayedMnemonic()) > 0) {
            InputMap inputMap = new InputMap();
            inputMap.put(KeyStroke.getKeyStroke(n, 18), "press");
            SwingUtilities.replaceUIInputMap(jLabel, 2, inputMap);
            ActionMap actionMap = new ActionMap();
            actionMap.put("press", new AbstractAction(){

                public void actionPerformed(ActionEvent actionEvent) {
                    JLabel jLabel = (JLabel)actionEvent.getSource();
                    Component component = jLabel.getLabelFor();
                    if (component != null) {
                        component.requestFocus();
                    }
                }
            });
            SwingUtilities.replaceUIActionMap(jLabel, actionMap);
        }
    }

    protected void uninstallKeyboardActions(JLabel jLabel) {
        SwingUtilities.replaceUIActionMap(jLabel, null);
        SwingUtilities.replaceUIInputMap(jLabel, 2, null);
    }

    protected void installListeners(JLabel jLabel) {
        jLabel.addPropertyChangeListener(this);
    }

    protected void uninstallListeners(JLabel jLabel) {
        jLabel.removePropertyChangeListener(this);
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName().equals("text")) {
            String string = (String)propertyChangeEvent.getNewValue();
            JLabel jLabel = (JLabel)propertyChangeEvent.getSource();
            BasicHTML.updateRenderer(jLabel, string);
        } else if (propertyChangeEvent.getPropertyName().equals("displayedMnemonic")) {
            JLabel jLabel = (JLabel)propertyChangeEvent.getSource();
            if (jLabel.getLabelFor() != null) {
                int n = (Integer)propertyChangeEvent.getOldValue();
                int n2 = (Integer)propertyChangeEvent.getNewValue();
                InputMap inputMap = jLabel.getInputMap(2);
                inputMap.put(KeyStroke.getKeyStroke(n, 512), null);
                inputMap.put(KeyStroke.getKeyStroke(n2, 512), "press");
            }
        } else if (propertyChangeEvent.getPropertyName().equals("labelFor")) {
            JLabel jLabel = (JLabel)propertyChangeEvent.getSource();
            InputMap inputMap = jLabel.getInputMap(2);
            int n = jLabel.getDisplayedMnemonic();
            if (n > 0) {
                inputMap.put(KeyStroke.getKeyStroke(n, 512), "press");
            }
        }
    }

    private FontMetrics getFontMetrics(JLabel jLabel) {
        Font font = jLabel.getFont();
        FontMetrics fontMetrics = jLabel.getFontMetrics(font);
        if (fontMetrics == null) {
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            fontMetrics = toolkit.getFontMetrics(font);
        }
        return fontMetrics;
    }
}

