/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Hashtable;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileSystemView;
import javax.swing.filechooser.FileView;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.FileChooserUI;
import javax.swing.plaf.basic.BasicDirectoryModel;
import javax.swing.plaf.metal.MetalIconFactory;

public class BasicFileChooserUI
extends FileChooserUI {
    protected int cancelButtonMnemonic;
    protected String cancelButtonText;
    protected String cancelButtonToolTipText;
    protected Icon computerIcon;
    protected Icon detailsViewIcon;
    protected Icon directoryIcon;
    protected int directoryOpenButtonMnemonic;
    protected String directoryOpenButtonText;
    protected String directoryOpenButtonToolTipText;
    protected Icon fileIcon;
    protected Icon floppyDriveIcon;
    protected Icon hardDriveIcon;
    protected int helpButtonMnemonic;
    protected String helpButtonText;
    protected String helpButtonToolTipText;
    protected Icon homeFolderIcon;
    protected Icon listViewIcon;
    protected Icon newFolderIcon;
    protected int openButtonMnemonic;
    protected String openButtonText;
    protected String openButtonToolTipText;
    protected int saveButtonMnemonic;
    protected String saveButtonText;
    protected String saveButtonToolTipText;
    protected int updateButtonMnemonic;
    protected String updateButtonText;
    protected String updateButtonToolTipText;
    protected Icon upFolderIcon;
    JFileChooser filechooser;
    BasicDirectoryModel model;
    FileFilter acceptAll;
    FileView fv;
    JButton accept;
    JPanel accessoryPanel;
    PropertyChangeListener propertyChangeListener;
    String acceptAllFileFilterText;
    String dirDescText;
    String fileDescText;
    boolean dirSelected;
    File currDir;
    JPanel bottomPanel;
    JPanel closePanel;
    JTextField entry;
    String parentPath;
    private ApproveSelectionAction approveSelectionAction;
    private CancelSelectionAction cancelSelectionAction;
    private GoHomeAction goHomeAction;
    private ChangeToParentDirectoryAction changeToParentDirectoryAction;
    private NewFolderAction newFolderAction;
    private UpdateAction updateAction;
    private File selectedDir;

    void closeDialog() {
        Window window = SwingUtilities.windowForComponent(this.filechooser);
        if (window instanceof JDialog) {
            ((JDialog)window).dispose();
        }
    }

    public BasicFileChooserUI(JFileChooser jFileChooser) {
        this.newFolderIcon = this.directoryIcon;
        this.acceptAll = new AcceptAllFileFilter();
        this.fv = new BasicFileView();
        this.accessoryPanel = new JPanel();
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new BasicFileChooserUI((JFileChooser)jComponent);
    }

    public void installUI(JComponent jComponent) {
        if (jComponent instanceof JFileChooser) {
            JFileChooser jFileChooser;
            this.filechooser = jFileChooser = (JFileChooser)jComponent;
            jFileChooser.resetChoosableFileFilters();
            this.createModel();
            this.clearIconCache();
            this.installDefaults(jFileChooser);
            this.installComponents(jFileChooser);
            this.installListeners(jFileChooser);
            File file = this.filechooser.getCurrentDirectory();
            if (file != null) {
                this.parentPath = file.getParent();
            }
        }
    }

    public void uninstallUI(JComponent jComponent) {
        this.model = null;
        this.uninstallListeners(this.filechooser);
        this.uninstallComponents(this.filechooser);
        this.uninstallDefaults(this.filechooser);
        this.filechooser = null;
    }

    void boxEntries() {
        ArrayList<String> arrayList = new ArrayList<String>();
        File file = this.filechooser.getCurrentDirectory();
        if (file == null) {
            file = this.filechooser.getFileSystemView().getDefaultDirectory();
        }
        while (file != null) {
            String string = file.getName();
            if (string.equals("")) {
                string = file.getAbsolutePath();
            }
            arrayList.add(arrayList.size(), string);
            file = file.getParentFile();
        }
        if (arrayList.size() == 0) {
            return;
        }
    }

    public void installComponents(JFileChooser jFileChooser) {
    }

    public void uninstallComponents(JFileChooser jFileChooser) {
    }

    protected void installListeners(JFileChooser jFileChooser) {
        this.propertyChangeListener = this.createPropertyChangeListener(this.filechooser);
        if (this.propertyChangeListener != null) {
            this.filechooser.addPropertyChangeListener(this.propertyChangeListener);
        }
        jFileChooser.addPropertyChangeListener(this.getModel());
    }

    protected void uninstallListeners(JFileChooser jFileChooser) {
        if (this.propertyChangeListener != null) {
            this.filechooser.removePropertyChangeListener(this.propertyChangeListener);
            this.propertyChangeListener = null;
        }
        jFileChooser.removePropertyChangeListener(this.getModel());
    }

    protected void installDefaults(JFileChooser jFileChooser) {
        this.installIcons(jFileChooser);
        this.installStrings(jFileChooser);
    }

    protected void uninstallDefaults(JFileChooser jFileChooser) {
        this.uninstallStrings(jFileChooser);
        this.uninstallIcons(jFileChooser);
    }

    protected void installIcons(JFileChooser jFileChooser) {
        UIDefaults uIDefaults = UIManager.getLookAndFeelDefaults();
        this.computerIcon = MetalIconFactory.getTreeComputerIcon();
        this.detailsViewIcon = uIDefaults.getIcon("FileChooser.detailsViewIcon");
        this.directoryIcon = new MetalIconFactory.TreeFolderIcon();
        this.fileIcon = new MetalIconFactory.TreeLeafIcon();
        this.floppyDriveIcon = MetalIconFactory.getTreeFloppyDriveIcon();
        this.hardDriveIcon = MetalIconFactory.getTreeHardDriveIcon();
        this.homeFolderIcon = uIDefaults.getIcon("FileChooser.homeFolderIcon");
        this.listViewIcon = uIDefaults.getIcon("FileChooser.listViewIcon");
        this.newFolderIcon = uIDefaults.getIcon("FileChooser.newFolderIcon");
        this.upFolderIcon = uIDefaults.getIcon("FileChooser.upFolderIcon");
    }

    protected void uninstallIcons(JFileChooser jFileChooser) {
        this.computerIcon = null;
        this.detailsViewIcon = null;
        this.directoryIcon = null;
        this.fileIcon = null;
        this.floppyDriveIcon = null;
        this.hardDriveIcon = null;
        this.homeFolderIcon = null;
        this.listViewIcon = null;
        this.newFolderIcon = null;
        this.upFolderIcon = null;
    }

    protected void installStrings(JFileChooser jFileChooser) {
        UIDefaults uIDefaults = UIManager.getLookAndFeelDefaults();
        this.dirDescText = uIDefaults.getString("FileChooser.directoryDescriptionText");
        this.fileDescText = uIDefaults.getString("FileChooser.fileDescriptionText");
        this.acceptAllFileFilterText = uIDefaults.getString("FileChooser.acceptAllFileFilterText");
        this.cancelButtonText = "Cancel";
        this.cancelButtonToolTipText = "Abort file chooser dialog";
        this.cancelButtonMnemonic = new Integer((String)UIManager.get("FileChooser.cancelButtonMnemonic"));
        this.directoryOpenButtonText = "Open";
        this.directoryOpenButtonToolTipText = "Open selected directory";
        this.directoryOpenButtonMnemonic = new Integer((String)UIManager.get("FileChooser.directoryOpenButtonMnemonic"));
        this.helpButtonText = "Help";
        this.helpButtonToolTipText = "FileChooser help";
        this.helpButtonMnemonic = new Integer((String)UIManager.get("FileChooser.helpButtonMnemonic"));
        this.openButtonText = "Open";
        this.openButtonToolTipText = "Open selected file";
        this.openButtonMnemonic = new Integer((String)UIManager.get("FileChooser.openButtonMnemonic"));
        this.saveButtonText = "Save";
        this.saveButtonToolTipText = "Save selected file";
        this.saveButtonMnemonic = new Integer((String)UIManager.get("FileChooser.saveButtonMnemonic"));
        this.updateButtonText = "Update";
        this.updateButtonToolTipText = "Update directory listing";
        this.updateButtonMnemonic = new Integer((String)UIManager.get("FileChooser.updateButtonMnemonic"));
    }

    protected void uninstallStrings(JFileChooser jFileChooser) {
        this.acceptAllFileFilterText = null;
        this.dirDescText = null;
        this.fileDescText = null;
        this.cancelButtonText = null;
        this.cancelButtonToolTipText = null;
        this.directoryOpenButtonText = null;
        this.directoryOpenButtonToolTipText = null;
        this.helpButtonText = null;
        this.helpButtonToolTipText = null;
        this.openButtonText = null;
        this.openButtonToolTipText = null;
        this.saveButtonText = null;
        this.saveButtonToolTipText = null;
        this.updateButtonText = null;
        this.updateButtonToolTipText = null;
    }

    protected void createModel() {
        this.model = new BasicDirectoryModel(this.filechooser);
    }

    public BasicDirectoryModel getModel() {
        return this.model;
    }

    public PropertyChangeListener createPropertyChangeListener(JFileChooser jFileChooser) {
        return null;
    }

    public String getFileName() {
        return this.entry.getText();
    }

    public String getDirectoryName() {
        return null;
    }

    public void setFileName(String string) {
    }

    public void setDirectoryName(String string) {
    }

    public void rescanCurrentDirectory(JFileChooser jFileChooser) {
        this.getModel().validateFileCache();
    }

    public void ensureFileIsVisible(JFileChooser jFileChooser, File file) {
    }

    public JFileChooser getFileChooser() {
        return this.filechooser;
    }

    public JPanel getAccessoryPanel() {
        return this.accessoryPanel;
    }

    protected JButton getApproveButton(JFileChooser jFileChooser) {
        return this.accept;
    }

    public String getApproveButtonToolTipText(JFileChooser jFileChooser) {
        if (jFileChooser.getApproveButtonToolTipText() != null) {
            return jFileChooser.getApproveButtonToolTipText();
        }
        if (jFileChooser.getDialogType() == 1) {
            return this.saveButtonToolTipText;
        }
        return this.openButtonToolTipText;
    }

    public void clearIconCache() {
        if (this.fv instanceof BasicFileView) {
            ((BasicFileView)this.fv).clearIconCache();
        }
    }

    public ListSelectionListener createListSelectionListener(JFileChooser jFileChooser) {
        return new SelectionListener();
    }

    protected MouseListener createDoubleClickListener(JFileChooser jFileChooser, JList jList) {
        return new DoubleClickListener(jList);
    }

    protected boolean isDirectorySelected() {
        return this.dirSelected;
    }

    protected void setDirectorySelected(boolean bl) {
        this.dirSelected = bl;
    }

    protected File getDirectory() {
        return this.currDir;
    }

    protected void setDirectory(File file) {
        this.currDir = file;
    }

    public FileFilter getAcceptAllFileFilter(JFileChooser jFileChooser) {
        return this.acceptAll;
    }

    public FileView getFileView(JFileChooser jFileChooser) {
        return this.fv;
    }

    public String getDialogTitle(JFileChooser jFileChooser) {
        String string = jFileChooser.getDialogTitle();
        if (string == null) {
            string = this.getApproveButtonText(jFileChooser);
        }
        return string;
    }

    public int getApproveButtonMnemonic(JFileChooser jFileChooser) {
        if (jFileChooser.getApproveButtonMnemonic() != 0) {
            return jFileChooser.getApproveButtonMnemonic();
        }
        if (jFileChooser.getDialogType() == 1) {
            return this.saveButtonMnemonic;
        }
        return this.openButtonMnemonic;
    }

    public String getApproveButtonText(JFileChooser jFileChooser) {
        String string = jFileChooser.getApproveButtonText();
        if (string == null) {
            string = jFileChooser.getDialogType() == 1 ? this.saveButtonText : this.openButtonText;
        }
        return string;
    }

    public Action getNewFolderAction() {
        if (this.newFolderAction == null) {
            this.newFolderAction = new NewFolderAction();
        }
        return this.newFolderAction;
    }

    public Action getGoHomeAction() {
        if (this.goHomeAction == null) {
            this.goHomeAction = new GoHomeAction();
        }
        return this.goHomeAction;
    }

    public Action getChangeToParentDirectoryAction() {
        if (this.changeToParentDirectoryAction == null) {
            this.changeToParentDirectoryAction = new ChangeToParentDirectoryAction();
        }
        return this.changeToParentDirectoryAction;
    }

    public Action getApproveSelectionAction() {
        if (this.approveSelectionAction == null) {
            this.approveSelectionAction = new ApproveSelectionAction();
        }
        return this.approveSelectionAction;
    }

    public Action getCancelSelectionAction() {
        if (this.cancelSelectionAction == null) {
            this.cancelSelectionAction = new CancelSelectionAction();
        }
        return this.cancelSelectionAction;
    }

    public Action getUpdateAction() {
        if (this.updateAction == null) {
            this.updateAction = new UpdateAction();
        }
        return this.updateAction;
    }

    protected class UpdateAction
    extends AbstractAction {
        protected UpdateAction() {
            super(null);
        }

        public void actionPerformed(ActionEvent actionEvent) {
        }
    }

    protected class SelectionListener
    implements ListSelectionListener {
        protected SelectionListener() {
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            JList jList = (JList)listSelectionEvent.getSource();
            Object object = jList.getSelectedValue();
            if (object == null) {
                return;
            }
            File file = BasicFileChooserUI.this.filechooser.getFileSystemView().createFileObject(object.toString());
            if (!BasicFileChooserUI.this.filechooser.isTraversable(file)) {
                BasicFileChooserUI.this.selectedDir = null;
                BasicFileChooserUI.this.filechooser.setSelectedFile(file);
            } else {
                BasicFileChooserUI.this.selectedDir = file;
                BasicFileChooserUI.this.filechooser.setSelectedFile(null);
            }
        }
    }

    protected class NewFolderAction
    extends AbstractAction {
        protected NewFolderAction() {
            super("New Folder");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            try {
                BasicFileChooserUI.this.filechooser.getFileSystemView().createNewFolder(BasicFileChooserUI.this.filechooser.getCurrentDirectory());
            }
            catch (IOException iOException) {
                return;
            }
            BasicFileChooserUI.this.filechooser.rescanCurrentDirectory();
            BasicFileChooserUI.this.filechooser.repaint();
        }
    }

    protected class GoHomeAction
    extends AbstractAction {
        protected GoHomeAction() {
            super("Go Home");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            BasicFileChooserUI.this.filechooser.setCurrentDirectory(BasicFileChooserUI.this.filechooser.getFileSystemView().getHomeDirectory());
            BasicFileChooserUI.this.filechooser.revalidate();
            BasicFileChooserUI.this.filechooser.repaint();
        }
    }

    protected class DoubleClickListener
    extends MouseAdapter {
        private Object lastSelected;
        private JList list;

        public DoubleClickListener(JList jList) {
            this.list = jList;
            this.lastSelected = jList.getSelectedValue();
            BasicFileChooserUI.this.setDirectorySelected(false);
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            Object object = this.list.getSelectedValue();
            if (object == null) {
                return;
            }
            FileSystemView fileSystemView = BasicFileChooserUI.this.filechooser.getFileSystemView();
            if (mouseEvent.getClickCount() >= 2 && this.lastSelected != null && object.toString().equals(this.lastSelected.toString())) {
                File file = fileSystemView.createFileObject(this.lastSelected.toString());
                if (BasicFileChooserUI.this.filechooser.isTraversable(file)) {
                    BasicFileChooserUI.this.filechooser.setCurrentDirectory(file);
                    BasicFileChooserUI.this.filechooser.rescanCurrentDirectory();
                } else {
                    BasicFileChooserUI.this.filechooser.setSelectedFile(file);
                    BasicFileChooserUI.this.filechooser.approveSelection();
                    BasicFileChooserUI.this.closeDialog();
                }
            } else {
                String string = object.toString();
                File file = fileSystemView.createFileObject(string);
                BasicFileChooserUI.this.filechooser.setSelectedFile(file);
                if (BasicFileChooserUI.this.filechooser.isMultiSelectionEnabled()) {
                    int[] nArray = this.list.getSelectedIndices();
                    File[] fileArray = new File[nArray.length];
                    for (int i = 0; i < nArray.length; ++i) {
                        fileArray[i] = (File)this.list.getModel().getElementAt(nArray[i]);
                    }
                    BasicFileChooserUI.this.filechooser.setSelectedFiles(fileArray);
                }
                if (BasicFileChooserUI.this.filechooser.isTraversable(file)) {
                    BasicFileChooserUI.this.setDirectorySelected(true);
                    BasicFileChooserUI.this.setDirectory(file);
                } else {
                    BasicFileChooserUI.this.setDirectorySelected(false);
                    BasicFileChooserUI.this.setDirectory(null);
                }
                this.lastSelected = string;
                BasicFileChooserUI.this.parentPath = file.getParent();
                if (file.isFile()) {
                    BasicFileChooserUI.this.setFileName(file.getName());
                } else if (BasicFileChooserUI.this.filechooser.getFileSelectionMode() != 0) {
                    BasicFileChooserUI.this.setFileName(string);
                }
            }
        }

        public void mouseEntered(MouseEvent mouseEvent) {
        }
    }

    protected class ChangeToParentDirectoryAction
    extends AbstractAction {
        protected ChangeToParentDirectoryAction() {
            super("Go Up");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            BasicFileChooserUI.this.filechooser.changeToParentDirectory();
            BasicFileChooserUI.this.filechooser.revalidate();
            BasicFileChooserUI.this.filechooser.repaint();
        }
    }

    protected class CancelSelectionAction
    extends AbstractAction {
        protected CancelSelectionAction() {
            super(null);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            BasicFileChooserUI.this.filechooser.setSelectedFile(null);
            BasicFileChooserUI.this.filechooser.setSelectedFiles(null);
            BasicFileChooserUI.this.filechooser.cancelSelection();
            BasicFileChooserUI.this.closeDialog();
        }
    }

    protected class BasicFileView
    extends FileView {
        protected Hashtable<File, Icon> iconCache = new Hashtable();

        public void cacheIcon(File file, Icon icon) {
            this.iconCache.put(file, icon);
        }

        public void clearIconCache() {
            this.iconCache.clear();
        }

        public Icon getCachedIcon(File file) {
            return this.iconCache.get(file);
        }

        public String getDescription(File file) {
            return this.getName(file);
        }

        public Icon getIcon(File file) {
            Icon icon = this.getCachedIcon(file);
            if (icon != null) {
                return icon;
            }
            icon = BasicFileChooserUI.this.filechooser.isTraversable(file) ? BasicFileChooserUI.this.directoryIcon : BasicFileChooserUI.this.fileIcon;
            this.cacheIcon(file, icon);
            return icon;
        }

        public String getName(File file) {
            String string = null;
            if (file != null) {
                JFileChooser jFileChooser = BasicFileChooserUI.this.getFileChooser();
                FileSystemView fileSystemView = jFileChooser.getFileSystemView();
                string = fileSystemView.getSystemDisplayName(file);
            }
            return string;
        }

        public String getTypeDescription(File file) {
            if (BasicFileChooserUI.this.filechooser.isTraversable(file)) {
                return BasicFileChooserUI.this.dirDescText;
            }
            return BasicFileChooserUI.this.fileDescText;
        }

        public Boolean isHidden(File file) {
            return BasicFileChooserUI.this.filechooser.getFileSystemView().isHiddenFile(file);
        }
    }

    protected class ApproveSelectionAction
    extends AbstractAction {
        protected ApproveSelectionAction() {
            super("approveSelection");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = null;
            object = BasicFileChooserUI.this.parentPath != null ? new String(BasicFileChooserUI.this.parentPath + BasicFileChooserUI.this.getFileName()) : BasicFileChooserUI.this.filechooser.getSelectedFile();
            if (object != null) {
                File file = BasicFileChooserUI.this.filechooser.getFileSystemView().createFileObject(object.toString());
                File file2 = BasicFileChooserUI.this.filechooser.getSelectedFile();
                if (BasicFileChooserUI.this.filechooser.isTraversable(file)) {
                    BasicFileChooserUI.this.filechooser.setCurrentDirectory(file2);
                    BasicFileChooserUI.this.filechooser.rescanCurrentDirectory();
                } else {
                    BasicFileChooserUI.this.filechooser.approveSelection();
                    BasicFileChooserUI.this.closeDialog();
                }
            } else {
                File file = new File(BasicFileChooserUI.this.filechooser.getCurrentDirectory(), BasicFileChooserUI.this.getFileName());
                if (BasicFileChooserUI.this.selectedDir != null) {
                    file = BasicFileChooserUI.this.selectedDir;
                }
                if (BasicFileChooserUI.this.filechooser.isTraversable(file)) {
                    BasicFileChooserUI.this.filechooser.setCurrentDirectory(file);
                    BasicFileChooserUI.this.filechooser.rescanCurrentDirectory();
                } else {
                    BasicFileChooserUI.this.filechooser.setSelectedFile(file);
                    BasicFileChooserUI.this.filechooser.approveSelection();
                    BasicFileChooserUI.this.closeDialog();
                }
            }
        }
    }

    protected class AcceptAllFileFilter
    extends FileFilter {
        public boolean accept(File file) {
            return true;
        }

        public String getDescription() {
            return BasicFileChooserUI.this.acceptAllFileFilterText;
        }
    }
}

