/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.beans.PropertyVetoException;
import javax.swing.AbstractAction;
import javax.swing.DefaultDesktopManager;
import javax.swing.DesktopManager;
import javax.swing.JComponent;
import javax.swing.JDesktopPane;
import javax.swing.JInternalFrame;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.DesktopPaneUI;
import javax.swing.plaf.UIResource;

public class BasicDesktopPaneUI
extends DesktopPaneUI {
    protected KeyStroke closeKey;
    protected KeyStroke maximizeKey;
    protected KeyStroke minimizeKey;
    protected KeyStroke navigateKey;
    protected KeyStroke navigateKey2;
    protected DesktopManager desktopManager;
    protected JDesktopPane desktop;

    public static ComponentUI createUI(JComponent jComponent) {
        return new BasicDesktopPaneUI();
    }

    public Dimension getMaximumSize(JComponent jComponent) {
        return this.getPreferredSize(jComponent);
    }

    public Dimension getMinimumSize(JComponent jComponent) {
        return this.getPreferredSize(jComponent);
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        return null;
    }

    protected void installDefaults() {
        Color color = this.desktop.getBackground();
        if (color == null || color instanceof UIResource) {
            this.desktop.setBackground(UIManager.getColor("desktop"));
        }
    }

    protected void installDesktopManager() {
        this.desktopManager = new DefaultDesktopManager();
        this.desktop.setDesktopManager(this.desktopManager);
    }

    protected void installKeyboardActions() {
        this.registerKeyboardActions();
    }

    public void installUI(JComponent jComponent) {
        if (jComponent instanceof JDesktopPane) {
            this.desktop = (JDesktopPane)jComponent;
            this.installDefaults();
            this.installDesktopManager();
            this.installKeyboardActions();
        }
    }

    protected void registerKeyboardActions() {
    }

    protected void uninstallDefaults() {
        this.desktop.setBackground(null);
    }

    protected void uninstallDesktopManager() {
        this.desktopManager = null;
        this.desktop.setDesktopManager(null);
    }

    protected void uninstallKeyboardActions() {
        this.unregisterKeyboardActions();
    }

    protected void unregisterKeyboardActions() {
    }

    public void uninstallUI(JComponent jComponent) {
        this.uninstallKeyboardActions();
        this.uninstallDesktopManager();
        this.uninstallDefaults();
        this.desktop = null;
    }

    protected class OpenAction
    extends AbstractAction {
        protected OpenAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JInternalFrame jInternalFrame = BasicDesktopPaneUI.this.desktop.getSelectedFrame();
            if (jInternalFrame != null) {
                try {
                    if (jInternalFrame.isIcon()) {
                        jInternalFrame.setIcon(false);
                    } else if (jInternalFrame.isMaximum()) {
                        jInternalFrame.setMaximum(false);
                    }
                }
                catch (PropertyVetoException propertyVetoException) {
                    // empty catch block
                }
            }
        }

        public boolean isEnabled() {
            return true;
        }
    }

    protected class NavigateAction
    extends AbstractAction {
        protected NavigateAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int n;
            JInternalFrame[] jInternalFrameArray = BasicDesktopPaneUI.this.desktop.getAllFrames();
            if (jInternalFrameArray.length == 0) {
                return;
            }
            JInternalFrame jInternalFrame = jInternalFrameArray[0];
            if (BasicDesktopPaneUI.this.desktop.getSelectedFrame() != null) {
                jInternalFrame = BasicDesktopPaneUI.this.desktop.getSelectedFrame();
            }
            for (n = 0; n < jInternalFrameArray.length && jInternalFrameArray[n] != jInternalFrame; ++n) {
            }
            if (n == jInternalFrameArray.length) {
                n = 0;
            }
            BasicDesktopPaneUI.this.desktop.setSelectedFrame(jInternalFrameArray[n]);
        }

        public boolean isEnabled() {
            return true;
        }
    }

    protected class MinimizeAction
    extends AbstractAction {
        protected MinimizeAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (BasicDesktopPaneUI.this.desktop.getSelectedFrame() != null) {
                try {
                    BasicDesktopPaneUI.this.desktop.getSelectedFrame().setIcon(true);
                }
                catch (PropertyVetoException propertyVetoException) {
                    // empty catch block
                }
            }
        }

        public boolean isEnabled() {
            if (BasicDesktopPaneUI.this.desktop.getSelectedFrame() != null) {
                return BasicDesktopPaneUI.this.desktop.getSelectedFrame().isIconifiable();
            }
            return false;
        }
    }

    protected class MaximizeAction
    extends AbstractAction {
        protected MaximizeAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (BasicDesktopPaneUI.this.desktop.getSelectedFrame() != null) {
                try {
                    BasicDesktopPaneUI.this.desktop.getSelectedFrame().setMaximum(true);
                }
                catch (PropertyVetoException propertyVetoException) {
                    // empty catch block
                }
            }
        }

        public boolean isEnabled() {
            if (BasicDesktopPaneUI.this.desktop.getSelectedFrame() != null) {
                return BasicDesktopPaneUI.this.desktop.getSelectedFrame().isMaximizable();
            }
            return false;
        }
    }

    protected class CloseAction
    extends AbstractAction {
        protected CloseAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (BasicDesktopPaneUI.this.desktop.getSelectedFrame() != null) {
                try {
                    BasicDesktopPaneUI.this.desktop.getSelectedFrame().setClosed(true);
                }
                catch (PropertyVetoException propertyVetoException) {
                    // empty catch block
                }
            }
        }

        public boolean isEnabled() {
            if (BasicDesktopPaneUI.this.desktop.getSelectedFrame() != null) {
                return BasicDesktopPaneUI.this.desktop.getSelectedFrame().isClosable();
            }
            return false;
        }
    }
}

