/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.ButtonUI;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicButtonListener;
import javax.swing.plaf.basic.BasicGraphicsUtils;
import javax.swing.plaf.basic.BasicHTML;
import javax.swing.text.View;

public class BasicButtonUI
extends ButtonUI {
    static Rectangle viewR = new Rectangle();
    static Rectangle iconR = new Rectangle();
    static Rectangle textR = new Rectangle();
    static Insets cachedInsets;
    private static BasicButtonUI sharedUI;
    private static BasicButtonListener sharedListener;
    protected int defaultTextIconGap = 4;
    protected int defaultTextShiftOffset;
    private int textShiftOffset;

    public static ComponentUI createUI(JComponent jComponent) {
        if (sharedUI == null) {
            sharedUI = new BasicButtonUI();
        }
        return sharedUI;
    }

    public int getDefaultTextIconGap(AbstractButton abstractButton) {
        return this.defaultTextIconGap;
    }

    protected void clearTextShiftOffset() {
        this.textShiftOffset = 0;
    }

    protected int getTextShiftOffset() {
        return this.textShiftOffset;
    }

    protected void setTextShiftOffset() {
        this.textShiftOffset = this.defaultTextShiftOffset;
    }

    protected String getPropertyPrefix() {
        return "Button.";
    }

    protected void installDefaults(AbstractButton abstractButton) {
        Object object;
        String string = this.getPropertyPrefix();
        LookAndFeel.installColorsAndFont(abstractButton, string + "background", string + "foreground", string + "font");
        LookAndFeel.installBorder(abstractButton, string + "border");
        if (abstractButton.getMargin() == null || abstractButton.getMargin() instanceof UIResource) {
            abstractButton.setMargin(UIManager.getInsets(string + "margin"));
        }
        if ((object = UIManager.get(string + "rollover")) != null) {
            LookAndFeel.installProperty(abstractButton, "rolloverEnabled", object);
        }
        this.defaultTextShiftOffset = UIManager.getInt(string + "textShiftOffset");
        if (abstractButton.isContentAreaFilled()) {
            LookAndFeel.installProperty(abstractButton, "opaque", Boolean.TRUE);
        } else {
            LookAndFeel.installProperty(abstractButton, "opaque", Boolean.FALSE);
        }
    }

    protected void uninstallDefaults(AbstractButton abstractButton) {
        LookAndFeel.uninstallBorder(abstractButton);
    }

    protected BasicButtonListener createButtonListener(AbstractButton abstractButton) {
        if (sharedListener == null) {
            sharedListener = new BasicButtonListener(abstractButton);
        }
        return sharedListener;
    }

    protected void installListeners(AbstractButton abstractButton) {
        BasicButtonListener basicButtonListener = this.createButtonListener(abstractButton);
        if (basicButtonListener != null) {
            abstractButton.addChangeListener(basicButtonListener);
            abstractButton.addPropertyChangeListener(basicButtonListener);
            abstractButton.addFocusListener(basicButtonListener);
            abstractButton.addMouseListener(basicButtonListener);
            abstractButton.addMouseMotionListener(basicButtonListener);
        }
        basicButtonListener.propertyChange(new PropertyChangeEvent(abstractButton, "font", null, abstractButton.getFont()));
    }

    protected void uninstallListeners(AbstractButton abstractButton) {
        BasicButtonListener basicButtonListener = this.getButtonListener(abstractButton);
        if (basicButtonListener != null) {
            abstractButton.removeChangeListener(basicButtonListener);
            abstractButton.removePropertyChangeListener(basicButtonListener);
            abstractButton.removeFocusListener(basicButtonListener);
            abstractButton.removeMouseListener(basicButtonListener);
            abstractButton.removeMouseMotionListener(basicButtonListener);
        }
    }

    protected void installKeyboardActions(AbstractButton abstractButton) {
        BasicButtonListener basicButtonListener = this.getButtonListener(abstractButton);
        if (basicButtonListener != null) {
            basicButtonListener.installKeyboardActions(abstractButton);
        }
    }

    protected void uninstallKeyboardActions(AbstractButton abstractButton) {
        BasicButtonListener basicButtonListener = this.getButtonListener(abstractButton);
        if (basicButtonListener != null) {
            basicButtonListener.uninstallKeyboardActions(abstractButton);
        }
    }

    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        if (jComponent instanceof AbstractButton) {
            AbstractButton abstractButton = (AbstractButton)jComponent;
            this.installDefaults(abstractButton);
            this.installListeners(abstractButton);
            this.installKeyboardActions(abstractButton);
            BasicHTML.updateRenderer(abstractButton, abstractButton.getText());
        }
    }

    public void uninstallUI(JComponent jComponent) {
        if (jComponent instanceof AbstractButton) {
            AbstractButton abstractButton = (AbstractButton)jComponent;
            this.uninstallKeyboardActions(abstractButton);
            this.uninstallListeners(abstractButton);
            this.uninstallDefaults(abstractButton);
            BasicHTML.updateRenderer(abstractButton, "");
            abstractButton.putClientProperty("BasicGraphicsUtils.cachedTextLayout", null);
        }
    }

    public Dimension getMinimumSize(JComponent jComponent) {
        Dimension dimension = this.getPreferredSize(jComponent);
        View view = (View)jComponent.getClientProperty("html");
        if (view != null) {
            dimension.width = (int)((float)dimension.width - (view.getPreferredSpan(0) - view.getPreferredSpan(0)));
        }
        return dimension;
    }

    public Dimension getMaximumSize(JComponent jComponent) {
        Dimension dimension = this.getPreferredSize(jComponent);
        View view = (View)jComponent.getClientProperty("html");
        if (view != null) {
            dimension.width = (int)((float)dimension.width + (view.getMaximumSpan(0) - view.getPreferredSpan(0)));
        }
        return dimension;
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        AbstractButton abstractButton = (AbstractButton)jComponent;
        Dimension dimension = BasicGraphicsUtils.getPreferredButtonSize(abstractButton, abstractButton.getIconTextGap());
        return dimension;
    }

    static Icon currentIcon(AbstractButton abstractButton) {
        Icon icon = abstractButton.getIcon();
        ButtonModel buttonModel = abstractButton.getModel();
        if (buttonModel.isPressed() && abstractButton.getPressedIcon() != null && abstractButton.isEnabled()) {
            icon = abstractButton.getPressedIcon();
        } else if (buttonModel.isRollover()) {
            if (abstractButton.isSelected() && abstractButton.getRolloverSelectedIcon() != null) {
                icon = abstractButton.getRolloverSelectedIcon();
            } else if (abstractButton.getRolloverIcon() != null) {
                icon = abstractButton.getRolloverIcon();
            }
        } else if (abstractButton.isSelected() && abstractButton.isEnabled()) {
            if (abstractButton.isEnabled() && abstractButton.getSelectedIcon() != null) {
                icon = abstractButton.getSelectedIcon();
            } else if (abstractButton.getDisabledSelectedIcon() != null) {
                icon = abstractButton.getDisabledSelectedIcon();
            }
        } else if (!abstractButton.isEnabled() && abstractButton.getDisabledIcon() != null) {
            icon = abstractButton.getDisabledIcon();
        }
        return icon;
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        AbstractButton abstractButton = (AbstractButton)jComponent;
        Insets insets = jComponent.getInsets(cachedInsets);
        BasicButtonUI.viewR.x = insets.left;
        BasicButtonUI.viewR.y = insets.top;
        BasicButtonUI.viewR.width = jComponent.getWidth() - insets.left - insets.right;
        BasicButtonUI.viewR.height = jComponent.getHeight() - insets.top - insets.bottom;
        BasicButtonUI.textR.x = 0;
        BasicButtonUI.textR.y = 0;
        BasicButtonUI.textR.width = 0;
        BasicButtonUI.textR.height = 0;
        BasicButtonUI.iconR.x = 0;
        BasicButtonUI.iconR.y = 0;
        BasicButtonUI.iconR.width = 0;
        BasicButtonUI.iconR.height = 0;
        Font font = jComponent.getFont();
        graphics.setFont(font);
        Icon icon = abstractButton.getIcon();
        String string = abstractButton.getText();
        string = SwingUtilities.layoutCompoundLabel(jComponent, graphics.getFontMetrics(font), string, icon, abstractButton.getVerticalAlignment(), abstractButton.getHorizontalAlignment(), abstractButton.getVerticalTextPosition(), abstractButton.getHorizontalTextPosition(), viewR, iconR, textR, string == null ? 0 : abstractButton.getIconTextGap());
        ButtonModel buttonModel = abstractButton.getModel();
        if (buttonModel.isArmed() && buttonModel.isPressed()) {
            this.paintButtonPressed(graphics, abstractButton);
        }
        if (icon != null) {
            this.paintIcon(graphics, jComponent, iconR);
        }
        if (string != null) {
            View view = (View)abstractButton.getClientProperty("html");
            if (view != null) {
                view.paint(graphics, textR);
            } else {
                this.paintText(graphics, abstractButton, textR, string);
            }
        }
        if (abstractButton.isFocusOwner() && abstractButton.isFocusPainted()) {
            this.paintFocus(graphics, abstractButton, viewR, textR, iconR);
        }
    }

    protected void paintFocus(Graphics graphics, AbstractButton abstractButton, Rectangle rectangle, Rectangle rectangle2, Rectangle rectangle3) {
    }

    protected void paintIcon(Graphics graphics, JComponent jComponent, Rectangle rectangle) {
        AbstractButton abstractButton = (AbstractButton)jComponent;
        Icon icon = BasicButtonUI.currentIcon(abstractButton);
        if (icon != null) {
            ButtonModel buttonModel = abstractButton.getModel();
            if (buttonModel.isPressed() && buttonModel.isArmed()) {
                int n = this.getTextShiftOffset();
                icon.paintIcon(jComponent, graphics, rectangle.x + n, rectangle.y + n);
            } else {
                icon.paintIcon(jComponent, graphics, rectangle.x, rectangle.y);
            }
        }
    }

    protected void paintButtonPressed(Graphics graphics, AbstractButton abstractButton) {
        if (abstractButton.isContentAreaFilled() && abstractButton.isOpaque()) {
            Rectangle rectangle = new Rectangle();
            SwingUtilities.calculateInnerArea(abstractButton, rectangle);
            graphics.setColor(UIManager.getColor(this.getPropertyPrefix() + "shadow"));
            graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
    }

    protected void paintText(Graphics graphics, JComponent jComponent, Rectangle rectangle, String string) {
        AbstractButton abstractButton = (AbstractButton)jComponent;
        Font font = abstractButton.getFont();
        graphics.setFont(font);
        FontMetrics fontMetrics = graphics.getFontMetrics(font);
        if (abstractButton.isEnabled()) {
            graphics.setColor(abstractButton.getForeground());
            BasicGraphicsUtils.drawString(abstractButton, graphics, string, -1, rectangle.x, rectangle.y + fontMetrics.getAscent());
        } else {
            String string2 = this.getPropertyPrefix();
            graphics.setColor(UIManager.getColor(string2 + "disabledText"));
            BasicGraphicsUtils.drawString(abstractButton, graphics, string, -1, rectangle.x, rectangle.y + fontMetrics.getAscent());
        }
    }

    protected void paintText(Graphics graphics, AbstractButton abstractButton, Rectangle rectangle, String string) {
        this.paintText(graphics, (JComponent)abstractButton, rectangle, string);
    }

    private BasicButtonListener getButtonListener(AbstractButton abstractButton) {
        PropertyChangeListener[] propertyChangeListenerArray = abstractButton.getPropertyChangeListeners();
        BasicButtonListener basicButtonListener = null;
        for (int i = 0; propertyChangeListenerArray != null && basicButtonListener == null && i < propertyChangeListenerArray.length; ++i) {
            if (!(propertyChangeListenerArray[i] instanceof BasicButtonListener)) continue;
            basicButtonListener = (BasicButtonListener)propertyChangeListenerArray[i];
        }
        return basicButtonListener;
    }
}

