/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Polygon;
import javax.swing.ButtonModel;
import javax.swing.JButton;
import javax.swing.SwingConstants;

public class BasicArrowButton
extends JButton
implements SwingConstants {
    protected int direction;
    transient Color shadow = Color.GRAY;
    transient Color darkShadow = new Color(102, 102, 102);
    transient Color highlight = Color.WHITE;

    public BasicArrowButton(int n) {
        this.setDirection(n);
        this.setFocusable(false);
    }

    public BasicArrowButton(int n, Color color, Color color2, Color color3, Color color4) {
        this(n);
        this.setBackground(color);
        this.shadow = color2;
        this.darkShadow = color3;
        this.highlight = color4;
        this.setFocusable(false);
    }

    public boolean isFocusTraversable() {
        return false;
    }

    public int getDirection() {
        return this.direction;
    }

    public void setDirection(int n) {
        this.direction = n;
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        int n = this.getHeight();
        int n2 = n / 4;
        int n3 = (this.getWidth() - n2) / 2;
        int n4 = (n - n2) / 2;
        ButtonModel buttonModel = this.getModel();
        if (buttonModel.isArmed()) {
            ++n3;
            ++n4;
        }
        this.paintTriangle(graphics, n3, n4, n2, this.direction, this.isEnabled());
    }

    public Dimension getPreferredSize() {
        return new Dimension(16, 16);
    }

    public Dimension getMinimumSize() {
        return new Dimension(5, 5);
    }

    public Dimension getMaximumSize() {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    public void paintTriangle(Graphics graphics, int n, int n2, int n3, int n4, boolean bl) {
        Color color = graphics.getColor();
        switch (n4) {
            case 1: {
                this.paintTriangleNorth(graphics, n, n2, n3, bl);
                break;
            }
            case 5: {
                this.paintTriangleSouth(graphics, n, n2, n3, bl);
                break;
            }
            case 2: 
            case 7: {
                this.paintTriangleWest(graphics, n, n2, n3, bl);
                break;
            }
            case 3: 
            case 4: {
                this.paintTriangleEast(graphics, n, n2, n3, bl);
            }
        }
        graphics.setColor(color);
    }

    private void paintTriangleNorth(Graphics graphics, int n, int n2, int n3, boolean bl) {
        int n4 = n + (n3 - 2) / 2;
        int n5 = n2;
        int n6 = n4 - (n3 - 1);
        int n7 = n4 + (n3 - 1);
        int n8 = n2 + (n3 - 1);
        Polygon polygon = new Polygon();
        polygon.addPoint(n4, n5);
        polygon.addPoint(n6, n8);
        polygon.addPoint(n7, n8);
        if (bl) {
            graphics.setColor(Color.DARK_GRAY);
            graphics.fillPolygon(polygon);
            graphics.drawPolygon(polygon);
        } else {
            graphics.setColor(Color.GRAY);
            graphics.fillPolygon(polygon);
            graphics.drawPolygon(polygon);
            graphics.setColor(Color.WHITE);
            graphics.drawLine(n6 + 1, n8 + 1, n7 + 1, n8 + 1);
        }
    }

    private void paintTriangleSouth(Graphics graphics, int n, int n2, int n3, boolean bl) {
        int n4 = n + (n3 - 2) / 2;
        int n5 = n2 + (n3 - 1);
        int n6 = n4 - (n3 - 1);
        int n7 = n4 + (n3 - 1);
        int n8 = n2;
        Polygon polygon = new Polygon();
        polygon.addPoint(n4, n5);
        polygon.addPoint(n6, n8);
        polygon.addPoint(n7, n8);
        if (bl) {
            graphics.setColor(Color.DARK_GRAY);
            graphics.fillPolygon(polygon);
            graphics.drawPolygon(polygon);
        } else {
            graphics.setColor(Color.GRAY);
            graphics.fillPolygon(polygon);
            graphics.drawPolygon(polygon);
            graphics.setColor(Color.WHITE);
            graphics.drawLine(n4 + 1, n5, n7, n8 + 1);
            graphics.drawLine(n4 + 1, n5 + 1, n7 + 1, n8 + 1);
        }
    }

    private void paintTriangleEast(Graphics graphics, int n, int n2, int n3, boolean bl) {
        int n4 = n + (n3 - 1);
        int n5 = n2 + (n3 - 2) / 2;
        int n6 = n;
        int n7 = n5 - (n3 - 1);
        int n8 = n5 + (n3 - 1);
        Polygon polygon = new Polygon();
        polygon.addPoint(n4, n5);
        polygon.addPoint(n6, n7);
        polygon.addPoint(n6, n8);
        if (bl) {
            graphics.setColor(Color.DARK_GRAY);
            graphics.fillPolygon(polygon);
            graphics.drawPolygon(polygon);
        } else {
            graphics.setColor(Color.GRAY);
            graphics.fillPolygon(polygon);
            graphics.drawPolygon(polygon);
            graphics.setColor(Color.WHITE);
            graphics.drawLine(n6 + 1, n8, n4, n5 + 1);
            graphics.drawLine(n6 + 1, n8 + 1, n4 + 1, n5 + 1);
        }
    }

    private void paintTriangleWest(Graphics graphics, int n, int n2, int n3, boolean bl) {
        int n4 = n;
        int n5 = n2 + (n3 - 2) / 2;
        int n6 = n + (n3 - 1);
        int n7 = n5 - (n3 - 1);
        int n8 = n5 + (n3 - 1);
        Polygon polygon = new Polygon();
        polygon.addPoint(n4, n5);
        polygon.addPoint(n6, n7);
        polygon.addPoint(n6, n8);
        if (bl) {
            graphics.setColor(Color.DARK_GRAY);
            graphics.fillPolygon(polygon);
            graphics.drawPolygon(polygon);
        } else {
            graphics.setColor(Color.GRAY);
            graphics.fillPolygon(polygon);
            graphics.drawPolygon(polygon);
            graphics.setColor(Color.WHITE);
            graphics.drawLine(n6 + 1, n7 + 1, n6 + 1, n8 + 1);
        }
    }
}

