/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.event;

import gnu.java.lang.CPStringBuilder;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.EventListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EventListenerList
implements Serializable {
    static final long serialVersionUID = -5677132037850737084L;
    private static final Object[] NO_LISTENERS = new Object[0];
    protected transient Object[] listenerList = NO_LISTENERS;

    public <T extends EventListener> void add(Class<T> clazz, T t) {
        if (t == null) {
            return;
        }
        if (!clazz.isInstance(t)) {
            throw new IllegalArgumentException();
        }
        int n = this.listenerList.length;
        Object[] objectArray = new Object[n + 2];
        if (n > 0) {
            System.arraycopy(this.listenerList, 0, objectArray, 0, n);
        }
        objectArray[n] = clazz;
        objectArray[n + 1] = t;
        this.listenerList = objectArray;
    }

    public int getListenerCount() {
        return this.listenerList.length / 2;
    }

    public int getListenerCount(Class<?> clazz) {
        int n = 0;
        for (int i = 0; i < this.listenerList.length; i += 2) {
            if (clazz != this.listenerList[i]) continue;
            ++n;
        }
        return n;
    }

    public Object[] getListenerList() {
        return this.listenerList;
    }

    public <T extends EventListener> T[] getListeners(Class<T> clazz) {
        int n = this.getListenerCount(clazz);
        EventListener[] eventListenerArray = (EventListener[])Array.newInstance(clazz, n);
        int n2 = 0;
        for (int i = this.listenerList.length - 2; i >= 0; i -= 2) {
            if (this.listenerList[i] != clazz) continue;
            eventListenerArray[n2++] = (EventListener)this.listenerList[i + 1];
        }
        return eventListenerArray;
    }

    public <T extends EventListener> void remove(Class<T> clazz, T t) {
        if (t == null) {
            return;
        }
        if (!clazz.isInstance(t)) {
            throw new IllegalArgumentException();
        }
        Object[] objectArray = this.listenerList;
        int n = objectArray.length;
        for (int i = 0; i < n; i += 2) {
            Object[] objectArray2;
            if (objectArray[i] != clazz || objectArray[i + 1] != t) continue;
            if (n == 2) {
                objectArray2 = NO_LISTENERS;
            } else {
                objectArray2 = new Object[n - 2];
                if (i > 0) {
                    System.arraycopy(objectArray, 0, objectArray2, 0, i);
                }
                if (i < n - 2) {
                    System.arraycopy(objectArray, i + 2, objectArray2, i, n - 2 - i);
                }
            }
            this.listenerList = objectArray2;
            return;
        }
    }

    public String toString() {
        CPStringBuilder cPStringBuilder = new CPStringBuilder("EventListenerList: ");
        cPStringBuilder.append(this.listenerList.length / 2);
        cPStringBuilder.append(" listeners: ");
        for (int i = 0; i < this.listenerList.length; i += 2) {
            cPStringBuilder.append(" type ");
            cPStringBuilder.append(((Class)this.listenerList[i]).getName());
            cPStringBuilder.append(" listener ");
            cPStringBuilder.append(this.listenerList[i + 1]);
        }
        return cPStringBuilder.toString();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        for (int i = 0; i < this.listenerList.length; i += 2) {
            Class clazz = (Class)this.listenerList[i];
            EventListener eventListener = (EventListener)this.listenerList[i + 1];
            if (eventListener == null || !(eventListener instanceof Serializable)) continue;
            objectOutputStream.writeObject(clazz.getName());
            objectOutputStream.writeObject(eventListener);
        }
        objectOutputStream.writeObject(null);
    }

    private <T extends EventListener> void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        Object object;
        this.listenerList = NO_LISTENERS;
        objectInputStream.defaultReadObject();
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        while ((object = objectInputStream.readObject()) != null) {
            EventListener eventListener = (EventListener)objectInputStream.readObject();
            this.add(Class.forName((String)object, true, classLoader), eventListener);
        }
    }
}

