/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.colorchooser;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.Icon;
import javax.swing.JColorChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.colorchooser.AbstractColorChooserPanel;

class DefaultSwatchChooserPanel
extends AbstractColorChooserPanel {
    MainSwatchPanel mainPalette;
    RecentSwatchPanel recentPalette;
    MouseListener mouseHandler;

    DefaultSwatchChooserPanel() {
    }

    public void updateChooser() {
    }

    protected void buildChooser() {
        this.setLayout(new MainPanelLayout());
        JPanel jPanel = new JPanel();
        JPanel jPanel2 = new JPanel();
        this.mainPalette = new MainSwatchPanel();
        this.recentPalette = new RecentSwatchPanel();
        JLabel jLabel = new JLabel("Recent:");
        this.mouseHandler = new MouseHandler();
        this.mainPalette.addMouseListener(this.mouseHandler);
        this.recentPalette.addMouseListener(this.mouseHandler);
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)this.mainPalette, "Center");
        jPanel2.setLayout(new RecentPanelLayout());
        jPanel2.add(jLabel);
        jPanel2.add(this.recentPalette);
        JPanel jPanel3 = new JPanel();
        jPanel3.add(jPanel);
        jPanel3.add(jPanel2);
        this.add(jPanel3);
    }

    public void uninstallChooserPanel(JColorChooser jColorChooser) {
        this.recentPalette = null;
        this.mainPalette = null;
        this.removeAll();
        super.uninstallChooserPanel(jColorChooser);
    }

    public String getDisplayName() {
        return "Swatches";
    }

    public Icon getSmallDisplayIcon() {
        return null;
    }

    public Icon getLargeDisplayIcon() {
        return null;
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
    }

    public String getToolTipText(MouseEvent mouseEvent) {
        return null;
    }

    static class RecentPanelLayout
    implements LayoutManager {
        RecentPanelLayout() {
        }

        public void addLayoutComponent(String string, Component component) {
        }

        public void layoutContainer(Container container) {
            Component[] componentArray = container.getComponents();
            Dimension dimension = container.getSize();
            Insets insets = container.getInsets();
            int n = insets.top;
            for (int i = 0; i < componentArray.length; ++i) {
                Dimension dimension2 = componentArray[i].getPreferredSize();
                if (dimension2 == null) continue;
                componentArray[i].setBounds(insets.left, n, dimension2.width, dimension2.height);
                n += dimension2.height;
            }
        }

        public Dimension minimumLayoutSize(Container container) {
            return this.preferredLayoutSize(container);
        }

        public Dimension preferredLayoutSize(Container container) {
            int n = 0;
            int n2 = 0;
            Insets insets = container.getInsets();
            Component[] componentArray = container.getComponents();
            for (int i = 0; i < componentArray.length; ++i) {
                Dimension dimension = componentArray[i].getPreferredSize();
                if (dimension == null) continue;
                n = Math.max(n, dimension.width);
                n2 += dimension.height;
            }
            return new Dimension(n + insets.left + insets.right, n2 + insets.top + insets.bottom);
        }

        public void removeLayoutComponent(Component component) {
        }
    }

    static class MainPanelLayout
    implements LayoutManager {
        MainPanelLayout() {
        }

        public void addLayoutComponent(String string, Component component) {
        }

        public void layoutContainer(Container container) {
            int n;
            Component[] componentArray = container.getComponents();
            Insets insets = container.getInsets();
            Dimension[] dimensionArray = new Dimension[componentArray.length];
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            int n5 = 0;
            for (n = 0; n < componentArray.length; ++n) {
                dimensionArray[n] = componentArray[n].getPreferredSize();
                if (dimensionArray[n] == null) {
                    return;
                }
                n4 = Math.max(n4, dimensionArray[n].height);
                n5 += dimensionArray[n].width;
            }
            n3 = (container.getSize().height - n4) / 2 + insets.top;
            n2 = insets.left + (container.getSize().width - n5) / 2;
            for (n = 0; n < componentArray.length; ++n) {
                if (dimensionArray[n] == null) continue;
                componentArray[n].setBounds(n2, n3, dimensionArray[n].width, dimensionArray[n].height);
                n2 += dimensionArray[n].width;
            }
        }

        public void removeLayoutComponent(Component component) {
        }

        public Dimension minimumLayoutSize(Container container) {
            return this.preferredLayoutSize(container);
        }

        public Dimension preferredLayoutSize(Container container) {
            int n = 0;
            int n2 = 0;
            Component[] componentArray = container.getComponents();
            for (int i = 0; i < componentArray.length; ++i) {
                Dimension dimension = componentArray[i].getPreferredSize();
                if (dimension == null) continue;
                n += dimension.width;
                n2 = Math.max(n2, dimension.height);
            }
            Insets insets = container.getInsets();
            return new Dimension(insets.left + insets.right + n, insets.top + insets.bottom + n2);
        }
    }

    class MouseHandler
    extends MouseAdapter {
        MouseHandler() {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            SwatchPanel swatchPanel = (SwatchPanel)mouseEvent.getSource();
            Color color = swatchPanel.getColorForPosition(mouseEvent.getX(), mouseEvent.getY());
            DefaultSwatchChooserPanel.this.recentPalette.addColorToQueue(color);
            DefaultSwatchChooserPanel.this.getColorSelectionModel().setSelectedColor(color);
            DefaultSwatchChooserPanel.this.repaint();
        }
    }

    static class RecentSwatchPanel
    extends SwatchPanel {
        Color[] colors;
        public static final Color defaultColor = Color.GRAY;
        int start = 0;

        RecentSwatchPanel() {
            this.numCols = 5;
            this.numRows = 7;
            this.initializeColors();
            this.revalidate();
        }

        public Color getColorForPosition(int n, int n2) {
            if (n % (this.cellWidth + this.gap) > this.cellWidth || n2 % (this.cellHeight + this.gap) > this.cellHeight) {
                return null;
            }
            int n3 = n2 / (this.cellHeight + this.gap);
            int n4 = n / (this.cellWidth + this.gap);
            return this.colors[this.getIndexForCell(n3, n4)];
        }

        protected void initializeColors() {
            this.colors = new Color[this.numRows * this.numCols];
            for (int i = 0; i < this.colors.length; ++i) {
                this.colors[i] = defaultColor;
            }
        }

        private int getIndexForCell(int n, int n2) {
            return (n * this.numCols + n2 + this.start) % (this.numRows * this.numCols);
        }

        void addColorToQueue(Color color) {
            if (--this.start == -1) {
                this.start = this.numRows * this.numCols - 1;
            }
            this.colors[this.start] = color;
        }

        public void paint(Graphics graphics) {
            Color color = graphics.getColor();
            Insets insets = this.getInsets();
            int n = insets.left;
            int n2 = insets.top;
            for (int i = 0; i < this.numRows; ++i) {
                for (int j = 0; j < this.numCols; ++j) {
                    graphics.setColor(this.colors[this.getIndexForCell(i, j)]);
                    graphics.fill3DRect(n, n2, this.cellWidth, this.cellHeight, true);
                    n += this.cellWidth + this.gap;
                }
                n = insets.left;
                n2 += this.cellWidth + this.gap;
            }
        }

        public String getToolTipText(MouseEvent mouseEvent) {
            Color color = this.getColorForPosition(mouseEvent.getX(), mouseEvent.getY());
            if (color == null) {
                return null;
            }
            return color.getRed() + "," + color.getGreen() + "," + color.getBlue();
        }
    }

    static class MainSwatchPanel
    extends SwatchPanel {
        public static final Color C204255255 = new Color(204, 204, 255);
        public static final Color C255204204 = new Color(255, 204, 204);
        public static final Color C204255204 = new Color(204, 255, 204);
        public static final Color C204204204 = new Color(204, 204, 204);
        public static final Color C153153255 = new Color(153, 153, 255);
        public static final Color C051051255 = new Color(51, 51, 255);
        public static final Color C153000153 = new Color(153, 0, 153);
        public static final Color C000051051 = new Color(0, 51, 51);
        public static final Color C051000051 = new Color(51, 0, 51);
        public static final Color C051051000 = new Color(51, 51, 0);
        public static final Color C102102000 = new Color(102, 102, 0);
        public static final Color C153255153 = new Color(153, 255, 153);
        public static final Color C102255102 = new Color(102, 255, 102);
        public static final Color C000102102 = new Color(0, 102, 102);
        public static final Color C102000102 = new Color(102, 0, 102);
        public static final Color C000153153 = new Color(0, 153, 153);
        public static final Color C153153000 = new Color(153, 153, 0);
        public static final Color C204204000 = new Color(204, 204, 0);
        public static final Color C204000204 = new Color(204, 0, 204);
        public static final Color C000204204 = new Color(0, 204, 204);
        public static final Color C051255051 = new Color(51, 255, 51);
        public static final Color C255051051 = new Color(255, 51, 51);
        public static final Color C255102102 = new Color(255, 102, 102);
        public static final Color C102102255 = new Color(102, 102, 255);
        public static final Color C255153153 = new Color(255, 153, 153);
        static Color[] colors = new Color[]{Color.WHITE, new Color(204, 255, 255), C204255255, C204255255, C204255255, C204255255, C204255255, C204255255, C204255255, C204255255, C204255255, new Color(255, 204, 255), C255204204, C255204204, C255204204, C255204204, C255204204, C255204204, C255204204, C255204204, C255204204, new Color(255, 255, 204), C204255204, C204255204, C204255204, C204255204, C204255204, C204255204, C204255204, C204255204, C204255204, C204204204, new Color(153, 255, 255), new Color(153, 204, 255), C153153255, C153153255, C153153255, C153153255, C153153255, C153153255, C153153255, new Color(204, 153, 255), new Color(255, 153, 255), new Color(255, 153, 204), C255153153, C255153153, C255153153, C255153153, C255153153, C255153153, C255153153, new Color(255, 204, 153), new Color(255, 255, 153), new Color(204, 255, 153), C153255153, C153255153, C153255153, C153255153, C153255153, C153255153, C153255153, new Color(153, 255, 204), C204204204, new Color(102, 255, 255), new Color(102, 204, 255), new Color(102, 153, 255), C102102255, C102102255, C102102255, C102102255, C102102255, new Color(153, 102, 255), new Color(204, 102, 255), new Color(255, 102, 255), new Color(255, 102, 204), new Color(255, 102, 153), C255102102, C255102102, C255102102, C255102102, C255102102, new Color(255, 153, 102), new Color(255, 204, 102), new Color(255, 255, 102), new Color(204, 255, 102), new Color(153, 255, 102), C102255102, C102255102, C102255102, C102255102, C102255102, new Color(102, 255, 153), new Color(102, 255, 204), new Color(153, 153, 153), new Color(51, 255, 255), new Color(51, 204, 255), new Color(51, 153, 255), new Color(51, 102, 255), C051051255, C051051255, C051051255, new Color(102, 51, 255), new Color(153, 51, 255), new Color(204, 51, 255), new Color(255, 51, 255), new Color(255, 51, 204), new Color(255, 51, 153), new Color(255, 51, 102), C255051051, C255051051, C255051051, new Color(255, 102, 51), new Color(255, 153, 51), new Color(255, 204, 51), new Color(255, 255, 51), new Color(204, 255, 51), new Color(153, 255, 51), new Color(102, 255, 51), C051255051, C051255051, C051255051, new Color(51, 255, 102), new Color(51, 255, 153), new Color(51, 255, 204), new Color(153, 153, 153), new Color(0, 255, 255), new Color(0, 204, 255), new Color(0, 153, 255), new Color(0, 102, 255), new Color(0, 51, 255), new Color(0, 0, 255), new Color(51, 0, 255), new Color(102, 0, 255), new Color(153, 0, 255), new Color(204, 0, 255), new Color(255, 0, 255), new Color(255, 0, 204), new Color(255, 0, 153), new Color(255, 0, 102), new Color(255, 0, 51), new Color(255, 0, 0), new Color(255, 51, 0), new Color(255, 102, 0), new Color(255, 153, 0), new Color(255, 204, 0), new Color(255, 255, 0), new Color(204, 255, 0), new Color(153, 255, 0), new Color(102, 255, 0), new Color(51, 255, 0), new Color(0, 255, 0), new Color(0, 255, 51), new Color(0, 255, 102), new Color(0, 255, 153), new Color(0, 255, 204), new Color(102, 102, 102), C000204204, C000204204, new Color(0, 153, 204), new Color(0, 102, 204), new Color(0, 51, 204), new Color(0, 0, 204), new Color(51, 0, 204), new Color(102, 0, 204), new Color(153, 0, 204), C204000204, C204000204, C204000204, new Color(204, 0, 153), new Color(204, 0, 102), new Color(204, 0, 51), new Color(204, 0, 0), new Color(204, 51, 0), new Color(204, 102, 0), new Color(204, 153, 0), C204204000, C204204000, C204204000, new Color(153, 204, 0), new Color(102, 204, 0), new Color(51, 204, 0), new Color(0, 204, 0), new Color(0, 204, 51), new Color(0, 204, 102), new Color(0, 204, 153), new Color(0, 204, 204), new Color(102, 102, 102), C000153153, C000153153, C000153153, new Color(0, 102, 153), new Color(0, 51, 153), new Color(0, 0, 153), new Color(51, 0, 153), new Color(102, 0, 153), C153000153, C153000153, C153000153, C153000153, C153000153, new Color(153, 0, 102), new Color(153, 0, 51), new Color(153, 0, 0), new Color(153, 51, 0), new Color(153, 102, 0), C153153000, C153153000, C153153000, C153153000, C153153000, new Color(102, 153, 0), new Color(51, 153, 0), new Color(0, 153, 0), new Color(0, 153, 51), new Color(0, 153, 102), C000153153, C000153153, new Color(51, 51, 51), C000102102, C000102102, C000102102, C000102102, new Color(0, 51, 102), new Color(0, 0, 102), new Color(51, 0, 102), C102000102, C102000102, C102000102, C102000102, C102000102, C102000102, C102000102, new Color(102, 0, 51), new Color(102, 0, 0), new Color(102, 51, 0), C102102000, C102102000, C102102000, C102102000, C102102000, C102102000, C102102000, new Color(51, 102, 0), new Color(0, 102, 0), new Color(0, 102, 51), C000102102, C000102102, C000102102, Color.BLACK, C000051051, C000051051, C000051051, C000051051, C000051051, new Color(0, 0, 51), C051000051, C051000051, C051000051, C051000051, C051000051, C051000051, C051000051, C051000051, C051000051, new Color(51, 0, 0), C051051000, C051051000, C051051000, C051051000, C051051000, C051051000, C051051000, C051051000, new Color(0, 51, 0), C000051051, C000051051, C000051051, C000051051, new Color(51, 51, 51)};

        MainSwatchPanel() {
            this.numCols = 31;
            this.numRows = 9;
            this.initializeColors();
            this.revalidate();
        }

        public Color getColorForPosition(int n, int n2) {
            if (n % (this.cellWidth + this.gap) > this.cellWidth || n2 % (this.cellHeight + this.gap) > this.cellHeight) {
                return null;
            }
            int n3 = n2 / (this.cellHeight + this.gap);
            int n4 = n / (this.cellWidth + this.gap);
            return colors[n3 * this.numCols + n4];
        }

        protected void initializeColors() {
        }

        public void paint(Graphics graphics) {
            int n = 0;
            Insets insets = this.getInsets();
            int n2 = insets.left;
            int n3 = insets.top;
            Color color = graphics.getColor();
            for (int i = 0; i < this.numRows; ++i) {
                for (int j = 0; j < this.numCols; ++j) {
                    graphics.setColor(colors[n++]);
                    graphics.fill3DRect(n2, n3, this.cellWidth, this.cellHeight, true);
                    n2 += this.gap + this.cellWidth;
                }
                n2 = insets.left;
                n3 += this.gap + this.cellHeight;
            }
            graphics.setColor(color);
        }

        public String getToolTipText(MouseEvent mouseEvent) {
            Color color = this.getColorForPosition(mouseEvent.getX(), mouseEvent.getY());
            if (color == null) {
                return null;
            }
            return color.getRed() + "," + color.getGreen() + "," + color.getBlue();
        }
    }

    static abstract class SwatchPanel
    extends JPanel {
        protected int cellWidth = 10;
        protected int cellHeight = 10;
        protected int gap = 1;
        protected int numRows;
        protected int numCols;

        SwatchPanel() {
            this.setBackground(Color.WHITE);
        }

        public Dimension getPreferredSize() {
            int n = this.numRows * this.cellHeight + (this.numRows - 1) * this.gap;
            int n2 = this.numCols * this.cellWidth + (this.numCols - 1) * this.gap;
            Insets insets = this.getInsets();
            return new Dimension(n2 + insets.left + insets.right, n + insets.top + insets.bottom);
        }

        public abstract Color getColorForPosition(int var1, int var2);

        protected abstract void initializeColors();
    }
}

