/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.border;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.border.AbstractBorder;
import javax.swing.border.Border;

public class LineBorder
extends AbstractBorder {
    static final long serialVersionUID = -787563427772288970L;
    private static LineBorder blackLineBorder;
    private static LineBorder grayLineBorder;
    protected int thickness;
    protected Color lineColor;
    protected boolean roundedCorners;

    public LineBorder(Color color) {
        this(color, 1, false);
    }

    public LineBorder(Color color, int n) {
        this(color, n, false);
    }

    public LineBorder(Color color, int n, boolean bl) {
        if (color == null || n < 0) {
            throw new IllegalArgumentException();
        }
        this.lineColor = color;
        this.thickness = n;
        this.roundedCorners = bl;
    }

    public static Border createBlackLineBorder() {
        if (blackLineBorder == null) {
            blackLineBorder = new LineBorder(Color.black);
        }
        return blackLineBorder;
    }

    public static Border createGrayLineBorder() {
        if (grayLineBorder == null) {
            grayLineBorder = new LineBorder(Color.gray);
        }
        return grayLineBorder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
        Color color = graphics.getColor();
        try {
            graphics.setColor(this.lineColor);
            --n3;
            --n4;
            for (int i = 0; i < this.thickness; ++i) {
                if (this.roundedCorners) {
                    graphics.drawRoundRect(n, n2, n3, n4, this.thickness, this.thickness);
                } else {
                    graphics.drawRect(n, n2, n3, n4);
                }
                ++n;
                ++n2;
                n3 -= 2;
                n4 -= 2;
            }
            Object var10_9 = null;
            graphics.setColor(color);
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            graphics.setColor(color);
            throw throwable;
        }
    }

    public Insets getBorderInsets(Component component) {
        return new Insets(this.thickness, this.thickness, this.thickness, this.thickness);
    }

    public Insets getBorderInsets(Component component, Insets insets) {
        insets.top = insets.bottom = this.thickness;
        insets.right = insets.bottom;
        insets.left = insets.bottom;
        return insets;
    }

    public Color getLineColor() {
        return this.lineColor;
    }

    public int getThickness() {
        return this.thickness;
    }

    public boolean getRoundedCorners() {
        return this.roundedCorners;
    }

    public boolean isBorderOpaque() {
        return !this.roundedCorners && this.lineColor.getAlpha() == 255;
    }
}

