/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.border;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.border.AbstractBorder;
import javax.swing.border.Border;

public class CompoundBorder
extends AbstractBorder {
    static final long serialVersionUID = 9054540377030555103L;
    protected Border insideBorder;
    protected Border outsideBorder;

    public CompoundBorder() {
        this(null, null);
    }

    public CompoundBorder(Border border, Border border2) {
        this.outsideBorder = border;
        this.insideBorder = border2;
    }

    public boolean isBorderOpaque() {
        if (this.insideBorder == null && this.outsideBorder == null) {
            return true;
        }
        if (this.insideBorder == null) {
            return this.outsideBorder.isBorderOpaque();
        }
        if (this.outsideBorder == null) {
            return this.insideBorder.isBorderOpaque();
        }
        return this.insideBorder.isBorderOpaque() && this.outsideBorder.isBorderOpaque();
    }

    public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
        if (this.outsideBorder != null) {
            this.outsideBorder.paintBorder(component, graphics, n, n2, n3, n4);
            Insets insets = this.outsideBorder.getBorderInsets(component);
            n += insets.left;
            n2 += insets.top;
            n3 -= insets.left + insets.right;
            n4 -= insets.top + insets.bottom;
        }
        if (this.insideBorder != null) {
            this.insideBorder.paintBorder(component, graphics, n, n2, n3, n4);
        }
    }

    public Insets getBorderInsets(Component component, Insets insets) {
        Insets insets2;
        if (insets == null) {
            insets = new Insets(0, 0, 0, 0);
        } else {
            insets.bottom = 0;
            insets.top = 0;
            insets.right = 0;
            insets.left = 0;
        }
        if (this.outsideBorder != null) {
            insets2 = this.outsideBorder.getBorderInsets(component);
            insets.left += insets2.left;
            insets.right += insets2.right;
            insets.top += insets2.top;
            insets.bottom += insets2.bottom;
        }
        if (this.insideBorder != null) {
            insets2 = this.insideBorder.getBorderInsets(component);
            insets.left += insets2.left;
            insets.right += insets2.right;
            insets.top += insets2.top;
            insets.bottom += insets2.bottom;
        }
        return insets;
    }

    public Insets getBorderInsets(Component component) {
        return this.getBorderInsets(component, null);
    }

    public Border getOutsideBorder() {
        return this.outsideBorder;
    }

    public Border getInsideBorder() {
        return this.insideBorder;
    }
}

