/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.border;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.border.AbstractBorder;

public class BevelBorder
extends AbstractBorder {
    static final long serialVersionUID = -1034942243356299676L;
    public static final int RAISED = 0;
    public static final int LOWERED = 1;
    protected int bevelType;
    protected Color highlightOuter;
    protected Color highlightInner;
    protected Color shadowOuter;
    protected Color shadowInner;

    public BevelBorder(int n) {
        if (n != 0 && n != 1) {
            throw new IllegalArgumentException();
        }
        this.bevelType = n;
    }

    public BevelBorder(int n, Color color, Color color2) {
        this(n, color.brighter(), color, color2, color2.brighter());
    }

    public BevelBorder(int n, Color color, Color color2, Color color3, Color color4) {
        this(n);
        if (color == null || color2 == null || color3 == null || color4 == null) {
            throw new NullPointerException();
        }
        this.highlightOuter = color;
        this.highlightInner = color2;
        this.shadowOuter = color3;
        this.shadowInner = color4;
    }

    public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
        switch (this.bevelType) {
            case 0: {
                this.paintRaisedBevel(component, graphics, n, n2, n3, n4);
                break;
            }
            case 1: {
                this.paintLoweredBevel(component, graphics, n, n2, n3, n4);
            }
        }
    }

    public Insets getBorderInsets(Component component) {
        return new Insets(2, 2, 2, 2);
    }

    public Insets getBorderInsets(Component component, Insets insets) {
        insets.bottom = 2;
        insets.top = 2;
        insets.right = 2;
        insets.left = 2;
        return insets;
    }

    public Color getHighlightOuterColor(Component component) {
        if (this.highlightOuter != null) {
            return this.highlightOuter;
        }
        return this.getHighlightInnerColor(component).brighter();
    }

    public Color getHighlightInnerColor(Component component) {
        if (this.highlightInner != null) {
            return this.highlightInner;
        }
        return component.getBackground().brighter();
    }

    public Color getShadowInnerColor(Component component) {
        if (this.shadowInner != null) {
            return this.shadowInner;
        }
        return component.getBackground().darker();
    }

    public Color getShadowOuterColor(Component component) {
        if (this.shadowOuter != null) {
            return this.shadowOuter;
        }
        return this.getShadowInnerColor(component).darker();
    }

    public Color getHighlightOuterColor() {
        return this.highlightOuter;
    }

    public Color getHighlightInnerColor() {
        return this.highlightInner;
    }

    public Color getShadowInnerColor() {
        return this.shadowInner;
    }

    public Color getShadowOuterColor() {
        return this.shadowOuter;
    }

    public int getBevelType() {
        return this.bevelType;
    }

    public boolean isBorderOpaque() {
        return !(this.highlightOuter != null && this.highlightOuter.getAlpha() != 255 || this.highlightInner != null && this.highlightInner.getAlpha() != 255 || this.shadowInner != null && this.shadowInner.getAlpha() != 255 || this.shadowOuter != null && this.shadowOuter.getAlpha() != 255);
    }

    protected void paintRaisedBevel(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
        BevelBorder.paintBevel(graphics, n, n2, n3, n4, this.getHighlightOuterColor(component), this.getHighlightInnerColor(component), this.getShadowInnerColor(component), this.getShadowOuterColor(component));
    }

    protected void paintLoweredBevel(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
        BevelBorder.paintBevel(graphics, n, n2, n3, n4, this.getShadowInnerColor(component), this.getShadowOuterColor(component), this.getHighlightInnerColor(component), this.getHighlightOuterColor(component));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void paintBevel(Graphics graphics, int n, int n2, int n3, int n4, Color color, Color color2, Color color3, Color color4) {
        Color color5 = graphics.getColor();
        graphics.translate(n, n2);
        --n3;
        --n4;
        try {
            graphics.setColor(color);
            graphics.drawLine(0, 0, n3, 0);
            graphics.drawLine(0, 1, 0, n4);
            graphics.setColor(color2);
            graphics.drawLine(1, 1, n3 - 1, 1);
            graphics.drawLine(1, 2, 1, n4 - 1);
            graphics.setColor(color3);
            graphics.drawLine(2, n4 - 1, n3 - 1, n4 - 1);
            graphics.drawLine(n3 - 1, 2, n3 - 1, n4 - 2);
            graphics.setColor(color4);
            graphics.drawLine(1, n4, n3, n4);
            graphics.drawLine(n3, 1, n3, n4 - 1);
            Object var11_10 = null;
            graphics.translate(-n, -n2);
            graphics.setColor(color5);
        }
        catch (Throwable throwable) {
            Object var11_11 = null;
            graphics.translate(-n, -n2);
            graphics.setColor(color5);
            throw throwable;
        }
    }
}

