/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.AbstractSpinnerModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpinnerListModel
extends AbstractSpinnerModel
implements Serializable {
    private static final long serialVersionUID = 3358804052191994516L;
    private List list;
    private transient int index;

    public SpinnerListModel() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("empty");
        this.setList(arrayList);
    }

    public SpinnerListModel(List<?> list2) {
        this.setList(list2);
    }

    public SpinnerListModel(Object[] objectArray) {
        if (objectArray == null || objectArray.length == 0) {
            throw new IllegalArgumentException("The supplied array was invalid.");
        }
        this.setList(Arrays.asList(objectArray));
    }

    public List<?> getList() {
        return this.list;
    }

    @Override
    public Object getNextValue() {
        if (this.index < this.list.size() - 1) {
            return this.list.get(this.index + 1);
        }
        return null;
    }

    @Override
    public Object getPreviousValue() {
        if (this.index > 0) {
            return this.list.get(this.index - 1);
        }
        return null;
    }

    @Override
    public Object getValue() {
        return this.list.get(this.index);
    }

    public void setList(List<?> list2) {
        if (list2 == null || list2.size() == 0) {
            throw new IllegalArgumentException("The supplied list was invalid.");
        }
        if (this.list != list2) {
            this.list = list2;
            this.fireStateChanged();
        }
        this.index = 0;
    }

    @Override
    public void setValue(Object object) {
        int n = this.list.indexOf(object);
        if (n == -1) {
            throw new IllegalArgumentException("The supplied value does not exist in this list");
        }
        this.index = n;
        this.fireStateChanged();
    }
}

