/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import gnu.classpath.SystemProperties;
import gnu.java.awt.LowPriorityEvent;
import java.applet.Applet;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.InvocationEvent;
import java.awt.image.VolatileImage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.WeakHashMap;
import javax.swing.CellRendererPane;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;

public class RepaintManager {
    static WeakHashMap currentRepaintManagers;
    private static Rectangle rectCache;
    private HashMap dirtyComponents = new HashMap();
    private HashMap dirtyComponentsWork = new HashMap();
    private RepaintWorker repaintWorker;
    private ArrayList invalidComponents = new ArrayList();
    private boolean doubleBufferingEnabled;
    private WeakHashMap offscreenBuffers;
    private Dimension doubleBufferMaximumSize;

    public RepaintManager() {
        this.repaintWorker = new RepaintWorker();
        this.doubleBufferMaximumSize = new Dimension(2000, 2000);
        this.doubleBufferingEnabled = SystemProperties.getProperty("gnu.swing.doublebuffering", "true").equals("true");
        this.offscreenBuffers = new WeakHashMap();
    }

    public static RepaintManager currentManager(Component component) {
        ThreadGroup threadGroup;
        RepaintManager repaintManager;
        if (currentRepaintManagers == null) {
            currentRepaintManagers = new WeakHashMap();
        }
        if ((repaintManager = (RepaintManager)currentRepaintManagers.get(threadGroup = Thread.currentThread().getThreadGroup())) == null) {
            repaintManager = new RepaintManager();
            currentRepaintManagers.put(threadGroup, repaintManager);
        }
        return repaintManager;
    }

    public static RepaintManager currentManager(JComponent jComponent) {
        return RepaintManager.currentManager((Component)jComponent);
    }

    public static void setCurrentManager(RepaintManager repaintManager) {
        if (currentRepaintManagers == null) {
            currentRepaintManagers = new WeakHashMap();
        }
        ThreadGroup threadGroup = Thread.currentThread().getThreadGroup();
        currentRepaintManagers.put(threadGroup, repaintManager);
    }

    public void addInvalidComponent(JComponent jComponent) {
        Container container;
        Container container2 = null;
        for (container = jComponent; container != null; container = container.getParent()) {
            if (container instanceof CellRendererPane || !container.isDisplayable()) {
                return;
            }
            if (!(container instanceof JComponent) || !((JComponent)container).isValidateRoot()) continue;
            container2 = container;
            break;
        }
        if (container2 == null) {
            return;
        }
        for (container = container2; container != null; container = container.getParent()) {
            if (container.isVisible() && container.isDisplayable()) continue;
            return;
        }
        if (this.invalidComponents.contains(container2)) {
            return;
        }
        this.invalidComponents.add(container2);
        if (!this.repaintWorker.isLive()) {
            this.repaintWorker.setLive(true);
            this.invokeLater(this.repaintWorker);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeInvalidComponent(JComponent jComponent) {
        ArrayList arrayList = this.invalidComponents;
        synchronized (arrayList) {
            this.invalidComponents.remove(jComponent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDirtyRegion(JComponent jComponent, int n, int n2, int n3, int n4) {
        if (n3 <= 0 || n4 <= 0 || !jComponent.isShowing()) {
            return;
        }
        jComponent.computeVisibleRect(rectCache);
        SwingUtilities.computeIntersection(n, n2, n3, n4, rectCache);
        if (!rectCache.isEmpty()) {
            HashMap hashMap = this.dirtyComponents;
            synchronized (hashMap) {
                Rectangle rectangle = (Rectangle)this.dirtyComponents.get(jComponent);
                if (rectangle != null) {
                    SwingUtilities.computeUnion(RepaintManager.rectCache.x, RepaintManager.rectCache.y, RepaintManager.rectCache.width, RepaintManager.rectCache.height, rectangle);
                } else {
                    this.dirtyComponents.put(jComponent, rectCache.getBounds());
                }
            }
            if (!this.repaintWorker.isLive()) {
                this.repaintWorker.setLive(true);
                this.invokeLater(this.repaintWorker);
            }
        }
    }

    public Rectangle getDirtyRegion(JComponent jComponent) {
        Rectangle rectangle = (Rectangle)this.dirtyComponents.get(jComponent);
        if (rectangle == null) {
            rectangle = new Rectangle();
        }
        return rectangle;
    }

    public void markCompletelyDirty(JComponent jComponent) {
        this.addDirtyRegion(jComponent, 0, 0, Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void markCompletelyClean(JComponent jComponent) {
        HashMap hashMap = this.dirtyComponents;
        synchronized (hashMap) {
            this.dirtyComponents.remove(jComponent);
        }
    }

    public boolean isCompletelyDirty(JComponent jComponent) {
        boolean bl = false;
        Rectangle rectangle = this.getDirtyRegion(jComponent);
        if (rectangle.width == Integer.MAX_VALUE && rectangle.height == Integer.MAX_VALUE) {
            bl = true;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void validateInvalidComponents() {
        while (this.invalidComponents.size() > 0) {
            Component component;
            ArrayList arrayList = this.invalidComponents;
            synchronized (arrayList) {
                component = (Component)this.invalidComponents.remove(0);
            }
            if (!component.isVisible() || !component.isShowing()) continue;
            component.validate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paintDirtyRegions() {
        JComponent jComponent;
        Object object;
        if (this.dirtyComponents.size() == 0) {
            return;
        }
        Cloneable cloneable = this.dirtyComponents;
        synchronized (cloneable) {
            object = this.dirtyComponents;
            this.dirtyComponents = this.dirtyComponentsWork;
            this.dirtyComponentsWork = object;
        }
        cloneable = new HashSet();
        object = this.dirtyComponentsWork.keySet();
        Iterator<Object> iterator = object.iterator();
        while (iterator.hasNext()) {
            jComponent = (JComponent)iterator.next();
            this.compileRepaintRoots(this.dirtyComponentsWork, jComponent, (HashSet)cloneable);
        }
        iterator = ((HashSet)cloneable).iterator();
        while (iterator.hasNext()) {
            jComponent = (JComponent)iterator.next();
            Rectangle rectangle = (Rectangle)this.dirtyComponentsWork.remove(jComponent);
            if (rectangle == null || rectangle.isEmpty()) continue;
            jComponent.paintImmediately(rectangle);
        }
        this.dirtyComponentsWork.clear();
    }

    private void compileRepaintRoots(HashMap hashMap, JComponent jComponent, HashSet hashSet) {
        Container container;
        Container container2 = jComponent;
        Container container3 = jComponent;
        Rectangle rectangle = (Rectangle)hashMap.get(jComponent);
        rectCache.setBounds(rectangle);
        int n = jComponent.getX();
        int n2 = jComponent.getY();
        int n3 = jComponent.getWidth();
        int n4 = jComponent.getHeight();
        rectCache = SwingUtilities.computeIntersection(0, 0, n3, n4, rectCache);
        if (rectCache.isEmpty()) {
            return;
        }
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        while ((container = container2.getParent()) != null && container instanceof JComponent) {
            container2 = container;
            n5 += n;
            n6 += n2;
            RepaintManager.rectCache.x += n;
            RepaintManager.rectCache.y += n2;
            n = container2.getX();
            n2 = container2.getY();
            n3 = container2.getWidth();
            rectCache = SwingUtilities.computeIntersection(0, 0, n3, n4 = container2.getHeight(), rectCache);
            if (rectCache.isEmpty()) {
                return;
            }
            if (!hashMap.containsKey(container)) continue;
            container3 = container2;
            n7 = n5;
            n8 = n6;
        }
        if (container3 != jComponent) {
            RepaintManager.rectCache.x += n7 - n5;
            RepaintManager.rectCache.y += n8 - n6;
            Rectangle rectangle2 = (Rectangle)hashMap.get(container3);
            SwingUtilities.computeUnion(RepaintManager.rectCache.x, RepaintManager.rectCache.y, RepaintManager.rectCache.width, RepaintManager.rectCache.height, rectangle2);
        }
        if (!hashSet.contains(container3)) {
            hashSet.add(container3);
        }
    }

    public Image getOffscreenBuffer(Component component, int n, int n2) {
        Window window = SwingUtilities.getWindowAncestor(component);
        Image image = (Image)this.offscreenBuffers.get(window);
        if (image == null || image.getWidth(null) < n || image.getHeight(null) < n2) {
            int n3 = Math.max(n, window.getWidth());
            n3 = Math.min(this.doubleBufferMaximumSize.width, n3);
            int n4 = Math.max(n2, window.getHeight());
            n4 = Math.min(this.doubleBufferMaximumSize.height, n4);
            image = component.createImage(n3, n4);
            this.offscreenBuffers.put(window, image);
        }
        return image;
    }

    void commitBuffer(Component component, int n, int n2, int n3, int n4) {
        Component component2;
        for (component2 = component; component2 != null && !(component2 instanceof Window) && !(component2 instanceof Applet); component2 = component2.getParent()) {
            n += component2.getX();
            n2 += component2.getY();
        }
        if (component2 != null) {
            Graphics graphics = component2.getGraphics();
            Image image = (Image)this.offscreenBuffers.get(component2);
            if (image != null) {
                graphics.clipRect(n, n2, n3, n4);
                graphics.drawImage(image, 0, 0, component2);
                graphics.dispose();
            }
        }
    }

    public Image getVolatileOffscreenBuffer(Component component, int n, int n2) {
        Window window = SwingUtilities.getWindowAncestor(component);
        Image image = (Image)this.offscreenBuffers.get(window);
        if (image == null || image.getWidth(null) < n || image.getHeight(null) < n2 || !(image instanceof VolatileImage)) {
            int n3 = Math.max(n, window.getWidth());
            n3 = Math.min(this.doubleBufferMaximumSize.width, n3);
            int n4 = Math.max(n2, window.getHeight());
            image = window.createVolatileImage(n3, n4 = Math.min(this.doubleBufferMaximumSize.height, n4));
            if (image != null) {
                this.offscreenBuffers.put(window, image);
            }
        }
        return image;
    }

    public Dimension getDoubleBufferMaximumSize() {
        return this.doubleBufferMaximumSize;
    }

    public void setDoubleBufferMaximumSize(Dimension dimension) {
        this.doubleBufferMaximumSize = dimension;
    }

    public void setDoubleBufferingEnabled(boolean bl) {
        this.doubleBufferingEnabled = bl;
    }

    public boolean isDoubleBufferingEnabled() {
        return this.doubleBufferingEnabled;
    }

    public String toString() {
        return "RepaintManager";
    }

    private void invokeLater(Runnable runnable) {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        EventQueue eventQueue = toolkit.getSystemEventQueue();
        RepaintWorkerEvent repaintWorkerEvent = new RepaintWorkerEvent(eventQueue, runnable, null, false);
        eventQueue.postEvent(repaintWorkerEvent);
    }

    static {
        rectCache = new Rectangle();
    }

    private class RepaintWorker
    implements Runnable {
        boolean live = false;

        public synchronized void setLive(boolean bl) {
            this.live = bl;
        }

        public synchronized boolean isLive() {
            return this.live;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                ThreadGroup threadGroup = Thread.currentThread().getThreadGroup();
                RepaintManager repaintManager = (RepaintManager)currentRepaintManagers.get(threadGroup);
                repaintManager.validateInvalidComponents();
                repaintManager.paintDirtyRegions();
                Object var4_3 = null;
                this.setLive(false);
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                this.setLive(false);
                throw throwable;
            }
        }
    }

    private static class RepaintWorkerEvent
    extends InvocationEvent
    implements LowPriorityEvent {
        public RepaintWorkerEvent(Object object, Runnable runnable, Object object2, boolean bl) {
            super(object, runnable, object2, bl);
        }

        public void dispatch() {
            super.dispatch();
        }
    }
}

