/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.accessibility.AccessibleContext;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JProgressBar;
import javax.swing.Timer;

public class ProgressMonitor {
    protected AccessibleContext accessibleContext;
    Component component;
    String note;
    Object message;
    int millisToDecideToPopup = 500;
    int millisToPopup = 2000;
    int min;
    int max;
    int progress;
    JProgressBar progressBar;
    JLabel noteLabel;
    JDialog progressDialog;
    Timer timer;
    boolean canceled;

    public ProgressMonitor(Component component, Object object, String string, int n, int n2) {
        this.component = component;
        this.message = object;
        this.note = string;
        this.min = n;
        this.max = n2;
    }

    public void close() {
        if (this.progressDialog != null) {
            this.progressDialog.setVisible(false);
        }
        if (this.timer != null) {
            this.timer.stop();
            this.timer = null;
        }
    }

    public void setProgress(int n) {
        this.progress = n;
        if (this.timer == null && this.progressDialog == null) {
            this.timer = new Timer(25, null);
            this.timer.addActionListener(new TimerListener());
            this.timer.start();
        }
        if (this.progressBar != null && this.progress >= this.progressBar.getMaximum()) {
            this.close();
        }
    }

    public int getMinimum() {
        return this.min;
    }

    public void setMinimum(int n) {
        this.min = n;
    }

    public int getMaximum() {
        return this.max;
    }

    public void setMaximum(int n) {
        this.max = n;
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    public int getMillisToDecideToPopup() {
        return this.millisToDecideToPopup;
    }

    public void setMillisToDecideToPopup(int n) {
        this.millisToDecideToPopup = n;
    }

    public int getMillisToPopup() {
        return this.millisToPopup;
    }

    public void setMillisToPopup(int n) {
        this.millisToPopup = n;
    }

    public String getNote() {
        return this.note;
    }

    public void setNote(String string) {
        if (this.noteLabel != null) {
            this.noteLabel.setText(string);
        } else {
            this.note = string;
        }
    }

    void createDialog() {
        Object[] objectArray;
        if (this.note == null) {
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = this.message;
            objectArray = objectArray2;
            this.progressBar = new JProgressBar(this.min, this.max);
            objectArray2[1] = this.progressBar;
        } else {
            Object[] objectArray3 = new Object[3];
            objectArray3[0] = this.message;
            this.noteLabel = new JLabel(this.note);
            objectArray3[1] = this.noteLabel;
            objectArray = objectArray3;
            this.progressBar = new JProgressBar(this.min, this.max);
            objectArray3[2] = this.progressBar;
        }
        Object[] objectArray4 = objectArray;
        JOptionPane jOptionPane = new JOptionPane(objectArray4, 1);
        JButton jButton = new JButton("Cancel");
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ProgressMonitor.this.canceled = true;
            }
        });
        jOptionPane.setOptions(new Object[]{jButton});
        this.progressDialog = jOptionPane.createDialog(this.component, "Progress ...");
        this.progressDialog.setModal(false);
        this.progressDialog.setResizable(true);
        this.progressDialog.pack();
        this.progressDialog.setVisible(true);
    }

    public AccessibleContext getAccessibleContext() {
        return this.accessibleContext;
    }

    class TimerListener
    implements ActionListener {
        long timestamp = System.currentTimeMillis();
        int lastProgress;
        boolean first = true;

        TimerListener() {
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void actionPerformed(ActionEvent actionEvent) {
            long l = System.currentTimeMillis();
            if (this.first) {
                long l2;
                if (l - this.timestamp <= (long)ProgressMonitor.this.millisToDecideToPopup) return;
                this.first = false;
                long l3 = l2 = ProgressMonitor.this.progress - ProgressMonitor.this.min == 0 ? (l - this.timestamp) * (long)(ProgressMonitor.this.max - ProgressMonitor.this.min) : (l - this.timestamp) * (long)(ProgressMonitor.this.max - ProgressMonitor.this.min) / (long)(ProgressMonitor.this.progress - ProgressMonitor.this.min);
                if (l2 > (long)ProgressMonitor.this.millisToPopup) {
                    ProgressMonitor.this.createDialog();
                }
            } else if (ProgressMonitor.this.progressDialog != null) {
                int n = ProgressMonitor.this.progress - ProgressMonitor.this.progressBar.getValue();
                if (n * ProgressMonitor.this.progressBar.getWidth() / (ProgressMonitor.this.max - ProgressMonitor.this.min) > 0) {
                    ProgressMonitor.this.progressBar.setValue(ProgressMonitor.this.progress);
                }
            } else {
                ProgressMonitor.this.timer.stop();
                ProgressMonitor.this.timer = null;
            }
            this.timestamp = l;
        }
    }
}

