/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.applet.Applet;
import java.awt.Component;
import java.awt.Container;
import java.awt.Window;
import java.awt.event.KeyEvent;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import java.util.WeakHashMap;
import javax.swing.ComponentInputMap;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.JMenuBar;
import javax.swing.KeyStroke;

class KeyboardManager {
    static KeyboardManager manager = new KeyboardManager();
    WeakHashMap topLevelLookup = new WeakHashMap();
    Hashtable menuBarLookup = new Hashtable();

    KeyboardManager() {
    }

    public static KeyboardManager getManager() {
        return manager;
    }

    static Container findTopLevel(Component component) {
        Container container;
        Container container2 = container = component instanceof Container ? (Container)component : component.getParent();
        while (!(container == null || container instanceof Window || container instanceof Applet || container instanceof JInternalFrame)) {
            container = container.getParent();
        }
        return container;
    }

    Hashtable getHashtableForTopLevel(Container container) {
        Hashtable hashtable = (Hashtable)this.topLevelLookup.get(container);
        if (hashtable == null) {
            hashtable = new Hashtable();
            this.topLevelLookup.put(container, hashtable);
        }
        return hashtable;
    }

    public void registerBinding(JComponent jComponent, KeyStroke keyStroke) {
        Container container = KeyboardManager.findTopLevel(jComponent);
        if (container == null) {
            return;
        }
        Hashtable hashtable = this.getHashtableForTopLevel(container);
        hashtable.put(keyStroke, jComponent);
    }

    public void clearBindingsForComp(JComponent jComponent) {
        Container container = KeyboardManager.findTopLevel(jComponent);
        if (container == null) {
            return;
        }
        Hashtable hashtable = this.getHashtableForTopLevel(container);
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            Object k = enumeration.nextElement();
            if (jComponent != (JComponent)hashtable.get(k)) continue;
            hashtable.remove(k);
        }
    }

    public void registerEntireMap(ComponentInputMap componentInputMap) {
        if (componentInputMap == null) {
            return;
        }
        JComponent jComponent = componentInputMap.getComponent();
        KeyStroke[] keyStrokeArray = componentInputMap.allKeys();
        if (keyStrokeArray == null) {
            return;
        }
        Container container = KeyboardManager.findTopLevel(jComponent);
        if (container == null) {
            return;
        }
        Hashtable hashtable = this.getHashtableForTopLevel(container);
        for (int i = 0; i < keyStrokeArray.length; ++i) {
            hashtable.put(keyStrokeArray[i], jComponent);
        }
    }

    public boolean processKeyStroke(Component component, KeyStroke keyStroke, KeyEvent keyEvent) {
        boolean bl = keyEvent.getID() == 401;
        Container container = KeyboardManager.findTopLevel(component);
        if (container == null) {
            return false;
        }
        Hashtable hashtable = this.getHashtableForTopLevel(container);
        Enumeration enumeration = hashtable.keys();
        JComponent jComponent = (JComponent)hashtable.get(keyStroke);
        if (jComponent != null && jComponent.processKeyBinding(keyStroke, keyEvent, 2, bl)) {
            return true;
        }
        Vector vector = this.getVectorForTopLevel(container);
        for (int i = 0; i < vector.size(); ++i) {
            if (!((JMenuBar)vector.elementAt(i)).processKeyBinding(keyStroke, keyEvent, 2, bl)) continue;
            return true;
        }
        return false;
    }

    Vector getVectorForTopLevel(Container container) {
        Vector vector = (Vector)this.menuBarLookup.get(container);
        if (vector == null) {
            vector = new Vector();
            this.menuBarLookup.put(container, vector);
        }
        return vector;
    }

    public void registerJMenuBar(JMenuBar jMenuBar) {
        Container container = KeyboardManager.findTopLevel(jMenuBar);
        Vector vector = this.getVectorForTopLevel(container);
        if (!vector.contains(jMenuBar)) {
            vector.add(jMenuBar);
        }
    }

    public void unregisterJMenuBar(JMenuBar jMenuBar) {
        Container container = KeyboardManager.findTopLevel(jMenuBar);
        Vector vector = this.getVectorForTopLevel(container);
        if (vector.contains(jMenuBar)) {
            vector.remove(jMenuBar);
        }
    }
}

