/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import gnu.classpath.SystemProperties;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.io.Serializable;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.ViewportLayout;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.ViewportUI;

public class JViewport
extends JComponent
implements Accessible {
    public static final int SIMPLE_SCROLL_MODE = 0;
    public static final int BLIT_SCROLL_MODE = 1;
    public static final int BACKINGSTORE_SCROLL_MODE = 2;
    private static final long serialVersionUID = -6925142919680527970L;
    private static final int defaultScrollMode;
    protected boolean scrollUnderway;
    protected boolean isViewSizeSet;
    protected boolean backingStore;
    protected Image backingStoreImage;
    protected Point lastPaintPosition;
    ChangeEvent changeEvent = new ChangeEvent(this);
    int scrollMode;
    ViewListener viewListener;
    Point cachedBlitFrom;
    Point cachedBlitTo;
    Dimension cachedBlitSize;
    Rectangle cachedBlitPaint;
    boolean damaged = true;
    boolean sizeChanged = true;
    private boolean isPaintRoot = false;

    public JViewport() {
        this.setOpaque(true);
        this.setScrollMode(defaultScrollMode);
        this.updateUI();
        this.setLayout(this.createLayoutManager());
        this.lastPaintPosition = new Point();
        this.cachedBlitFrom = new Point();
        this.cachedBlitTo = new Point();
        this.cachedBlitSize = new Dimension();
        this.cachedBlitPaint = new Rectangle();
    }

    public Dimension getExtentSize() {
        return this.getSize();
    }

    public Dimension toViewCoordinates(Dimension dimension) {
        return dimension;
    }

    public Point toViewCoordinates(Point point) {
        Point point2 = this.getViewPosition();
        return new Point(point.x + point2.x, point.y + point2.y);
    }

    public void setExtentSize(Dimension dimension) {
        Dimension dimension2 = this.getExtentSize();
        if (!dimension.equals(dimension2)) {
            this.setSize(dimension);
            this.fireStateChanged();
        }
    }

    public Dimension getViewSize() {
        Component component = this.getView();
        Dimension dimension = component != null ? (this.isViewSizeSet ? component.getSize() : component.getPreferredSize()) : new Dimension(0, 0);
        return dimension;
    }

    public void setViewSize(Dimension dimension) {
        Component component = this.getView();
        if (component != null && !dimension.equals(component.getSize())) {
            this.scrollUnderway = false;
            component.setSize(dimension);
            this.isViewSizeSet = true;
            this.fireStateChanged();
        }
    }

    public Point getViewPosition() {
        Component component = this.getView();
        if (component == null) {
            return new Point(0, 0);
        }
        Point point = component.getLocation();
        point.x = -point.x;
        point.y = -point.y;
        return point;
    }

    public void setViewPosition(Point point) {
        Component component = this.getView();
        if (component != null && !point.equals(this.getViewPosition())) {
            this.scrollUnderway = true;
            component.setLocation(-point.x, -point.y);
            this.fireStateChanged();
        }
    }

    public Rectangle getViewRect() {
        return new Rectangle(this.getViewPosition(), this.getExtentSize());
    }

    public boolean isBackingStoreEnabled() {
        return this.scrollMode == 2;
    }

    public void setBackingStoreEnabled(boolean bl) {
        if (bl && this.scrollMode != 2) {
            this.scrollMode = 2;
            this.fireStateChanged();
        }
    }

    public void setScrollMode(int n) {
        this.scrollMode = n;
        this.fireStateChanged();
    }

    public int getScrollMode() {
        return this.scrollMode;
    }

    public Component getView() {
        if (this.getComponentCount() == 0) {
            return null;
        }
        return this.getComponents()[0];
    }

    public void setView(Component component) {
        Component component2 = this.getView();
        if (this.viewListener != null && component2 != null) {
            component2.removeComponentListener(this.viewListener);
        }
        if (component != null) {
            if (this.viewListener == null) {
                this.viewListener = this.createViewListener();
            }
            component.addComponentListener(this.viewListener);
            this.add(component);
            this.fireStateChanged();
        }
        this.revalidate();
        this.repaint();
    }

    public void reshape(int n, int n2, int n3, int n4) {
        if (n3 != this.getWidth() || n4 != this.getHeight()) {
            this.sizeChanged = true;
        }
        super.reshape(n, n2, n3, n4);
        if (this.sizeChanged) {
            this.damaged = true;
            this.fireStateChanged();
        }
    }

    public final Insets getInsets() {
        return new Insets(0, 0, 0, 0);
    }

    public final Insets getInsets(Insets insets) {
        if (insets == null) {
            return this.getInsets();
        }
        insets.top = 0;
        insets.bottom = 0;
        insets.left = 0;
        insets.right = 0;
        return insets;
    }

    public boolean isOptimizedDrawingEnabled() {
        return false;
    }

    public void paint(Graphics graphics) {
        Component component = this.getView();
        if (component == null) {
            return;
        }
        Rectangle rectangle = component.getBounds();
        Rectangle rectangle2 = this.getBounds();
        if (rectangle.width == 0 || rectangle.height == 0 || rectangle2.width == 0 || rectangle2.height == 0) {
            return;
        }
        switch (this.getScrollMode()) {
            case 2: {
                this.paintBackingStore(graphics);
                break;
            }
            case 1: {
                this.paintBlit(graphics);
                break;
            }
            default: {
                this.paintSimple(graphics);
            }
        }
        this.damaged = false;
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.listenerList.add(ChangeListener.class, changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.listenerList.remove(ChangeListener.class, changeListener);
    }

    public ChangeListener[] getChangeListeners() {
        return (ChangeListener[])this.getListeners(ChangeListener.class);
    }

    public String getUIClassID() {
        return "ViewportUI";
    }

    public void updateUI() {
        this.setUI((ViewportUI)UIManager.getUI(this));
    }

    public ViewportUI getUI() {
        return (ViewportUI)this.ui;
    }

    public void setUI(ViewportUI viewportUI) {
        super.setUI(viewportUI);
    }

    public final void setBorder(Border border) {
        if (border != null) {
            throw new IllegalArgumentException();
        }
    }

    public void scrollRectToVisible(Rectangle rectangle) {
        Component component = this.getView();
        if (component == null) {
            return;
        }
        Point point = this.getViewPosition();
        int n = rectangle.x + point.x;
        int n2 = rectangle.y + point.y;
        Rectangle rectangle2 = this.getView().getBounds();
        Rectangle rectangle3 = this.getBounds();
        if (this.isShowing()) {
            this.getView().validate();
        }
        if (n2 + rectangle.height + rectangle2.y > rectangle3.height) {
            point.y = n2 + rectangle.height - rectangle3.height;
        }
        if (n2 + rectangle2.y < 0) {
            point.y = n2;
        }
        if (n + rectangle.width + rectangle2.x > rectangle3.width) {
            point.x = n + rectangle.width - rectangle3.width;
        }
        if (n + rectangle2.x < 0) {
            point.x = n;
        }
        this.setViewPosition(point);
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleJViewport();
        }
        return this.accessibleContext;
    }

    public void repaint(long l, int n, int n2, int n3, int n4) {
        Container container = this.getParent();
        if (container != null) {
            container.repaint(l, n + this.getX(), n2 + this.getY(), n3, n4);
        } else {
            super.repaint(l, n, n2, n3, n4);
        }
    }

    protected void addImpl(Component component, Object object, int n) {
        if (this.getComponentCount() > 0) {
            this.remove(this.getComponents()[0]);
        }
        super.addImpl(component, object, n);
    }

    protected void fireStateChanged() {
        ChangeListener[] changeListenerArray = this.getChangeListeners();
        for (int i = 0; i < changeListenerArray.length; ++i) {
            changeListenerArray[i].stateChanged(this.changeEvent);
        }
    }

    protected ViewListener createViewListener() {
        return new ViewListener();
    }

    protected LayoutManager createLayoutManager() {
        return new ViewportLayout();
    }

    protected boolean computeBlit(int n, int n2, Point point, Point point2, Dimension dimension, Rectangle rectangle) {
        if (n != 0 && n2 != 0 || n2 == 0 && n2 == 0 || this.damaged) {
            return false;
        }
        Rectangle rectangle2 = SwingUtilities.calculateInnerArea(this, this.getBounds());
        point.x = rectangle2.x;
        point.y = rectangle2.y;
        point2.x = rectangle2.x;
        point2.y = rectangle2.y;
        if (n2 > 0) {
            point.y = rectangle2.y + n2;
        } else if (n2 < 0) {
            point2.y = rectangle2.y - n2;
        } else if (n > 0) {
            point.x = rectangle2.x + n;
        } else if (n < 0) {
            point2.x = rectangle2.x - n;
        }
        if (n != 0) {
            dimension.width = rectangle2.width - Math.abs(n);
            dimension.height = rectangle2.height;
        } else if (n2 != 0) {
            dimension.width = rectangle2.width;
            dimension.height = rectangle2.height - Math.abs(n2);
        }
        rectangle.setBounds(rectangle2);
        if (n2 > 0) {
            rectangle.y = rectangle2.y + rectangle2.height - n2;
            rectangle.height = n2;
        } else if (n2 < 0) {
            rectangle.height = -n2;
        }
        if (n > 0) {
            rectangle.x = rectangle2.x + rectangle2.width - n;
            rectangle.width = n;
        } else if (n < 0) {
            rectangle.width = -n;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void paintSimple(Graphics graphics) {
        this.paintComponent(graphics);
        Point point = this.getViewPosition();
        Component component = this.getView();
        Shape shape = graphics.getClip();
        graphics.clipRect(0, 0, this.getWidth(), this.getHeight());
        boolean bl = false;
        try {
            graphics.translate(-point.x, -point.y);
            bl = true;
            component.paint(graphics);
            Object var7_6 = null;
            if (bl) {
                graphics.translate(point.x, point.y);
            }
            graphics.setClip(shape);
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            if (bl) {
                graphics.translate(point.x, point.y);
            }
            graphics.setClip(shape);
            throw throwable;
        }
    }

    void paintBackingStore(Graphics graphics) {
        if (this.backingStoreImage == null || this.sizeChanged) {
            this.backingStoreImage = this.createImage(this.getWidth(), this.getHeight());
            this.sizeChanged = false;
            Graphics graphics2 = this.backingStoreImage.getGraphics();
            this.paintSimple(graphics2);
            graphics2.dispose();
        } else {
            Graphics graphics3 = this.backingStoreImage.getGraphics();
            Point point = this.getViewPosition();
            int n = point.x - this.lastPaintPosition.x;
            int n2 = point.y - this.lastPaintPosition.y;
            boolean bl = this.computeBlit(n, n2, this.cachedBlitFrom, this.cachedBlitTo, this.cachedBlitSize, this.cachedBlitPaint);
            if (bl && this.isPaintRoot) {
                if (this.cachedBlitSize.width > 0 && this.cachedBlitSize.height > 0) {
                    graphics3.copyArea(this.cachedBlitFrom.x, this.cachedBlitFrom.y, this.cachedBlitSize.width, this.cachedBlitSize.height, this.cachedBlitTo.x - this.cachedBlitFrom.x, this.cachedBlitTo.y - this.cachedBlitFrom.y);
                }
                graphics3.setClip(this.cachedBlitPaint.x, this.cachedBlitPaint.y, this.cachedBlitPaint.width, this.cachedBlitPaint.height);
                this.paintSimple(graphics3);
            } else {
                if (n == 0 && n2 == 0) {
                    graphics3.setClip(graphics.getClip());
                }
                this.paintSimple(graphics3);
            }
            graphics3.dispose();
        }
        graphics.drawImage(this.backingStoreImage, 0, 0, this);
        this.lastPaintPosition.setLocation(this.getViewPosition());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void paintBlit(Graphics graphics) {
        Point point = this.getViewPosition();
        int n = point.x - this.lastPaintPosition.x;
        int n2 = point.y - this.lastPaintPosition.y;
        boolean bl = this.computeBlit(n, n2, this.cachedBlitFrom, this.cachedBlitTo, this.cachedBlitSize, this.cachedBlitPaint);
        if (bl && this.isPaintRoot) {
            if (this.cachedBlitSize.width > 0 && this.cachedBlitSize.width > 0) {
                graphics.copyArea(this.cachedBlitFrom.x, this.cachedBlitFrom.y, this.cachedBlitSize.width, this.cachedBlitSize.height, this.cachedBlitTo.x - this.cachedBlitFrom.x, this.cachedBlitTo.y - this.cachedBlitFrom.y);
            }
            Shape shape = graphics.getClip();
            graphics.clipRect(this.cachedBlitPaint.x, this.cachedBlitPaint.y, this.cachedBlitPaint.width, this.cachedBlitPaint.height);
            try {
                this.paintSimple(graphics);
                Object var8_7 = null;
                graphics.setClip(shape);
            }
            catch (Throwable throwable) {
                Object var8_8 = null;
                graphics.setClip(shape);
                throw throwable;
            }
        } else {
            this.paintSimple(graphics);
        }
        this.lastPaintPosition.setLocation(this.getViewPosition());
    }

    void paintImmediately2(int n, int n2, int n3, int n4) {
        this.isPaintRoot = true;
        super.paintImmediately2(n, n2, n3, n4);
        this.isPaintRoot = false;
    }

    boolean isPaintRoot() {
        return this.scrollMode == 2;
    }

    static {
        String string = SystemProperties.getProperty("gnu.swing.scrollmode", "BACKINGSTORE");
        defaultScrollMode = string.equalsIgnoreCase("simple") ? 0 : (string.equalsIgnoreCase("backingstore") ? 2 : 1);
    }

    protected class ViewListener
    extends ComponentAdapter
    implements Serializable {
        private static final long serialVersionUID = -2812489404285958070L;

        protected ViewListener() {
        }

        public void componentResized(ComponentEvent componentEvent) {
            JViewport.this.fireStateChanged();
            JViewport.this.revalidate();
        }
    }

    protected class AccessibleJViewport
    extends JComponent.AccessibleJComponent {
        protected AccessibleJViewport() {
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.VIEWPORT;
        }
    }
}

