/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleState;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.DefaultButtonModel;
import javax.swing.Icon;
import javax.swing.UIManager;
import javax.swing.plaf.ButtonUI;

public class JToggleButton
extends AbstractButton
implements Accessible {
    private static final long serialVersionUID = -3128248873429850443L;

    public JToggleButton() {
        this(null, null, false);
    }

    public JToggleButton(Action action) {
        this();
        this.setAction(action);
    }

    public JToggleButton(Icon icon) {
        this(null, icon, false);
    }

    public JToggleButton(Icon icon, boolean bl) {
        this(null, icon, bl);
    }

    public JToggleButton(String string) {
        this(string, null, false);
    }

    public JToggleButton(String string, boolean bl) {
        this(string, null, bl);
    }

    public JToggleButton(String string, Icon icon) {
        this(string, icon, false);
    }

    public JToggleButton(String string, Icon icon, boolean bl) {
        this.setModel(new ToggleButtonModel());
        this.init(string, icon);
        this.model.setSelected(bl);
        this.setAlignmentX(0.0f);
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleJToggleButton();
        }
        return this.accessibleContext;
    }

    public String getUIClassID() {
        return "ToggleButtonUI";
    }

    protected String paramString() {
        return super.paramString();
    }

    public void updateUI() {
        this.setUI((ButtonUI)UIManager.getUI(this));
    }

    public static class ToggleButtonModel
    extends DefaultButtonModel {
        private static final long serialVersionUID = -1589950750899943974L;

        public void setPressed(boolean bl) {
            if (!this.isEnabled()) {
                return;
            }
            if (bl && this.isPressed() || !bl && !this.isPressed()) {
                return;
            }
            if (!bl && this.isArmed()) {
                this.setSelected(!this.isSelected());
            }
            this.stateMask = bl ? (this.stateMask |= 4) : (this.stateMask &= 0xFFFFFFFB);
            this.fireStateChanged();
            if (!bl && this.isArmed()) {
                this.fireActionPerformed(new ActionEvent(this, 1001, this.actionCommand));
            }
        }

        public boolean isSelected() {
            return super.isSelected();
        }

        public void setSelected(boolean bl) {
            super.setSelected(bl);
        }
    }

    protected class AccessibleJToggleButton
    extends AbstractButton.AccessibleAbstractButton
    implements ItemListener {
        private static final long serialVersionUID = -8652952712161229225L;

        public AccessibleJToggleButton() {
            JToggleButton.this.addItemListener(this);
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.TOGGLE_BUTTON;
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            if (itemEvent.getStateChange() == 1) {
                this.firePropertyChange("AccessibleState", null, AccessibleState.SELECTED);
            } else {
                this.firePropertyChange("AccessibleState", AccessibleState.ENABLED, null);
            }
        }
    }
}

