/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import gnu.java.lang.CPStringBuilder;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.EventListener;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.swing.Action;
import javax.swing.DefaultSingleSelectionModel;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JSeparator;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import javax.swing.SingleSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.MenuKeyListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.plaf.PopupMenuUI;

public class JPopupMenu
extends JComponent
implements Accessible,
MenuElement {
    private static final long serialVersionUID = -8336996630009646009L;
    private boolean borderPainted = true;
    private static boolean DefaultLightWeightPopupEnabled = true;
    transient Component invoker;
    private String label;
    private Insets margin;
    private boolean lightWeightPopupEnabled = JPopupMenu.getDefaultLightWeightPopupEnabled();
    protected SingleSelectionModel selectionModel;
    private transient Popup popup;
    private int popupLocationX;
    private int popupLocationY;
    private boolean visible = false;

    public JPopupMenu() {
        this(null);
    }

    public JPopupMenu(String string) {
        this.setLabel(string);
        this.setSelectionModel(new DefaultSingleSelectionModel());
        super.setVisible(false);
        this.updateUI();
    }

    public JMenuItem add(JMenuItem jMenuItem) {
        this.insert(jMenuItem, -1);
        return jMenuItem;
    }

    public JMenuItem add(String string) {
        JMenuItem jMenuItem = new JMenuItem(string);
        return this.add(jMenuItem);
    }

    public JMenuItem add(Action action) {
        JMenuItem jMenuItem = this.createActionComponent(action);
        if (action != null) {
            action.addPropertyChangeListener(this.createActionChangeListener(jMenuItem));
        }
        return this.add(jMenuItem);
    }

    public void remove(int n) {
        super.remove(n);
        this.revalidate();
    }

    public void insert(Action action, int n) {
        JMenuItem jMenuItem = new JMenuItem(action);
        this.insert(jMenuItem, n);
    }

    public void insert(Component component, int n) {
        super.add(component, n);
    }

    public static boolean getDefaultLightWeightPopupEnabled() {
        return DefaultLightWeightPopupEnabled;
    }

    public static void setDefaultLightWeightPopupEnabled(boolean bl) {
        DefaultLightWeightPopupEnabled = bl;
    }

    public PopupMenuUI getUI() {
        return (PopupMenuUI)this.ui;
    }

    public void setUI(PopupMenuUI popupMenuUI) {
        super.setUI(popupMenuUI);
    }

    public void updateUI() {
        this.setUI((PopupMenuUI)UIManager.getUI(this));
    }

    public String getUIClassID() {
        return "PopupMenuUI";
    }

    public SingleSelectionModel getSelectionModel() {
        return this.selectionModel;
    }

    public void setSelectionModel(SingleSelectionModel singleSelectionModel) {
        this.selectionModel = singleSelectionModel;
    }

    protected JMenuItem createActionComponent(Action action) {
        return new JMenuItem(action);
    }

    protected PropertyChangeListener createActionChangeListener(JMenuItem jMenuItem) {
        return new ActionChangeListener();
    }

    public boolean isLightWeightPopupEnabled() {
        return this.lightWeightPopupEnabled;
    }

    public void setLightWeightPopupEnabled(boolean bl) {
        this.lightWeightPopupEnabled = bl;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String string) {
        if (string != this.label) {
            String string2 = this.label;
            this.label = string;
            this.firePropertyChange("label", string2, string);
        }
    }

    public void addSeparator() {
        this.insert(new Separator(), -1);
    }

    public void addMenuKeyListener(MenuKeyListener menuKeyListener) {
        this.listenerList.add(MenuKeyListener.class, menuKeyListener);
    }

    public void removeMenuKeyListener(MenuKeyListener menuKeyListener) {
        this.listenerList.remove(MenuKeyListener.class, menuKeyListener);
    }

    public MenuKeyListener[] getMenuKeyListeners() {
        return (MenuKeyListener[])this.listenerList.getListeners(MenuKeyListener.class);
    }

    public void addPopupMenuListener(PopupMenuListener popupMenuListener) {
        this.listenerList.add(PopupMenuListener.class, popupMenuListener);
    }

    public void removePopupMenuListener(PopupMenuListener popupMenuListener) {
        this.listenerList.remove(PopupMenuListener.class, popupMenuListener);
    }

    public PopupMenuListener[] getPopupMenuListeners() {
        return (PopupMenuListener[])this.listenerList.getListeners(PopupMenuListener.class);
    }

    protected void firePopupMenuWillBecomeVisible() {
        EventListener[] eventListenerArray = this.listenerList.getListeners(PopupMenuListener.class);
        for (int i = 0; i < eventListenerArray.length; ++i) {
            ((PopupMenuListener)eventListenerArray[i]).popupMenuWillBecomeVisible(new PopupMenuEvent(this));
        }
    }

    protected void firePopupMenuWillBecomeInvisible() {
        EventListener[] eventListenerArray = this.listenerList.getListeners(PopupMenuListener.class);
        for (int i = 0; i < eventListenerArray.length; ++i) {
            ((PopupMenuListener)eventListenerArray[i]).popupMenuWillBecomeInvisible(new PopupMenuEvent(this));
        }
    }

    protected void firePopupMenuCanceled() {
        EventListener[] eventListenerArray = this.listenerList.getListeners(PopupMenuListener.class);
        for (int i = 0; i < eventListenerArray.length; ++i) {
            ((PopupMenuListener)eventListenerArray[i]).popupMenuCanceled(new PopupMenuEvent(this));
        }
    }

    public void pack() {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    JPopupMenu.this.show();
                }
            });
        }
        this.setSize(this.getPreferredSize());
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(final boolean bl) {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    JPopupMenu.this.setVisible(bl);
                }
            });
        }
        if (bl == this.isVisible()) {
            return;
        }
        boolean bl2 = this.isVisible();
        this.visible = bl;
        if (bl2 != this.isVisible()) {
            if (bl) {
                MenuElement[] menuElementArray;
                if (this.invoker != null && !(this.invoker instanceof JMenu)) {
                    menuElementArray = this.getSubElements().length > 0 ? new MenuElement[]{this, this.getSubElements()[0]} : new MenuElement[]{this};
                    MenuSelectionManager.defaultManager().setSelectedPath(menuElementArray);
                }
                this.firePopupMenuWillBecomeVisible();
                menuElementArray = PopupFactory.getSharedInstance();
                this.pack();
                this.popup = menuElementArray.getPopup(this.invoker, this, this.popupLocationX, this.popupLocationY);
                this.popup.show();
            } else {
                this.getSelectionModel().clearSelection();
                this.firePopupMenuWillBecomeInvisible();
                this.popup.hide();
            }
            this.firePropertyChange("visible", bl2, this.isVisible());
        }
    }

    public void setLocation(int n, int n2) {
        this.popupLocationX = n;
        this.popupLocationY = n2;
    }

    public Component getInvoker() {
        return this.invoker;
    }

    public void setInvoker(Component component) {
        this.invoker = component;
    }

    public void show(Component component, int n, int n2) {
        if (component.isShowing()) {
            this.setInvoker(component);
            Point point = new Point(n, n2);
            SwingUtilities.convertPointToScreen(point, component);
            this.setLocation(point.x, point.y);
            this.setVisible(true);
        }
    }

    public Component getComponentAtIndex(int n) {
        return this.getComponent(n);
    }

    public int getComponentIndex(Component component) {
        Component[] componentArray = this.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            if (!componentArray[i].equals(component)) continue;
            return i;
        }
        return -1;
    }

    public void setPopupSize(Dimension dimension) {
        super.setSize(dimension);
    }

    public void setPopupSize(int n, int n2) {
        super.setSize(n, n2);
    }

    public void setSelected(Component component) {
        int n = this.getComponentIndex(component);
        this.selectionModel.setSelectedIndex(n);
    }

    public boolean isBorderPainted() {
        return this.borderPainted;
    }

    public void setBorderPainted(boolean bl) {
        this.borderPainted = bl;
    }

    public Insets getMargin() {
        return this.margin;
    }

    protected String paramString() {
        CPStringBuilder cPStringBuilder = new CPStringBuilder();
        cPStringBuilder.append(super.paramString());
        cPStringBuilder.append(",label=");
        if (this.getLabel() != null) {
            cPStringBuilder.append(this.getLabel());
        }
        cPStringBuilder.append(",lightWeightPopupEnabled=").append(this.isLightWeightPopupEnabled());
        cPStringBuilder.append(",margin=");
        if (this.getMargin() != null) {
            cPStringBuilder.append(this.margin);
        }
        cPStringBuilder.append(",paintBorder=").append(this.isBorderPainted());
        return cPStringBuilder.toString();
    }

    public void processMouseEvent(MouseEvent mouseEvent, MenuElement[] menuElementArray, MenuSelectionManager menuSelectionManager) {
    }

    public void processKeyEvent(KeyEvent keyEvent, MenuElement[] menuElementArray, MenuSelectionManager menuSelectionManager) {
    }

    public void menuSelectionChanged(boolean bl) {
        if (this.invoker instanceof JMenu) {
            JMenu jMenu = (JMenu)this.invoker;
            jMenu.setPopupMenuVisible(bl);
        } else if (!bl) {
            this.setVisible(false);
        }
    }

    public MenuElement[] getSubElements() {
        Component[] componentArray = this.getComponents();
        ArrayList<Component> arrayList = new ArrayList<Component>();
        for (int i = 0; i < componentArray.length; ++i) {
            if (!(componentArray[i] instanceof MenuElement)) continue;
            arrayList.add(componentArray[i]);
        }
        return arrayList.toArray(new MenuElement[arrayList.size()]);
    }

    public Component getComponent() {
        return this;
    }

    public boolean isPopupTrigger(MouseEvent mouseEvent) {
        return this.getUI().isPopupTrigger(mouseEvent);
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleJPopupMenu();
        }
        return this.accessibleContext;
    }

    boolean onTop() {
        return true;
    }

    private class ActionChangeListener
    implements PropertyChangeListener {
        private ActionChangeListener() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        }
    }

    protected class AccessibleJPopupMenu
    extends JComponent.AccessibleJComponent {
        private static final long serialVersionUID = 7423261328879849768L;

        protected AccessibleJPopupMenu() {
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.POPUP_MENU;
        }
    }

    public static class Separator
    extends JSeparator {
        public String getUIClassID() {
            return "PopupMenuSeparatorUI";
        }
    }
}

