/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.AWTEvent;
import java.awt.ActiveEvent;
import java.awt.Component;
import java.awt.Container;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.MenuComponent;
import java.awt.Toolkit;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseMotionAdapter;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JDesktopPane;
import javax.swing.JDialog;
import javax.swing.JInternalFrame;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.OptionPaneUI;

public class JOptionPane
extends JComponent
implements Accessible {
    private static final long serialVersionUID = 5231143276678566796L;
    public static final int CANCEL_OPTION = 2;
    public static final int CLOSED_OPTION = -1;
    public static final int DEFAULT_OPTION = -1;
    public static final int NO_OPTION = 1;
    public static final int OK_CANCEL_OPTION = 2;
    public static final int OK_OPTION = 0;
    public static final int YES_NO_CANCEL_OPTION = 1;
    public static final int YES_NO_OPTION = 0;
    public static final int YES_OPTION = 0;
    public static final int ERROR_MESSAGE = 0;
    public static final int INFORMATION_MESSAGE = 1;
    public static final int PLAIN_MESSAGE = -1;
    public static final int QUESTION_MESSAGE = 3;
    public static final int WARNING_MESSAGE = 2;
    public static final String ICON_PROPERTY = "icon";
    public static final String INITIAL_SELECTION_VALUE_PROPERTY = "initialSelectionValue";
    public static final String INITIAL_VALUE_PROPERTY = "initialValue";
    public static final String INPUT_VALUE_PROPERTY = "inputValue";
    public static final String MESSAGE_PROPERTY = "message";
    public static final String MESSAGE_TYPE_PROPERTY = "messageType";
    public static final String OPTION_TYPE_PROPERTY = "optionType";
    public static final String OPTIONS_PROPERTY = "options";
    public static final String SELECTION_VALUES_PROPERTY = "selectionValues";
    public static final String VALUE_PROPERTY = "value";
    public static final String WANTS_INPUT_PROPERTY = "wantsInput";
    public static final Object UNINITIALIZED_VALUE = "uninitializedValue";
    protected Icon icon;
    protected Object initialSelectionValue;
    protected Object initialValue;
    protected Object inputValue = UNINITIALIZED_VALUE;
    protected Object message;
    protected int messageType = -1;
    protected Object[] options;
    protected int optionType = -1;
    protected Object[] selectionValues;
    protected Object value = UNINITIALIZED_VALUE;
    protected boolean wantsInput;
    private static Frame privFrame = (Frame)SwingUtilities.getOwnerFrame(null);

    public JOptionPane() {
        this("JOptionPane message", -1, -1, null, null, null);
    }

    public JOptionPane(Object object) {
        this(object, -1, -1, null, null, null);
    }

    public JOptionPane(Object object, int n) {
        this(object, n, -1, null, null, null);
    }

    public JOptionPane(Object object, int n, int n2) {
        this(object, n, n2, null, null, null);
    }

    public JOptionPane(Object object, int n, int n2, Icon icon) {
        this(object, n, n2, icon, null, null);
    }

    public JOptionPane(Object object, int n, int n2, Icon icon, Object[] objectArray) {
        this(object, n, n2, icon, objectArray, null);
    }

    public JOptionPane(Object object, int n, int n2, Icon icon, Object[] objectArray, Object object2) {
        this.message = object;
        if (!this.validMessageType(n)) {
            throw new IllegalArgumentException("Message Type not legal value.");
        }
        this.messageType = n;
        if (!this.validOptionType(n2)) {
            throw new IllegalArgumentException("Option Type not legal value.");
        }
        this.optionType = n2;
        this.icon = icon;
        this.options = objectArray;
        this.initialValue = object2;
        this.setLayout(new BoxLayout(this, 1));
        this.updateUI();
    }

    public JDialog createDialog(Component component, String string) {
        Frame frame = JOptionPane.getFrameForComponent(component);
        if (frame == null) {
            frame = JOptionPane.getRootFrame();
        }
        JDialog jDialog = new JDialog(frame, string);
        this.inputValue = UNINITIALIZED_VALUE;
        this.value = UNINITIALIZED_VALUE;
        jDialog.getContentPane().add(this);
        jDialog.setModal(true);
        jDialog.setResizable(false);
        jDialog.pack();
        jDialog.setLocationRelativeTo(component);
        this.addPropertyChangeListener(new ValuePropertyHandler(jDialog));
        return jDialog;
    }

    public JInternalFrame createInternalFrame(Component component, String string) throws RuntimeException {
        JLayeredPane jLayeredPane = JOptionPane.getDesktopPaneForComponent(component);
        if (jLayeredPane == null) {
            jLayeredPane = JLayeredPane.getLayeredPaneAbove(component);
        }
        if (jLayeredPane == null) {
            throw new RuntimeException("parentComponent does not have a valid parent");
        }
        JInternalFrame jInternalFrame = new JInternalFrame(string);
        this.inputValue = UNINITIALIZED_VALUE;
        this.value = UNINITIALIZED_VALUE;
        jInternalFrame.setContentPane(this);
        jInternalFrame.setClosable(true);
        jLayeredPane.add(jInternalFrame);
        jInternalFrame.setLayer(JLayeredPane.MODAL_LAYER);
        jInternalFrame.pack();
        jInternalFrame.setVisible(true);
        return jInternalFrame;
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleJOptionPane();
        }
        return this.accessibleContext;
    }

    public static JDesktopPane getDesktopPaneForComponent(Component component) {
        return (JDesktopPane)SwingUtilities.getAncestorOfClass(JDesktopPane.class, component);
    }

    public static Frame getFrameForComponent(Component component) {
        return (Frame)SwingUtilities.getAncestorOfClass(Frame.class, component);
    }

    public Icon getIcon() {
        return this.icon;
    }

    public Object getInitialSelectionValue() {
        return this.initialSelectionValue;
    }

    public Object getInitialValue() {
        return this.initialValue;
    }

    public Object getInputValue() {
        if (this.getValue().equals(new Integer(2))) {
            this.setInputValue(null);
        }
        return this.inputValue;
    }

    public int getMaxCharactersPerLineCount() {
        return Integer.MAX_VALUE;
    }

    public Object getMessage() {
        return this.message;
    }

    public int getMessageType() {
        return this.messageType;
    }

    public Object[] getOptions() {
        return this.options;
    }

    public int getOptionType() {
        return this.optionType;
    }

    public static Frame getRootFrame() {
        return privFrame;
    }

    public Object[] getSelectionValues() {
        return this.selectionValues;
    }

    public OptionPaneUI getUI() {
        return (OptionPaneUI)this.ui;
    }

    public String getUIClassID() {
        return "OptionPaneUI";
    }

    public Object getValue() {
        return this.value;
    }

    public boolean getWantsInput() {
        return this.wantsInput;
    }

    protected String paramString() {
        return "JOptionPane";
    }

    public void selectInitialValue() {
        if (this.ui != null) {
            ((OptionPaneUI)this.ui).selectInitialValue(this);
        }
    }

    public void setIcon(Icon icon) {
        if (this.icon != icon) {
            Icon icon2 = this.icon;
            this.icon = icon;
            this.firePropertyChange(ICON_PROPERTY, icon2, this.icon);
        }
    }

    public void setInitialSelectionValue(Object object) {
        if (this.initialSelectionValue != object) {
            Object object2 = this.initialSelectionValue;
            this.initialSelectionValue = object;
            this.firePropertyChange(INITIAL_SELECTION_VALUE_PROPERTY, object2, this.initialSelectionValue);
        }
    }

    public void setInitialValue(Object object) {
        if (this.initialValue != object) {
            Object object2 = this.initialValue;
            this.initialValue = object;
            this.firePropertyChange(INITIAL_VALUE_PROPERTY, object2, this.initialValue);
        }
    }

    public void setInputValue(Object object) {
        if (this.inputValue != object) {
            Object object2 = this.inputValue;
            this.inputValue = object;
            this.firePropertyChange(INPUT_VALUE_PROPERTY, object2, this.inputValue);
        }
    }

    public void setMessage(Object object) {
        if (this.message != object) {
            Object object2 = this.message;
            this.message = object;
            this.firePropertyChange(MESSAGE_PROPERTY, object2, this.message);
        }
    }

    public void setMessageType(int n) {
        if (!this.validMessageType(n)) {
            throw new IllegalArgumentException("Message Type not legal value.");
        }
        if (n != this.messageType) {
            int n2 = this.messageType;
            this.messageType = n;
            this.firePropertyChange(MESSAGE_TYPE_PROPERTY, n2, this.messageType);
        }
    }

    public void setOptions(Object[] objectArray) {
        if (this.options != objectArray) {
            Object[] objectArray2 = this.options;
            this.options = objectArray;
            this.firePropertyChange(OPTIONS_PROPERTY, objectArray2, this.options);
        }
    }

    public void setOptionType(int n) {
        if (!this.validOptionType(n)) {
            throw new IllegalArgumentException("Option Type not legal value.");
        }
        if (n != this.optionType) {
            int n2 = this.optionType;
            this.optionType = n;
            this.firePropertyChange(OPTION_TYPE_PROPERTY, n2, this.optionType);
        }
    }

    public static void setRootFrame(Frame frame) {
        privFrame = frame;
    }

    public void setSelectionValues(Object[] objectArray) {
        if (objectArray != this.selectionValues) {
            if (objectArray != null) {
                this.wantsInput = true;
            }
            Object[] objectArray2 = this.selectionValues;
            this.selectionValues = objectArray;
            this.firePropertyChange(SELECTION_VALUES_PROPERTY, objectArray2, this.selectionValues);
        }
    }

    public void setUI(OptionPaneUI optionPaneUI) {
        super.setUI(optionPaneUI);
    }

    public void setValue(Object object) {
        if (this.value != object) {
            Object object2 = this.value;
            this.value = object;
            this.firePropertyChange(VALUE_PROPERTY, object2, this.value);
        }
    }

    public void setWantsInput(boolean bl) {
        if (this.wantsInput != bl) {
            boolean bl2 = this.wantsInput;
            this.wantsInput = bl;
            this.firePropertyChange(WANTS_INPUT_PROPERTY, bl2, this.wantsInput);
        }
    }

    public static int showConfirmDialog(Component component, Object object) {
        JOptionPane jOptionPane = new JOptionPane(object, 3);
        JDialog jDialog = jOptionPane.createDialog(component, "Select an Option");
        jDialog.show();
        if (jOptionPane.getValue() instanceof Integer) {
            return (Integer)jOptionPane.getValue();
        }
        return -1;
    }

    public static int showConfirmDialog(Component component, Object object, String string, int n) {
        JOptionPane jOptionPane = new JOptionPane(object, -1, n);
        JDialog jDialog = jOptionPane.createDialog(component, string);
        jDialog.show();
        if (jOptionPane.getValue() instanceof Integer) {
            return (Integer)jOptionPane.getValue();
        }
        return -1;
    }

    public static int showConfirmDialog(Component component, Object object, String string, int n, int n2) {
        JOptionPane jOptionPane = new JOptionPane(object, n2, n);
        JDialog jDialog = jOptionPane.createDialog(component, string);
        jDialog.show();
        if (jOptionPane.getValue() instanceof Integer) {
            return (Integer)jOptionPane.getValue();
        }
        return -1;
    }

    public static int showConfirmDialog(Component component, Object object, String string, int n, int n2, Icon icon) {
        JOptionPane jOptionPane = new JOptionPane(object, n2, n, icon);
        JDialog jDialog = jOptionPane.createDialog(component, string);
        jDialog.show();
        if (jOptionPane.getValue() instanceof Integer) {
            return (Integer)jOptionPane.getValue();
        }
        return -1;
    }

    public static String showInputDialog(Component component, Object object) {
        JOptionPane jOptionPane = new JOptionPane(object, 3);
        jOptionPane.setWantsInput(true);
        JDialog jDialog = jOptionPane.createDialog(component, null);
        jDialog.show();
        return (String)jOptionPane.getInputValue();
    }

    public static String showInputDialog(Component component, Object object, Object object2) {
        JOptionPane jOptionPane = new JOptionPane(object, 3);
        jOptionPane.setInitialSelectionValue(object2);
        jOptionPane.setWantsInput(true);
        JDialog jDialog = jOptionPane.createDialog(component, null);
        jDialog.show();
        return (String)jOptionPane.getInputValue();
    }

    public static String showInputDialog(Component component, Object object, String string, int n) {
        JOptionPane jOptionPane = new JOptionPane(object, n);
        jOptionPane.setWantsInput(true);
        JDialog jDialog = jOptionPane.createDialog(component, string);
        jDialog.show();
        return (String)jOptionPane.getInputValue();
    }

    public static Object showInputDialog(Component component, Object object, String string, int n, Icon icon, Object[] objectArray, Object object2) {
        JOptionPane jOptionPane = new JOptionPane(object, n);
        jOptionPane.setWantsInput(true);
        jOptionPane.setIcon(icon);
        jOptionPane.setSelectionValues(objectArray);
        jOptionPane.setInitialSelectionValue(object2);
        JDialog jDialog = jOptionPane.createDialog(component, string);
        jDialog.show();
        return jOptionPane.getInputValue();
    }

    public static String showInputDialog(Object object) {
        JOptionPane jOptionPane = new JOptionPane(object, 3);
        jOptionPane.setWantsInput(true);
        JDialog jDialog = jOptionPane.createDialog(null, null);
        jDialog.show();
        return (String)jOptionPane.getInputValue();
    }

    public static String showInputDialog(Object object, Object object2) {
        JOptionPane jOptionPane = new JOptionPane(object, 3);
        jOptionPane.setWantsInput(true);
        jOptionPane.setInitialSelectionValue(object2);
        JDialog jDialog = jOptionPane.createDialog(null, null);
        jDialog.show();
        return (String)jOptionPane.getInputValue();
    }

    public static int showInternalConfirmDialog(Component component, Object object) {
        JOptionPane jOptionPane = new JOptionPane(object);
        JInternalFrame jInternalFrame = jOptionPane.createInternalFrame(component, null);
        JOptionPane.startModal(jInternalFrame);
        if (jOptionPane.getValue() instanceof Integer) {
            return (Integer)jOptionPane.getValue();
        }
        return -1;
    }

    public static int showInternalConfirmDialog(Component component, Object object, String string, int n) {
        JOptionPane jOptionPane = new JOptionPane(object, -1, n);
        JInternalFrame jInternalFrame = jOptionPane.createInternalFrame(component, string);
        JOptionPane.startModal(jInternalFrame);
        if (jOptionPane.getValue() instanceof Integer) {
            return (Integer)jOptionPane.getValue();
        }
        return -1;
    }

    public static int showInternalConfirmDialog(Component component, Object object, String string, int n, int n2) {
        JOptionPane jOptionPane = new JOptionPane(object, n2, n);
        JInternalFrame jInternalFrame = jOptionPane.createInternalFrame(component, string);
        JOptionPane.startModal(jInternalFrame);
        if (jOptionPane.getValue() instanceof Integer) {
            return (Integer)jOptionPane.getValue();
        }
        return -1;
    }

    public static int showInternalConfirmDialog(Component component, Object object, String string, int n, int n2, Icon icon) {
        JOptionPane jOptionPane = new JOptionPane(object, n2, n, icon);
        JInternalFrame jInternalFrame = jOptionPane.createInternalFrame(component, string);
        JOptionPane.startModal(jInternalFrame);
        if (jOptionPane.getValue() instanceof Integer) {
            return (Integer)jOptionPane.getValue();
        }
        return -1;
    }

    public static String showInternalInputDialog(Component component, Object object) {
        JOptionPane jOptionPane = new JOptionPane(object);
        jOptionPane.setWantsInput(true);
        JInternalFrame jInternalFrame = jOptionPane.createInternalFrame(component, null);
        JOptionPane.startModal(jInternalFrame);
        return (String)jOptionPane.getInputValue();
    }

    public static String showInternalInputDialog(Component component, Object object, String string, int n) {
        JOptionPane jOptionPane = new JOptionPane(object, n);
        jOptionPane.setWantsInput(true);
        JInternalFrame jInternalFrame = jOptionPane.createInternalFrame(component, string);
        JOptionPane.startModal(jInternalFrame);
        return (String)jOptionPane.getInputValue();
    }

    public static Object showInternalInputDialog(Component component, Object object, String string, int n, Icon icon, Object[] objectArray, Object object2) {
        JOptionPane jOptionPane = new JOptionPane(object, n);
        jOptionPane.setWantsInput(true);
        jOptionPane.setIcon(icon);
        jOptionPane.setSelectionValues(objectArray);
        jOptionPane.setInitialSelectionValue(object2);
        JInternalFrame jInternalFrame = jOptionPane.createInternalFrame(component, string);
        JOptionPane.startModal(jInternalFrame);
        return jOptionPane.getInputValue();
    }

    public static void showInternalMessageDialog(Component component, Object object) {
        JOptionPane jOptionPane = new JOptionPane(object);
        JInternalFrame jInternalFrame = jOptionPane.createInternalFrame(component, null);
        JOptionPane.startModal(jInternalFrame);
    }

    public static void showInternalMessageDialog(Component component, Object object, String string, int n) {
        JOptionPane jOptionPane = new JOptionPane(object, n);
        JInternalFrame jInternalFrame = jOptionPane.createInternalFrame(component, string);
        JOptionPane.startModal(jInternalFrame);
    }

    public static void showInternalMessageDialog(Component component, Object object, String string, int n, Icon icon) {
        JOptionPane jOptionPane = new JOptionPane(object, n);
        jOptionPane.setIcon(icon);
        JInternalFrame jInternalFrame = jOptionPane.createInternalFrame(component, string);
        JOptionPane.startModal(jInternalFrame);
    }

    public static int showInternalOptionDialog(Component component, Object object, String string, int n, int n2, Icon icon, Object[] objectArray, Object object2) {
        JOptionPane jOptionPane = new JOptionPane(object, n2, n, icon, objectArray, object2);
        JInternalFrame jInternalFrame = jOptionPane.createInternalFrame(component, string);
        JOptionPane.startModal(jInternalFrame);
        if (jOptionPane.getValue() instanceof Integer) {
            return (Integer)jOptionPane.getValue();
        }
        return -1;
    }

    public static void showMessageDialog(Component component, Object object) {
        JOptionPane jOptionPane = new JOptionPane(object, 1);
        JDialog jDialog = jOptionPane.createDialog(component, null);
        jDialog.show();
    }

    public static void showMessageDialog(Component component, Object object, String string, int n) {
        JOptionPane jOptionPane = new JOptionPane(object, n);
        JDialog jDialog = jOptionPane.createDialog(component, string);
        jDialog.show();
    }

    public static void showMessageDialog(Component component, Object object, String string, int n, Icon icon) {
        JOptionPane jOptionPane = new JOptionPane(object, n);
        jOptionPane.setIcon(icon);
        JDialog jDialog = jOptionPane.createDialog(component, string);
        jDialog.show();
    }

    public static int showOptionDialog(Component component, Object object, String string, int n, int n2, Icon icon, Object[] objectArray, Object object2) {
        JOptionPane jOptionPane = new JOptionPane(object, n2, n, icon, objectArray, object2);
        JDialog jDialog = jOptionPane.createDialog(component, string);
        jDialog.show();
        if (jOptionPane.getValue() instanceof Integer) {
            return (Integer)jOptionPane.getValue();
        }
        return -1;
    }

    public void updateUI() {
        this.setUI((OptionPaneUI)UIManager.getUI(this));
    }

    private boolean validMessageType(int n) {
        switch (n) {
            case -1: 
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                return true;
            }
        }
        return false;
    }

    private boolean validOptionType(int n) {
        switch (n) {
            case -1: 
            case 0: 
            case 1: 
            case 2: {
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void startModal(JInternalFrame jInternalFrame) {
        JPanel jPanel = new JPanel();
        jPanel.setOpaque(false);
        JLayeredPane jLayeredPane = JLayeredPane.getLayeredPaneAbove(jInternalFrame);
        jLayeredPane.setLayer(jPanel, JLayeredPane.MODAL_LAYER);
        jPanel.setBounds(0, 0, jLayeredPane.getWidth(), jLayeredPane.getHeight());
        jPanel.addMouseListener(new MouseAdapter(){});
        jPanel.addMouseMotionListener(new MouseMotionAdapter(){});
        jLayeredPane.add(jPanel);
        jInternalFrame.toFront();
        EventQueue eventQueue = Toolkit.getDefaultToolkit().getSystemEventQueue();
        try {
            try {}
            catch (InterruptedException interruptedException) {
                Object var6_7 = null;
                jLayeredPane.remove(jPanel);
                Container container2 = jInternalFrame.getParent();
                if (container2 == null) return;
                container2.remove(jInternalFrame);
                return;
            }
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            jLayeredPane.remove(jPanel);
            Container container = jInternalFrame.getParent();
            if (container == null) throw throwable;
            container.remove(jInternalFrame);
            throw throwable;
        }
        while (!jInternalFrame.isClosed()) {
            if (EventQueue.isDispatchThread()) {
                AWTEvent aWTEvent = eventQueue.getNextEvent();
                if (aWTEvent instanceof ActiveEvent) {
                    ((ActiveEvent)((Object)aWTEvent)).dispatch();
                    continue;
                }
                if (aWTEvent.getSource() instanceof Component) {
                    ((Component)aWTEvent.getSource()).dispatchEvent(aWTEvent);
                    continue;
                }
                if (!(aWTEvent.getSource() instanceof MenuComponent)) continue;
                ((MenuComponent)aWTEvent.getSource()).dispatchEvent(aWTEvent);
                continue;
            }
            Thread.yield();
        }
        Object var6_6 = null;
        jLayeredPane.remove(jPanel);
        Container container = jInternalFrame.getParent();
        if (container == null) return;
        container.remove(jInternalFrame);
    }

    private static class ValuePropertyHandler
    implements PropertyChangeListener {
        JDialog dialog;

        ValuePropertyHandler(JDialog jDialog) {
            this.dialog = jDialog;
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            Object object = propertyChangeEvent.getNewValue();
            if (string.equals(JOptionPane.VALUE_PROPERTY) && object != null && object != UNINITIALIZED_VALUE) {
                this.dialog.setVisible(false);
            }
        }
    }

    protected class AccessibleJOptionPane
    extends JComponent.AccessibleJComponent {
        private static final long serialVersionUID = 686071432213084821L;

        protected AccessibleJOptionPane() {
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.OPTION_PANE;
        }
    }
}

