/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.Component;
import java.awt.Container;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.EventListener;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleState;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ButtonModel;
import javax.swing.DefaultButtonModel;
import javax.swing.Icon;
import javax.swing.JInternalFrame;
import javax.swing.JMenu;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.MenuDragMouseEvent;
import javax.swing.event.MenuDragMouseListener;
import javax.swing.event.MenuKeyEvent;
import javax.swing.event.MenuKeyListener;
import javax.swing.plaf.MenuItemUI;

public class JMenuItem
extends AbstractButton
implements Accessible,
MenuElement {
    private static final long serialVersionUID = -1681004643499461044L;
    private KeyStroke accelerator;
    private boolean isDragging;

    public JMenuItem() {
        this(null, null);
    }

    public JMenuItem(Icon icon) {
        this(null, icon);
    }

    public JMenuItem(String string) {
        this(string, null);
    }

    public JMenuItem(Action action) {
        super.setAction(action);
        this.setModel(new DefaultButtonModel());
        this.init(null, null);
        if (action != null) {
            String string;
            Integer n;
            KeyStroke keyStroke;
            String string2 = (String)action.getValue("Name");
            if (string2 != null) {
                this.setName(string2);
            }
            if ((keyStroke = (KeyStroke)action.getValue("AcceleratorKey")) != null) {
                this.setAccelerator(keyStroke);
            }
            if ((n = (Integer)action.getValue("MnemonicKey")) != null) {
                this.setMnemonic(n);
            }
            if ((string = (String)action.getValue("ActionCommandKey")) != null) {
                this.setActionCommand(string);
            }
        }
    }

    public JMenuItem(String string, Icon icon) {
        this.setModel(new DefaultButtonModel());
        this.init(string, icon);
    }

    public JMenuItem(String string, int n) {
        this(string, null);
        this.setMnemonic(n);
    }

    protected void init(String string, Icon icon) {
        super.init(string, icon);
        this.focusPainted = false;
        this.horizontalAlignment = 10;
        this.horizontalTextPosition = 11;
    }

    public void setUI(MenuItemUI menuItemUI) {
        super.setUI(menuItemUI);
    }

    public void updateUI() {
        this.setUI((MenuItemUI)UIManager.getUI(this));
    }

    public String getUIClassID() {
        return "MenuItemUI";
    }

    public boolean isArmed() {
        return this.getModel().isArmed();
    }

    public void setArmed(boolean bl) {
        this.getModel().setArmed(bl);
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
    }

    public KeyStroke getAccelerator() {
        return this.accelerator;
    }

    public void setAccelerator(KeyStroke keyStroke) {
        KeyStroke keyStroke2 = this.accelerator;
        this.accelerator = keyStroke;
        this.firePropertyChange("accelerator", keyStroke2, keyStroke);
    }

    protected void configurePropertiesFromAction(Action action) {
        super.configurePropertiesFromAction(action);
        if (!(this instanceof JMenu) && action != null) {
            this.setAccelerator((KeyStroke)action.getValue("AcceleratorKey"));
            if (this.accelerator != null) {
                super.registerKeyboardAction(action, this.accelerator, 2);
            }
        }
    }

    protected PropertyChangeListener createActionPropertyChangeListener(Action action) {
        return new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                Action action = (Action)propertyChangeEvent.getSource();
                JMenuItem.this.configurePropertiesFromAction(action);
            }
        };
    }

    public void processMouseEvent(MouseEvent mouseEvent, MenuElement[] menuElementArray, MenuSelectionManager menuSelectionManager) {
        MenuDragMouseEvent menuDragMouseEvent = new MenuDragMouseEvent(mouseEvent.getComponent(), mouseEvent.getID(), mouseEvent.getWhen(), mouseEvent.getModifiers(), mouseEvent.getX(), mouseEvent.getY(), mouseEvent.getClickCount(), mouseEvent.isPopupTrigger(), menuElementArray, menuSelectionManager);
        this.processMenuDragMouseEvent(menuDragMouseEvent);
    }

    public void processKeyEvent(KeyEvent keyEvent, MenuElement[] menuElementArray, MenuSelectionManager menuSelectionManager) {
        MenuKeyEvent menuKeyEvent = new MenuKeyEvent(keyEvent.getComponent(), keyEvent.getID(), keyEvent.getWhen(), keyEvent.getModifiers(), keyEvent.getKeyCode(), keyEvent.getKeyChar(), menuElementArray, menuSelectionManager);
        this.processMenuKeyEvent(menuKeyEvent);
        if (menuKeyEvent.isConsumed()) {
            keyEvent.consume();
        }
    }

    public void processMenuDragMouseEvent(MenuDragMouseEvent menuDragMouseEvent) {
        switch (menuDragMouseEvent.getID()) {
            case 504: {
                this.isDragging = false;
                this.fireMenuDragMouseEntered(menuDragMouseEvent);
                break;
            }
            case 505: {
                this.isDragging = false;
                this.fireMenuDragMouseExited(menuDragMouseEvent);
                break;
            }
            case 506: {
                this.isDragging = true;
                this.fireMenuDragMouseDragged(menuDragMouseEvent);
                break;
            }
            case 502: {
                if (!this.isDragging) break;
                this.fireMenuDragMouseReleased(menuDragMouseEvent);
            }
        }
    }

    public void processMenuKeyEvent(MenuKeyEvent menuKeyEvent) {
        switch (menuKeyEvent.getID()) {
            case 401: {
                this.fireMenuKeyPressed(menuKeyEvent);
                break;
            }
            case 402: {
                this.fireMenuKeyReleased(menuKeyEvent);
                break;
            }
            case 400: {
                this.fireMenuKeyTyped(menuKeyEvent);
                break;
            }
        }
    }

    protected void fireMenuDragMouseEntered(MenuDragMouseEvent menuDragMouseEvent) {
        EventListener[] eventListenerArray = this.listenerList.getListeners(MenuDragMouseListener.class);
        for (int i = 0; i < eventListenerArray.length; ++i) {
            ((MenuDragMouseListener)eventListenerArray[i]).menuDragMouseEntered(menuDragMouseEvent);
        }
    }

    protected void fireMenuDragMouseExited(MenuDragMouseEvent menuDragMouseEvent) {
        EventListener[] eventListenerArray = this.listenerList.getListeners(MenuDragMouseListener.class);
        for (int i = 0; i < eventListenerArray.length; ++i) {
            ((MenuDragMouseListener)eventListenerArray[i]).menuDragMouseExited(menuDragMouseEvent);
        }
    }

    protected void fireMenuDragMouseDragged(MenuDragMouseEvent menuDragMouseEvent) {
        EventListener[] eventListenerArray = this.listenerList.getListeners(MenuDragMouseListener.class);
        for (int i = 0; i < eventListenerArray.length; ++i) {
            ((MenuDragMouseListener)eventListenerArray[i]).menuDragMouseDragged(menuDragMouseEvent);
        }
    }

    protected void fireMenuDragMouseReleased(MenuDragMouseEvent menuDragMouseEvent) {
        EventListener[] eventListenerArray = this.listenerList.getListeners(MenuDragMouseListener.class);
        for (int i = 0; i < eventListenerArray.length; ++i) {
            ((MenuDragMouseListener)eventListenerArray[i]).menuDragMouseReleased(menuDragMouseEvent);
        }
    }

    protected void fireMenuKeyPressed(MenuKeyEvent menuKeyEvent) {
        EventListener[] eventListenerArray = this.listenerList.getListeners(MenuKeyListener.class);
        for (int i = 0; i < eventListenerArray.length; ++i) {
            ((MenuKeyListener)eventListenerArray[i]).menuKeyPressed(menuKeyEvent);
        }
    }

    protected void fireMenuKeyReleased(MenuKeyEvent menuKeyEvent) {
        EventListener[] eventListenerArray = this.listenerList.getListeners(MenuKeyListener.class);
        for (int i = 0; i < eventListenerArray.length; ++i) {
            ((MenuKeyListener)eventListenerArray[i]).menuKeyTyped(menuKeyEvent);
        }
    }

    protected void fireMenuKeyTyped(MenuKeyEvent menuKeyEvent) {
        EventListener[] eventListenerArray = this.listenerList.getListeners(MenuKeyListener.class);
        for (int i = 0; i < eventListenerArray.length; ++i) {
            ((MenuKeyListener)eventListenerArray[i]).menuKeyTyped(menuKeyEvent);
        }
    }

    public void menuSelectionChanged(boolean bl) {
        Container container = this.getParent();
        if (bl) {
            this.model.setArmed(true);
            if (container != null && container instanceof JPopupMenu) {
                ((JPopupMenu)container).setSelected(this);
            }
        } else {
            this.model.setArmed(false);
            if (container != null && container instanceof JPopupMenu) {
                ((JPopupMenu)container).getSelectionModel().clearSelection();
            }
        }
    }

    public MenuElement[] getSubElements() {
        return new MenuElement[0];
    }

    public Component getComponent() {
        return this;
    }

    public void addMenuDragMouseListener(MenuDragMouseListener menuDragMouseListener) {
        this.listenerList.add(MenuDragMouseListener.class, menuDragMouseListener);
    }

    public void removeMenuDragMouseListener(MenuDragMouseListener menuDragMouseListener) {
        this.listenerList.remove(MenuDragMouseListener.class, menuDragMouseListener);
    }

    public MenuDragMouseListener[] getMenuDragMouseListeners() {
        return (MenuDragMouseListener[])this.listenerList.getListeners(MenuDragMouseListener.class);
    }

    public void addMenuKeyListener(MenuKeyListener menuKeyListener) {
        this.listenerList.add(MenuKeyListener.class, menuKeyListener);
    }

    public void removeMenuKeyListener(MenuKeyListener menuKeyListener) {
        this.listenerList.remove(MenuKeyListener.class, menuKeyListener);
    }

    public MenuKeyListener[] getMenuKeyListeners() {
        return (MenuKeyListener[])this.listenerList.getListeners(MenuKeyListener.class);
    }

    protected String paramString() {
        return super.paramString();
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            AccessibleJMenuItem accessibleJMenuItem = new AccessibleJMenuItem();
            this.addChangeListener(accessibleJMenuItem);
            this.accessibleContext = accessibleJMenuItem;
        }
        return this.accessibleContext;
    }

    boolean onTop() {
        return SwingUtilities.getAncestorOfClass(JInternalFrame.class, this) == null;
    }

    protected class AccessibleJMenuItem
    extends AbstractButton.AccessibleAbstractButton
    implements ChangeListener {
        private static final long serialVersionUID = 6748924232082076534L;
        private boolean armed;
        private boolean focusOwner;
        private boolean pressed;
        private boolean selected;

        AccessibleJMenuItem() {
        }

        public void stateChanged(ChangeEvent changeEvent) {
            this.firePropertyChange("AccessibleVisibleData", Boolean.FALSE, Boolean.TRUE);
            ButtonModel buttonModel = JMenuItem.this.getModel();
            if (buttonModel.isArmed()) {
                if (!this.armed) {
                    this.armed = true;
                    this.firePropertyChange("AccessibleState", AccessibleState.ARMED, null);
                }
            } else if (this.armed) {
                this.armed = false;
                this.firePropertyChange("AccessibleState", null, AccessibleState.ARMED);
            }
            if (buttonModel.isPressed()) {
                if (!this.pressed) {
                    this.pressed = true;
                    this.firePropertyChange("AccessibleState", AccessibleState.PRESSED, null);
                }
            } else if (this.pressed) {
                this.pressed = false;
                this.firePropertyChange("AccessibleState", null, AccessibleState.PRESSED);
            }
            if (buttonModel.isSelected()) {
                if (!this.selected) {
                    this.selected = true;
                    this.firePropertyChange("AccessibleState", AccessibleState.SELECTED, null);
                }
            } else if (this.selected) {
                this.selected = false;
                this.firePropertyChange("AccessibleState", null, AccessibleState.SELECTED);
            }
            if (JMenuItem.this.isFocusOwner()) {
                if (!this.focusOwner) {
                    this.focusOwner = true;
                    this.firePropertyChange("AccessibleState", AccessibleState.FOCUSED, null);
                }
            } else if (this.focusOwner) {
                this.focusOwner = false;
                this.firePropertyChange("AccessibleState", null, AccessibleState.FOCUSED);
            }
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.MENU_ITEM;
        }
    }
}

