/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.EventListener;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleSelection;
import javax.swing.Action;
import javax.swing.ButtonModel;
import javax.swing.JComponent;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import javax.swing.plaf.MenuItemUI;

public class JMenu
extends JMenuItem
implements Accessible,
MenuElement {
    private static final long serialVersionUID = 4227225638931828014L;
    private JPopupMenu popupMenu = null;
    private MenuEvent menuEvent = new MenuEvent(this);
    private int delay;
    protected WinListener popupListener;
    private Point menuLocation;
    private ChangeListener menuChangeListener;

    public JMenu() {
        this.setOpaque(false);
    }

    public JMenu(String string) {
        super(string);
        this.popupMenu = new JPopupMenu();
        this.popupMenu.setInvoker(this);
        this.setOpaque(false);
    }

    public JMenu(Action action) {
        super(action);
        this.createActionChangeListener(this);
        this.popupMenu = new JPopupMenu();
        this.popupMenu.setInvoker(this);
        this.setOpaque(false);
    }

    public JMenu(String string, boolean bl) {
        this(string);
    }

    public JMenuItem add(JMenuItem jMenuItem) {
        return this.getPopupMenu().add(jMenuItem);
    }

    public Component add(Component component) {
        this.getPopupMenu().insert(component, -1);
        return component;
    }

    public Component add(Component component, int n) {
        return this.getPopupMenu().add(component, n);
    }

    public JMenuItem add(String string) {
        return this.add(new JMenuItem(string));
    }

    public JMenuItem add(Action action) {
        JMenuItem jMenuItem = this.createActionComponent(action);
        jMenuItem.setAction(action);
        this.add(jMenuItem);
        return jMenuItem;
    }

    public void remove(JMenuItem jMenuItem) {
        this.getPopupMenu().remove(jMenuItem);
    }

    public void remove(int n) {
        if (n < 0 || n > 0 && this.getMenuComponentCount() == 0) {
            throw new IllegalArgumentException();
        }
        if (this.getMenuComponentCount() > 0) {
            this.popupMenu.remove(n);
        }
    }

    public void remove(Component component) {
        int n = this.getPopupMenu().getComponentIndex(component);
        if (n >= 0) {
            this.getPopupMenu().remove(n);
        }
    }

    public void removeAll() {
        if (this.popupMenu != null) {
            this.popupMenu.removeAll();
        }
    }

    public void insert(String string, int n) {
        this.insert(new JMenuItem(string), n);
    }

    public JMenuItem insert(JMenuItem jMenuItem, int n) {
        if (n < 0) {
            throw new IllegalArgumentException("index less than zero");
        }
        this.getPopupMenu().insert(jMenuItem, n);
        return jMenuItem;
    }

    public JMenuItem insert(Action action, int n) {
        JMenuItem jMenuItem = new JMenuItem(action);
        this.insert(jMenuItem, n);
        return jMenuItem;
    }

    public void updateUI() {
        this.setUI((MenuItemUI)UIManager.getUI(this));
    }

    public String getUIClassID() {
        return "MenuUI";
    }

    public void setModel(ButtonModel buttonModel) {
        ButtonModel buttonModel2 = this.getModel();
        if (buttonModel2 != null && this.menuChangeListener != null) {
            buttonModel2.removeChangeListener(this.menuChangeListener);
        }
        super.setModel(buttonModel);
        if (buttonModel != null) {
            if (this.menuChangeListener == null) {
                this.menuChangeListener = new MenuChangeListener();
            }
            buttonModel.addChangeListener(this.menuChangeListener);
        }
    }

    public boolean isSelected() {
        return super.isSelected();
    }

    public void setSelected(boolean bl) {
        ButtonModel buttonModel = this.getModel();
        if (bl != buttonModel.isSelected()) {
            buttonModel.setSelected(bl);
        }
    }

    public boolean isPopupMenuVisible() {
        return this.getPopupMenu().isVisible();
    }

    public void setPopupMenuVisible(boolean bl) {
        if (bl != this.isPopupMenuVisible() && (this.isEnabled() || !bl)) {
            if (bl && this.isShowing()) {
                Point point = this.menuLocation == null ? this.getPopupMenuOrigin() : this.menuLocation;
                this.getPopupMenu().show(this, point.x, point.y);
            } else {
                this.getPopupMenu().setVisible(false);
            }
        }
    }

    protected Point getPopupMenuOrigin() {
        Point point = this.getLocationOnScreen();
        Dimension dimension = this.getSize();
        JPopupMenu jPopupMenu = this.getPopupMenu();
        Dimension dimension2 = jPopupMenu.getSize();
        if (dimension2.width == 0 || dimension2.height == 0) {
            dimension2 = jPopupMenu.getPreferredSize();
        }
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Rectangle rectangle = new Rectangle(toolkit.getScreenSize());
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice graphicsDevice = graphicsEnvironment.getDefaultScreenDevice();
        GraphicsConfiguration graphicsConfiguration = graphicsDevice.getDefaultConfiguration();
        Insets insets = toolkit.getScreenInsets(graphicsConfiguration);
        rectangle.x -= insets.left;
        rectangle.width -= insets.left + insets.right;
        rectangle.y -= insets.top;
        rectangle.height -= insets.top + insets.bottom;
        point.x -= insets.left;
        point.y -= insets.top;
        Point point2 = new Point();
        if (this.isTopLevelMenu()) {
            int n = UIManager.getInt("Menu.menuPopupOffsetX");
            int n2 = UIManager.getInt("Menu.menuPopupOffsetY");
            if (this.getComponentOrientation().isLeftToRight()) {
                point2.x = n;
                if (point.x + point2.x + dimension2.width > rectangle.width + rectangle.width && rectangle.width - dimension.width < 2 * (point.x - rectangle.x)) {
                    point2.x = dimension.width - n - dimension2.width;
                }
            } else {
                point2.x = dimension.width - n - dimension2.width;
                if (point.x + point2.x < rectangle.x && rectangle.width - dimension.width > 2 * (point.x - rectangle.x)) {
                    point2.x = n;
                }
            }
            point2.y = dimension.height + n2;
            if (point.y + point2.y + dimension2.height >= rectangle.height && rectangle.height - dimension.height < 2 * (point.y - rectangle.y)) {
                point2.y = -n2 - dimension2.height;
            }
        } else {
            int n = UIManager.getInt("Menu.submenuPopupOffsetX");
            int n3 = UIManager.getInt("Menu.submenuPopupOffsetY");
            if (this.getComponentOrientation().isLeftToRight()) {
                point2.x = dimension.width + n;
                if (point.x + point2.x + dimension2.width >= rectangle.x + rectangle.width && rectangle.width - dimension.width < 2 * (point.x - rectangle.x)) {
                    point2.x = -n - dimension2.width;
                }
            } else {
                point2.x = -n - dimension2.width;
                if (point.x + point2.x < rectangle.x && rectangle.width - dimension.width > 2 * (point.x - rectangle.x)) {
                    point2.x = dimension.width + n;
                }
            }
            point2.y = n3;
            if (point.y + point2.y + dimension2.height >= rectangle.y + rectangle.height && rectangle.height - dimension.height < 2 * (point.y - rectangle.y)) {
                point2.y = dimension.height - n3 - dimension2.height;
            }
        }
        return point2;
    }

    public int getDelay() {
        return this.delay;
    }

    public void setDelay(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("delay less than 0");
        }
        this.delay = n;
    }

    public void setMenuLocation(int n, int n2) {
        this.menuLocation = new Point(n, n2);
        if (this.popupMenu != null) {
            this.popupMenu.setLocation(n, n2);
        }
    }

    protected JMenuItem createActionComponent(Action action) {
        return new JMenuItem(action);
    }

    protected PropertyChangeListener createActionChangeListener(JMenuItem jMenuItem) {
        return new ActionChangedListener(jMenuItem);
    }

    public void addSeparator() {
        this.getPopupMenu().addSeparator();
    }

    public void insertSeparator(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("index less than 0");
        }
        this.getPopupMenu().insert(new JPopupMenu.Separator(), n);
    }

    public JMenuItem getItem(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("index less than 0");
        }
        if (this.getItemCount() == 0) {
            return null;
        }
        Component component = this.popupMenu.getComponentAtIndex(n);
        if (component instanceof JMenuItem) {
            return (JMenuItem)component;
        }
        return null;
    }

    public int getItemCount() {
        return this.getMenuComponentCount();
    }

    public boolean isTearOff() {
        throw new Error("The method isTearOff() has not yet been implemented.");
    }

    public int getMenuComponentCount() {
        return this.getPopupMenu().getComponentCount();
    }

    public Component getMenuComponent(int n) {
        if (this.getPopupMenu() == null || this.getMenuComponentCount() == 0) {
            return null;
        }
        return this.popupMenu.getComponentAtIndex(n);
    }

    public Component[] getMenuComponents() {
        return this.getPopupMenu().getComponents();
    }

    public boolean isTopLevelMenu() {
        return this.getParent() instanceof JMenuBar;
    }

    public boolean isMenuComponent(Component component) {
        return false;
    }

    public JPopupMenu getPopupMenu() {
        if (this.popupMenu == null) {
            this.popupMenu = new JPopupMenu();
            this.popupMenu.setInvoker(this);
        }
        return this.popupMenu;
    }

    public void addMenuListener(MenuListener menuListener) {
        this.listenerList.add(MenuListener.class, menuListener);
    }

    public void removeMenuListener(MenuListener menuListener) {
        this.listenerList.remove(MenuListener.class, menuListener);
    }

    public MenuListener[] getMenuListeners() {
        return (MenuListener[])this.listenerList.getListeners(MenuListener.class);
    }

    protected void fireMenuSelected() {
        MenuListener[] menuListenerArray = this.getMenuListeners();
        for (int i = 0; i < menuListenerArray.length; ++i) {
            menuListenerArray[i].menuSelected(this.menuEvent);
        }
    }

    protected void fireMenuDeselected() {
        EventListener[] eventListenerArray = this.listenerList.getListeners(MenuListener.class);
        for (int i = 0; i < eventListenerArray.length; ++i) {
            ((MenuListener)eventListenerArray[i]).menuDeselected(this.menuEvent);
        }
    }

    protected void fireMenuCanceled() {
        EventListener[] eventListenerArray = this.listenerList.getListeners(MenuListener.class);
        for (int i = 0; i < eventListenerArray.length; ++i) {
            ((MenuListener)eventListenerArray[i]).menuCanceled(this.menuEvent);
        }
    }

    protected WinListener createWinListener(JPopupMenu jPopupMenu) {
        return new WinListener(jPopupMenu);
    }

    public void menuSelectionChanged(boolean bl) {
        this.setSelected(bl);
    }

    public MenuElement[] getSubElements() {
        return new MenuElement[]{this.popupMenu};
    }

    public Component getComponent() {
        return this;
    }

    public void setAccelerator(KeyStroke keyStroke) {
        throw new Error("setAccelerator() is not defined for JMenu.  Use setMnemonic() instead.");
    }

    protected void processKeyEvent(KeyEvent keyEvent) {
        MenuSelectionManager.defaultManager().processKeyEvent(keyEvent);
    }

    public void doClick(int n) {
        this.getModel().setArmed(true);
        this.getModel().setPressed(true);
        try {
            Thread.sleep(n);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.getModel().setPressed(false);
        this.getModel().setArmed(false);
        this.popupMenu.show(this, this.getWidth(), 0);
    }

    protected String paramString() {
        return super.paramString();
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleJMenu();
        }
        return this.accessibleContext;
    }

    MenuElement[] createPath(JMenu jMenu) {
        JComponent jComponent;
        ArrayList<JComponent> arrayList = new ArrayList<JComponent>();
        MenuElement[] menuElementArray = null;
        Component component = jMenu.getPopupMenu();
        while (true) {
            if (component instanceof JPopupMenu) {
                jComponent = component;
                arrayList.add(0, jComponent);
                component = ((JPopupMenu)jComponent).getInvoker();
                continue;
            }
            if (component instanceof JMenu) {
                jComponent = (JMenu)component;
                arrayList.add(0, jComponent);
                component = jComponent.getParent();
                continue;
            }
            if (component instanceof JMenuBar) break;
        }
        jComponent = (JMenuBar)component;
        arrayList.add(0, jComponent);
        menuElementArray = new MenuElement[arrayList.size()];
        menuElementArray = arrayList.toArray(menuElementArray);
        return menuElementArray;
    }

    private class ActionChangedListener
    implements PropertyChangeListener {
        private JMenuItem menuItem;

        public ActionChangedListener(JMenuItem jMenuItem) {
            this.menuItem = jMenuItem;
            Action action = jMenuItem.getAction();
            if (action != null) {
                action.addPropertyChangeListener(this);
            }
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        }
    }

    protected class WinListener
    extends WindowAdapter
    implements Serializable {
        private static final long serialVersionUID = -6415815570638474823L;

        public WinListener(JPopupMenu jPopupMenu) {
        }

        public void windowClosing(WindowEvent windowEvent) {
            JMenu.this.setSelected(false);
        }
    }

    protected class AccessibleJMenu
    extends JMenuItem.AccessibleJMenuItem
    implements AccessibleSelection {
        private static final long serialVersionUID = -8131864021059524309L;

        protected AccessibleJMenu() {
        }

        public int getAccessibleChildrenCount() {
            Component[] componentArray = JMenu.this.getMenuComponents();
            int n = 0;
            for (int i = 0; i < componentArray.length; ++i) {
                if (!(componentArray[i] instanceof Accessible)) continue;
                ++n;
            }
            return n;
        }

        public Accessible getAccessibleChild(int n) {
            Component[] componentArray = JMenu.this.getMenuComponents();
            int n2 = 0;
            Accessible accessible = null;
            for (int i = 0; i < componentArray.length; ++i) {
                if (!(componentArray[i] instanceof Accessible)) continue;
                if (n2 == n) {
                    accessible = (Accessible)((Object)componentArray[i]);
                    break;
                }
                ++n2;
            }
            return accessible;
        }

        public AccessibleSelection getAccessibleSelection() {
            return this;
        }

        public Accessible getAccessibleSelection(int n) {
            MenuSelectionManager menuSelectionManager;
            MenuElement[] menuElementArray;
            Accessible accessible = null;
            if (n == 0 && (menuElementArray = (menuSelectionManager = MenuSelectionManager.defaultManager()).getSelectedPath()) != null) {
                for (int i = 0; i < menuElementArray.length; ++i) {
                    if (menuElementArray[i] == JMenu.this) {
                        do {
                            if (!(menuElementArray[i] instanceof Accessible)) continue;
                            accessible = (Accessible)((Object)menuElementArray[i]);
                            break;
                        } while (++i < menuElementArray.length);
                    }
                    if (accessible != null) break;
                }
            }
            return accessible;
        }

        public boolean isAccessibleChildSelected(int n) {
            boolean bl = false;
            MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
            MenuElement[] menuElementArray = menuSelectionManager.getSelectedPath();
            if (menuElementArray != null) {
                Accessible accessible = this.getAccessibleChild(n);
                for (int i = 0; i < menuElementArray.length; ++i) {
                    if (menuElementArray[i] != accessible) continue;
                    bl = true;
                    break;
                }
            }
            return bl;
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.MENU;
        }

        public int getAccessibleSelectionCount() {
            int n = 0;
            MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
            MenuElement[] menuElementArray = menuSelectionManager.getSelectedPath();
            if (menuElementArray != null) {
                for (int i = 0; i < menuElementArray.length; ++i) {
                    if (menuElementArray[i] != JMenu.this || i + 1 >= menuElementArray.length) continue;
                    n = 1;
                    break;
                }
            }
            return n;
        }

        public void addAccessibleSelection(int n) {
            Accessible accessible = this.getAccessibleChild(n);
            if (accessible != null && accessible instanceof JMenuItem) {
                JMenuItem jMenuItem = (JMenuItem)accessible;
                MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
                menuSelectionManager.setSelectedPath(JMenu.this.createPath(JMenu.this));
            }
        }

        public void removeAccessibleSelection(int n) {
            Accessible accessible = this.getAccessibleChild(n);
            if (accessible != null) {
                MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
                MenuElement[] menuElementArray = menuSelectionManager.getSelectedPath();
                for (int i = 0; i < menuElementArray.length; ++i) {
                    if (menuElementArray[i] != accessible) continue;
                    MenuElement[] menuElementArray2 = new MenuElement[i - 1];
                    System.arraycopy(menuElementArray, 0, menuElementArray2, 0, i - 1);
                    menuSelectionManager.setSelectedPath(menuElementArray2);
                    break;
                }
            }
        }

        public void clearAccessibleSelection() {
            MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
            MenuElement[] menuElementArray = menuSelectionManager.getSelectedPath();
            for (int i = 0; i < menuElementArray.length; ++i) {
                if (menuElementArray[i] != JMenu.this) continue;
                MenuElement[] menuElementArray2 = new MenuElement[i];
                System.arraycopy(menuElementArray, 0, menuElementArray2, 0, i);
                menuSelectionManager.setSelectedPath(menuElementArray2);
                break;
            }
        }

        public void selectAllAccessibleSelection() {
        }
    }

    private class MenuChangeListener
    implements ChangeListener {
        private boolean selected;

        private MenuChangeListener() {
        }

        public void stateChanged(ChangeEvent changeEvent) {
            ButtonModel buttonModel = (ButtonModel)changeEvent.getSource();
            boolean bl = buttonModel.isSelected();
            if (bl != this.selected) {
                if (bl) {
                    JMenu.this.fireMenuSelected();
                } else {
                    JMenu.this.fireMenuDeselected();
                }
                this.selected = bl;
            }
        }
    }
}

