/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.Container;
import java.awt.Dimension;
import java.io.BufferedInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleHyperlink;
import javax.accessibility.AccessibleHypertext;
import javax.accessibility.AccessibleStateSet;
import javax.accessibility.AccessibleText;
import javax.swing.JComponent;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.plaf.TextUI;
import javax.swing.text.AbstractDocument;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultEditorKit;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;
import javax.swing.text.WrappedPlainView;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;

public class JEditorPane
extends JTextComponent {
    private static final long serialVersionUID = 3140472492599046285L;
    private EditorKit editorKit;
    boolean focus_root;
    static HashMap editorKits;
    static HashMap registerMap;
    HashMap editorMap;
    private PageLoader loader;

    public JEditorPane() {
        this.init();
        this.setEditorKit(this.createDefaultEditorKit());
    }

    public JEditorPane(String string) throws IOException {
        this(new URL(string));
    }

    public JEditorPane(String string, String string2) {
        this.init();
        this.setEditorKit(JEditorPane.createEditorKitForContentType(string));
        this.setText(string2);
    }

    public JEditorPane(URL uRL) throws IOException {
        this.init();
        this.setEditorKit(JEditorPane.createEditorKitForContentType("text/html"));
        this.setPage(uRL);
    }

    void init() {
        this.editorMap = new HashMap();
    }

    protected EditorKit createDefaultEditorKit() {
        return new PlainEditorKit();
    }

    public static EditorKit createEditorKitForContentType(String string) {
        EditorKit editorKit = (EditorKit)editorKits.get(string);
        if (editorKit == null) {
            EditorKitMapping editorKitMapping = (EditorKitMapping)registerMap.get(string);
            if (editorKitMapping != null) {
                String string2 = editorKitMapping.className;
                ClassLoader classLoader = editorKitMapping.classLoader;
                try {
                    editorKit = (EditorKit)classLoader.loadClass(string2).newInstance();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (editorKit != null) {
                editorKits.put(string, editorKit);
            }
        }
        return editorKit;
    }

    public void fireHyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
        HyperlinkListener[] hyperlinkListenerArray = this.getHyperlinkListeners();
        for (int i = 0; i < hyperlinkListenerArray.length; ++i) {
            hyperlinkListenerArray[i].hyperlinkUpdate(hyperlinkEvent);
        }
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = this.getEditorKit() instanceof HTMLEditorKit ? new AccessibleJEditorPaneHTML() : new AccessibleJEditorPane();
        }
        return this.accessibleContext;
    }

    public final String getContentType() {
        return this.getEditorKit().getContentType();
    }

    public EditorKit getEditorKit() {
        if (this.editorKit == null) {
            this.setEditorKit(this.createDefaultEditorKit());
        }
        return this.editorKit;
    }

    public static String getEditorKitClassNameForContentType(String string) {
        EditorKitMapping editorKitMapping = (EditorKitMapping)registerMap.get(string);
        String string2 = editorKitMapping != null ? editorKitMapping.className : null;
        return string2;
    }

    public EditorKit getEditorKitForContentType(String string) {
        EditorKit editorKit = (EditorKit)this.editorMap.get(string);
        if (editorKit == null && (editorKit = JEditorPane.createEditorKitForContentType(string)) != null) {
            this.setEditorKitForContentType(string, editorKit);
        }
        if (editorKit == null) {
            editorKit = this.createDefaultEditorKit();
        }
        return editorKit;
    }

    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        Container container = this.getParent();
        if (container instanceof JViewport) {
            int n;
            JViewport jViewport = (JViewport)this.getParent();
            TextUI textUI = this.getUI();
            Dimension dimension2 = null;
            if (!this.getScrollableTracksViewportWidth()) {
                dimension2 = textUI.getMinimumSize(this);
                n = jViewport.getWidth();
                if (n != 0 && n < dimension2.width) {
                    dimension.width = dimension2.width;
                }
            }
            if (!this.getScrollableTracksViewportHeight()) {
                if (dimension2 == null) {
                    dimension2 = textUI.getMinimumSize(this);
                }
                if ((n = jViewport.getHeight()) != 0 && n < dimension2.height) {
                    dimension.height = dimension2.height;
                }
            }
        }
        return dimension;
    }

    public boolean getScrollableTracksViewportHeight() {
        Container container = this.getParent();
        int n = container.getHeight();
        TextUI textUI = this.getUI();
        return container instanceof JViewport && n >= textUI.getMinimumSize((JComponent)this).height && n <= textUI.getMaximumSize((JComponent)this).height;
    }

    public boolean getScrollableTracksViewportWidth() {
        Container container = this.getParent();
        return container != null && container instanceof JViewport && container.getWidth() > this.getUI().getMinimumSize((JComponent)this).width;
    }

    public URL getPage() {
        return this.loader != null ? this.loader.page : null;
    }

    protected InputStream getStream(URL uRL) throws IOException {
        URLConnection uRLConnection = uRL.openConnection();
        String string = uRLConnection.getContentType();
        if (string != null) {
            this.setContentType(string);
        }
        InputStream inputStream = uRLConnection.getInputStream();
        return new BufferedInputStream(inputStream);
    }

    public String getText() {
        return super.getText();
    }

    public String getUIClassID() {
        return "EditorPaneUI";
    }

    public boolean isFocusCycleRoot() {
        return this.focus_root;
    }

    protected String paramString() {
        return "JEditorPane";
    }

    public void read(InputStream inputStream, Object object) throws IOException {
        EditorKit editorKit = this.getEditorKit();
        if (editorKit instanceof HTMLEditorKit && object instanceof HTMLDocument) {
            HTMLDocument hTMLDocument = (HTMLDocument)object;
            this.setDocument(hTMLDocument);
            try {
                InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
                editorKit.read(inputStreamReader, (Document)hTMLDocument, 0);
            }
            catch (BadLocationException badLocationException) {
                assert (false) : "BadLocationException must not be thrown here.";
            }
        } else {
            InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
            super.read(inputStreamReader, object);
        }
    }

    public static void registerEditorKitForContentType(String string, String string2) {
        JEditorPane.registerEditorKitForContentType(string, string2, Thread.currentThread().getContextClassLoader());
    }

    public static void registerEditorKitForContentType(String string, String string2, ClassLoader classLoader) {
        registerMap.put(string, new EditorKitMapping(string2, classLoader));
    }

    public void replaceSelection(String string) {
        super.replaceSelection(string);
    }

    public void scrollToReference(String string) {
    }

    public final void setContentType(String string) {
        int n = string.indexOf(59);
        if (n > -1) {
            string = string.substring(0, n).trim();
        }
        if (this.editorKit != null && this.editorKit.getContentType().equals(string)) {
            return;
        }
        EditorKit editorKit = this.getEditorKitForContentType(string);
        if (editorKit != null) {
            this.setEditorKit(editorKit);
        }
    }

    public void setEditorKit(EditorKit editorKit) {
        if (this.editorKit == editorKit) {
            return;
        }
        if (this.editorKit != null) {
            this.editorKit.deinstall(this);
        }
        EditorKit editorKit2 = this.editorKit;
        this.editorKit = editorKit;
        if (this.editorKit != null) {
            this.editorKit.install(this);
            this.setDocument(this.editorKit.createDefaultDocument());
        }
        this.firePropertyChange("editorKit", editorKit2, editorKit);
        this.invalidate();
        this.repaint();
        this.accessibleContext = null;
    }

    public void setEditorKitForContentType(String string, EditorKit editorKit) {
        this.editorMap.put(string, editorKit);
    }

    public void setPage(String string) throws IOException {
        this.setPage(new URL(string));
    }

    public void setPage(URL uRL) throws IOException {
        if (uRL == null) {
            throw new IOException("invalid url");
        }
        URL uRL2 = this.getPage();
        if (uRL2 == null || !uRL2.sameFile(uRL)) {
            InputStream inputStream = this.getStream(uRL);
            if (this.editorKit != null) {
                Object object;
                Document document = this.editorKit.createDefaultDocument();
                document.putProperty("stream", uRL);
                if (this.loader != null) {
                    this.loader.cancel();
                }
                this.loader = new PageLoader(document, inputStream, uRL2, uRL);
                int n = -1;
                if (document instanceof AbstractDocument) {
                    object = (AbstractDocument)document;
                    n = ((AbstractDocument)object).getAsynchronousLoadPriority();
                }
                if (n >= 0) {
                    this.setDocument(document);
                    object = new Thread(this.loader, "JEditorPane.PageLoader");
                    ((Thread)object).setDaemon(true);
                    ((Thread)object).setPriority(n);
                    ((Thread)object).start();
                } else {
                    this.loader.run();
                    this.setDocument(document);
                }
            }
        }
    }

    public void setText(String string) {
        try {
            Document document = this.getDocument();
            document.remove(0, document.getLength());
            if (string == null || string.equals("")) {
                return;
            }
            this.getEditorKit().read(new StringReader(string), document, 0);
        }
        catch (BadLocationException badLocationException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void addHyperlinkListener(HyperlinkListener hyperlinkListener) {
        this.listenerList.add(HyperlinkListener.class, hyperlinkListener);
    }

    public void removeHyperlinkListener(HyperlinkListener hyperlinkListener) {
        this.listenerList.remove(HyperlinkListener.class, hyperlinkListener);
    }

    public HyperlinkListener[] getHyperlinkListeners() {
        return (HyperlinkListener[])this.getListeners(HyperlinkListener.class);
    }

    static {
        registerMap = new HashMap();
        editorKits = new HashMap();
        JEditorPane.registerEditorKitForContentType("application/rtf", "javax.swing.text.rtf.RTFEditorKit");
        JEditorPane.registerEditorKitForContentType("text/plain", "javax.swing.JEditorPane$PlainEditorKit");
        JEditorPane.registerEditorKitForContentType("text/html", "javax.swing.text.html.HTMLEditorKit");
        JEditorPane.registerEditorKitForContentType("text/rtf", "javax.swing.text.rtf.RTFEditorKit");
    }

    private class PageLoader
    implements Runnable {
        private Document doc;
        private PageStream in;
        private URL old;
        URL page;

        PageLoader(Document document, InputStream inputStream, URL uRL, URL uRL2) {
            this.doc = document;
            this.in = new PageStream(inputStream);
            this.old = uRL;
            this.page = uRL2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            try {
                try {
                    JEditorPane.this.read(this.in, (Object)this.doc);
                }
                catch (IOException iOException) {
                    UIManager.getLookAndFeel().provideErrorFeedback(JEditorPane.this);
                    Object var3_2 = null;
                    if (SwingUtilities.isEventDispatchThread()) {
                        JEditorPane.this.firePropertyChange("page", this.old, this.page);
                        return;
                    }
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            JEditorPane.this.firePropertyChange("page", PageLoader.this.old, PageLoader.this.page);
                        }
                    });
                    return;
                }
                Object var3_1 = null;
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                if (SwingUtilities.isEventDispatchThread()) {
                    JEditorPane.this.firePropertyChange("page", this.old, this.page);
                    throw throwable;
                }
                SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
                throw throwable;
            }
            if (SwingUtilities.isEventDispatchThread()) {
                JEditorPane.this.firePropertyChange("page", this.old, this.page);
                return;
            }
            SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
        }

        void cancel() {
            this.in.cancel();
        }
    }

    private class PageStream
    extends FilterInputStream {
        private boolean cancelled;

        protected PageStream(InputStream inputStream) {
            super(inputStream);
            this.cancelled = false;
        }

        private void checkCancelled() throws IOException {
            if (this.cancelled) {
                throw new IOException("Stream has been cancelled");
            }
        }

        void cancel() {
            this.cancelled = true;
        }

        public int read() throws IOException {
            this.checkCancelled();
            return super.read();
        }

        public int read(byte[] byArray, int n, int n2) throws IOException {
            this.checkCancelled();
            return super.read(byArray, n, n2);
        }

        public long skip(long l) throws IOException {
            this.checkCancelled();
            return super.skip(l);
        }

        public int available() throws IOException {
            this.checkCancelled();
            return super.available();
        }

        public void reset() throws IOException {
            this.checkCancelled();
            super.reset();
        }
    }

    private static class PlainEditorKit
    extends DefaultEditorKit {
        private PlainEditorKit() {
        }

        public ViewFactory getViewFactory() {
            return new ViewFactory(){

                public View create(Element element) {
                    return new WrappedPlainView(element);
                }
            };
        }
    }

    private static class EditorKitMapping {
        String className;
        ClassLoader classLoader;

        EditorKitMapping(String string, ClassLoader classLoader) {
            this.className = string;
            this.classLoader = classLoader;
        }
    }

    protected class JEditorPaneAccessibleHypertextSupport
    extends AccessibleJEditorPane
    implements AccessibleHypertext {
        public int getLinkCount() {
            HTMLDocument hTMLDocument = (HTMLDocument)JEditorPane.this.getDocument();
            HTMLDocument.Iterator iterator = hTMLDocument.getIterator(HTML.Tag.A);
            int n = 0;
            while (iterator.isValid()) {
                ++n;
                iterator.next();
            }
            return n;
        }

        public AccessibleHyperlink getLink(int n) {
            HTMLDocument hTMLDocument = (HTMLDocument)JEditorPane.this.getDocument();
            HTMLDocument.Iterator iterator = hTMLDocument.getIterator(HTML.Tag.A);
            int n2 = 0;
            while (iterator.isValid() && ++n2 != n) {
                iterator.next();
            }
            if (iterator.isValid()) {
                int n3 = iterator.getStartOffset();
                Element element = hTMLDocument.getCharacterElement(n3);
                HTMLLink hTMLLink = new HTMLLink(element);
                return hTMLLink;
            }
            return null;
        }

        public int getLinkIndex(int n) {
            HTMLDocument hTMLDocument = (HTMLDocument)JEditorPane.this.getDocument();
            HTMLDocument.Iterator iterator = hTMLDocument.getIterator(HTML.Tag.A);
            int n2 = 0;
            while (iterator.isValid() && (iterator.getStartOffset() > n || iterator.getEndOffset() <= n)) {
                ++n2;
                iterator.next();
            }
            if (iterator.isValid()) {
                return n2;
            }
            return -1;
        }

        public String getLinkText(int n) {
            HTMLDocument hTMLDocument = (HTMLDocument)JEditorPane.this.getDocument();
            HTMLDocument.Iterator iterator = hTMLDocument.getIterator(HTML.Tag.A);
            int n2 = 0;
            while (iterator.isValid() && ++n2 != n) {
                iterator.next();
            }
            if (iterator.isValid()) {
                int n3 = iterator.getStartOffset();
                Element element = hTMLDocument.getCharacterElement(n3);
                try {
                    String string = hTMLDocument.getText(element.getStartOffset(), element.getEndOffset() - element.getStartOffset());
                    return string;
                }
                catch (BadLocationException badLocationException) {
                    throw (AssertionError)((Object)((Throwable)((Object)new AssertionError((Object)"BadLocationException must not be thrown here."))).initCause(badLocationException));
                }
            }
            return null;
        }

        public class HTMLLink
        extends AccessibleHyperlink {
            Element element;

            public HTMLLink(Element element) {
                this.element = element;
            }

            public boolean isValid() {
                HTMLDocument hTMLDocument = (HTMLDocument)JEditorPane.this.getDocument();
                return hTMLDocument.getCharacterElement(this.element.getStartOffset()) == this.element;
            }

            public int getAccessibleActionCount() {
                return 1;
            }

            public boolean doAccessibleAction(int n) {
                String string = (String)this.element.getAttributes().getAttribute("href");
                HTMLDocument hTMLDocument = (HTMLDocument)JEditorPane.this.getDocument();
                try {
                    URL uRL = new URL(hTMLDocument.getBase(), string);
                    JEditorPane.this.setPage(uRL);
                    String string2 = hTMLDocument.getText(this.element.getStartOffset(), this.element.getEndOffset() - this.element.getStartOffset());
                    HyperlinkEvent hyperlinkEvent = new HyperlinkEvent(JEditorPane.this, HyperlinkEvent.EventType.ACTIVATED, uRL, string2, this.element);
                    JEditorPane.this.fireHyperlinkUpdate(hyperlinkEvent);
                    return true;
                }
                catch (Exception exception) {
                    return false;
                }
            }

            public String getAccessibleActionDescription(int n) {
                HTMLDocument hTMLDocument = (HTMLDocument)JEditorPane.this.getDocument();
                try {
                    return hTMLDocument.getText(this.element.getStartOffset(), this.element.getEndOffset() - this.element.getStartOffset());
                }
                catch (BadLocationException badLocationException) {
                    throw (AssertionError)((Object)((Throwable)((Object)new AssertionError((Object)"BadLocationException must not be thrown here."))).initCause(badLocationException));
                }
            }

            public Object getAccessibleActionObject(int n) {
                String string = (String)this.element.getAttributes().getAttribute("href");
                HTMLDocument hTMLDocument = (HTMLDocument)JEditorPane.this.getDocument();
                try {
                    URL uRL = new URL(hTMLDocument.getBase(), string);
                    return uRL;
                }
                catch (MalformedURLException malformedURLException) {
                    return null;
                }
            }

            public Object getAccessibleActionAnchor(int n) {
                return this.getAccessibleActionDescription(n);
            }

            public int getStartIndex() {
                return this.element.getStartOffset();
            }

            public int getEndIndex() {
                return this.element.getEndOffset();
            }
        }
    }

    protected class AccessibleJEditorPaneHTML
    extends AccessibleJEditorPane {
        protected AccessibleJEditorPaneHTML() {
        }

        public AccessibleText getAccessibleText() {
            return new JEditorPaneAccessibleHypertextSupport();
        }
    }

    protected class AccessibleJEditorPane
    extends JTextComponent.AccessibleJTextComponent {
        protected AccessibleJEditorPane() {
            super(JEditorPane.this);
        }

        public String getAccessibleDescription() {
            String string = super.getAccessibleDescription();
            if (string == null) {
                return JEditorPane.this.getContentType();
            }
            return string;
        }

        public AccessibleStateSet getAccessibleStateSet() {
            AccessibleStateSet accessibleStateSet = super.getAccessibleStateSet();
            return accessibleStateSet;
        }
    }
}

