/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.EventListener;
import javax.swing.BoundedRangeModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultBoundedRangeModel
implements BoundedRangeModel,
Serializable {
    private static final long serialVersionUID = 5034068491295259790L;
    protected transient ChangeEvent changeEvent;
    protected EventListenerList listenerList = new EventListenerList();
    private int value;
    private int extent;
    private int minimum;
    private int maximum;
    private boolean isAdjusting;

    public DefaultBoundedRangeModel() {
        this.maximum = 100;
    }

    public DefaultBoundedRangeModel(int n, int n2, int n3, int n4) {
        if (n3 > n || n2 < 0 || n + n2 > n4) {
            throw new IllegalArgumentException();
        }
        this.value = n;
        this.extent = n2;
        this.minimum = n3;
        this.maximum = n4;
    }

    public String toString() {
        return this.getClass().getName() + "[value=" + this.value + ", extent=" + this.extent + ", min=" + this.minimum + ", max=" + this.maximum + ", adj=" + this.isAdjusting + ']';
    }

    @Override
    public int getValue() {
        return this.value;
    }

    @Override
    public void setValue(int n) {
        if ((n = Math.max(this.minimum, n)) + this.extent > this.maximum) {
            n = this.maximum - this.extent;
        }
        if (n != this.value) {
            this.value = n;
            this.fireStateChanged();
        }
    }

    @Override
    public int getExtent() {
        return this.extent;
    }

    @Override
    public void setExtent(int n) {
        if (this.value + (n = Math.max(n, 0)) > this.maximum) {
            n = this.maximum - this.value;
        }
        if (n != this.extent) {
            this.extent = n;
            this.fireStateChanged();
        }
    }

    @Override
    public int getMinimum() {
        return this.minimum;
    }

    @Override
    public void setMinimum(int n) {
        int n2 = Math.max(n, this.maximum);
        int n3 = Math.max(n, this.value);
        this.setRangeProperties(n3, this.extent, n, n2, this.isAdjusting);
    }

    @Override
    public int getMaximum() {
        return this.maximum;
    }

    @Override
    public void setMaximum(int n) {
        int n2 = Math.min(this.minimum, n);
        int n3 = Math.min(this.extent, n - n2);
        int n4 = Math.min(this.value, n - n3);
        this.setRangeProperties(n4, n3, n2, n, this.isAdjusting);
    }

    @Override
    public boolean getValueIsAdjusting() {
        return this.isAdjusting;
    }

    @Override
    public void setValueIsAdjusting(boolean bl) {
        if (bl == this.isAdjusting) {
            return;
        }
        this.isAdjusting = bl;
        this.fireStateChanged();
    }

    @Override
    public void setRangeProperties(int n, int n2, int n3, int n4, boolean bl) {
        n3 = Math.min(Math.min(n3, n4), n);
        if (n2 + n > (n4 = Math.max(n, n4))) {
            n2 = n4 - n;
        }
        n2 = Math.max(0, n2);
        if (n == this.value && n2 == this.extent && n3 == this.minimum && n4 == this.maximum && bl == this.isAdjusting) {
            return;
        }
        this.value = n;
        this.extent = n2;
        this.minimum = n3;
        this.maximum = n4;
        this.isAdjusting = bl;
        this.fireStateChanged();
    }

    @Override
    public void addChangeListener(ChangeListener changeListener) {
        this.listenerList.add(ChangeListener.class, changeListener);
    }

    @Override
    public void removeChangeListener(ChangeListener changeListener) {
        this.listenerList.remove(ChangeListener.class, changeListener);
    }

    protected void fireStateChanged() {
        ChangeListener[] changeListenerArray = this.getChangeListeners();
        if (this.changeEvent == null) {
            this.changeEvent = new ChangeEvent(this);
        }
        for (int i = changeListenerArray.length - 1; i >= 0; --i) {
            changeListenerArray[i].stateChanged(this.changeEvent);
        }
    }

    public <T extends EventListener> T[] getListeners(Class<T> clazz) {
        return this.listenerList.getListeners(clazz);
    }

    public ChangeListener[] getChangeListeners() {
        return (ChangeListener[])this.getListeners(ChangeListener.class);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        objectInputStream.defaultReadObject();
        this.listenerList = new EventListenerList();
    }
}

