/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import gnu.java.lang.CPStringBuilder;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.ItemSelectable;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.Enumeration;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleAction;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleIcon;
import javax.accessibility.AccessibleRelation;
import javax.accessibility.AccessibleRelationSet;
import javax.accessibility.AccessibleState;
import javax.accessibility.AccessibleStateSet;
import javax.accessibility.AccessibleText;
import javax.accessibility.AccessibleValue;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;
import javax.swing.DefaultButtonModel;
import javax.swing.GrayFilter;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.OverlayLayout;
import javax.swing.SwingConstants;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.ButtonUI;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.Position;
import javax.swing.text.StyledDocument;
import javax.swing.text.View;

public abstract class AbstractButton
extends JComponent
implements ItemSelectable,
SwingConstants {
    private static final long serialVersionUID = -937921345538462020L;
    Icon default_icon;
    Icon pressed_icon;
    Icon disabledIcon;
    Icon selectedIcon;
    Icon disabledSelectedIcon;
    Icon rolloverIcon;
    Icon rolloverSelectedIcon;
    Icon current_icon;
    String text;
    int iconTextGap;
    int verticalAlignment = 0;
    int horizontalAlignment = 0;
    int horizontalTextPosition = 11;
    int verticalTextPosition = 0;
    boolean borderPainted = true;
    boolean focusPainted = true;
    boolean contentAreaFilled = true;
    boolean rollOverEnabled;
    Action action;
    protected ButtonModel model;
    Insets margin;
    int mnemonicIndex;
    protected ActionListener actionListener;
    protected ItemListener itemListener;
    protected ChangeListener changeListener;
    private EventHandler eventHandler;
    long multiClickThreshhold;
    PropertyChangeListener actionPropertyChangeListener;
    protected ChangeEvent changeEvent = new ChangeEvent(this);
    private boolean clientBorderPaintedSet = false;
    private boolean clientRolloverEnabledSet = false;
    private boolean clientIconTextGapSet = false;
    private boolean clientContentAreaFilledSet = false;
    public static final String BORDER_PAINTED_CHANGED_PROPERTY = "borderPainted";
    public static final String CONTENT_AREA_FILLED_CHANGED_PROPERTY = "contentAreaFilled";
    public static final String DISABLED_ICON_CHANGED_PROPERTY = "disabledIcon";
    public static final String DISABLED_SELECTED_ICON_CHANGED_PROPERTY = "disabledSelectedIcon";
    public static final String FOCUS_PAINTED_CHANGED_PROPERTY = "focusPainted";
    public static final String HORIZONTAL_ALIGNMENT_CHANGED_PROPERTY = "horizontalAlignment";
    public static final String HORIZONTAL_TEXT_POSITION_CHANGED_PROPERTY = "horizontalTextPosition";
    public static final String ICON_CHANGED_PROPERTY = "icon";
    public static final String MARGIN_CHANGED_PROPERTY = "margin";
    public static final String MNEMONIC_CHANGED_PROPERTY = "mnemonic";
    public static final String MODEL_CHANGED_PROPERTY = "model";
    public static final String PRESSED_ICON_CHANGED_PROPERTY = "pressedIcon";
    public static final String ROLLOVER_ENABLED_CHANGED_PROPERTY = "rolloverEnabled";
    public static final String ROLLOVER_ICON_CHANGED_PROPERTY = "rolloverIcon";
    public static final String ROLLOVER_SELECTED_ICON_CHANGED_PROPERTY = "rolloverSelectedIcon";
    public static final String SELECTED_ICON_CHANGED_PROPERTY = "selectedIcon";
    public static final String TEXT_CHANGED_PROPERTY = "text";
    public static final String VERTICAL_ALIGNMENT_CHANGED_PROPERTY = "verticalAlignment";
    public static final String VERTICAL_TEXT_POSITION_CHANGED_PROPERTY = "verticalTextPosition";

    public AbstractButton() {
        this.setFocusable(true);
        this.setAlignmentX(0.5f);
        this.setAlignmentY(0.5f);
        this.setDisplayedMnemonicIndex(-1);
        this.setOpaque(true);
        this.text = "";
        this.iconTextGap = 4;
    }

    public ButtonModel getModel() {
        return this.model;
    }

    public void setModel(ButtonModel buttonModel) {
        if (buttonModel == this.model) {
            return;
        }
        if (this.model != null) {
            this.model.removeActionListener(this.actionListener);
            this.actionListener = null;
            this.model.removeChangeListener(this.changeListener);
            this.changeListener = null;
            this.model.removeItemListener(this.itemListener);
            this.itemListener = null;
        }
        ButtonModel buttonModel2 = this.model;
        this.model = buttonModel;
        if (this.model != null) {
            this.actionListener = this.createActionListener();
            this.model.addActionListener(this.actionListener);
            this.changeListener = this.createChangeListener();
            this.model.addChangeListener(this.changeListener);
            this.itemListener = this.createItemListener();
            this.model.addItemListener(this.itemListener);
        }
        this.firePropertyChange(MODEL_CHANGED_PROPERTY, buttonModel2, this.model);
        this.revalidate();
        this.repaint();
    }

    protected void init(String string, Icon icon) {
        if (string != null) {
            this.setText(string);
        }
        if (icon != null) {
            this.default_icon = icon;
        }
        this.updateUI();
    }

    public String getActionCommand() {
        String string = this.model.getActionCommand();
        if (string != null) {
            return string;
        }
        return this.text;
    }

    public void setActionCommand(String string) {
        if (this.model != null) {
            this.model.setActionCommand(string);
        }
    }

    public void addActionListener(ActionListener actionListener) {
        this.listenerList.add(ActionListener.class, actionListener);
    }

    public void removeActionListener(ActionListener actionListener) {
        this.listenerList.remove(ActionListener.class, actionListener);
    }

    public ActionListener[] getActionListeners() {
        return (ActionListener[])this.listenerList.getListeners(ActionListener.class);
    }

    public void addItemListener(ItemListener itemListener) {
        this.listenerList.add(ItemListener.class, itemListener);
    }

    public void removeItemListener(ItemListener itemListener) {
        this.listenerList.remove(ItemListener.class, itemListener);
    }

    public ItemListener[] getItemListeners() {
        return (ItemListener[])this.listenerList.getListeners(ItemListener.class);
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.listenerList.add(ChangeListener.class, changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.listenerList.remove(ChangeListener.class, changeListener);
    }

    public ChangeListener[] getChangeListeners() {
        return (ChangeListener[])this.listenerList.getListeners(ChangeListener.class);
    }

    protected void fireItemStateChanged(ItemEvent itemEvent) {
        itemEvent.setSource(this);
        ItemListener[] itemListenerArray = this.getItemListeners();
        for (int i = 0; i < itemListenerArray.length; ++i) {
            itemListenerArray[i].itemStateChanged(itemEvent);
        }
    }

    protected void fireActionPerformed(ActionEvent actionEvent) {
        ActionEvent actionEvent2 = new ActionEvent(this, actionEvent.getID(), this.getActionCommand(), actionEvent.getWhen(), actionEvent.getModifiers());
        ActionListener[] actionListenerArray = this.getActionListeners();
        for (int i = 0; i < actionListenerArray.length; ++i) {
            actionListenerArray[i].actionPerformed(actionEvent2);
        }
    }

    protected void fireStateChanged() {
        ChangeListener[] changeListenerArray = this.getChangeListeners();
        for (int i = 0; i < changeListenerArray.length; ++i) {
            changeListenerArray[i].stateChanged(this.changeEvent);
        }
    }

    public int getMnemonic() {
        ButtonModel buttonModel = this.getModel();
        if (buttonModel != null) {
            return buttonModel.getMnemonic();
        }
        return -1;
    }

    public void setMnemonic(char c) {
        this.setMnemonic((int)c);
    }

    public void setMnemonic(int n) {
        ButtonModel buttonModel = this.getModel();
        int n2 = -1;
        if (buttonModel != null) {
            n2 = buttonModel.getMnemonic();
        }
        if (n2 != n) {
            if (buttonModel != null) {
                buttonModel.setMnemonic(n);
            }
            if (this.text != null && !this.text.equals("")) {
                char c = Character.toUpperCase((char)n);
                String string = this.text.toUpperCase();
                this.setDisplayedMnemonicIndex(string.indexOf(c));
            }
            this.firePropertyChange(MNEMONIC_CHANGED_PROPERTY, n2, n);
            this.revalidate();
            this.repaint();
        }
    }

    public void setDisplayedMnemonicIndex(int n) {
        if (n < -1 || this.text != null && n >= this.text.length()) {
            throw new IllegalArgumentException();
        }
        this.mnemonicIndex = n;
    }

    public int getDisplayedMnemonicIndex() {
        return this.mnemonicIndex;
    }

    public void setRolloverEnabled(boolean bl) {
        this.clientRolloverEnabledSet = true;
        if (this.rollOverEnabled != bl) {
            this.rollOverEnabled = bl;
            this.firePropertyChange(ROLLOVER_ENABLED_CHANGED_PROPERTY, !bl, bl);
            this.revalidate();
            this.repaint();
        }
    }

    public boolean isRolloverEnabled() {
        return this.rollOverEnabled;
    }

    public void setSelected(boolean bl) {
        ButtonModel buttonModel = this.getModel();
        if (buttonModel != null) {
            buttonModel.setSelected(bl);
        }
    }

    public boolean isSelected() {
        ButtonModel buttonModel = this.getModel();
        if (buttonModel != null) {
            return buttonModel.isSelected();
        }
        return false;
    }

    public void setEnabled(boolean bl) {
        if (bl == this.isEnabled()) {
            return;
        }
        super.setEnabled(bl);
        this.setFocusable(bl);
        ButtonModel buttonModel = this.getModel();
        if (buttonModel != null) {
            buttonModel.setEnabled(bl);
        }
    }

    public int getHorizontalAlignment() {
        return this.horizontalAlignment;
    }

    public void setHorizontalAlignment(int n) {
        if (this.horizontalAlignment == n) {
            return;
        }
        if (n != 2 && n != 0 && n != 4 && n != 10 && n != 11) {
            throw new IllegalArgumentException("Invalid alignment.");
        }
        int n2 = this.horizontalAlignment;
        this.horizontalAlignment = n;
        this.firePropertyChange(HORIZONTAL_ALIGNMENT_CHANGED_PROPERTY, n2, n);
        this.revalidate();
        this.repaint();
    }

    public int getHorizontalTextPosition() {
        return this.horizontalTextPosition;
    }

    public void setHorizontalTextPosition(int n) {
        if (this.horizontalTextPosition == n) {
            return;
        }
        if (n != 2 && n != 0 && n != 4 && n != 10 && n != 11) {
            throw new IllegalArgumentException("Invalid alignment.");
        }
        int n2 = this.horizontalTextPosition;
        this.horizontalTextPosition = n;
        this.firePropertyChange(HORIZONTAL_TEXT_POSITION_CHANGED_PROPERTY, n2, n);
        this.revalidate();
        this.repaint();
    }

    public int getVerticalAlignment() {
        return this.verticalAlignment;
    }

    public void setVerticalAlignment(int n) {
        if (this.verticalAlignment == n) {
            return;
        }
        if (n != 1 && n != 0 && n != 3) {
            throw new IllegalArgumentException("Invalid alignment.");
        }
        int n2 = this.verticalAlignment;
        this.verticalAlignment = n;
        this.firePropertyChange(VERTICAL_ALIGNMENT_CHANGED_PROPERTY, n2, n);
        this.revalidate();
        this.repaint();
    }

    public int getVerticalTextPosition() {
        return this.verticalTextPosition;
    }

    public void setVerticalTextPosition(int n) {
        if (this.verticalTextPosition == n) {
            return;
        }
        if (n != 1 && n != 0 && n != 3) {
            throw new IllegalArgumentException("Invalid alignment.");
        }
        int n2 = this.verticalTextPosition;
        this.verticalTextPosition = n;
        this.firePropertyChange(VERTICAL_TEXT_POSITION_CHANGED_PROPERTY, n2, n);
        this.revalidate();
        this.repaint();
    }

    public boolean isBorderPainted() {
        return this.borderPainted;
    }

    public void setBorderPainted(boolean bl) {
        this.clientBorderPaintedSet = true;
        if (this.borderPainted == bl) {
            return;
        }
        boolean bl2 = this.borderPainted;
        this.borderPainted = bl;
        this.firePropertyChange(BORDER_PAINTED_CHANGED_PROPERTY, bl2, bl);
        this.revalidate();
        this.repaint();
    }

    public Action getAction() {
        return this.action;
    }

    public void setAction(Action action) {
        if (this.action != null) {
            this.action.removePropertyChangeListener(this.actionPropertyChangeListener);
            this.removeActionListener(this.action);
            if (this.actionPropertyChangeListener != null) {
                this.action.removePropertyChangeListener(this.actionPropertyChangeListener);
                this.actionPropertyChangeListener = null;
            }
        }
        Action action2 = this.action;
        this.action = action;
        this.configurePropertiesFromAction(this.action);
        if (this.action != null) {
            this.actionPropertyChangeListener = this.createActionPropertyChangeListener(action);
            this.action.addPropertyChangeListener(this.actionPropertyChangeListener);
            this.addActionListener(this.action);
        }
    }

    public Icon getIcon() {
        return this.default_icon;
    }

    public void setIcon(Icon icon) {
        if (this.default_icon == icon) {
            return;
        }
        Icon icon2 = this.default_icon;
        this.default_icon = icon;
        this.firePropertyChange(ICON_CHANGED_PROPERTY, icon2, icon);
        this.revalidate();
        this.repaint();
    }

    public String getText() {
        return this.text;
    }

    public void setLabel(String string) {
        this.setText(string);
    }

    public String getLabel() {
        return this.getText();
    }

    public void setText(String string) {
        if (this.text == string) {
            return;
        }
        String string2 = this.text;
        this.text = string;
        this.firePropertyChange(TEXT_CHANGED_PROPERTY, string2, string);
        this.revalidate();
        this.repaint();
    }

    public void setIconTextGap(int n) {
        this.clientIconTextGapSet = true;
        if (this.iconTextGap == n) {
            return;
        }
        int n2 = this.iconTextGap;
        this.iconTextGap = n;
        this.firePropertyChange("iconTextGap", new Integer(n2), new Integer(n));
        this.revalidate();
        this.repaint();
    }

    public int getIconTextGap() {
        return this.iconTextGap;
    }

    public Insets getMargin() {
        return this.margin;
    }

    public void setMargin(Insets insets) {
        if (this.margin == insets) {
            return;
        }
        Insets insets2 = this.margin;
        this.margin = insets;
        this.firePropertyChange(MARGIN_CHANGED_PROPERTY, insets2, insets);
        this.revalidate();
        this.repaint();
    }

    public Icon getPressedIcon() {
        return this.pressed_icon;
    }

    public void setPressedIcon(Icon icon) {
        if (this.pressed_icon == icon) {
            return;
        }
        Icon icon2 = this.pressed_icon;
        this.pressed_icon = icon;
        this.firePropertyChange(PRESSED_ICON_CHANGED_PROPERTY, icon2, this.pressed_icon);
        this.revalidate();
        this.repaint();
    }

    public Icon getDisabledIcon() {
        if (this.disabledIcon == null && this.default_icon instanceof ImageIcon) {
            Image image = ((ImageIcon)this.default_icon).getImage();
            Image image2 = GrayFilter.createDisabledImage(image);
            this.disabledIcon = new ImageIcon(image2);
        }
        return this.disabledIcon;
    }

    public void setDisabledIcon(Icon icon) {
        if (this.disabledIcon == icon) {
            return;
        }
        Icon icon2 = this.disabledIcon;
        this.disabledIcon = icon;
        this.firePropertyChange(DISABLED_ICON_CHANGED_PROPERTY, icon2, icon);
        this.revalidate();
        this.repaint();
    }

    public boolean isFocusPainted() {
        return this.focusPainted;
    }

    public void setFocusPainted(boolean bl) {
        if (this.focusPainted == bl) {
            return;
        }
        boolean bl2 = this.focusPainted;
        this.focusPainted = bl;
        this.firePropertyChange(FOCUS_PAINTED_CHANGED_PROPERTY, bl2, bl);
        this.revalidate();
        this.repaint();
    }

    protected int checkHorizontalKey(int n, String string) {
        switch (n) {
            case 0: 
            case 2: 
            case 4: 
            case 10: 
            case 11: {
                break;
            }
            default: {
                throw new IllegalArgumentException(string);
            }
        }
        return n;
    }

    protected int checkVerticalKey(int n, String string) {
        switch (n) {
            case 0: 
            case 1: 
            case 3: {
                break;
            }
            default: {
                throw new IllegalArgumentException(string);
            }
        }
        return n;
    }

    protected void configurePropertiesFromAction(Action action) {
        if (action == null) {
            this.setText(null);
            this.setIcon(null);
            this.setEnabled(true);
            this.setToolTipText(null);
        } else {
            String string;
            this.setText((String)action.getValue("Name"));
            this.setIcon((Icon)action.getValue("SmallIcon"));
            this.setEnabled(action.isEnabled());
            this.setToolTipText((String)action.getValue("ShortDescription"));
            if (action.getValue("MnemonicKey") != null) {
                this.setMnemonic((Integer)action.getValue("MnemonicKey"));
            }
            if ((string = (String)action.getValue("ActionCommandKey")) != null) {
                this.setActionCommand((String)action.getValue("ActionCommandKey"));
            } else {
                this.setActionCommand(this.getText());
            }
        }
    }

    protected ActionListener createActionListener() {
        return this.getEventHandler();
    }

    protected PropertyChangeListener createActionPropertyChangeListener(Action action) {
        return new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                Action action = (Action)propertyChangeEvent.getSource();
                if (propertyChangeEvent.getPropertyName().equals("enabled")) {
                    AbstractButton.this.setEnabled(action.isEnabled());
                } else if (propertyChangeEvent.getPropertyName().equals("Name")) {
                    AbstractButton.this.setText((String)action.getValue("Name"));
                } else if (propertyChangeEvent.getPropertyName().equals("SmallIcon")) {
                    AbstractButton.this.setIcon((Icon)action.getValue("SmallIcon"));
                } else if (propertyChangeEvent.getPropertyName().equals("ShortDescription")) {
                    AbstractButton.this.setToolTipText((String)action.getValue("ShortDescription"));
                } else if (propertyChangeEvent.getPropertyName().equals("MnemonicKey")) {
                    if (action.getValue("MnemonicKey") != null) {
                        AbstractButton.this.setMnemonic((Integer)action.getValue("MnemonicKey"));
                    } else if (propertyChangeEvent.getPropertyName().equals("ActionCommandKey")) {
                        AbstractButton.this.setActionCommand((String)action.getValue("ActionCommandKey"));
                    }
                }
            }
        };
    }

    protected ChangeListener createChangeListener() {
        return this.getEventHandler();
    }

    protected ItemListener createItemListener() {
        return this.getEventHandler();
    }

    public void doClick() {
        this.doClick(100);
    }

    public void doClick(int n) {
        ButtonModel buttonModel = this.getModel();
        if (buttonModel != null) {
            buttonModel.setArmed(true);
            buttonModel.setPressed(true);
            try {
                Thread.sleep(n);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            buttonModel.setPressed(false);
            buttonModel.setArmed(false);
        }
    }

    public Icon getDisabledSelectedIcon() {
        return this.disabledSelectedIcon;
    }

    public void setDisabledSelectedIcon(Icon icon) {
        if (this.disabledSelectedIcon == icon) {
            return;
        }
        Icon icon2 = this.disabledSelectedIcon;
        this.disabledSelectedIcon = icon;
        this.firePropertyChange(DISABLED_SELECTED_ICON_CHANGED_PROPERTY, icon2, icon);
        this.revalidate();
        this.repaint();
    }

    public Icon getRolloverIcon() {
        return this.rolloverIcon;
    }

    public void setRolloverIcon(Icon icon) {
        if (this.rolloverIcon == icon) {
            return;
        }
        Icon icon2 = this.rolloverIcon;
        this.rolloverIcon = icon;
        this.firePropertyChange(ROLLOVER_ICON_CHANGED_PROPERTY, icon2, this.rolloverIcon);
        this.setRolloverEnabled(true);
        this.revalidate();
        this.repaint();
    }

    public Icon getRolloverSelectedIcon() {
        return this.rolloverSelectedIcon;
    }

    public void setRolloverSelectedIcon(Icon icon) {
        if (this.rolloverSelectedIcon == icon) {
            return;
        }
        Icon icon2 = this.rolloverSelectedIcon;
        this.rolloverSelectedIcon = icon;
        this.firePropertyChange(ROLLOVER_SELECTED_ICON_CHANGED_PROPERTY, icon2, icon);
        this.setRolloverEnabled(true);
        this.revalidate();
        this.repaint();
    }

    public Icon getSelectedIcon() {
        return this.selectedIcon;
    }

    public void setSelectedIcon(Icon icon) {
        if (this.selectedIcon == icon) {
            return;
        }
        Icon icon2 = this.selectedIcon;
        this.selectedIcon = icon;
        this.firePropertyChange(SELECTED_ICON_CHANGED_PROPERTY, icon2, icon);
        this.revalidate();
        this.repaint();
    }

    public Object[] getSelectedObjects() {
        if (this.isSelected()) {
            Object[] objectArray = new Object[]{this.getText()};
            return objectArray;
        }
        return null;
    }

    public boolean imageUpdate(Image image, int n, int n2, int n3, int n4, int n5) {
        return this.current_icon == image;
    }

    public boolean isContentAreaFilled() {
        return this.contentAreaFilled;
    }

    public void setContentAreaFilled(boolean bl) {
        this.clientContentAreaFilledSet = true;
        if (this.contentAreaFilled == bl) {
            return;
        }
        this.setOpaque(bl);
        boolean bl2 = this.contentAreaFilled;
        this.contentAreaFilled = bl;
        this.firePropertyChange(CONTENT_AREA_FILLED_CHANGED_PROPERTY, bl2, bl);
    }

    protected void paintBorder(Graphics graphics) {
        if (this.isBorderPainted()) {
            super.paintBorder(graphics);
        }
    }

    protected String paramString() {
        CPStringBuilder cPStringBuilder = new CPStringBuilder();
        cPStringBuilder.append(super.paramString());
        cPStringBuilder.append(",defaultIcon=");
        if (this.getIcon() != null) {
            cPStringBuilder.append(this.getIcon());
        }
        cPStringBuilder.append(",disabledIcon=");
        if (this.getDisabledIcon() != null) {
            cPStringBuilder.append(this.getDisabledIcon());
        }
        cPStringBuilder.append(",disabledSelectedIcon=");
        if (this.getDisabledSelectedIcon() != null) {
            cPStringBuilder.append(this.getDisabledSelectedIcon());
        }
        cPStringBuilder.append(",margin=");
        if (this.getMargin() != null) {
            cPStringBuilder.append(this.getMargin());
        }
        cPStringBuilder.append(",paintBorder=").append(this.isBorderPainted());
        cPStringBuilder.append(",paintFocus=").append(this.isFocusPainted());
        cPStringBuilder.append(",pressedIcon=");
        if (this.getPressedIcon() != null) {
            cPStringBuilder.append(this.getPressedIcon());
        }
        cPStringBuilder.append(",rolloverEnabled=").append(this.isRolloverEnabled());
        cPStringBuilder.append(",rolloverIcon=");
        if (this.getRolloverIcon() != null) {
            cPStringBuilder.append(this.getRolloverIcon());
        }
        cPStringBuilder.append(",rolloverSelected=");
        if (this.getRolloverSelectedIcon() != null) {
            cPStringBuilder.append(this.getRolloverSelectedIcon());
        }
        cPStringBuilder.append(",selectedIcon=");
        if (this.getSelectedIcon() != null) {
            cPStringBuilder.append(this.getSelectedIcon());
        }
        cPStringBuilder.append(",text=");
        if (this.getText() != null) {
            cPStringBuilder.append(this.getText());
        }
        return cPStringBuilder.toString();
    }

    public void setUI(ButtonUI buttonUI) {
        super.setUI(buttonUI);
    }

    public ButtonUI getUI() {
        return (ButtonUI)this.ui;
    }

    public void updateUI() {
    }

    public long getMultiClickThreshhold() {
        return this.multiClickThreshhold;
    }

    public void setMultiClickThreshhold(long l) {
        if (l < 0L) {
            throw new IllegalArgumentException();
        }
        this.multiClickThreshhold = l;
    }

    protected void addImpl(Component component, Object object, int n) {
        if (this.getClientProperty("AbstractButton.customLayoutSet") == null) {
            this.setLayout(new OverlayLayout(this));
        }
        super.addImpl(component, object, n);
    }

    public void setLayout(LayoutManager layoutManager) {
        this.putClientProperty("AbstractButton.customLayoutSet", Boolean.TRUE);
        super.setLayout(layoutManager);
    }

    void setUIProperty(String string, Object object) {
        if (string.equals(BORDER_PAINTED_CHANGED_PROPERTY)) {
            if (!this.clientBorderPaintedSet) {
                this.setBorderPainted((Boolean)object);
                this.clientBorderPaintedSet = false;
            }
        } else if (string.equals(ROLLOVER_ENABLED_CHANGED_PROPERTY)) {
            if (!this.clientRolloverEnabledSet) {
                this.setRolloverEnabled((Boolean)object);
                this.clientRolloverEnabledSet = false;
            }
        } else if (string.equals("iconTextGap")) {
            if (!this.clientIconTextGapSet) {
                this.setIconTextGap((Integer)object);
                this.clientIconTextGapSet = false;
            }
        } else if (string.equals(CONTENT_AREA_FILLED_CHANGED_PROPERTY)) {
            if (!this.clientContentAreaFilledSet) {
                this.setContentAreaFilled((Boolean)object);
                this.clientContentAreaFilledSet = false;
            }
        } else {
            super.setUIProperty(string, object);
        }
    }

    EventHandler getEventHandler() {
        if (this.eventHandler == null) {
            this.eventHandler = new EventHandler();
        }
        return this.eventHandler;
    }

    protected abstract class AccessibleAbstractButton
    extends JComponent.AccessibleJComponent
    implements AccessibleAction,
    AccessibleValue,
    AccessibleText {
        private static final long serialVersionUID = -5673062525319836790L;

        protected AccessibleAbstractButton() {
            super(AbstractButton.this);
        }

        public AccessibleStateSet getAccessibleStateSet() {
            AccessibleStateSet accessibleStateSet = super.getAccessibleStateSet();
            if (AbstractButton.this.getModel().isArmed()) {
                accessibleStateSet.add(AccessibleState.ARMED);
            }
            if (AbstractButton.this.getModel().isPressed()) {
                accessibleStateSet.add(AccessibleState.PRESSED);
            }
            if (AbstractButton.this.isSelected()) {
                accessibleStateSet.add(AccessibleState.CHECKED);
            }
            return accessibleStateSet;
        }

        public String getAccessibleName() {
            String string = super.getAccessibleName();
            if (string == null) {
                string = AbstractButton.this.text;
            }
            return string;
        }

        public AccessibleIcon[] getAccessibleIcon() {
            AccessibleContext accessibleContext;
            AccessibleIcon[] accessibleIconArray = null;
            Icon icon = AbstractButton.this.getIcon();
            if (icon instanceof Accessible && (accessibleContext = ((Accessible)((Object)icon)).getAccessibleContext()) instanceof AccessibleIcon) {
                accessibleIconArray = new AccessibleIcon[]{(AccessibleIcon)((Object)accessibleContext)};
            }
            return accessibleIconArray;
        }

        public AccessibleRelationSet getAccessibleRelationSet() {
            ButtonGroup buttonGroup;
            AccessibleRelationSet accessibleRelationSet = super.getAccessibleRelationSet();
            ButtonModel buttonModel = AbstractButton.this.getModel();
            if (buttonModel instanceof DefaultButtonModel && (buttonGroup = ((DefaultButtonModel)buttonModel).getGroup()) != null) {
                Object[] objectArray = new Object[buttonGroup.getButtonCount()];
                Enumeration<AbstractButton> enumeration = buttonGroup.getElements();
                int n = 0;
                while (enumeration.hasMoreElements()) {
                    objectArray[n] = enumeration.nextElement();
                    ++n;
                }
                AccessibleRelation accessibleRelation = new AccessibleRelation(AccessibleRelation.MEMBER_OF);
                accessibleRelation.setTarget(objectArray);
                accessibleRelationSet.add(accessibleRelation);
            }
            return accessibleRelationSet;
        }

        public AccessibleAction getAccessibleAction() {
            return this;
        }

        public AccessibleValue getAccessibleValue() {
            return this;
        }

        public int getAccessibleActionCount() {
            return 1;
        }

        public String getAccessibleActionDescription(int n) {
            String string = null;
            if (n == 0) {
                string = UIManager.getString("AbstractButton.clickText");
            }
            return string;
        }

        public boolean doAccessibleAction(int n) {
            boolean bl = false;
            if (n == 0) {
                AbstractButton.this.doClick();
                bl = true;
            }
            return bl;
        }

        public Number getCurrentAccessibleValue() {
            Integer n = AbstractButton.this.isSelected() ? new Integer(1) : new Integer(0);
            return n;
        }

        public boolean setCurrentAccessibleValue(Number number) {
            boolean bl = false;
            if (number != null) {
                if (number.intValue() == 0) {
                    AbstractButton.this.setSelected(false);
                } else {
                    AbstractButton.this.setSelected(true);
                }
                bl = true;
            }
            return bl;
        }

        public Number getMinimumAccessibleValue() {
            return new Integer(0);
        }

        public Number getMaximumAccessibleValue() {
            return new Integer(1);
        }

        public AccessibleText getAccessibleText() {
            AccessibleAbstractButton accessibleAbstractButton = null;
            if (AbstractButton.this.getClientProperty("html") != null) {
                accessibleAbstractButton = this;
            }
            return accessibleAbstractButton;
        }

        public int getIndexAtPoint(Point point) {
            int n = -1;
            View view = (View)AbstractButton.this.getClientProperty("html");
            if (view != null) {
                Rectangle rectangle = new Rectangle(0, 0, AbstractButton.this.getWidth(), AbstractButton.this.getHeight());
                n = view.viewToModel(point.x, point.y, rectangle, new Position.Bias[1]);
            }
            return n;
        }

        public Rectangle getCharacterBounds(int n) {
            Rectangle rectangle = null;
            View view = (View)AbstractButton.this.getClientProperty("html");
            if (view != null) {
                Rectangle rectangle2 = new Rectangle(0, 0, AbstractButton.this.getWidth(), AbstractButton.this.getHeight());
                try {
                    Shape shape = view.modelToView(n, rectangle2, Position.Bias.Forward);
                    rectangle = shape.getBounds();
                }
                catch (BadLocationException badLocationException) {
                    rectangle = null;
                }
            }
            return rectangle;
        }

        public int getCharCount() {
            View view = (View)AbstractButton.this.getClientProperty("html");
            int n = view != null ? view.getDocument().getLength() : this.getAccessibleName().length();
            return n;
        }

        public int getCaretPosition() {
            return -1;
        }

        public String getAtIndex(int n, int n2) {
            String string = "";
            int n3 = -1;
            int n4 = -1;
            switch (n) {
                case 1: {
                    string = String.valueOf(AbstractButton.this.text.charAt(n2));
                    break;
                }
                case 2: {
                    n3 = AbstractButton.this.text.lastIndexOf(32, n2);
                    n4 = AbstractButton.this.text.indexOf(32, n3 + 1);
                    if (n4 == -1) {
                        n4 = n3 + 1;
                    }
                    string = AbstractButton.this.text.substring(n3 + 1, n4);
                    break;
                }
                default: {
                    n3 = AbstractButton.this.text.lastIndexOf(46, n2);
                    n4 = AbstractButton.this.text.indexOf(46, n3 + 1);
                    if (n4 == -1) {
                        n4 = n3 + 1;
                    }
                    string = AbstractButton.this.text.substring(n3 + 1, n4);
                }
            }
            return string;
        }

        public String getAfterIndex(int n, int n2) {
            String string = "";
            int n3 = -1;
            int n4 = -1;
            switch (n) {
                case 1: {
                    string = String.valueOf(AbstractButton.this.text.charAt(n2 + 1));
                    break;
                }
                case 2: {
                    n3 = AbstractButton.this.text.indexOf(32, n2);
                    n4 = AbstractButton.this.text.indexOf(32, n3 + 1);
                    if (n4 == -1) {
                        n4 = n3 + 1;
                    }
                    string = AbstractButton.this.text.substring(n3 + 1, n4);
                    break;
                }
                default: {
                    n3 = AbstractButton.this.text.indexOf(46, n2);
                    n4 = AbstractButton.this.text.indexOf(46, n3 + 1);
                    if (n4 == -1) {
                        n4 = n3 + 1;
                    }
                    string = AbstractButton.this.text.substring(n3 + 1, n4);
                }
            }
            return string;
        }

        public String getBeforeIndex(int n, int n2) {
            String string = "";
            int n3 = -1;
            int n4 = -1;
            switch (n) {
                case 1: {
                    string = String.valueOf(AbstractButton.this.text.charAt(n2 - 1));
                    break;
                }
                case 2: {
                    n4 = AbstractButton.this.text.lastIndexOf(32, n2);
                    if (n4 == -1) {
                        n4 = 0;
                    }
                    n3 = AbstractButton.this.text.lastIndexOf(32, n4 - 1);
                    string = AbstractButton.this.text.substring(n3 + 1, n4);
                    break;
                }
                default: {
                    n4 = AbstractButton.this.text.lastIndexOf(46, n2);
                    if (n4 == -1) {
                        n4 = 0;
                    }
                    n3 = AbstractButton.this.text.lastIndexOf(46, n4 - 1);
                    string = AbstractButton.this.text.substring(n3 + 1, n4);
                }
            }
            return string;
        }

        public AttributeSet getCharacterAttribute(int n) {
            StyledDocument styledDocument;
            Element element;
            Document document;
            AttributeSet attributeSet = null;
            View view = (View)AbstractButton.this.getClientProperty("html");
            if (view != null && (document = view.getDocument()) instanceof StyledDocument && (element = (styledDocument = (StyledDocument)document).getCharacterElement(n)) != null) {
                attributeSet = element.getAttributes();
            }
            return attributeSet;
        }

        public int getSelectionStart() {
            return -1;
        }

        public int getSelectionEnd() {
            return -1;
        }

        public String getSelectedText() {
            return null;
        }
    }

    private class EventHandler
    implements ActionListener,
    ChangeListener,
    ItemListener {
        private EventHandler() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            AbstractButton.this.fireActionPerformed(actionEvent);
        }

        public void stateChanged(ChangeEvent changeEvent) {
            AbstractButton.this.fireStateChanged();
            AbstractButton.this.repaint();
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            AbstractButton.this.fireItemStateChanged(itemEvent);
        }
    }

    protected class ButtonChangeListener
    implements ChangeListener,
    Serializable {
        private static final long serialVersionUID = 1471056094226600578L;

        ButtonChangeListener() {
        }

        public void stateChanged(ChangeEvent changeEvent) {
            AbstractButton.this.getEventHandler().stateChanged(changeEvent);
        }
    }
}

