/*
 * Decompiled with CFR 0.152.
 */
package javax.sound.sampled;

import gnu.java.lang.CPStringBuilder;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.Line;

public interface DataLine
extends Line {
    public int available();

    public void drain();

    public void flush();

    public int getBufferSize();

    public AudioFormat getFormat();

    public int getFramePosition();

    public float getLevel();

    public long getLongFramePosition();

    public long getMicrosecondPosition();

    public boolean isActive();

    public boolean isRunning();

    public void start();

    public void stop();

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Info
    extends Line.Info {
        private int minBufferSize;
        private int maxBufferSize;
        private AudioFormat[] formats;

        public Info(Class<?> clazz, AudioFormat audioFormat) {
            super(clazz);
            this.minBufferSize = -1;
            this.maxBufferSize = -1;
            this.formats = new AudioFormat[]{audioFormat};
        }

        public Info(Class<?> clazz, AudioFormat[] audioFormatArray, int n, int n2) {
            super(clazz);
            this.minBufferSize = n;
            this.maxBufferSize = n2;
            this.formats = audioFormatArray;
        }

        public Info(Class<?> clazz, AudioFormat audioFormat, int n) {
            super(clazz);
            this.minBufferSize = n;
            this.maxBufferSize = n;
            this.formats = new AudioFormat[]{audioFormat};
        }

        public AudioFormat[] getFormats() {
            return this.formats;
        }

        public int getMaxBufferSize() {
            return this.maxBufferSize;
        }

        public int getMinBufferSize() {
            return this.minBufferSize;
        }

        public boolean isFormatSupported(AudioFormat audioFormat) {
            for (int i = 0; i < this.formats.length; ++i) {
                if (!audioFormat.matches(this.formats[i])) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean matches(Line.Info info) {
            if (!super.matches(info) || !(info instanceof Info)) {
                return false;
            }
            Info info2 = (Info)info;
            if (this.minBufferSize < info2.minBufferSize || this.maxBufferSize > info2.maxBufferSize) {
                return false;
            }
            for (int i = 0; i < this.formats.length; ++i) {
                boolean bl = false;
                for (int j = 0; j < info2.formats.length; ++j) {
                    if (!this.formats[i].matches(info2.formats[j])) continue;
                    bl = true;
                    break;
                }
                if (bl) continue;
                return false;
            }
            return true;
        }

        @Override
        public String toString() {
            CPStringBuilder cPStringBuilder = new CPStringBuilder();
            cPStringBuilder.append("formats: [");
            for (int i = 0; i < this.formats.length; ++i) {
                if (i > 0) {
                    cPStringBuilder.append(", ");
                }
                cPStringBuilder.append(this.formats[i].toString());
            }
            cPStringBuilder.append("]; minBufferSize: ");
            cPStringBuilder.append(this.minBufferSize);
            cPStringBuilder.append("; maxBufferSize: ");
            cPStringBuilder.append(this.maxBufferSize);
            return cPStringBuilder.toString();
        }
    }
}

