/*
 * Decompiled with CFR 0.152.
 */
package javax.sound.midi;

import gnu.classpath.ServiceFactory;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MidiDevice;
import javax.sound.midi.MidiFileFormat;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.Receiver;
import javax.sound.midi.Sequence;
import javax.sound.midi.Sequencer;
import javax.sound.midi.Soundbank;
import javax.sound.midi.Synthesizer;
import javax.sound.midi.Transmitter;
import javax.sound.midi.spi.MidiDeviceProvider;
import javax.sound.midi.spi.MidiFileReader;
import javax.sound.midi.spi.MidiFileWriter;
import javax.sound.midi.spi.SoundbankReader;

public class MidiSystem {
    private MidiSystem() {
    }

    public static MidiDevice.Info[] getMidiDeviceInfo() {
        Iterator<MidiDeviceProvider> iterator = ServiceFactory.lookupProviders(MidiDeviceProvider.class);
        ArrayList<MidiDevice.Info> arrayList = new ArrayList<MidiDevice.Info>();
        while (iterator.hasNext()) {
            MidiDeviceProvider midiDeviceProvider = iterator.next();
            MidiDevice.Info[] infoArray = midiDeviceProvider.getDeviceInfo();
            int n = infoArray.length;
            while (n > 0) {
                arrayList.add(infoArray[--n]);
            }
        }
        return arrayList.toArray(new MidiDevice.Info[arrayList.size()]);
    }

    public static MidiDevice getMidiDevice(MidiDevice.Info info) throws MidiUnavailableException {
        Iterator<MidiDeviceProvider> iterator = ServiceFactory.lookupProviders(MidiDeviceProvider.class);
        if (!iterator.hasNext()) {
            throw new MidiUnavailableException("No MIDI device providers available.");
        }
        do {
            MidiDeviceProvider midiDeviceProvider;
            if (!(midiDeviceProvider = iterator.next()).isDeviceSupported(info)) continue;
            return midiDeviceProvider.getDevice(info);
        } while (iterator.hasNext());
        throw new IllegalArgumentException("MIDI device " + info + " not available.");
    }

    public static Receiver getReceiver() throws MidiUnavailableException {
        MidiDevice.Info[] infoArray = MidiSystem.getMidiDeviceInfo();
        for (int i = 0; i < infoArray.length; ++i) {
            MidiDevice midiDevice = MidiSystem.getMidiDevice(infoArray[i]);
            if (!(midiDevice instanceof Receiver)) continue;
            return (Receiver)((Object)midiDevice);
        }
        throw new MidiUnavailableException("No Receiver device available");
    }

    public static Transmitter getTransmitter() throws MidiUnavailableException {
        MidiDevice.Info[] infoArray = MidiSystem.getMidiDeviceInfo();
        for (int i = 0; i < infoArray.length; ++i) {
            MidiDevice midiDevice = MidiSystem.getMidiDevice(infoArray[i]);
            if (!(midiDevice instanceof Transmitter)) continue;
            return (Transmitter)((Object)midiDevice);
        }
        throw new MidiUnavailableException("No Transmitter device available");
    }

    public static Synthesizer getSynthesizer() throws MidiUnavailableException {
        MidiDevice.Info[] infoArray = MidiSystem.getMidiDeviceInfo();
        for (int i = 0; i < infoArray.length; ++i) {
            MidiDevice midiDevice = MidiSystem.getMidiDevice(infoArray[i]);
            if (!(midiDevice instanceof Synthesizer)) continue;
            return (Synthesizer)midiDevice;
        }
        throw new MidiUnavailableException("No Synthesizer device available");
    }

    public static Sequencer getSequencer() throws MidiUnavailableException {
        MidiDevice.Info[] infoArray = MidiSystem.getMidiDeviceInfo();
        for (int i = 0; i < infoArray.length; ++i) {
            MidiDevice midiDevice = MidiSystem.getMidiDevice(infoArray[i]);
            if (!(midiDevice instanceof Sequencer)) continue;
            return (Sequencer)midiDevice;
        }
        throw new MidiUnavailableException("No Sequencer device available");
    }

    public static Soundbank getSoundbank(InputStream inputStream) throws InvalidMidiDataException, IOException {
        Iterator<SoundbankReader> iterator = ServiceFactory.lookupProviders(SoundbankReader.class);
        while (iterator.hasNext()) {
            SoundbankReader soundbankReader = iterator.next();
            Soundbank soundbank = soundbankReader.getSoundbank(inputStream);
            if (soundbank == null) continue;
            return soundbank;
        }
        throw new InvalidMidiDataException("Cannot read soundbank from stream");
    }

    public static Soundbank getSoundbank(URL uRL) throws InvalidMidiDataException, IOException {
        Iterator<SoundbankReader> iterator = ServiceFactory.lookupProviders(SoundbankReader.class);
        while (iterator.hasNext()) {
            SoundbankReader soundbankReader = iterator.next();
            Soundbank soundbank = soundbankReader.getSoundbank(uRL);
            if (soundbank == null) continue;
            return soundbank;
        }
        throw new InvalidMidiDataException("Cannot read from url " + uRL);
    }

    public static Soundbank getSoundbank(File file) throws InvalidMidiDataException, IOException {
        Iterator<SoundbankReader> iterator = ServiceFactory.lookupProviders(SoundbankReader.class);
        while (iterator.hasNext()) {
            SoundbankReader soundbankReader = iterator.next();
            Soundbank soundbank = soundbankReader.getSoundbank(file);
            if (soundbank == null) continue;
            return soundbank;
        }
        throw new InvalidMidiDataException("Cannot read soundbank from file " + file);
    }

    public static MidiFileFormat getMidiFileFormat(InputStream inputStream) throws InvalidMidiDataException, IOException {
        Iterator<MidiFileReader> iterator = ServiceFactory.lookupProviders(MidiFileReader.class);
        while (iterator.hasNext()) {
            MidiFileReader midiFileReader = iterator.next();
            MidiFileFormat midiFileFormat = midiFileReader.getMidiFileFormat(inputStream);
            if (midiFileFormat == null) continue;
            return midiFileFormat;
        }
        throw new InvalidMidiDataException("Can't read MidiFileFormat from stream");
    }

    public static MidiFileFormat getMidiFileFormat(URL uRL) throws InvalidMidiDataException, IOException {
        Iterator<MidiFileReader> iterator = ServiceFactory.lookupProviders(MidiFileReader.class);
        while (iterator.hasNext()) {
            MidiFileReader midiFileReader = iterator.next();
            MidiFileFormat midiFileFormat = midiFileReader.getMidiFileFormat(uRL);
            if (midiFileFormat == null) continue;
            return midiFileFormat;
        }
        throw new InvalidMidiDataException("Cannot read from url " + uRL);
    }

    public static MidiFileFormat getMidiFileFormat(File file) throws InvalidMidiDataException, IOException {
        Iterator<MidiFileReader> iterator = ServiceFactory.lookupProviders(MidiFileReader.class);
        while (iterator.hasNext()) {
            MidiFileReader midiFileReader = iterator.next();
            MidiFileFormat midiFileFormat = midiFileReader.getMidiFileFormat(file);
            if (midiFileFormat == null) continue;
            return midiFileFormat;
        }
        throw new InvalidMidiDataException("Can't read MidiFileFormat from file " + file);
    }

    public static Sequence getSequence(InputStream inputStream) throws InvalidMidiDataException, IOException {
        Iterator<MidiFileReader> iterator = ServiceFactory.lookupProviders(MidiFileReader.class);
        while (iterator.hasNext()) {
            MidiFileReader midiFileReader = iterator.next();
            Sequence sequence = midiFileReader.getSequence(inputStream);
            if (sequence == null) continue;
            return sequence;
        }
        throw new InvalidMidiDataException("Can't read Sequence from stream");
    }

    public static Sequence getSequence(URL uRL) throws InvalidMidiDataException, IOException {
        Iterator<MidiFileReader> iterator = ServiceFactory.lookupProviders(MidiFileReader.class);
        while (iterator.hasNext()) {
            MidiFileReader midiFileReader = iterator.next();
            Sequence sequence = midiFileReader.getSequence(uRL);
            if (sequence == null) continue;
            return sequence;
        }
        throw new InvalidMidiDataException("Cannot read from url " + uRL);
    }

    public static Sequence getSequence(File file) throws InvalidMidiDataException, IOException {
        Iterator<MidiFileReader> iterator = ServiceFactory.lookupProviders(MidiFileReader.class);
        while (iterator.hasNext()) {
            MidiFileReader midiFileReader = iterator.next();
            Sequence sequence = midiFileReader.getSequence(file);
            if (sequence == null) continue;
            return sequence;
        }
        throw new InvalidMidiDataException("Can't read Sequence from file " + file);
    }

    public static int[] getMidiFileTypes() {
        Object object;
        boolean[] blArray = new boolean[3];
        int n = 0;
        Iterator<MidiFileWriter> iterator = ServiceFactory.lookupProviders(MidiFileWriter.class);
        while (iterator.hasNext()) {
            object = iterator.next();
            int[] nArray = ((MidiFileWriter)object).getMidiFileTypes();
            int n2 = nArray.length;
            while (n2 > 0) {
                int n3;
                if (blArray[n3 = nArray[--n2]]) continue;
                ++n;
                blArray[n3] = true;
            }
        }
        object = new int[n];
        int n4 = blArray.length;
        while (n4 > 0) {
            if (!blArray[--n4]) continue;
            object[--n] = n4;
        }
        return object;
    }

    public static boolean isFileTypeSupported(int n) {
        Iterator<MidiFileWriter> iterator = ServiceFactory.lookupProviders(MidiFileWriter.class);
        while (iterator.hasNext()) {
            MidiFileWriter midiFileWriter = iterator.next();
            if (!midiFileWriter.isFileTypeSupported(n)) continue;
            return true;
        }
        return false;
    }

    public static int[] getMidiFileTypes(Sequence sequence) {
        Object object;
        boolean[] blArray = new boolean[3];
        int n = 0;
        Iterator<MidiFileWriter> iterator = ServiceFactory.lookupProviders(MidiFileWriter.class);
        while (iterator.hasNext()) {
            object = iterator.next();
            int[] nArray = ((MidiFileWriter)object).getMidiFileTypes(sequence);
            int n2 = nArray.length;
            while (n2 > 0) {
                int n3;
                if (blArray[n3 = nArray[--n2]]) continue;
                ++n;
                blArray[n3] = true;
            }
        }
        object = new int[n];
        int n4 = blArray.length;
        while (n4 > 0) {
            if (!blArray[--n4]) continue;
            object[--n] = n4;
        }
        return object;
    }

    public static boolean isFileTypeSupported(int n, Sequence sequence) {
        Iterator<MidiFileWriter> iterator = ServiceFactory.lookupProviders(MidiFileWriter.class);
        while (iterator.hasNext()) {
            MidiFileWriter midiFileWriter = iterator.next();
            if (!midiFileWriter.isFileTypeSupported(n, sequence)) continue;
            return true;
        }
        return false;
    }

    public static int write(Sequence sequence, int n, OutputStream outputStream) throws IOException {
        Iterator<MidiFileWriter> iterator = ServiceFactory.lookupProviders(MidiFileWriter.class);
        while (iterator.hasNext()) {
            MidiFileWriter midiFileWriter = iterator.next();
            if (!midiFileWriter.isFileTypeSupported(n, sequence)) continue;
            return midiFileWriter.write(sequence, n, outputStream);
        }
        throw new IllegalArgumentException("File type " + n + " is not supported");
    }

    public static int write(Sequence sequence, int n, File file) throws IOException {
        Iterator<MidiFileWriter> iterator = ServiceFactory.lookupProviders(MidiFileWriter.class);
        while (iterator.hasNext()) {
            MidiFileWriter midiFileWriter = iterator.next();
            if (!midiFileWriter.isFileTypeSupported(n, sequence)) continue;
            return midiFileWriter.write(sequence, n, file);
        }
        throw new IllegalArgumentException("File type " + n + " is not supported");
    }
}

