/*
 * Decompiled with CFR 0.152.
 */
package javax.security.auth.callback;

import java.io.Serializable;
import javax.security.auth.callback.Callback;

public class ConfirmationCallback
implements Callback,
Serializable {
    public static final int UNSPECIFIED_OPTION = -1;
    public static final int YES_NO_OPTION = 0;
    public static final int YES_NO_CANCEL_OPTION = 1;
    public static final int OK_CANCEL_OPTION = 2;
    public static final int YES = 0;
    public static final int NO = 1;
    public static final int CANCEL = 2;
    public static final int OK = 3;
    public static final int INFORMATION = 0;
    public static final int WARNING = 1;
    public static final int ERROR = 2;
    private String prompt;
    private int messageType;
    private int optionType;
    private int defaultOption;
    private String[] options = null;
    private int selection;

    public ConfirmationCallback(int n, int n2, int n3) throws IllegalArgumentException {
        this.setMessageType(n);
        this.setOptionType(n2, n3);
        this.defaultOption = n3;
    }

    public ConfirmationCallback(int n, String[] stringArray, int n2) {
        this.setMessageType(n);
        this.setOptions(stringArray, n2);
        this.defaultOption = n2;
    }

    public ConfirmationCallback(String string, int n, int n2, int n3) {
        this.setPrompt(string);
        this.setMessageType(n);
        this.setOptionType(n2, n3);
        this.defaultOption = n3;
    }

    public ConfirmationCallback(String string, int n, String[] stringArray, int n2) {
        this.setPrompt(string);
        this.setMessageType(n);
        this.setOptions(stringArray, n2);
        this.defaultOption = n2;
    }

    public String getPrompt() {
        return this.prompt;
    }

    public int getMessageType() {
        return this.messageType;
    }

    public int getOptionType() {
        if (this.options != null) {
            return -1;
        }
        return this.optionType;
    }

    public String[] getOptions() {
        return this.options;
    }

    public int getDefaultOption() {
        return this.defaultOption;
    }

    public void setSelectedIndex(int n) {
        if (this.options != null) {
            this.setOptions(this.options, n);
        } else {
            this.setOptionType(this.optionType, n);
        }
    }

    public int getSelectedIndex() {
        return this.selection;
    }

    private void setMessageType(int n) throws IllegalArgumentException {
        switch (n) {
            case 0: 
            case 1: 
            case 2: {
                this.messageType = n;
                break;
            }
            default: {
                throw new IllegalArgumentException("illegal message type");
            }
        }
    }

    private void setOptionType(int n, int n2) throws IllegalArgumentException {
        block0 : switch (n) {
            case 0: {
                this.optionType = n;
                switch (n2) {
                    case 0: 
                    case 1: {
                        this.selection = n2;
                        break block0;
                    }
                }
                throw new IllegalArgumentException("invalid option");
            }
            case 1: {
                this.optionType = n;
                switch (n2) {
                    case 0: 
                    case 1: 
                    case 2: {
                        this.selection = n2;
                        break block0;
                    }
                }
                throw new IllegalArgumentException("invalid option");
            }
            case 2: {
                this.optionType = n;
                switch (n2) {
                    case 2: 
                    case 3: {
                        this.selection = n2;
                        break block0;
                    }
                }
                throw new IllegalArgumentException("invalid option");
            }
            default: {
                throw new IllegalArgumentException("illegal option type");
            }
        }
    }

    private void setOptions(String[] stringArray, int n) throws IllegalArgumentException {
        if (n < 0 || n > stringArray.length - 1) {
            throw new IllegalArgumentException("invalid selection");
        }
        if (stringArray == null || stringArray.length == 0) {
            throw new IllegalArgumentException("options is null or empty");
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i] != null && stringArray[i].length() != 0) continue;
            throw new IllegalArgumentException("options[" + i + "] is null or empty");
        }
        this.options = stringArray;
        this.selection = n;
    }

    private void setPrompt(String string) throws IllegalArgumentException {
        if (string == null || string.length() == 0) {
            throw new IllegalArgumentException("prompt is null or empty");
        }
        this.prompt = string;
    }
}

