/*
 * Decompiled with CFR 0.152.
 */
package javax.print.attribute;

import java.io.Serializable;
import java.text.StringCharacterIterator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import javax.print.attribute.IntegerSyntax;

public abstract class SetOfIntegerSyntax
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 3666874174847632203L;
    private int[][] members;

    private static int[][] normalize(int[][] nArray, int n) {
        Arrays.sort(nArray, 0, n, new Comparator(){

            public int compare(Object object, Object object2) {
                int[] nArray = (int[])object;
                int[] nArray2 = (int[])object2;
                if (nArray[0] == nArray2[0]) {
                    return nArray[1] - nArray2[1];
                }
                return nArray[0] - nArray2[0];
            }
        });
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            int n3 = i;
            while (i + 1 < n && nArray[i + 1][0] <= nArray[i][1] + 1) {
                nArray[i][1] = Math.max(nArray[i][1], nArray[i + 1][1]);
                ++i;
            }
            nArray[n2++] = nArray[n3];
        }
        int[][] nArrayArray = new int[n2][];
        System.arraycopy(nArray, 0, nArrayArray, 0, n2);
        return nArrayArray;
    }

    protected SetOfIntegerSyntax(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("member may not be less than 0");
        }
        this.members = new int[][]{{n, n}};
    }

    protected SetOfIntegerSyntax(int[][] nArray) {
        int[][] nArrayArray;
        int n = 0;
        if (nArray == null) {
            nArrayArray = new int[][]{};
        } else {
            nArrayArray = new int[nArray.length][];
            for (int i = 0; i < nArray.length; ++i) {
                int n2;
                int n3;
                if (nArray[i].length == 1) {
                    n3 = nArray[i][0];
                    n2 = nArray[i][0];
                } else if (nArray[i].length == 2) {
                    n3 = nArray[i][0];
                    n2 = nArray[i][1];
                } else {
                    throw new IllegalArgumentException("invalid member element");
                }
                if (n3 <= n2 && n3 < 0) {
                    throw new IllegalArgumentException("invalid member element");
                }
                if (n3 > n2) continue;
                int[] nArray2 = new int[]{n3, n2};
                nArrayArray[n++] = nArray2;
            }
        }
        this.members = SetOfIntegerSyntax.normalize(nArrayArray, n);
    }

    private boolean skipWhitespace(StringCharacterIterator stringCharacterIterator) {
        while (Character.isWhitespace(stringCharacterIterator.current())) {
            stringCharacterIterator.next();
        }
        return stringCharacterIterator.current() == '\uffff';
    }

    private boolean skipNumber(StringCharacterIterator stringCharacterIterator) {
        boolean bl = false;
        while (Character.isDigit(stringCharacterIterator.current())) {
            bl = true;
            stringCharacterIterator.next();
        }
        return bl;
    }

    protected SetOfIntegerSyntax(String string) {
        if (string == null) {
            this.members = SetOfIntegerSyntax.normalize(new int[0][], 0);
        } else {
            ArrayList<int[]> arrayList = new ArrayList<int[]>();
            StringCharacterIterator stringCharacterIterator = new StringCharacterIterator(string);
            while (!this.skipWhitespace(stringCharacterIterator)) {
                int n = stringCharacterIterator.getIndex();
                if (!this.skipNumber(stringCharacterIterator)) {
                    throw new IllegalArgumentException();
                }
                int[] nArray = new int[2];
                nArray[0] = Integer.parseInt(string.substring(n, stringCharacterIterator.getIndex()));
                if (!this.skipWhitespace(stringCharacterIterator)) {
                    char c = stringCharacterIterator.current();
                    if (c == ':' || c == '-') {
                        stringCharacterIterator.next();
                        if (this.skipWhitespace(stringCharacterIterator)) {
                            throw new IllegalArgumentException();
                        }
                        n = stringCharacterIterator.getIndex();
                        if (!this.skipNumber(stringCharacterIterator)) {
                            throw new IllegalArgumentException();
                        }
                        nArray[1] = Integer.parseInt(string.substring(n, stringCharacterIterator.getIndex()));
                    } else {
                        nArray[1] = nArray[0];
                    }
                } else {
                    nArray[1] = nArray[0];
                }
                if (nArray[0] <= nArray[1]) {
                    arrayList.add(nArray);
                }
                if (this.skipWhitespace(stringCharacterIterator)) break;
                if (stringCharacterIterator.current() != ',') {
                    throw new IllegalArgumentException();
                }
                stringCharacterIterator.next();
            }
            this.members = SetOfIntegerSyntax.normalize((int[][])arrayList.toArray((T[])new int[0][]), arrayList.size());
        }
    }

    protected SetOfIntegerSyntax(int n, int n2) {
        int[][] nArrayArray;
        if (n <= n2 && n < 0) {
            throw new IllegalArgumentException();
        }
        if (n <= n2) {
            int[][] nArrayArray2 = new int[1][];
            nArrayArray = nArrayArray2;
            nArrayArray2[0] = new int[]{n, n2};
        } else {
            nArrayArray = new int[][]{};
        }
        this.members = nArrayArray;
    }

    public boolean contains(int n) {
        for (int i = 0; i < this.members.length; ++i) {
            if (n < this.members[i][0]) {
                return false;
            }
            if (n > this.members[i][1]) continue;
            return true;
        }
        return false;
    }

    public boolean contains(IntegerSyntax integerSyntax) {
        return this.contains(integerSyntax.getValue());
    }

    public boolean equals(Object object) {
        if (!(object instanceof SetOfIntegerSyntax)) {
            return false;
        }
        SetOfIntegerSyntax setOfIntegerSyntax = (SetOfIntegerSyntax)object;
        if (setOfIntegerSyntax.members.length != this.members.length) {
            return false;
        }
        for (int i = 0; i < this.members.length; ++i) {
            if (this.members[i][0] == setOfIntegerSyntax.members[i][0] && this.members[i][1] == setOfIntegerSyntax.members[i][1]) continue;
            return false;
        }
        return true;
    }

    public int[][] getMembers() {
        return (int[][])this.members.clone();
    }

    public int hashCode() {
        int n = 0;
        for (int i = 0; i < this.members.length; ++i) {
            n += this.members[i][0] + this.members[i][1];
        }
        return n;
    }

    public int next(int n) {
        for (int i = 0; i < this.members.length; ++i) {
            if (n >= this.members[i][1]) continue;
            if (n < this.members[i][0]) {
                return this.members[i][0];
            }
            return n + 1;
        }
        return -1;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < this.members.length; ++i) {
            if (i > 0) {
                stringBuilder.append(',');
            }
            stringBuilder.append(this.members[i][0]);
            if (this.members[i][0] == this.members[i][1]) continue;
            stringBuilder.append('-');
            stringBuilder.append(this.members[i][1]);
        }
        return stringBuilder.toString();
    }
}

