/*
 * Decompiled with CFR 0.152.
 */
package javax.print.attribute;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import javax.print.attribute.Attribute;
import javax.print.attribute.AttributeSet;
import javax.print.attribute.AttributeSetUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HashAttributeSet
implements AttributeSet,
Serializable {
    private static final long serialVersionUID = 5311560590283707917L;
    private Class myInterface;
    private transient HashMap attributeMap = new HashMap();

    public HashAttributeSet() {
        this(Attribute.class);
    }

    public HashAttributeSet(Attribute attribute) {
        this(attribute, Attribute.class);
    }

    public HashAttributeSet(Attribute[] attributeArray) {
        this(attributeArray, Attribute.class);
    }

    public HashAttributeSet(AttributeSet attributeSet) {
        this(attributeSet, Attribute.class);
    }

    protected HashAttributeSet(Class<?> clazz) {
        if (clazz == null) {
            throw new NullPointerException("interfaceName may not be null");
        }
        this.myInterface = clazz;
    }

    protected HashAttributeSet(Attribute attribute, Class<?> clazz) {
        this(clazz);
        if (attribute == null) {
            throw new NullPointerException();
        }
        this.addInternal(attribute, clazz);
    }

    protected HashAttributeSet(Attribute[] attributeArray, Class<?> clazz) {
        this(clazz);
        if (attributeArray != null) {
            for (int i = 0; i < attributeArray.length; ++i) {
                this.addInternal(attributeArray[i], clazz);
            }
        }
    }

    protected HashAttributeSet(AttributeSet attributeSet, Class<?> clazz) {
        this(clazz);
        if (attributeSet != null) {
            this.addAllInternal(attributeSet, clazz);
        }
    }

    @Override
    public boolean add(Attribute attribute) {
        return this.addInternal(attribute, this.myInterface);
    }

    private boolean addInternal(Attribute attribute, Class clazz) {
        if (attribute == null) {
            throw new NullPointerException("attribute may not be null");
        }
        AttributeSetUtilities.verifyAttributeCategory(clazz, this.myInterface);
        Attribute attribute2 = this.attributeMap.put(attribute.getCategory(), AttributeSetUtilities.verifyAttributeValue(attribute, clazz));
        return !attribute.equals(attribute2);
    }

    @Override
    public boolean addAll(AttributeSet attributeSet) {
        return this.addAllInternal(attributeSet, this.myInterface);
    }

    private boolean addAllInternal(AttributeSet attributeSet, Class clazz) {
        boolean bl = false;
        Attribute[] attributeArray = attributeSet.toArray();
        for (int i = 0; i < attributeArray.length; ++i) {
            if (!this.addInternal(attributeArray[i], clazz)) continue;
            bl = true;
        }
        return bl;
    }

    @Override
    public void clear() {
        this.attributeMap.clear();
    }

    @Override
    public boolean containsKey(Class<?> clazz) {
        return this.attributeMap.containsKey(clazz);
    }

    @Override
    public boolean containsValue(Attribute attribute) {
        return this.attributeMap.containsValue(attribute);
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof HashAttributeSet)) {
            return false;
        }
        return this.attributeMap.equals(((HashAttributeSet)object).attributeMap);
    }

    @Override
    public Attribute get(Class<?> clazz) {
        if (clazz == null) {
            throw new NullPointerException("category may not be null");
        }
        return (Attribute)this.attributeMap.get(clazz);
    }

    @Override
    public int hashCode() {
        int n = 0;
        Iterator iterator = this.attributeMap.values().iterator();
        while (iterator.hasNext()) {
            n += iterator.next().hashCode();
        }
        return n;
    }

    @Override
    public boolean isEmpty() {
        return this.attributeMap.isEmpty();
    }

    @Override
    public boolean remove(Attribute attribute) {
        if (attribute == null) {
            return false;
        }
        return this.attributeMap.remove(attribute.getCategory()) != null;
    }

    @Override
    public boolean remove(Class<?> clazz) {
        if (clazz == null) {
            return false;
        }
        return this.attributeMap.remove(clazz) != null;
    }

    @Override
    public int size() {
        return this.attributeMap.size();
    }

    @Override
    public Attribute[] toArray() {
        int n = 0;
        Iterator iterator = this.attributeMap.values().iterator();
        Attribute[] attributeArray = new Attribute[this.size()];
        while (iterator.hasNext()) {
            attributeArray[n] = (Attribute)iterator.next();
            ++n;
        }
        return attributeArray;
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        this.myInterface = (Class)objectInputStream.readObject();
        int n = objectInputStream.readInt();
        this.attributeMap = new HashMap(n);
        for (int i = 0; i < n; ++i) {
            this.add((Attribute)objectInputStream.readObject());
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeObject(this.myInterface);
        objectOutputStream.writeInt(this.size());
        Iterator iterator = this.attributeMap.values().iterator();
        while (iterator.hasNext()) {
            objectOutputStream.writeObject(iterator.next());
        }
    }
}

