/*
 * Decompiled with CFR 0.152.
 */
package javax.net.ssl;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.security.KeyStore;
import java.security.Security;
import javax.net.SocketFactory;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;

public abstract class SSLSocketFactory
extends SocketFactory {
    private static SSLContext context;

    public static synchronized SocketFactory getDefault() {
        TrustManager[] trustManagerArray;
        KeyManager[] keyManagerArray;
        try {
            keyManagerArray = Security.getProperty("ssl.SocketFactory.provider");
            trustManagerArray = ClassLoader.getSystemClassLoader();
            if (keyManagerArray != null && trustManagerArray != null) {
                return (SocketFactory)trustManagerArray.loadClass((String)keyManagerArray).newInstance();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (context == null) {
            Object object;
            keyManagerArray = null;
            trustManagerArray = null;
            String string = KeyManagerFactory.getDefaultAlgorithm();
            String string2 = TrustManagerFactory.getDefaultAlgorithm();
            try {
                object = KeyManagerFactory.getInstance(string);
                ((KeyManagerFactory)object).init(null, null);
                keyManagerArray = ((KeyManagerFactory)object).getKeyManagers();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                object = TrustManagerFactory.getInstance(string2);
                ((TrustManagerFactory)object).init((KeyStore)null);
                trustManagerArray = ((TrustManagerFactory)object).getTrustManagers();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                context = SSLContext.getInstance("SSLv3");
                context.init(keyManagerArray, trustManagerArray, null);
            }
            catch (Exception exception) {
                return new ErrorSocketFactory(new RuntimeException("error instantiating default socket factory: " + exception.toString(), exception));
            }
        }
        try {
            return context.getSocketFactory();
        }
        catch (Exception exception) {
            return new ErrorSocketFactory(new RuntimeException("no SSLSocketFactory implementation available"));
        }
    }

    public abstract Socket createSocket(Socket var1, String var2, int var3, boolean var4) throws IOException;

    public abstract String[] getDefaultCipherSuites();

    public abstract String[] getSupportedCipherSuites();

    private static final class ErrorSocketFactory
    extends SSLSocketFactory {
        private RuntimeException x;

        ErrorSocketFactory(RuntimeException runtimeException) {
            this.x = runtimeException;
        }

        public Socket createSocket() throws IOException {
            throw (IOException)new IOException().initCause(this.x);
        }

        public Socket createSocket(String string, int n) throws IOException {
            throw (IOException)new IOException().initCause(this.x);
        }

        public Socket createSocket(String string, int n, InetAddress inetAddress, int n2) throws IOException {
            throw (IOException)new IOException().initCause(this.x);
        }

        public Socket createSocket(InetAddress inetAddress, int n) throws IOException {
            throw (IOException)new IOException().initCause(this.x);
        }

        public Socket createSocket(InetAddress inetAddress, int n, InetAddress inetAddress2, int n2) throws IOException {
            throw (IOException)new IOException().initCause(this.x);
        }

        public String[] getDefaultCipherSuites() {
            throw new RuntimeException(this.x);
        }

        public String[] getSupportedCipherSuites() {
            throw new RuntimeException(this.x);
        }

        public Socket createSocket(Socket socket, String string, int n, boolean bl) throws IOException {
            throw new RuntimeException(this.x);
        }
    }
}

