/*
 * Decompiled with CFR 0.152.
 */
package javax.net.ssl;

public class SSLEngineResult {
    private final HandshakeStatus handshakeStatus;
    private final Status status;
    private final int bytesConsumed;
    private final int bytesProduced;

    public SSLEngineResult(Status status, HandshakeStatus handshakeStatus, int n, int n2) {
        if (status == null) {
            throw new IllegalArgumentException("'status' may not be null");
        }
        if (handshakeStatus == null) {
            throw new IllegalArgumentException("'handshakeStatus' may not be null");
        }
        if (n < 0) {
            throw new IllegalArgumentException("'bytesConumed' must be nonnegative");
        }
        if (n2 < 0) {
            throw new IllegalArgumentException("'bytesProduced' must be nonnegative");
        }
        this.status = status;
        this.handshakeStatus = handshakeStatus;
        this.bytesConsumed = n;
        this.bytesProduced = n2;
    }

    public int bytesConsumed() {
        return this.bytesConsumed;
    }

    public int bytesProduced() {
        return this.bytesProduced;
    }

    public HandshakeStatus getHandshakeStatus() {
        return this.handshakeStatus;
    }

    public Status getStatus() {
        return this.status;
    }

    public String toString() {
        return super.toString() + " [ status: " + (Object)((Object)this.status) + "; handshakeStatus: " + (Object)((Object)this.handshakeStatus) + "; bytesConsumed: " + this.bytesConsumed + "; bytesProduced: " + this.bytesProduced + " ]";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum HandshakeStatus {
        NOT_HANDSHAKING,
        FINISHED,
        NEED_TASK,
        NEED_WRAP,
        NEED_UNWRAP;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Status {
        BUFFER_UNDERFLOW,
        BUFFER_OVERFLOW,
        OK,
        CLOSED;

    }
}

