/*
 * Decompiled with CFR 0.152.
 */
package javax.naming.directory;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.NoSuchElementException;
import java.util.Vector;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasicAttributes
implements Attributes {
    private static final long serialVersionUID = 4980164073184639448L;
    private boolean ignoreCase;
    transient Vector<Attribute> attributes;

    public BasicAttributes() {
        this(false);
    }

    public BasicAttributes(boolean bl) {
        this.ignoreCase = bl;
        this.attributes = new Vector();
    }

    public BasicAttributes(String string, Object object) {
        this(string, object, false);
    }

    public BasicAttributes(String string, Object object, boolean bl) {
        this.ignoreCase = bl;
        this.attributes = new Vector();
        this.attributes.add(new BasicAttribute(string, object));
    }

    @Override
    public Object clone() {
        BasicAttributes basicAttributes = new BasicAttributes(this.ignoreCase);
        basicAttributes.attributes = (Vector)this.attributes.clone();
        return basicAttributes;
    }

    public boolean equals(Object object) {
        if (!(object instanceof Attributes)) {
            return false;
        }
        Attributes attributes = (Attributes)object;
        if (this.ignoreCase != attributes.isCaseIgnored() || this.attributes.size() != attributes.size()) {
            return false;
        }
        NamingEnumeration<? extends Attribute> namingEnumeration = attributes.getAll();
        while (namingEnumeration.hasMoreElements()) {
            Attribute attribute;
            Attribute attribute2 = (Attribute)namingEnumeration.nextElement();
            if (attribute2.equals(attribute = this.get(attribute2.getID()))) continue;
            return false;
        }
        return true;
    }

    @Override
    public Attribute get(String string) {
        for (int i = 0; i < this.attributes.size(); ++i) {
            Attribute attribute = this.attributes.get(i);
            if ((!this.ignoreCase || !string.equalsIgnoreCase(attribute.getID())) && (this.ignoreCase || !string.equals(attribute.getID()))) continue;
            return attribute;
        }
        return null;
    }

    public NamingEnumeration<Attribute> getAll() {
        return new BasicAttributesEnumeration();
    }

    @Override
    public NamingEnumeration<String> getIDs() {
        final NamingEnumeration<Attribute> namingEnumeration = this.getAll();
        return new NamingEnumeration<String>(){

            @Override
            public boolean hasMore() throws NamingException {
                return namingEnumeration.hasMore();
            }

            @Override
            public boolean hasMoreElements() {
                return namingEnumeration.hasMoreElements();
            }

            @Override
            public String next() throws NamingException {
                return ((Attribute)namingEnumeration.next()).getID();
            }

            @Override
            public String nextElement() {
                return ((Attribute)namingEnumeration.nextElement()).getID();
            }

            @Override
            public void close() throws NamingException {
                namingEnumeration.close();
            }
        };
    }

    public int hashCode() {
        int n = 0;
        for (int i = 0; i < this.attributes.size(); ++i) {
            n += this.attributes.get(i).hashCode();
        }
        return n;
    }

    @Override
    public boolean isCaseIgnored() {
        return this.ignoreCase;
    }

    @Override
    public Attribute put(Attribute attribute) {
        Attribute attribute2 = this.remove(attribute.getID());
        this.attributes.add(attribute);
        return attribute2;
    }

    @Override
    public Attribute put(String string, Object object) {
        return this.put(new BasicAttribute(string, object));
    }

    @Override
    public Attribute remove(String string) {
        for (int i = 0; i < this.attributes.size(); ++i) {
            Attribute attribute = this.attributes.get(i);
            if ((!this.ignoreCase || !string.equalsIgnoreCase(attribute.getID())) && (this.ignoreCase || !string.equals(attribute.getID()))) continue;
            this.attributes.remove(i);
            return attribute;
        }
        return null;
    }

    @Override
    public int size() {
        return this.attributes.size();
    }

    public String toString() {
        String string = "";
        for (int i = 0; i < this.attributes.size(); ++i) {
            if (i > 0) {
                string = string + "; ";
            }
            string = string + this.attributes.get(i).toString();
        }
        return string;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        int n = objectInputStream.readInt();
        this.attributes = new Vector(n);
        for (int i = 0; i < n; ++i) {
            this.attributes.add((Attribute)objectInputStream.readObject());
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeInt(this.attributes.size());
        for (int i = 0; i < this.attributes.size(); ++i) {
            objectOutputStream.writeObject(this.attributes.get(i));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class BasicAttributesEnumeration
    implements NamingEnumeration<Attribute> {
        int where = 0;

        @Override
        public void close() throws NamingException {
        }

        @Override
        public boolean hasMore() throws NamingException {
            return this.hasMoreElements();
        }

        @Override
        public Attribute next() throws NamingException {
            return this.nextElement();
        }

        @Override
        public boolean hasMoreElements() {
            return this.where < BasicAttributes.this.attributes.size();
        }

        @Override
        public Attribute nextElement() throws NoSuchElementException {
            if (this.where >= BasicAttributes.this.attributes.size()) {
                throw new NoSuchElementException("no more elements");
            }
            Attribute attribute = BasicAttributes.this.attributes.get(this.where);
            ++this.where;
            return attribute;
        }
    }
}

