/*
 * Decompiled with CFR 0.152.
 */
package javax.naming;

import java.applet.Applet;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Properties;
import javax.naming.Binding;
import javax.naming.CannotProceedException;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NameClassPair;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.OperationNotSupportedException;
import javax.naming.spi.NamingManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InitialContext
implements Context {
    protected Context defaultInitCtx;
    protected boolean gotDefault = false;
    protected Hashtable<Object, Object> myProps;
    static final HashSet<String> colon_list = new HashSet();
    static final String[] use_properties;

    public InitialContext(Hashtable<?, ?> hashtable) throws NamingException {
        this.init(hashtable);
    }

    protected InitialContext(boolean bl) throws NamingException {
        if (!bl) {
            this.init(null);
        }
    }

    public InitialContext() throws NamingException {
        this.init(null);
    }

    protected void init(Hashtable<?, ?> hashtable) throws NamingException {
        InputStream inputStream;
        Properties properties;
        Object object;
        Object object2;
        this.myProps = hashtable != null ? hashtable : new Hashtable();
        Applet applet = (Applet)this.myProps.get("java.naming.applet");
        Properties properties2 = null;
        if (applet != null) {
            properties2 = new Properties();
        }
        Properties properties3 = new Properties();
        for (int i = use_properties.length - 1; i >= 0; --i) {
            String string;
            object2 = use_properties[i];
            if (applet != null && (string = applet.getParameter((String)object2)) != null) {
                properties2.put(object2, string);
            }
            if ((string = System.getProperty((String)object2)) == null) continue;
            properties3.put(object2, string);
        }
        InitialContext.merge(this.myProps, properties3);
        if (properties2 != null) {
            InitialContext.merge(this.myProps, properties2);
        }
        try {
            object = Thread.currentThread().getContextClassLoader().getResources("jndi.properties");
            while (object.hasMoreElements()) {
                object2 = (URL)object.nextElement();
                properties = new Properties();
                try {
                    inputStream = ((URL)object2).openStream();
                    properties.load(inputStream);
                    inputStream.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                InitialContext.merge(this.myProps, properties);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if ((object = System.getProperty("gnu.classpath.home.url")) != null) {
            object2 = (String)object + "/jndi.properties";
            properties = new Properties();
            try {
                inputStream = new URL((String)object2).openStream();
                properties.load(inputStream);
                inputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            InitialContext.merge(this.myProps, properties);
        }
    }

    static void merge(Hashtable<Object, Object> hashtable, Hashtable<Object, Object> hashtable2) {
        Enumeration<Object> enumeration = hashtable2.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            Object object = hashtable.get(string);
            if (object == null) {
                hashtable.put(string, hashtable2.get(string));
                continue;
            }
            if (!colon_list.contains(string)) continue;
            String string2 = (String)hashtable2.get(string);
            hashtable.put(string, (String)object + ":" + string2);
        }
    }

    protected Context getDefaultInitCtx() throws NamingException {
        if (!this.gotDefault) {
            this.defaultInitCtx = NamingManager.getInitialContext(this.myProps);
            this.gotDefault = true;
        }
        return this.defaultInitCtx;
    }

    protected Context getURLOrDefaultInitCtx(Name name) throws NamingException {
        if (name.size() > 0) {
            return this.getURLOrDefaultInitCtx(name.get(0));
        }
        return this.getDefaultInitCtx();
    }

    protected Context getURLOrDefaultInitCtx(String string) throws NamingException {
        Context context;
        String string2 = null;
        if (NamingManager.hasInitialContextFactoryBuilder()) {
            return this.getDefaultInitCtx();
        }
        int n = string.indexOf(58);
        int n2 = string.indexOf(47);
        if (n > 0 && (n2 == -1 || n < n2)) {
            string2 = string.substring(0, n);
        }
        if (string2 != null && (context = NamingManager.getURLContext(string2, this.myProps)) != null) {
            return context;
        }
        return this.getDefaultInitCtx();
    }

    @Override
    public void bind(Name name, Object object) throws NamingException {
        this.getURLOrDefaultInitCtx(name).bind(name, object);
    }

    @Override
    public void bind(String string, Object object) throws NamingException {
        this.getURLOrDefaultInitCtx(string).bind(string, object);
    }

    @Override
    public Object lookup(Name name) throws NamingException {
        try {
            return this.getURLOrDefaultInitCtx(name).lookup(name);
        }
        catch (CannotProceedException cannotProceedException) {
            Context context = NamingManager.getContinuationContext(cannotProceedException);
            return context.lookup(cannotProceedException.getRemainingName());
        }
    }

    @Override
    public Object lookup(String string) throws NamingException {
        try {
            return this.getURLOrDefaultInitCtx(string).lookup(string);
        }
        catch (CannotProceedException cannotProceedException) {
            Context context = NamingManager.getContinuationContext(cannotProceedException);
            return context.lookup(cannotProceedException.getRemainingName());
        }
    }

    @Override
    public void rebind(Name name, Object object) throws NamingException {
        this.getURLOrDefaultInitCtx(name).rebind(name, object);
    }

    @Override
    public void rebind(String string, Object object) throws NamingException {
        this.getURLOrDefaultInitCtx(string).rebind(string, object);
    }

    @Override
    public void unbind(Name name) throws NamingException {
        this.getURLOrDefaultInitCtx(name).unbind(name);
    }

    @Override
    public void unbind(String string) throws NamingException {
        this.getURLOrDefaultInitCtx(string).unbind(string);
    }

    @Override
    public void rename(Name name, Name name2) throws NamingException {
        this.getURLOrDefaultInitCtx(name).rename(name, name2);
    }

    @Override
    public void rename(String string, String string2) throws NamingException {
        this.getURLOrDefaultInitCtx(string).rename(string, string2);
    }

    @Override
    public NamingEnumeration<NameClassPair> list(Name name) throws NamingException {
        return this.getURLOrDefaultInitCtx(name).list(name);
    }

    @Override
    public NamingEnumeration<NameClassPair> list(String string) throws NamingException {
        return this.getURLOrDefaultInitCtx(string).list(string);
    }

    @Override
    public NamingEnumeration<Binding> listBindings(Name name) throws NamingException {
        return this.getURLOrDefaultInitCtx(name).listBindings(name);
    }

    @Override
    public NamingEnumeration<Binding> listBindings(String string) throws NamingException {
        return this.getURLOrDefaultInitCtx(string).listBindings(string);
    }

    @Override
    public void destroySubcontext(Name name) throws NamingException {
        this.getURLOrDefaultInitCtx(name).destroySubcontext(name);
    }

    @Override
    public void destroySubcontext(String string) throws NamingException {
        this.getURLOrDefaultInitCtx(string).destroySubcontext(string);
    }

    @Override
    public Context createSubcontext(Name name) throws NamingException {
        return this.getURLOrDefaultInitCtx(name).createSubcontext(name);
    }

    @Override
    public Context createSubcontext(String string) throws NamingException {
        return this.getURLOrDefaultInitCtx(string).createSubcontext(string);
    }

    @Override
    public Object lookupLink(Name name) throws NamingException {
        return this.getURLOrDefaultInitCtx(name).lookupLink(name);
    }

    @Override
    public Object lookupLink(String string) throws NamingException {
        return this.getURLOrDefaultInitCtx(string).lookupLink(string);
    }

    @Override
    public NameParser getNameParser(Name name) throws NamingException {
        return this.getURLOrDefaultInitCtx(name).getNameParser(name);
    }

    @Override
    public NameParser getNameParser(String string) throws NamingException {
        return this.getURLOrDefaultInitCtx(string).getNameParser(string);
    }

    @Override
    public Name composeName(Name name, Name name2) throws NamingException {
        return this.getURLOrDefaultInitCtx(name).composeName(name, name2);
    }

    @Override
    public String composeName(String string, String string2) throws NamingException {
        return this.getURLOrDefaultInitCtx(string).composeName(string, string2);
    }

    @Override
    public Object addToEnvironment(String string, Object object) throws NamingException {
        return this.myProps.put(string, object);
    }

    @Override
    public Object removeFromEnvironment(String string) throws NamingException {
        return this.myProps.remove(string);
    }

    @Override
    public Hashtable<?, ?> getEnvironment() throws NamingException {
        return this.myProps;
    }

    @Override
    public void close() throws NamingException {
        this.myProps = null;
        this.defaultInitCtx = null;
    }

    @Override
    public String getNameInNamespace() throws NamingException {
        throw new OperationNotSupportedException();
    }

    static {
        colon_list.add("java.naming.factory.object");
        colon_list.add("java.naming.factory.url.pkgs");
        colon_list.add("java.naming.factory.state");
        use_properties = new String[]{"java.naming.dns.url", "java.naming.factory.initial", "java.naming.factory.object", "java.naming.provider.url", "java.naming.factory.state", "java.naming.factory.url.pkgs"};
    }
}

