/*
 * Decompiled with CFR 0.152.
 */
package javax.naming;

import gnu.java.lang.CPStringBuilder;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.Vector;
import javax.naming.InvalidNameException;
import javax.naming.Name;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompositeName
implements Name,
Cloneable,
Serializable {
    private static final long serialVersionUID = 1667768148915813118L;
    private transient Vector<String> elts = new Vector();

    public CompositeName() {
    }

    protected CompositeName(Enumeration<String> enumeration) {
        try {
            while (enumeration.hasMoreElements()) {
                this.elts.add(enumeration.nextElement());
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    public CompositeName(String string) throws InvalidNameException {
        int n = 120;
        boolean bl = false;
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < string.length(); ++i) {
            int n2 = string.charAt(i);
            if (bl) {
                bl = false;
            } else {
                if (n2 == 92) {
                    bl = true;
                    continue;
                }
                if (n != 120) {
                    if (n == n2) {
                        if (i + 1 < string.length() && string.charAt(i + 1) != '/') {
                            throw new InvalidNameException("close quote before end of component");
                        }
                        this.elts.add(stringBuilder.toString());
                        stringBuilder.setLength(0);
                        n = 120;
                        continue;
                    }
                } else {
                    if (stringBuilder.length() == 0 && (n2 == 39 || n2 == 34)) {
                        n = n2;
                        continue;
                    }
                    if (n2 == 47) {
                        this.elts.add(stringBuilder.toString());
                        stringBuilder.setLength(0);
                        continue;
                    }
                }
            }
            stringBuilder.append((char)n2);
        }
        if (stringBuilder.length() != 0) {
            this.elts.add(stringBuilder.toString());
        }
        if (n != 120) {
            throw new InvalidNameException("unterminated quote");
        }
        if (bl) {
            throw new InvalidNameException("trailing escape character");
        }
    }

    @Override
    public Name add(int n, String string) throws InvalidNameException {
        this.elts.add(n, string);
        return this;
    }

    @Override
    public Name add(String string) throws InvalidNameException {
        this.elts.add(string);
        return this;
    }

    @Override
    public Name addAll(int n, Name name) throws InvalidNameException {
        Enumeration<String> enumeration = name.getAll();
        try {
            while (enumeration.hasMoreElements()) {
                this.elts.add(n, enumeration.nextElement());
                ++n;
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        return this;
    }

    @Override
    public Name addAll(Name name) throws InvalidNameException {
        Enumeration<String> enumeration = name.getAll();
        try {
            while (enumeration.hasMoreElements()) {
                this.elts.add(enumeration.nextElement());
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        return this;
    }

    @Override
    public Object clone() {
        return new CompositeName(this.elts.elements());
    }

    @Override
    public int compareTo(Object object) {
        if (object == null || !(object instanceof CompositeName)) {
            throw new ClassCastException("CompositeName.compareTo() expected CompositeName");
        }
        CompositeName compositeName = (CompositeName)object;
        int n = Math.min(compositeName.elts.size(), this.elts.size());
        for (int i = 0; i < n; ++i) {
            String string = this.elts.get(i);
            int n2 = string.compareTo(compositeName.elts.get(i));
            if (n2 == 0) continue;
            return n2;
        }
        return this.elts.size() - compositeName.elts.size();
    }

    @Override
    public boolean endsWith(Name name) {
        if (!(name instanceof CompositeName)) {
            return false;
        }
        CompositeName compositeName = (CompositeName)name;
        if (compositeName.elts.size() > this.elts.size()) {
            return false;
        }
        int n = this.elts.size() - compositeName.elts.size();
        for (int i = 0; i < compositeName.elts.size(); ++i) {
            if (compositeName.elts.get(i).equals(this.elts.get(n + i))) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object object) {
        if (!(object instanceof CompositeName)) {
            return false;
        }
        CompositeName compositeName = (CompositeName)object;
        return this.elts.equals(compositeName.elts);
    }

    @Override
    public String get(int n) {
        return this.elts.get(n);
    }

    @Override
    public Enumeration<String> getAll() {
        return this.elts.elements();
    }

    @Override
    public Name getPrefix(int n) {
        CompositeName compositeName = new CompositeName();
        for (int i = 0; i < n; ++i) {
            compositeName.elts.add(this.elts.get(i));
        }
        return compositeName;
    }

    @Override
    public Name getSuffix(int n) {
        if (n > this.elts.size()) {
            throw new ArrayIndexOutOfBoundsException(n);
        }
        CompositeName compositeName = new CompositeName();
        for (int i = n; i < this.elts.size(); ++i) {
            compositeName.elts.add(this.elts.get(i));
        }
        return compositeName;
    }

    public int hashCode() {
        int n = 0;
        for (int i = 0; i < this.elts.size(); ++i) {
            n += this.elts.get(i).hashCode();
        }
        return n;
    }

    @Override
    public boolean isEmpty() {
        return this.elts.isEmpty();
    }

    @Override
    public Object remove(int n) throws InvalidNameException {
        return this.elts.remove(n);
    }

    @Override
    public int size() {
        return this.elts.size();
    }

    @Override
    public boolean startsWith(Name name) {
        if (!(name instanceof CompositeName)) {
            return false;
        }
        CompositeName compositeName = (CompositeName)name;
        if (compositeName.elts.size() > this.elts.size()) {
            return false;
        }
        for (int i = 0; i < compositeName.elts.size(); ++i) {
            if (compositeName.elts.get(i).equals(this.elts.get(i))) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        CPStringBuilder cPStringBuilder = new CPStringBuilder();
        for (int i = 0; i < this.elts.size(); ++i) {
            String string = this.elts.get(i);
            if (i > 0 || i == this.elts.size() - 1 && string.equals("")) {
                cPStringBuilder.append('/');
            }
            for (int j = 0; j < string.length(); ++j) {
                char c = string.charAt(j);
                if (j == 0 && (c == '\"' || c == '\'') || c == '\\' && (j == string.length() - 1 || "\\'\"/".indexOf(string.charAt(j + 1)) != -1) || c == '/') {
                    cPStringBuilder.append('\\');
                }
                cPStringBuilder.append(c);
            }
        }
        return cPStringBuilder.toString();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        int n = objectInputStream.readInt();
        this.elts = new Vector(n);
        for (int i = 0; i < n; ++i) {
            this.elts.add((String)objectInputStream.readObject());
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeInt(this.elts.size());
        for (int i = 0; i < this.elts.size(); ++i) {
            objectOutputStream.writeObject(this.elts.get(i));
        }
    }
}

