/*
 * Decompiled with CFR 0.152.
 */
package javax.management.openmbean;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.TabularData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TabularType
extends OpenType<TabularData> {
    private static final long serialVersionUID = 6554071860220659261L;
    private CompositeType rowType;
    private List<String> indexNames;
    private transient Integer hashCode;
    private transient String string;

    public TabularType(String string, String string2, CompositeType compositeType, String[] stringArray) throws OpenDataException {
        super(TabularData.class.getName(), string, string2);
        if (compositeType == null) {
            throw new IllegalArgumentException("A null row type was given.");
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i] == null) {
                throw new IllegalArgumentException("Name " + i + " is null.");
            }
            if (stringArray[i].length() == 0) {
                throw new IllegalArgumentException("Name " + i + " is the empty string.");
            }
            if (compositeType.containsKey(stringArray[i])) continue;
            throw new OpenDataException("No matching key for " + stringArray[i] + " was found in the supplied row type.");
        }
        this.rowType = compositeType;
        this.indexNames = Collections.unmodifiableList(Arrays.asList(stringArray));
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof TabularType)) {
            return false;
        }
        TabularType tabularType = (TabularType)object;
        return tabularType.getTypeName().equals(this.getTypeName()) && tabularType.getRowType().equals(this.getRowType()) && tabularType.getIndexNames().equals(this.getIndexNames());
    }

    public List<String> getIndexNames() {
        return this.indexNames;
    }

    public CompositeType getRowType() {
        return this.rowType;
    }

    @Override
    public int hashCode() {
        if (this.hashCode == null) {
            int n = 0;
            for (String string : this.indexNames) {
                n += string.hashCode();
            }
            this.hashCode = n + this.getTypeName().hashCode() + this.rowType.hashCode();
        }
        return this.hashCode;
    }

    @Override
    public boolean isValue(Object object) {
        if (object instanceof TabularData) {
            TabularData tabularData = (TabularData)object;
            return this.equals(tabularData.getTabularType());
        }
        return false;
    }

    @Override
    public String toString() {
        if (this.string == null) {
            this.string = this.getClass().getName() + "[name=" + this.getTypeName() + ", rowType=" + this.rowType + ", indexNames=" + this.indexNames + "]";
        }
        return this.string;
    }
}

