/*
 * Decompiled with CFR 0.152.
 */
package javax.management.openmbean;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.InvalidKeyException;
import javax.management.openmbean.InvalidOpenTypeException;
import javax.management.openmbean.KeyAlreadyExistsException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.TabularData;
import javax.management.openmbean.TabularType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TabularDataSupport
implements TabularData,
Serializable,
Cloneable,
Map<Object, Object> {
    private static final long serialVersionUID = 5720150593236309827L;
    private HashMap<Object, Object> dataMap;
    private TabularType tabularType;

    public TabularDataSupport(TabularType tabularType) {
        this(tabularType, 101, 0.75f);
    }

    public TabularDataSupport(TabularType tabularType, int n, float f) {
        if (tabularType == null) {
            throw new IllegalArgumentException("The type may not be null.");
        }
        this.tabularType = tabularType;
        this.dataMap = new HashMap(n, f);
    }

    @Override
    public Object[] calculateIndex(CompositeData compositeData) {
        if (!compositeData.getCompositeType().equals(this.tabularType.getRowType())) {
            throw new InvalidOpenTypeException("The type of the given value does not match the row type of this instance.");
        }
        List<String> list2 = this.tabularType.getIndexNames();
        ArrayList<String> arrayList = new ArrayList<String>(list2.size());
        for (String string : list2) {
            arrayList.add(compositeData.get(string).toString());
        }
        return arrayList.toArray();
    }

    @Override
    public void clear() {
        this.dataMap.clear();
    }

    public Object clone() {
        TabularDataSupport tabularDataSupport = null;
        try {
            tabularDataSupport = (TabularDataSupport)super.clone();
            tabularDataSupport.setMap((HashMap)this.dataMap.clone());
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return tabularDataSupport;
    }

    @Override
    public boolean containsKey(Object object) {
        if (object instanceof Object[]) {
            return this.containsKey((Object[])object);
        }
        return false;
    }

    @Override
    public boolean containsKey(Object[] objectArray) {
        if (objectArray == null) {
            return false;
        }
        if (!this.isKeyValid(objectArray)) {
            return false;
        }
        return this.dataMap.containsKey(objectArray);
    }

    @Override
    public boolean containsValue(Object object) {
        if (object instanceof CompositeData) {
            return this.containsValue((CompositeData)object);
        }
        return false;
    }

    @Override
    public boolean containsValue(CompositeData compositeData) {
        if (compositeData == null) {
            return false;
        }
        if (!compositeData.getCompositeType().equals(this.tabularType.getRowType())) {
            return false;
        }
        return this.dataMap.containsValue(compositeData);
    }

    @Override
    public Set<Map.Entry<Object, Object>> entrySet() {
        return this.dataMap.entrySet();
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof TabularData)) {
            return false;
        }
        TabularData tabularData = (TabularData)object;
        return this.tabularType.equals(tabularData.getTabularType()) && this.dataMap.values().equals(tabularData.values());
    }

    @Override
    public Object get(Object object) {
        return this.get((Object[])object);
    }

    @Override
    public CompositeData get(Object[] objectArray) {
        if (!this.isKeyValid(objectArray)) {
            throw new InvalidKeyException("The key does not match the tabular type of this instance.");
        }
        return (CompositeData)this.dataMap.get(objectArray);
    }

    @Override
    public TabularType getTabularType() {
        return this.tabularType;
    }

    @Override
    public int hashCode() {
        return this.tabularType.hashCode() + this.dataMap.values().hashCode();
    }

    @Override
    public boolean isEmpty() {
        return this.dataMap.isEmpty();
    }

    private boolean isKeyValid(Object[] objectArray) {
        Iterator<String> iterator = this.tabularType.getIndexNames().iterator();
        CompositeType compositeType = this.tabularType.getRowType();
        int n = 0;
        while (iterator.hasNext()) {
            OpenType<?> openType = compositeType.getType(iterator.next());
            if (!openType.isValue(objectArray[n])) {
                return false;
            }
            ++n;
        }
        return true;
    }

    @Override
    public Set<Object> keySet() {
        return this.dataMap.keySet();
    }

    @Override
    public void put(CompositeData compositeData) {
        Object[] objectArray = this.calculateIndex(compositeData);
        if (this.dataMap.containsKey(objectArray)) {
            throw new KeyAlreadyExistsException("A value with this index already exists.");
        }
        this.dataMap.put(objectArray, compositeData);
    }

    @Override
    public Object put(Object object, Object object2) {
        this.put((CompositeData)object2);
        return object2;
    }

    @Override
    public void putAll(CompositeData[] compositeDataArray) {
        if (compositeDataArray == null || compositeDataArray.length == 0) {
            return;
        }
        HashMap<Object[], CompositeData> hashMap = new HashMap<Object[], CompositeData>(compositeDataArray.length);
        for (int i = 0; i < compositeDataArray.length; ++i) {
            Object[] objectArray = this.calculateIndex(compositeDataArray[i]);
            if (this.dataMap.containsKey(objectArray)) {
                throw new KeyAlreadyExistsException("Element " + i + ": A value with this index already exists.");
            }
            hashMap.put(objectArray, compositeDataArray[i]);
        }
        this.dataMap.putAll(hashMap);
    }

    @Override
    public void putAll(Map<?, ?> map) {
        if (map == null || map.size() == 0) {
            return;
        }
        Collection<?> collection = map.values();
        CompositeData[] compositeDataArray = new CompositeData[collection.size()];
        Iterator<?> iterator = collection.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            compositeDataArray[n] = (CompositeData)iterator.next();
            ++n;
        }
        this.putAll(compositeDataArray);
    }

    @Override
    public Object remove(Object object) {
        return this.remove((Object[])object);
    }

    @Override
    public CompositeData remove(Object[] objectArray) {
        if (!this.isKeyValid(objectArray)) {
            throw new InvalidKeyException("The key does not match the tabular type of this instance.");
        }
        return (CompositeData)this.dataMap.remove(objectArray);
    }

    private void setMap(HashMap<Object, Object> hashMap) {
        this.dataMap = hashMap;
    }

    @Override
    public int size() {
        return this.dataMap.size();
    }

    @Override
    public String toString() {
        return this.getClass().getName() + "[tabularType=" + this.tabularType + ",dataMap=" + this.dataMap + "]";
    }

    @Override
    public Collection<Object> values() {
        return this.dataMap.values();
    }
}

