/*
 * Decompiled with CFR 0.152.
 */
package javax.management.openmbean;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.management.MBeanParameterInfo;
import javax.management.openmbean.ArrayType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenMBeanParameterInfo;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.TabularType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OpenMBeanParameterInfoSupport
extends MBeanParameterInfo
implements OpenMBeanParameterInfo {
    private static final long serialVersionUID = -7235016873758443122L;
    private OpenType<?> openType;
    private Object defaultValue;
    private Set<?> legalValues;
    private Comparable<?> minValue;
    private Comparable<?> maxValue;
    private transient Integer hashCode;
    private transient String string;

    public OpenMBeanParameterInfoSupport(String string, String string2, OpenType<?> openType) {
        super(string, openType == null ? null : openType.getClassName(), string2);
        if (string == null) {
            throw new IllegalArgumentException("The name may not be null.");
        }
        if (string2 == null) {
            throw new IllegalArgumentException("The description may not be null.");
        }
        if (openType == null) {
            throw new IllegalArgumentException("The type may not be null.");
        }
        if (string.length() == 0) {
            throw new IllegalArgumentException("The name may not be the empty string.");
        }
        if (string2.length() == 0) {
            throw new IllegalArgumentException("The description may not be the empty string.");
        }
        this.openType = openType;
    }

    public <T> OpenMBeanParameterInfoSupport(String string, String string2, OpenType<T> openType, T t) throws OpenDataException {
        this(string, string2, openType, t, null);
    }

    public <T> OpenMBeanParameterInfoSupport(String string, String string2, OpenType<T> openType, T t, Comparable<T> comparable, Comparable<T> comparable2) throws OpenDataException {
        this(string, string2, openType);
        if (t != null && !openType.isValue(t)) {
            throw new OpenDataException("The default value is not a member of the open type given.");
        }
        if (comparable != null && !openType.isValue(comparable)) {
            throw new OpenDataException("The minimum value is not a member of the open type given.");
        }
        if (comparable2 != null && !openType.isValue(comparable2)) {
            throw new OpenDataException("The maximum value is not a member of the open type given.");
        }
        if (t != null && (openType instanceof ArrayType || openType instanceof TabularType)) {
            throw new OpenDataException("Default values are not applicable for array or tabular types.");
        }
        if (comparable != null && comparable2 != null && comparable.compareTo(comparable2) > 0) {
            throw new OpenDataException("The minimum value is greater than the maximum.");
        }
        if (comparable != null && t != null && comparable.compareTo((Comparable<T>)t) > 0) {
            throw new OpenDataException("The minimum value is greater than the default.");
        }
        if (t != null && comparable2 != null && comparable2.compareTo(t) < 0) {
            throw new OpenDataException("The default value is greater than the maximum.");
        }
        this.defaultValue = t;
        this.minValue = comparable;
        this.maxValue = comparable2;
    }

    public <T> OpenMBeanParameterInfoSupport(String string, String string2, OpenType<T> openType, T t, T[] TArray) throws OpenDataException {
        this(string, string2, openType);
        if (t != null && !openType.isValue(t)) {
            throw new OpenDataException("The default value is not a member of the open type given.");
        }
        if (t != null && (openType instanceof ArrayType || openType instanceof TabularType)) {
            throw new OpenDataException("Default values are not applicable for array or tabular types.");
        }
        if (TArray != null && (openType instanceof ArrayType || openType instanceof TabularType)) {
            throw new OpenDataException("Legal values are not applicable for array or tabular types.");
        }
        if (TArray != null && TArray.length > 0) {
            HashSet hashSet = new HashSet(TArray.length);
            for (int i = 0; i < TArray.length; ++i) {
                if (TArray[i] != null && !openType.isValue(TArray[i])) {
                    throw new OpenDataException("The legal value, " + TArray[i] + "is not a member of the open type given.");
                }
                hashSet.add(TArray[i]);
            }
            if (t != null && !hashSet.contains(t)) {
                throw new OpenDataException("The default value is not in the set of legal values.");
            }
            this.legalValues = Collections.unmodifiableSet(hashSet);
        }
        this.defaultValue = t;
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof OpenMBeanParameterInfo)) {
            return false;
        }
        OpenMBeanParameterInfo openMBeanParameterInfo = (OpenMBeanParameterInfo)object;
        return this.getName().equals(openMBeanParameterInfo.getName()) && this.openType.equals(openMBeanParameterInfo.getOpenType()) && (this.defaultValue == null ? openMBeanParameterInfo.getDefaultValue() == null : this.defaultValue.equals(openMBeanParameterInfo.getDefaultValue())) && (this.minValue == null ? openMBeanParameterInfo.getMinValue() == null : this.minValue.equals(openMBeanParameterInfo.getMinValue())) && (this.maxValue == null ? openMBeanParameterInfo.getMaxValue() == null : this.maxValue.equals(openMBeanParameterInfo.getMaxValue())) && (this.legalValues == null ? openMBeanParameterInfo.getLegalValues() == null : this.legalValues.equals(openMBeanParameterInfo.getLegalValues()));
    }

    @Override
    public Object getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public Set<?> getLegalValues() {
        return this.legalValues;
    }

    @Override
    public Comparable<?> getMaxValue() {
        return this.maxValue;
    }

    @Override
    public Comparable<?> getMinValue() {
        return this.minValue;
    }

    @Override
    public OpenType<?> getOpenType() {
        return this.openType;
    }

    @Override
    public boolean hasDefaultValue() {
        return this.defaultValue != null;
    }

    @Override
    public int hashCode() {
        if (this.hashCode == null) {
            this.hashCode = this.getName().hashCode() + this.openType.hashCode() + (this.defaultValue == null ? 0 : this.defaultValue.hashCode()) + (this.minValue == null ? 0 : this.minValue.hashCode()) + (this.maxValue == null ? 0 : this.maxValue.hashCode()) + (this.legalValues == null ? 0 : this.legalValues.hashCode());
        }
        return this.hashCode;
    }

    @Override
    public boolean hasLegalValues() {
        return this.legalValues != null;
    }

    @Override
    public boolean hasMaxValue() {
        return this.maxValue != null;
    }

    @Override
    public boolean hasMinValue() {
        return this.minValue != null;
    }

    @Override
    public boolean isValue(Object object) {
        return this.openType.isValue(object);
    }

    @Override
    public String toString() {
        if (this.string == null) {
            this.string = this.getClass().getName() + "[name=" + this.getName() + ",openType=" + this.openType + ",defaultValue=" + this.defaultValue + ",minValue=" + this.minValue + ",maxValue=" + this.maxValue + ",legalValues=" + this.legalValues + "]";
        }
        return this.string;
    }
}

