/*
 * Decompiled with CFR 0.152.
 */
package javax.management.openmbean;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.management.MBeanAttributeInfo;
import javax.management.openmbean.ArrayType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenMBeanAttributeInfo;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.TabularType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OpenMBeanAttributeInfoSupport
extends MBeanAttributeInfo
implements OpenMBeanAttributeInfo {
    private static final long serialVersionUID = -4867215622149721849L;
    private OpenType<?> openType;
    private Object defaultValue;
    private Set<?> legalValues;
    private Comparable<?> minValue;
    private Comparable<?> maxValue;
    private transient Integer hashCode;
    private transient String string;

    public OpenMBeanAttributeInfoSupport(String string, String string2, OpenType<?> openType, boolean bl, boolean bl2, boolean bl3) {
        super(string, openType == null ? null : openType.getClassName(), string2, bl, bl2, bl3);
        if (string == null) {
            throw new IllegalArgumentException("The name may not be null.");
        }
        if (string2 == null) {
            throw new IllegalArgumentException("The description may not be null.");
        }
        if (openType == null) {
            throw new IllegalArgumentException("The type may not be null.");
        }
        if (string.length() == 0) {
            throw new IllegalArgumentException("The name may not be the empty string.");
        }
        if (string2.length() == 0) {
            throw new IllegalArgumentException("The description may not be the empty string.");
        }
    }

    public <T> OpenMBeanAttributeInfoSupport(String string, String string2, OpenType<T> openType, boolean bl, boolean bl2, boolean bl3, T t) throws OpenDataException {
        this(string, string2, openType, bl, bl2, bl3, t, null);
    }

    public <T> OpenMBeanAttributeInfoSupport(String string, String string2, OpenType<T> openType, boolean bl, boolean bl2, boolean bl3, T t, Comparable<T> comparable, Comparable<T> comparable2) throws OpenDataException {
        this(string, string2, openType, bl, bl2, bl3);
        if (t != null && !openType.isValue(t)) {
            throw new OpenDataException("The default value is not a member of the open type given.");
        }
        if (comparable != null && !openType.isValue(comparable)) {
            throw new OpenDataException("The minimum value is not a member of the open type given.");
        }
        if (comparable2 != null && !openType.isValue(comparable2)) {
            throw new OpenDataException("The maximum value is not a member of the open type given.");
        }
        if (t != null && (openType instanceof ArrayType || openType instanceof TabularType)) {
            throw new OpenDataException("Default values are not applicable for array or tabular types.");
        }
        if (comparable != null && comparable2 != null && comparable.compareTo(comparable2) > 0) {
            throw new OpenDataException("The minimum value is greater than the maximum.");
        }
        if (comparable != null && t != null && comparable.compareTo((Comparable<T>)t) > 0) {
            throw new OpenDataException("The minimum value is greater than the default.");
        }
        if (t != null && comparable2 != null && comparable2.compareTo(t) < 0) {
            throw new OpenDataException("The default value is greater than the maximum.");
        }
        this.openType = openType;
        this.defaultValue = t;
        this.minValue = comparable;
        this.maxValue = comparable2;
    }

    public <T> OpenMBeanAttributeInfoSupport(String string, String string2, OpenType<T> openType, boolean bl, boolean bl2, boolean bl3, T t, T[] TArray) throws OpenDataException {
        this(string, string2, openType, bl, bl2, bl3);
        if (t != null && !openType.isValue(t)) {
            throw new OpenDataException("The default value is not a member of the open type given.");
        }
        if (t != null && (openType instanceof ArrayType || openType instanceof TabularType)) {
            throw new OpenDataException("Default values are not applicable for array or tabular types.");
        }
        if (TArray != null && (openType instanceof ArrayType || openType instanceof TabularType)) {
            throw new OpenDataException("Legal values are not applicable for array or tabular types.");
        }
        if (TArray != null && TArray.length > 0) {
            HashSet hashSet = new HashSet(TArray.length);
            for (int i = 0; i < TArray.length; ++i) {
                if (TArray[i] != null && !openType.isValue(TArray[i])) {
                    throw new OpenDataException("The legal value, " + TArray[i] + "is not a member of the open type given.");
                }
                hashSet.add(TArray[i]);
            }
            if (t != null && !hashSet.contains(t)) {
                throw new OpenDataException("The default value is not in the set of legal values.");
            }
            this.legalValues = Collections.unmodifiableSet(hashSet);
        }
        this.openType = openType;
        this.defaultValue = t;
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof OpenMBeanAttributeInfo)) {
            return false;
        }
        OpenMBeanAttributeInfo openMBeanAttributeInfo = (OpenMBeanAttributeInfo)object;
        return this.getName().equals(openMBeanAttributeInfo.getName()) && this.openType.equals(openMBeanAttributeInfo.getOpenType()) && this.isReadable() == openMBeanAttributeInfo.isReadable() && this.isWritable() == openMBeanAttributeInfo.isWritable() && this.isIs() == openMBeanAttributeInfo.isIs() && (this.defaultValue == null ? openMBeanAttributeInfo.getDefaultValue() == null : this.defaultValue.equals(openMBeanAttributeInfo.getDefaultValue())) && (this.minValue == null ? openMBeanAttributeInfo.getMinValue() == null : this.minValue.equals(openMBeanAttributeInfo.getMinValue())) && (this.maxValue == null ? openMBeanAttributeInfo.getMaxValue() == null : this.maxValue.equals(openMBeanAttributeInfo.getMaxValue())) && (this.legalValues == null ? openMBeanAttributeInfo.getLegalValues() == null : this.legalValues.equals(openMBeanAttributeInfo.getLegalValues()));
    }

    @Override
    public Object getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public Set<?> getLegalValues() {
        return this.legalValues;
    }

    @Override
    public Comparable<?> getMaxValue() {
        return this.maxValue;
    }

    @Override
    public Comparable<?> getMinValue() {
        return this.minValue;
    }

    @Override
    public OpenType<?> getOpenType() {
        return this.openType;
    }

    @Override
    public boolean hasDefaultValue() {
        return this.defaultValue != null;
    }

    @Override
    public int hashCode() {
        if (this.hashCode == null) {
            this.hashCode = this.getName().hashCode() + this.openType.hashCode() + Boolean.valueOf(this.isReadable()).hashCode() + 2 * Boolean.valueOf(this.isWritable()).hashCode() + 4 * Boolean.valueOf(this.isIs()).hashCode() + (this.defaultValue == null ? 0 : this.defaultValue.hashCode()) + (this.minValue == null ? 0 : this.minValue.hashCode()) + (this.maxValue == null ? 0 : this.maxValue.hashCode()) + (this.legalValues == null ? 0 : this.legalValues.hashCode());
        }
        return this.hashCode;
    }

    @Override
    public boolean hasLegalValues() {
        return this.legalValues != null;
    }

    @Override
    public boolean hasMaxValue() {
        return this.maxValue != null;
    }

    @Override
    public boolean hasMinValue() {
        return this.minValue != null;
    }

    @Override
    public boolean isValue(Object object) {
        return this.openType.isValue(object);
    }

    @Override
    public String toString() {
        if (this.string == null) {
            this.string = this.getClass().getName() + "[name=" + this.getName() + ",openType=" + this.openType + ",isReadable=" + this.isReadable() + ",isWritable=" + this.isWritable() + ",isIs=" + this.isIs() + ",defaultValue=" + this.defaultValue + ",minValue=" + this.minValue + ",maxValue=" + this.maxValue + ",legalValues=" + this.legalValues + "]";
        }
        return this.string;
    }
}

