/*
 * Decompiled with CFR 0.152.
 */
package javax.management.openmbean;

import java.lang.reflect.Array;
import java.util.HashMap;
import java.util.Map;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import javax.management.openmbean.TabularType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArrayType<T>
extends OpenType<T> {
    private static final long serialVersionUID = 720504429830309770L;
    private int dimension;
    private OpenType<?> elementType;
    private boolean primitiveArray;
    private transient Integer hashCode;
    private transient String string;
    private static final Map<OpenType<?>, ArrayType<?>> cache = new HashMap();
    private static final Map<Class<?>, ArrayType<?>> primCache = new HashMap();

    private static final String getArrayClassName(OpenType<?> openType, int n, boolean bl) throws OpenDataException {
        Class<?> clazz;
        if (bl) {
            clazz = ArrayType.getPrimitiveTypeClass((SimpleType)openType);
        } else {
            String string = openType.getClassName();
            try {
                clazz = Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new OpenDataException("The class name, " + string + ", is unavailable.");
            }
        }
        while (clazz.isArray()) {
            clazz = clazz.getComponentType();
        }
        return Array.newInstance(clazz, new int[ArrayType.getDimensions(openType, n)]).getClass().getName();
    }

    private static final int getDimensions(OpenType<?> openType, int n) {
        if (n < 1) {
            throw new IllegalArgumentException("Dimensions must be greater than or equal to 1.");
        }
        if (openType instanceof ArrayType) {
            return n + ((ArrayType)openType).getDimension();
        }
        return n;
    }

    private static final SimpleType<?> getPrimitiveType(Class<?> clazz) throws OpenDataException {
        if (clazz.equals(Boolean.TYPE)) {
            return SimpleType.BOOLEAN;
        }
        if (clazz.equals(Byte.TYPE)) {
            return SimpleType.BYTE;
        }
        if (clazz.equals(Character.TYPE)) {
            return SimpleType.CHARACTER;
        }
        if (clazz.equals(Double.TYPE)) {
            return SimpleType.DOUBLE;
        }
        if (clazz.equals(Float.TYPE)) {
            return SimpleType.FLOAT;
        }
        if (clazz.equals(Integer.TYPE)) {
            return SimpleType.INTEGER;
        }
        if (clazz.equals(Long.TYPE)) {
            return SimpleType.LONG;
        }
        if (clazz.equals(Short.TYPE)) {
            return SimpleType.SHORT;
        }
        if (clazz.equals(Void.TYPE)) {
            return SimpleType.VOID;
        }
        throw new OpenDataException(clazz + " is not a primitive type.");
    }

    private static final Class<?> getPrimitiveTypeClass(SimpleType<?> simpleType) throws OpenDataException {
        if (simpleType.equals(SimpleType.BOOLEAN)) {
            return Boolean.TYPE;
        }
        if (simpleType.equals(SimpleType.BYTE)) {
            return Byte.TYPE;
        }
        if (simpleType.equals(SimpleType.CHARACTER)) {
            return Character.TYPE;
        }
        if (simpleType.equals(SimpleType.DOUBLE)) {
            return Double.TYPE;
        }
        if (simpleType.equals(SimpleType.FLOAT)) {
            return Float.TYPE;
        }
        if (simpleType.equals(SimpleType.INTEGER)) {
            return Integer.TYPE;
        }
        if (simpleType.equals(SimpleType.LONG)) {
            return Long.TYPE;
        }
        if (simpleType.equals(SimpleType.SHORT)) {
            return Short.TYPE;
        }
        if (simpleType.equals(SimpleType.VOID)) {
            return Void.TYPE;
        }
        throw new OpenDataException(simpleType + " is not a primitive type.");
    }

    private static final OpenType<?> getElementType(OpenType<?> openType) {
        if (openType instanceof ArrayType) {
            return ((ArrayType)openType).getElementOpenType();
        }
        return openType;
    }

    private static final String getElementTypeName(OpenType<?> openType) throws OpenDataException {
        OpenType<?> openType2 = ArrayType.getElementType(openType);
        if (openType instanceof ArrayType && ((ArrayType)openType).isPrimitiveArray()) {
            return ArrayType.getPrimitiveTypeClass((SimpleType)openType2).getName();
        }
        return openType2.getClassName();
    }

    public ArrayType(int n, OpenType<?> openType) throws OpenDataException {
        super(ArrayType.getArrayClassName(openType, n, false), ArrayType.getArrayClassName(openType, n, false), ArrayType.getDimensions(openType, n) + "-dimension array of " + ArrayType.getElementTypeName(openType));
        if (!(openType instanceof SimpleType || openType instanceof CompositeType || openType instanceof TabularType || openType instanceof ArrayType)) {
            throw new OpenDataException("The element type must be a simple type, an array type, a composite type or a tabular type.");
        }
        this.dimension = ArrayType.getDimensions(openType, n);
        this.elementType = ArrayType.getElementType(openType);
        this.primitiveArray = openType instanceof ArrayType && ((ArrayType)openType).isPrimitiveArray();
    }

    public ArrayType(SimpleType<?> simpleType, boolean bl) throws OpenDataException {
        super(ArrayType.getArrayClassName(simpleType, 1, bl), ArrayType.getArrayClassName(simpleType, 1, bl), "1-dimension array of " + (bl ? ArrayType.getPrimitiveTypeClass(simpleType).getName() : simpleType.getClassName()));
        this.dimension = 1;
        this.elementType = simpleType;
        this.primitiveArray = bl;
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof ArrayType)) {
            return false;
        }
        ArrayType arrayType = (ArrayType)object;
        return arrayType.getDimension() == this.dimension && arrayType.getElementOpenType().equals(this.elementType) && arrayType.isPrimitiveArray() == this.primitiveArray;
    }

    public static <E> ArrayType<E[]> getArrayType(OpenType<E> openType) throws OpenDataException {
        ArrayType<Object> arrayType = cache.get(openType);
        if (arrayType != null) {
            return arrayType;
        }
        arrayType = new ArrayType(1, openType);
        cache.put(openType, arrayType);
        return arrayType;
    }

    public static <T> ArrayType<T> getPrimitiveArrayType(Class<T> clazz) {
        ArrayType<Object> arrayType = primCache.get(clazz);
        if (arrayType != null) {
            return arrayType;
        }
        Class<Object> clazz2 = clazz;
        int n = 0;
        do {
            clazz2 = clazz2.getComponentType();
            ++n;
            if (clazz2 != null) continue;
            throw new IllegalArgumentException("The given class is not an array.");
        } while (clazz2.isArray());
        try {
            arrayType = new ArrayType<T>(ArrayType.getPrimitiveType(clazz2), true);
        }
        catch (OpenDataException openDataException) {
            throw new IllegalArgumentException("The array is not of a primitive type", openDataException);
        }
        while (n > 1) {
            try {
                arrayType = new ArrayType<T>(1, arrayType);
                --n;
            }
            catch (OpenDataException openDataException) {
                throw (Error)new InternalError("Couldn't generate extra dimensions").initCause(openDataException);
            }
        }
        primCache.put(clazz, arrayType);
        return arrayType;
    }

    public int getDimension() {
        return this.dimension;
    }

    public OpenType<?> getElementOpenType() {
        return this.elementType;
    }

    @Override
    public int hashCode() {
        if (this.hashCode == null) {
            this.hashCode = this.dimension + this.elementType.hashCode() + Boolean.valueOf(this.primitiveArray).hashCode();
        }
        return this.hashCode;
    }

    public boolean isPrimitiveArray() {
        return this.primitiveArray;
    }

    @Override
    public boolean isValue(Object object) {
        if (object == null) {
            return false;
        }
        Class<? extends Object> clazz = object.getClass();
        if (!clazz.isArray()) {
            return false;
        }
        if (this.elementType instanceof SimpleType) {
            return this.getClassName().equals(clazz.getName());
        }
        Class<? extends Object> clazz2 = null;
        try {
            clazz2 = Class.forName(this.getClassName());
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new IllegalStateException("The array type's element class could not be found.", classNotFoundException);
        }
        if (!clazz2.isAssignableFrom(clazz)) {
            return false;
        }
        for (int i = 0; i < Array.getLength(object); ++i) {
            Object object2 = Array.get(object, i);
            if (object2 == null || this.elementType.isValue(object2)) continue;
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        if (this.string == null) {
            this.string = this.getClass().getName() + "[name=" + this.getTypeName() + ", dimension=" + this.dimension + ", elementType=" + this.elementType + ", primitiveArray=" + this.primitiveArray + "]";
        }
        return this.string;
    }
}

