/*
 * Decompiled with CFR 0.152.
 */
package javax.management;

import javax.management.AttributeValueExp;
import javax.management.BadAttributeValueExpException;
import javax.management.BadBinaryOpValueExpException;
import javax.management.BadStringOperationException;
import javax.management.InstanceNotFoundException;
import javax.management.InvalidApplicationException;
import javax.management.ObjectName;
import javax.management.QueryEval;
import javax.management.QueryExp;
import javax.management.StringValueExp;
import javax.management.ValueExp;

public class Query {
    public static final int PLUS = 0;
    public static final int MINUS = 1;
    public static final int TIMES = 2;
    public static final int DIV = 3;
    public static final int GT = 0;
    public static final int LT = 1;
    public static final int GE = 2;
    public static final int LE = 3;
    public static final int EQ = 4;

    public static QueryExp and(QueryExp queryExp, QueryExp queryExp2) {
        return new AndQueryExp(queryExp, queryExp2);
    }

    public static QueryExp anySubString(AttributeValueExp attributeValueExp, StringValueExp stringValueExp) {
        return new MatchQueryExp(attributeValueExp, "*" + stringValueExp.getValue() + "*");
    }

    public static AttributeValueExp attr(String string) {
        return new AttributeValueExp(string);
    }

    public static AttributeValueExp attr(String string, String string2) {
        return new QualifiedAttributeValueExp(string, string2);
    }

    public static QueryExp between(ValueExp valueExp, ValueExp valueExp2, ValueExp valueExp3) {
        return new BetweenQueryExp(valueExp, valueExp2, valueExp3);
    }

    public static AttributeValueExp classattr() {
        return new ClassAttributeValueExp();
    }

    public static ValueExp div(ValueExp valueExp, ValueExp valueExp2) {
        return new BinaryOpValueExp(3, valueExp, valueExp2);
    }

    public static QueryExp eq(ValueExp valueExp, ValueExp valueExp2) {
        return new BinaryRelQueryExp(4, valueExp, valueExp2);
    }

    public static QueryExp finalSubString(AttributeValueExp attributeValueExp, StringValueExp stringValueExp) {
        return new MatchQueryExp(attributeValueExp, "*" + stringValueExp.getValue());
    }

    public static QueryExp geq(ValueExp valueExp, ValueExp valueExp2) {
        return new BinaryRelQueryExp(2, valueExp, valueExp2);
    }

    public static QueryExp gt(ValueExp valueExp, ValueExp valueExp2) {
        return new BinaryRelQueryExp(0, valueExp, valueExp2);
    }

    public static QueryExp in(ValueExp valueExp, ValueExp[] valueExpArray) {
        return new InQueryExp(valueExp, valueExpArray);
    }

    public static QueryExp initialSubString(AttributeValueExp attributeValueExp, StringValueExp stringValueExp) {
        return new MatchQueryExp(attributeValueExp, stringValueExp.getValue() + "*");
    }

    public static QueryExp isInstanceOf(StringValueExp stringValueExp) {
        return new InstanceOfQueryExp(stringValueExp);
    }

    public static QueryExp leq(ValueExp valueExp, ValueExp valueExp2) {
        return new BinaryRelQueryExp(3, valueExp, valueExp2);
    }

    public static QueryExp lt(ValueExp valueExp, ValueExp valueExp2) {
        return new BinaryRelQueryExp(1, valueExp, valueExp2);
    }

    public static QueryExp match(AttributeValueExp attributeValueExp, StringValueExp stringValueExp) {
        return new MatchQueryExp(attributeValueExp, stringValueExp.getValue());
    }

    public static ValueExp minus(ValueExp valueExp, ValueExp valueExp2) {
        return new BinaryOpValueExp(1, valueExp, valueExp2);
    }

    public static QueryExp not(QueryExp queryExp) {
        return new NotQueryExp(queryExp);
    }

    public static QueryExp or(QueryExp queryExp, QueryExp queryExp2) {
        return new OrQueryExp(queryExp, queryExp2);
    }

    public static ValueExp plus(ValueExp valueExp, ValueExp valueExp2) {
        return new BinaryOpValueExp(0, valueExp, valueExp2);
    }

    public static ValueExp times(ValueExp valueExp, ValueExp valueExp2) {
        return new BinaryOpValueExp(2, valueExp, valueExp2);
    }

    public static ValueExp value(boolean bl) {
        return new BooleanValueExp(bl);
    }

    public static ValueExp value(double d) {
        return new NumericValueExp(d);
    }

    public static ValueExp value(float f) {
        return new NumericValueExp(Float.valueOf(f));
    }

    public static ValueExp value(int n) {
        return new NumericValueExp(n);
    }

    public static ValueExp value(long l) {
        return new NumericValueExp(l);
    }

    public static ValueExp value(Number number) {
        return new NumericValueExp(number);
    }

    public static StringValueExp value(String string) {
        return new StringValueExp(string);
    }

    private static final class NumericValueExp
    extends QueryEval
    implements ValueExp {
        private static final long serialVersionUID = -4679739485102359104L;
        private Number val;

        public NumericValueExp(Number number) {
            this.val = number;
        }

        public ValueExp apply(ObjectName objectName) throws BadStringOperationException, BadBinaryOpValueExpException, BadAttributeValueExpException, InvalidApplicationException {
            return this;
        }

        public Number getValue() {
            return this.val;
        }

        public String toString() {
            return this.val.toString();
        }

        public NumericValueExp plus(NumericValueExp numericValueExp) {
            Number number = numericValueExp.getValue();
            if (this.val instanceof Double) {
                double d = this.val.doubleValue();
                if (number instanceof Double) {
                    return new NumericValueExp(d + number.doubleValue());
                }
                if (number instanceof Float) {
                    return new NumericValueExp(d + (double)number.floatValue());
                }
                if (number instanceof Long) {
                    return new NumericValueExp(d + (double)number.longValue());
                }
                return new NumericValueExp(d + (double)number.intValue());
            }
            if (this.val instanceof Float) {
                float f = this.val.floatValue();
                if (number instanceof Double) {
                    return new NumericValueExp((double)f + number.doubleValue());
                }
                if (number instanceof Float) {
                    return new NumericValueExp(Float.valueOf(f + number.floatValue()));
                }
                if (number instanceof Long) {
                    return new NumericValueExp(Float.valueOf(f + (float)number.longValue()));
                }
                return new NumericValueExp(Float.valueOf(f + (float)number.intValue()));
            }
            if (this.val instanceof Long) {
                long l = this.val.longValue();
                if (number instanceof Double) {
                    return new NumericValueExp((double)l + number.doubleValue());
                }
                if (number instanceof Float) {
                    return new NumericValueExp(Float.valueOf((float)l + number.floatValue()));
                }
                if (number instanceof Long) {
                    return new NumericValueExp(l + number.longValue());
                }
                return new NumericValueExp(l + (long)number.intValue());
            }
            int n = this.val.intValue();
            if (number instanceof Double) {
                return new NumericValueExp((double)n + number.doubleValue());
            }
            if (number instanceof Float) {
                return new NumericValueExp(Float.valueOf((float)n + number.floatValue()));
            }
            if (number instanceof Long) {
                return new NumericValueExp((long)n + number.longValue());
            }
            return new NumericValueExp(n + number.intValue());
        }

        public NumericValueExp minus(NumericValueExp numericValueExp) {
            Number number = numericValueExp.getValue();
            if (this.val instanceof Double) {
                double d = this.val.doubleValue();
                if (number instanceof Double) {
                    return new NumericValueExp(d - number.doubleValue());
                }
                if (number instanceof Float) {
                    return new NumericValueExp(d - (double)number.floatValue());
                }
                if (number instanceof Long) {
                    return new NumericValueExp(d - (double)number.longValue());
                }
                return new NumericValueExp(d - (double)number.intValue());
            }
            if (this.val instanceof Float) {
                float f = this.val.floatValue();
                if (number instanceof Double) {
                    return new NumericValueExp((double)f - number.doubleValue());
                }
                if (number instanceof Float) {
                    return new NumericValueExp(Float.valueOf(f - number.floatValue()));
                }
                if (number instanceof Long) {
                    return new NumericValueExp(Float.valueOf(f - (float)number.longValue()));
                }
                return new NumericValueExp(Float.valueOf(f - (float)number.intValue()));
            }
            if (this.val instanceof Long) {
                long l = this.val.longValue();
                if (number instanceof Double) {
                    return new NumericValueExp((double)l - number.doubleValue());
                }
                if (number instanceof Float) {
                    return new NumericValueExp(Float.valueOf((float)l - number.floatValue()));
                }
                if (number instanceof Long) {
                    return new NumericValueExp(l - number.longValue());
                }
                return new NumericValueExp(l - (long)number.intValue());
            }
            int n = this.val.intValue();
            if (number instanceof Double) {
                return new NumericValueExp((double)n - number.doubleValue());
            }
            if (number instanceof Float) {
                return new NumericValueExp(Float.valueOf((float)n - number.floatValue()));
            }
            if (number instanceof Long) {
                return new NumericValueExp((long)n - number.longValue());
            }
            return new NumericValueExp(n - number.intValue());
        }

        public NumericValueExp times(NumericValueExp numericValueExp) {
            Number number = numericValueExp.getValue();
            if (this.val instanceof Double) {
                double d = this.val.doubleValue();
                if (number instanceof Double) {
                    return new NumericValueExp(d * number.doubleValue());
                }
                if (number instanceof Float) {
                    return new NumericValueExp(d * (double)number.floatValue());
                }
                if (number instanceof Long) {
                    return new NumericValueExp(d * (double)number.longValue());
                }
                return new NumericValueExp(d * (double)number.intValue());
            }
            if (this.val instanceof Float) {
                float f = this.val.floatValue();
                if (number instanceof Double) {
                    return new NumericValueExp((double)f * number.doubleValue());
                }
                if (number instanceof Float) {
                    return new NumericValueExp(Float.valueOf(f * number.floatValue()));
                }
                if (number instanceof Long) {
                    return new NumericValueExp(Float.valueOf(f * (float)number.longValue()));
                }
                return new NumericValueExp(Float.valueOf(f * (float)number.intValue()));
            }
            if (this.val instanceof Long) {
                long l = this.val.longValue();
                if (number instanceof Double) {
                    return new NumericValueExp((double)l * number.doubleValue());
                }
                if (number instanceof Float) {
                    return new NumericValueExp(Float.valueOf((float)l * number.floatValue()));
                }
                if (number instanceof Long) {
                    return new NumericValueExp(l * number.longValue());
                }
                return new NumericValueExp(l * (long)number.intValue());
            }
            int n = this.val.intValue();
            if (number instanceof Double) {
                return new NumericValueExp((double)n * number.doubleValue());
            }
            if (number instanceof Float) {
                return new NumericValueExp(Float.valueOf((float)n * number.floatValue()));
            }
            if (number instanceof Long) {
                return new NumericValueExp((long)n * number.longValue());
            }
            return new NumericValueExp(n * number.intValue());
        }

        public NumericValueExp div(NumericValueExp numericValueExp) {
            Number number = numericValueExp.getValue();
            if (this.val instanceof Double) {
                double d = this.val.doubleValue();
                if (number instanceof Double) {
                    return new NumericValueExp(d / number.doubleValue());
                }
                if (number instanceof Float) {
                    return new NumericValueExp(d / (double)number.floatValue());
                }
                if (number instanceof Long) {
                    return new NumericValueExp(d / (double)number.longValue());
                }
                return new NumericValueExp(d / (double)number.intValue());
            }
            if (this.val instanceof Float) {
                float f = this.val.floatValue();
                if (number instanceof Double) {
                    return new NumericValueExp((double)f / number.doubleValue());
                }
                if (number instanceof Float) {
                    return new NumericValueExp(Float.valueOf(f / number.floatValue()));
                }
                if (number instanceof Long) {
                    return new NumericValueExp(Float.valueOf(f / (float)number.longValue()));
                }
                return new NumericValueExp(Float.valueOf(f / (float)number.intValue()));
            }
            if (this.val instanceof Long) {
                long l = this.val.longValue();
                if (number instanceof Double) {
                    return new NumericValueExp((double)l / number.doubleValue());
                }
                if (number instanceof Float) {
                    return new NumericValueExp(Float.valueOf((float)l / number.floatValue()));
                }
                if (number instanceof Long) {
                    return new NumericValueExp(l / number.longValue());
                }
                return new NumericValueExp(l / (long)number.intValue());
            }
            int n = this.val.intValue();
            if (number instanceof Double) {
                return new NumericValueExp((double)n / number.doubleValue());
            }
            if (number instanceof Float) {
                return new NumericValueExp(Float.valueOf((float)n / number.floatValue()));
            }
            if (number instanceof Long) {
                return new NumericValueExp((long)n / number.longValue());
            }
            return new NumericValueExp(n / number.intValue());
        }
    }

    private static final class BooleanValueExp
    extends QueryEval
    implements ValueExp {
        private static final long serialVersionUID = 7754922052666594581L;
        private boolean val;

        public BooleanValueExp(boolean bl) {
            this.val = bl;
        }

        public ValueExp apply(ObjectName objectName) throws BadStringOperationException, BadBinaryOpValueExpException, BadAttributeValueExpException, InvalidApplicationException {
            return this;
        }

        public String toString() {
            return Boolean.toString(this.val);
        }
    }

    private static final class OrQueryExp
    extends QueryEval
    implements QueryExp {
        private static final long serialVersionUID = 2962973084421716523L;
        private QueryExp exp1;
        private QueryExp exp2;

        public OrQueryExp(QueryExp queryExp, QueryExp queryExp2) {
            this.exp1 = queryExp;
            this.exp2 = queryExp2;
        }

        public boolean apply(ObjectName objectName) throws BadStringOperationException, BadBinaryOpValueExpException, BadAttributeValueExpException, InvalidApplicationException {
            return this.exp1.apply(objectName) || this.exp2.apply(objectName);
        }
    }

    private static final class NotQueryExp
    extends QueryEval
    implements QueryExp {
        private static final long serialVersionUID = 5269643775896723397L;
        private QueryExp exp;

        public NotQueryExp(QueryExp queryExp) {
            this.exp = queryExp;
        }

        public boolean apply(ObjectName objectName) throws BadStringOperationException, BadBinaryOpValueExpException, BadAttributeValueExpException, InvalidApplicationException {
            return !this.exp.apply(objectName);
        }
    }

    private static final class InstanceOfQueryExp
    extends QueryEval
    implements QueryExp {
        private static final long serialVersionUID = -1081892073854801359L;
        private StringValueExp classNameValue;

        public InstanceOfQueryExp(StringValueExp stringValueExp) {
            this.classNameValue = stringValueExp;
        }

        public boolean apply(ObjectName objectName) throws BadStringOperationException, BadBinaryOpValueExpException, BadAttributeValueExpException, InvalidApplicationException {
            try {
                String string = ((StringValueExp)this.classNameValue.apply(objectName)).getValue();
                return QueryEval.getMBeanServer().isInstanceOf(objectName, string);
            }
            catch (InstanceNotFoundException instanceNotFoundException) {
                throw (BadAttributeValueExpException)new BadAttributeValueExpException((Object)"The named bean is not registered.").initCause(instanceNotFoundException);
            }
        }
    }

    private static final class InQueryExp
    extends QueryEval
    implements QueryExp {
        private static final long serialVersionUID = -5801329450358952434L;
        private ValueExp val;
        private ValueExp[] valueList;

        public InQueryExp(ValueExp valueExp, ValueExp[] valueExpArray) {
            this.val = valueExp;
            this.valueList = valueExpArray;
        }

        public boolean apply(ObjectName objectName) throws BadStringOperationException, BadBinaryOpValueExpException, BadAttributeValueExpException, InvalidApplicationException {
            String string = this.val.apply(objectName).toString();
            for (ValueExp valueExp : this.valueList) {
                if (!string.equals(valueExp.apply(objectName).toString())) continue;
                return true;
            }
            return false;
        }
    }

    private static final class BinaryRelQueryExp
    extends QueryEval
    implements QueryExp {
        private static final long serialVersionUID = -5690656271650491000L;
        private int relOp;
        private ValueExp exp1;
        private ValueExp exp2;

        public BinaryRelQueryExp(int n, ValueExp valueExp, ValueExp valueExp2) {
            this.relOp = n;
            this.exp1 = valueExp;
            this.exp2 = valueExp2;
        }

        public boolean apply(ObjectName objectName) throws BadStringOperationException, BadBinaryOpValueExpException, BadAttributeValueExpException, InvalidApplicationException {
            String string = this.exp1.apply(objectName).toString();
            String string2 = this.exp2.apply(objectName).toString();
            switch (this.relOp) {
                case 4: {
                    return string.equals(string2);
                }
                case 0: {
                    return string.compareTo(string2) > 0;
                }
                case 2: {
                    return string.compareTo(string2) >= 0;
                }
                case 3: {
                    return string.compareTo(string2) <= 0;
                }
                case 1: {
                    return string.compareTo(string2) < 0;
                }
            }
            throw new BadStringOperationException("Invalid operator: " + this.relOp);
        }

        public String toString() {
            String string;
            switch (this.relOp) {
                case 4: {
                    string = "=";
                    break;
                }
                case 0: {
                    string = ">";
                    break;
                }
                case 2: {
                    string = ">=";
                    break;
                }
                case 3: {
                    string = "<=";
                    break;
                }
                case 1: {
                    string = "<";
                    break;
                }
                default: {
                    string = "?";
                }
            }
            return this.exp1 + " " + string + " " + this.exp2;
        }
    }

    private static final class BinaryOpValueExp
    extends QueryEval
    implements ValueExp {
        private static final long serialVersionUID = 1216286847881456786L;
        private int op;
        private ValueExp exp1;
        private ValueExp exp2;

        public BinaryOpValueExp(int n, ValueExp valueExp, ValueExp valueExp2) {
            this.op = n;
            this.exp1 = valueExp;
            this.exp2 = valueExp2;
        }

        public ValueExp apply(ObjectName objectName) throws BadStringOperationException, BadBinaryOpValueExpException, BadAttributeValueExpException, InvalidApplicationException {
            NumericValueExp numericValueExp = (NumericValueExp)this.exp1.apply(objectName);
            NumericValueExp numericValueExp2 = (NumericValueExp)this.exp2.apply(objectName);
            switch (this.op) {
                case 0: {
                    return numericValueExp.plus(numericValueExp2);
                }
                case 1: {
                    return numericValueExp.minus(numericValueExp2);
                }
                case 2: {
                    return numericValueExp.times(numericValueExp2);
                }
                case 3: {
                    return numericValueExp.div(numericValueExp2);
                }
            }
            throw new BadBinaryOpValueExpException(this);
        }

        public String toString() {
            String string;
            switch (this.op) {
                case 0: {
                    string = "+";
                    break;
                }
                case 1: {
                    string = "-";
                    break;
                }
                case 2: {
                    string = "x";
                    break;
                }
                case 3: {
                    string = "/";
                    break;
                }
                default: {
                    string = "?";
                }
            }
            return this.exp1 + " " + string + " " + this.exp2;
        }
    }

    private static final class ClassAttributeValueExp
    extends AttributeValueExp {
        private static final long serialVersionUID = -1081892073854801359L;

        private ClassAttributeValueExp() {
        }

        public ValueExp apply(ObjectName objectName) throws BadStringOperationException, BadBinaryOpValueExpException, BadAttributeValueExpException, InvalidApplicationException {
            try {
                return new StringValueExp(QueryEval.getMBeanServer().getObjectInstance(objectName).getClassName());
            }
            catch (InstanceNotFoundException instanceNotFoundException) {
                throw (BadAttributeValueExpException)new BadAttributeValueExpException((Object)"The named bean is not registered.").initCause(instanceNotFoundException);
            }
        }
    }

    private static final class BetweenQueryExp
    extends QueryEval
    implements QueryExp {
        private static final long serialVersionUID = -2933597532866307444L;
        private ValueExp exp1;
        private ValueExp exp2;
        private ValueExp exp3;

        public BetweenQueryExp(ValueExp valueExp, ValueExp valueExp2, ValueExp valueExp3) {
            this.exp1 = valueExp;
            this.exp2 = valueExp2;
            this.exp3 = valueExp3;
        }

        public boolean apply(ObjectName objectName) throws BadStringOperationException, BadBinaryOpValueExpException, BadAttributeValueExpException, InvalidApplicationException {
            String string = this.exp1.apply(objectName).toString();
            String string2 = this.exp2.apply(objectName).toString();
            String string3 = this.exp3.apply(objectName).toString();
            return string.compareTo(string2) >= 0 && string.compareTo(string3) <= 0;
        }
    }

    private static final class QualifiedAttributeValueExp
    extends AttributeValueExp {
        private static final long serialVersionUID = 8832517277410933254L;
        private String className;

        public QualifiedAttributeValueExp(String string, String string2) {
            super(string2);
            this.className = string;
        }

        public ValueExp apply(ObjectName objectName) throws BadStringOperationException, BadBinaryOpValueExpException, BadAttributeValueExpException, InvalidApplicationException {
            try {
                if (!QueryEval.getMBeanServer().getObjectInstance(objectName).getClassName().equals(this.className)) {
                    throw new BadAttributeValueExpException((Object)"The value is not from the correct class.");
                }
            }
            catch (InstanceNotFoundException instanceNotFoundException) {
                throw (BadAttributeValueExpException)new BadAttributeValueExpException((Object)"The named bean is not registered.").initCause(instanceNotFoundException);
            }
            return super.apply(objectName);
        }
    }

    private static final class MatchQueryExp
    extends QueryEval
    implements QueryExp {
        private static final long serialVersionUID = -7156603696948215014L;
        private AttributeValueExp exp;
        private String pattern;

        public MatchQueryExp(AttributeValueExp attributeValueExp, String string) {
            this.exp = attributeValueExp;
            this.pattern = string;
        }

        public boolean apply(ObjectName objectName) throws BadStringOperationException, BadBinaryOpValueExpException, BadAttributeValueExpException, InvalidApplicationException {
            String string = ((StringValueExp)this.exp.apply(objectName)).getValue();
            int n = 0;
            int n2 = -1;
            int n3 = -1;
            boolean bl = false;
            for (int i = 0; i < this.pattern.length(); ++i) {
                boolean bl2 = false;
                int n4 = this.pattern.codePointAt(i);
                if (!bl) {
                    if (n4 == 63 && n < string.length()) {
                        ++n;
                        bl2 = true;
                    } else if (n4 == 42) {
                        n2 = n;
                        n3 = i;
                        bl2 = true;
                    } else if (n4 == 91 && n < string.length()) {
                        boolean bl3 = false;
                        int n5 = i + 1;
                        int n6 = this.pattern.codePointAt(n5);
                        do {
                            if (n6 == 33 && n5 == i + 1) {
                                bl3 = true;
                                continue;
                            }
                            if (this.pattern.codePointAt(n5 + 1) == 45 && this.pattern.codePointAt(n5 + 2) != 93) {
                                if (n6 > this.pattern.codePointAt(n5 + 2)) {
                                    throw new BadStringOperationException("Invalid range: " + n6 + " to " + this.pattern.codePointAt(n5 + 2));
                                }
                                for (int j = n6; j <= this.pattern.codePointAt(n5 + 2); ++j) {
                                    if (string.codePointAt(n) != j) continue;
                                    bl2 = true;
                                }
                                n5 += 2;
                                continue;
                            }
                            if (string.codePointAt(n) != n6) continue;
                            bl2 = true;
                        } while ((n6 = this.pattern.codePointAt(++n5)) != 93);
                        if (bl3) {
                            bl2 = !bl2;
                        }
                        ++n;
                        i = n5;
                    } else if (n4 == 92) {
                        bl = true;
                    } else if (n < string.length() && n4 == string.codePointAt(n)) {
                        bl2 = true;
                        ++n;
                    }
                } else {
                    bl = false;
                    if (n < string.length() && n4 == string.codePointAt(n)) {
                        bl2 = true;
                        ++n;
                    }
                }
                if (bl2) continue;
                if (n2 != -1) {
                    n = ++n2;
                    i = n3;
                    if (n != string.length()) continue;
                    return false;
                }
                return false;
            }
            return true;
        }
    }

    private static final class AndQueryExp
    extends QueryEval
    implements QueryExp {
        private static final long serialVersionUID = -1081892073854801359L;
        private QueryExp exp1;
        private QueryExp exp2;

        public AndQueryExp(QueryExp queryExp, QueryExp queryExp2) {
            this.exp1 = queryExp;
            this.exp2 = queryExp2;
        }

        public boolean apply(ObjectName objectName) throws BadStringOperationException, BadBinaryOpValueExpException, BadAttributeValueExpException, InvalidApplicationException {
            return this.exp1.apply(objectName) && this.exp2.apply(objectName);
        }
    }
}

