/*
 * Decompiled with CFR 0.152.
 */
package javax.management;

import gnu.javax.management.ListenerData;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Executor;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanNotificationInfo;
import javax.management.Notification;
import javax.management.NotificationEmitter;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;

public class NotificationBroadcasterSupport
implements NotificationEmitter {
    private Executor executor;
    private MBeanNotificationInfo[] info;
    private final List<ListenerData> listeners = new ArrayList<ListenerData>();

    public NotificationBroadcasterSupport() {
        this((Executor)null, (MBeanNotificationInfo[])null);
    }

    public NotificationBroadcasterSupport(Executor executor) {
        this(executor, new MBeanNotificationInfo[]{null});
    }

    public NotificationBroadcasterSupport(MBeanNotificationInfo ... mBeanNotificationInfoArray) {
        this((Executor)null, mBeanNotificationInfoArray);
    }

    public NotificationBroadcasterSupport(Executor executor, MBeanNotificationInfo ... mBeanNotificationInfoArray) {
        this.executor = executor;
        this.info = mBeanNotificationInfoArray;
    }

    public void addNotificationListener(NotificationListener notificationListener, NotificationFilter notificationFilter, Object object) throws IllegalArgumentException {
        if (notificationListener == null) {
            throw new IllegalArgumentException("Null listener added to bean.");
        }
        this.listeners.add(new ListenerData(notificationListener, notificationFilter, object));
    }

    public MBeanNotificationInfo[] getNotificationInfo() {
        if (this.info == null || this.info.length == 0) {
            return new MBeanNotificationInfo[0];
        }
        return (MBeanNotificationInfo[])this.info.clone();
    }

    protected void handleNotification(NotificationListener notificationListener, Notification notification, Object object) {
        notificationListener.handleNotification(notification, object);
    }

    public void removeNotificationListener(NotificationListener notificationListener) throws ListenerNotFoundException {
        Iterator<ListenerData> iterator = this.listeners.iterator();
        boolean bl = false;
        while (iterator.hasNext()) {
            if (iterator.next().getListener() != notificationListener) continue;
            iterator.remove();
            bl = true;
        }
        if (!bl) {
            throw new ListenerNotFoundException("The specified listener, " + notificationListener + "is not registered with this bean.");
        }
    }

    public void removeNotificationListener(NotificationListener notificationListener, NotificationFilter notificationFilter, Object object) throws ListenerNotFoundException {
        if (!this.listeners.remove(new ListenerData(notificationListener, notificationFilter, object))) {
            throw new ListenerNotFoundException("The specified listener, " + notificationListener + " with filter " + notificationFilter + "and passback " + object + ", is not registered with this bean.");
        }
    }

    public void sendNotification(Notification notification) {
        for (ListenerData listenerData : this.listeners) {
            NotificationFilter notificationFilter = listenerData.getFilter();
            if (notificationFilter != null && !notificationFilter.isNotificationEnabled(notification)) continue;
            if (this.executor == null) {
                try {
                    this.handleNotification(listenerData.getListener(), notification, listenerData.getPassback());
                }
                catch (Exception exception) {}
                continue;
            }
            this.executor.execute(new DispatchTask(listenerData, notification));
        }
    }

    private final class DispatchTask
    implements Runnable {
        private ListenerData ldata;
        private Notification notif;

        public DispatchTask(ListenerData listenerData, Notification notification) {
            this.ldata = listenerData;
            this.notif = notification;
        }

        public void run() {
            try {
                NotificationBroadcasterSupport.this.handleNotification(this.ldata.getListener(), this.notif, this.ldata.getPassback());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

