/*
 * Decompiled with CFR 0.152.
 */
package javax.management;

import gnu.classpath.SystemProperties;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.JMRuntimeException;
import javax.management.MBeanException;
import javax.management.MBeanServer;
import javax.management.MBeanServerBuilder;
import javax.management.MBeanServerDelegate;
import javax.management.MBeanServerPermission;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.loading.ClassLoaderRepository;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MBeanServerFactory {
    private static MBeanServerBuilder builder;
    private static final Map<Object, MBeanServer> servers;

    private MBeanServerFactory() {
    }

    public static MBeanServer createMBeanServer() {
        return MBeanServerFactory.createMBeanServer(null);
    }

    public static MBeanServer createMBeanServer(String string) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new MBeanServerPermission("createMBeanServer"));
        }
        MBeanServer mBeanServer = MBeanServerFactory.createServer(string);
        try {
            ObjectName objectName = new ObjectName("JMImplementation:type=MBeanServerDelegate");
            servers.put(mBeanServer.getAttribute(objectName, "MBeanServerId"), mBeanServer);
        }
        catch (MalformedObjectNameException malformedObjectNameException) {
            throw (Error)new InternalError("Malformed delegate bean name.").initCause(malformedObjectNameException);
        }
        catch (MBeanException mBeanException) {
            throw (Error)new InternalError("Exception in getMBeanServerId().").initCause(mBeanException);
        }
        catch (AttributeNotFoundException attributeNotFoundException) {
            throw (Error)new InternalError("Could not find MBeanServerId attribute.").initCause(attributeNotFoundException);
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            throw (Error)new InternalError("Could not find the delegate bean.").initCause(instanceNotFoundException);
        }
        catch (ReflectionException reflectionException) {
            throw (Error)new InternalError("Could not call getMBeanServerId().").initCause(reflectionException);
        }
        return mBeanServer;
    }

    public static ArrayList<MBeanServer> findMBeanServer(String string) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new MBeanServerPermission("findMBeanServer"));
        }
        if (string == null) {
            return new ArrayList<MBeanServer>(servers.values());
        }
        ArrayList<MBeanServer> arrayList = new ArrayList<MBeanServer>();
        MBeanServer mBeanServer = servers.get(string);
        if (mBeanServer != null) {
            arrayList.add(servers.get(string));
        }
        return arrayList;
    }

    public static ClassLoaderRepository getClassLoaderRepository(MBeanServer mBeanServer) {
        return mBeanServer.getClassLoaderRepository();
    }

    public static MBeanServer newMBeanServer() {
        return MBeanServerFactory.newMBeanServer(null);
    }

    public static MBeanServer newMBeanServer(String string) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new MBeanServerPermission("newMBeanServer"));
        }
        return MBeanServerFactory.createServer(string);
    }

    private static MBeanServer createServer(String string) {
        Object object;
        Object object2;
        String string2;
        if (string == null) {
            string = "DefaultDomain";
        }
        if ((string2 = SystemProperties.getProperty("javax.management.builder.initial")) == null) {
            if (builder == null || builder.getClass() != MBeanServerBuilder.class) {
                builder = new MBeanServerBuilder();
            }
        } else if (builder == null || !string2.equals(builder.getClass().getName())) {
            object2 = Thread.currentThread().getContextClassLoader();
            if (object2 == null) {
                object2 = MBeanServerFactory.class.getClassLoader();
            }
            try {
                object = Class.forName(string2, true, (ClassLoader)object2);
                builder = (MBeanServerBuilder)((Class)object).newInstance();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw (JMRuntimeException)new JMRuntimeException("The builder class, " + string2 + ", could not be found.").initCause(classNotFoundException);
            }
            catch (InstantiationException instantiationException) {
                throw (JMRuntimeException)new JMRuntimeException("The builder class, " + string2 + ", could not be instantiated.").initCause(instantiationException);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw (JMRuntimeException)new JMRuntimeException("The builder class, " + string2 + ", could not be accessed.").initCause(illegalAccessException);
            }
        }
        if ((object2 = builder.newMBeanServerDelegate()) == null) {
            throw new JMRuntimeException("A delegate could not be created.");
        }
        object = builder.newMBeanServer(string, null, (MBeanServerDelegate)object2);
        if (object == null) {
            throw new JMRuntimeException("A server could not be created.");
        }
        return object;
    }

    public static void releaseMBeanServer(MBeanServer mBeanServer) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new MBeanServerPermission("releaseMBeanServer"));
        }
        Iterator<MBeanServer> iterator = servers.values().iterator();
        while (iterator.hasNext()) {
            MBeanServer mBeanServer2 = iterator.next();
            if (mBeanServer != mBeanServer2) continue;
            iterator.remove();
            return;
        }
        throw new IllegalArgumentException("The server given is not referenced.");
    }

    static {
        servers = new HashMap<Object, MBeanServer>();
    }
}

