/*
 * Decompiled with CFR 0.152.
 */
package javax.management;

import gnu.java.lang.CPStringBuilder;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.security.Permission;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;

public class MBeanPermission
extends Permission {
    private static final long serialVersionUID = -2416928705275160661L;
    private String actions;
    private transient Set<String> actionSet;
    private static final Set<String> validSet = new HashSet<String>();

    public MBeanPermission(String string, String string2) {
        super(string);
        if (string == null || string.length() == 0) {
            throw new IllegalArgumentException("The supplied name was null or empty.");
        }
        if (string2 == null || string2.length() == 0) {
            throw new IllegalArgumentException("The supplied action list was null or empty.");
        }
        this.actions = string2;
        this.updateActionSet();
    }

    public MBeanPermission(String string, String string2, ObjectName objectName, String string3) {
        this((string == null ? "-" : string) + "#" + (string2 == null ? "-" : string2) + "[" + (objectName == null ? "-" : objectName.toString()) + "]", string3);
    }

    public boolean equals(Object object) {
        if (object instanceof MBeanPermission) {
            MBeanPermission mBeanPermission = (MBeanPermission)object;
            return mBeanPermission.getName().equals(this.getName()) && mBeanPermission.getActions().equals(this.actions);
        }
        return false;
    }

    public String getActions() {
        Iterator<String> iterator = this.actionSet.iterator();
        CPStringBuilder cPStringBuilder = new CPStringBuilder();
        while (iterator.hasNext()) {
            cPStringBuilder.append(iterator.next());
            if (!iterator.hasNext()) continue;
            cPStringBuilder.append(",");
        }
        return cPStringBuilder.toString();
    }

    public int hashCode() {
        return this.getName().hashCode() + this.actions.hashCode();
    }

    public boolean implies(Permission permission) {
        if (permission instanceof MBeanPermission) {
            MBeanPermission mBeanPermission = (MBeanPermission)permission;
            NameHolder nameHolder = new NameHolder(mBeanPermission.getName());
            NameHolder nameHolder2 = new NameHolder(this.getName());
            if (!nameHolder2.equals(nameHolder)) {
                return false;
            }
            for (String string : mBeanPermission.actionSet) {
                boolean bl = this.actions.contains(string);
                if (!bl && string.equals("queryNames")) {
                    bl = this.actions.contains("queryMBeans");
                }
                if (bl) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private void updateActionSet() {
        String[] stringArray = this.actions.split(",");
        this.actionSet = new TreeSet<String>();
        for (int i = 0; i < stringArray.length; ++i) {
            this.actionSet.add(stringArray[i].trim());
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.updateActionSet();
        this.checkActions();
    }

    private void checkActions() {
        for (String string : this.actionSet) {
            if (validSet.contains(string)) continue;
            throw new IllegalArgumentException("Invalid action " + string + " found.");
        }
    }

    static {
        validSet.add("addNotificationListener");
        validSet.add("getAttribute");
        validSet.add("getClassLoader");
        validSet.add("getClassLoaderFor");
        validSet.add("getClassLoaderRepository");
        validSet.add("getDomains");
        validSet.add("getMBeanInfo");
        validSet.add("getObjectInstance");
        validSet.add("instantiate");
        validSet.add("invoke");
        validSet.add("isInstanceOf");
        validSet.add("queryMBeans");
        validSet.add("queryNames");
        validSet.add("registerMBean");
        validSet.add("removeNotificationListener");
        validSet.add("setAttribute");
        validSet.add("unregisterMBean");
    }

    private class NameHolder {
        private String className;
        private String member;
        private ObjectName objectName;

        public NameHolder(String string) {
            String string2 = null;
            int n = string.indexOf("#");
            int n2 = string.indexOf("[");
            if (n2 == -1) {
                if (n == -1) {
                    this.className = string;
                } else {
                    this.className = string.substring(0, n);
                    this.member = string.substring(n + 1);
                }
            } else if (n == -1) {
                this.className = string.substring(0, n2);
                string2 = string.substring(n2 + 1, string.length() - 1);
            } else {
                this.className = string.substring(0, n);
                this.member = string.substring(n + 1, n2);
                string2 = string.substring(n2 + 1, string.length() - 1);
            }
            if (this.className.equals("-")) {
                this.className = null;
            }
            if (this.member.equals("-")) {
                this.member = null;
            }
            if (string2 == null || string2.equals("-")) {
                this.objectName = null;
            } else {
                try {
                    this.objectName = new ObjectName(string2);
                }
                catch (MalformedObjectNameException malformedObjectNameException) {
                    throw (Error)new InternalError("Invalid object name.").initCause(malformedObjectNameException);
                }
            }
        }

        public boolean equals(Object object) {
            if (object instanceof NameHolder) {
                int n;
                NameHolder nameHolder = (NameHolder)object;
                boolean bl = false;
                String string = nameHolder.getClassName();
                bl = string == null || this.className.equals("*") ? true : ((n = this.className.indexOf("*")) != -1 ? string.startsWith(this.className.substring(0, n)) : string.equals(this.className));
                n = 0;
                String string2 = nameHolder.getMember();
                n = string2 == null || this.member.equals("*") ? 1 : (int)(string2.equals(this.member) ? 1 : 0);
                boolean bl2 = false;
                ObjectName objectName = nameHolder.getObjectName();
                bl2 = objectName == null ? true : (this.objectName.isPattern() ? this.objectName.apply(objectName) : objectName.equals(this.objectName));
                return bl && n != 0 && bl2;
            }
            return false;
        }

        public String getClassName() {
            return this.className;
        }

        public String getMember() {
            return this.member;
        }

        public ObjectName getObjectName() {
            return this.objectName;
        }
    }
}

