/*
 * Decompiled with CFR 0.152.
 */
package javax.management;

import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Arrays;
import javax.management.MBeanFeatureInfo;
import javax.management.MBeanParameterInfo;

public class MBeanOperationInfo
extends MBeanFeatureInfo
implements Cloneable {
    private static final long serialVersionUID = -6178860474881375330L;
    public static final int INFO = 0;
    public static final int ACTION = 1;
    public static final int ACTION_INFO = 2;
    public static final int UNKNOWN = 3;
    private String type;
    private MBeanParameterInfo[] signature;
    private int impact;

    public MBeanOperationInfo(String string, Method method) {
        super(method.getName(), string);
        Type[] typeArray = method.getGenericParameterTypes();
        this.signature = new MBeanParameterInfo[typeArray.length];
        for (int i = 0; i < typeArray.length; ++i) {
            Type type = typeArray[i];
            this.signature[i] = type instanceof Class ? new MBeanParameterInfo(null, ((Class)type).getName(), null) : new MBeanParameterInfo(null, type.toString(), null);
        }
        Type type = method.getGenericReturnType();
        this.type = type instanceof Class ? ((Class)type).getName() : type.toString();
        this.impact = method.getReturnType() == Void.TYPE ? (typeArray.length == 0 ? 3 : 1) : (typeArray.length == 0 ? 0 : 2);
    }

    public MBeanOperationInfo(String string, String string2, MBeanParameterInfo[] mBeanParameterInfoArray, String string3, int n) {
        super(string, string2);
        if (mBeanParameterInfoArray == null) {
            this.signature = new MBeanParameterInfo[0];
        } else {
            this.signature = new MBeanParameterInfo[mBeanParameterInfoArray.length];
            System.arraycopy(mBeanParameterInfoArray, 0, this.signature, 0, mBeanParameterInfoArray.length);
        }
        this.type = string3;
        this.impact = n;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new IllegalStateException("clone() called on non-cloneable object.");
        }
    }

    public boolean equals(Object object) {
        if (!(object instanceof MBeanOperationInfo)) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        MBeanOperationInfo mBeanOperationInfo = (MBeanOperationInfo)object;
        MBeanParameterInfo[] mBeanParameterInfoArray = mBeanOperationInfo.getSignature();
        for (int i = 0; i < this.signature.length; ++i) {
            if (i == mBeanParameterInfoArray.length) {
                return true;
            }
            if (this.signature[i].equals(mBeanParameterInfoArray[i])) continue;
            return false;
        }
        return this.type.equals(mBeanOperationInfo.getReturnType()) && this.impact == mBeanOperationInfo.getImpact();
    }

    public int getImpact() {
        return this.impact;
    }

    public String getReturnType() {
        return this.type;
    }

    public MBeanParameterInfo[] getSignature() {
        return (MBeanParameterInfo[])this.signature.clone();
    }

    public int hashCode() {
        return super.hashCode() + Arrays.hashCode(this.signature) + this.type.hashCode() + Integer.valueOf(this.impact).hashCode();
    }

    public String toString() {
        if (this.string == null) {
            String string;
            switch (this.impact) {
                case 0: {
                    string = "INFO";
                    break;
                }
                case 1: {
                    string = "ACTION";
                    break;
                }
                case 2: {
                    string = "ACTION_INFO";
                    break;
                }
                case 3: {
                    string = "UNKNOWN";
                    break;
                }
                default: {
                    string = "ERRONEOUS VALUE";
                }
            }
            super.toString();
            this.string = this.string.substring(0, this.string.length() - 1) + ",returnType=" + this.type + ",impact=" + string + ",signature=" + Arrays.toString(this.signature) + "]";
        }
        return this.string;
    }
}

