/*
 * Decompiled with CFR 0.152.
 */
package javax.management;

import java.io.Serializable;
import java.util.Arrays;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanConstructorInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;

public class MBeanInfo
implements Cloneable,
Serializable {
    private static final long serialVersionUID = -6451021435135161911L;
    private String description;
    private String className;
    private MBeanAttributeInfo[] attributes;
    private MBeanOperationInfo[] operations;
    private MBeanConstructorInfo[] constructors;
    private MBeanNotificationInfo[] notifications;
    private transient String string;

    public MBeanInfo(String string, String string2, MBeanAttributeInfo[] mBeanAttributeInfoArray, MBeanConstructorInfo[] mBeanConstructorInfoArray, MBeanOperationInfo[] mBeanOperationInfoArray, MBeanNotificationInfo[] mBeanNotificationInfoArray) {
        this.className = string;
        this.description = string2;
        this.attributes = mBeanAttributeInfoArray == null ? new MBeanAttributeInfo[0] : (MBeanAttributeInfo[])mBeanAttributeInfoArray.clone();
        this.constructors = mBeanConstructorInfoArray == null ? new MBeanConstructorInfo[0] : (MBeanConstructorInfo[])mBeanConstructorInfoArray.clone();
        this.operations = mBeanOperationInfoArray == null ? new MBeanOperationInfo[0] : (MBeanOperationInfo[])mBeanOperationInfoArray.clone();
        this.notifications = mBeanNotificationInfoArray == null ? new MBeanNotificationInfo[0] : (MBeanNotificationInfo[])mBeanNotificationInfoArray.clone();
    }

    public Object clone() {
        MBeanInfo mBeanInfo = null;
        try {
            mBeanInfo = (MBeanInfo)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return mBeanInfo;
    }

    public boolean equals(Object object) {
        if (!(object instanceof MBeanInfo)) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        MBeanInfo mBeanInfo = (MBeanInfo)object;
        MBeanAttributeInfo[] mBeanAttributeInfoArray = mBeanInfo.getAttributes();
        for (int i = 0; i < this.attributes.length; ++i) {
            if (i == mBeanAttributeInfoArray.length) {
                return true;
            }
            if (this.attributes[i].equals(mBeanAttributeInfoArray[i])) continue;
            return false;
        }
        MBeanConstructorInfo[] mBeanConstructorInfoArray = mBeanInfo.getConstructors();
        for (int i = 0; i < this.constructors.length; ++i) {
            if (i == mBeanConstructorInfoArray.length) {
                return true;
            }
            if (this.constructors[i].equals(mBeanConstructorInfoArray[i])) continue;
            return false;
        }
        MBeanOperationInfo[] mBeanOperationInfoArray = mBeanInfo.getOperations();
        for (int i = 0; i < this.operations.length; ++i) {
            if (i == mBeanOperationInfoArray.length) {
                return true;
            }
            if (this.operations[i].equals(mBeanOperationInfoArray[i])) continue;
            return false;
        }
        MBeanNotificationInfo[] mBeanNotificationInfoArray = mBeanInfo.getNotifications();
        for (int i = 0; i < this.notifications.length; ++i) {
            if (i == mBeanNotificationInfoArray.length) {
                return true;
            }
            if (this.notifications[i].equals(mBeanNotificationInfoArray[i])) continue;
            return false;
        }
        return this.className.equals(mBeanInfo.getClassName()) && this.description.equals(mBeanInfo.getDescription());
    }

    public MBeanAttributeInfo[] getAttributes() {
        return (MBeanAttributeInfo[])this.attributes.clone();
    }

    public String getClassName() {
        return this.className;
    }

    public MBeanConstructorInfo[] getConstructors() {
        return (MBeanConstructorInfo[])this.constructors.clone();
    }

    public String getDescription() {
        return this.description;
    }

    public MBeanNotificationInfo[] getNotifications() {
        return (MBeanNotificationInfo[])this.notifications.clone();
    }

    public MBeanOperationInfo[] getOperations() {
        return (MBeanOperationInfo[])this.operations.clone();
    }

    public int hashCode() {
        return this.className.hashCode() + this.description.hashCode() + Arrays.hashCode(this.attributes) + Arrays.hashCode(this.constructors) + Arrays.hashCode(this.operations) + Arrays.hashCode(this.notifications);
    }

    public String toString() {
        if (this.string == null) {
            this.string = this.getClass().getName() + "[name=" + this.className + ",desc=" + this.description + ",attributes=" + Arrays.toString(this.attributes) + ",constructors=" + Arrays.toString(this.constructors) + ",operations=" + Arrays.toString(this.operations) + ",notifications=" + Arrays.toString(this.notifications) + "]";
        }
        return this.string;
    }
}

